/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.service.cache.CodeRuleCacheMrg;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CoderuleOrgEditPlugin
extends AbstractFormPlugin {
    private static final String DEFAULT_ORGFUNCID = "15";
    public static final String CODE_RULE_ID = "codeRuleId";
    private static final String BOS_CODERULE = "bos-coderule";

    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey().toLowerCase()) {
            case "btnaddline": {
                this.openOrgF7();
                break;
            }
            case "btndeleteline": {
                this.refreshOrgf7();
                break;
            }
        }
    }

    private void refreshOrgf7() {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity("orgentity");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject obj : curOrgList) {
            orgIds.add(obj.getDynamicObject("orgid").getLong("id"));
        }
        this.getModel().setValue("orgf7", (Object)orgIds.toArray());
    }

    private void openOrgF7() {
        MulBasedataEdit base = (MulBasedataEdit)this.getControl("orgf7");
        base.setOrgFuncId(this.getOrgFuncId(this.getModel().getValue("bizobjectid")));
        base.click();
    }

    private String getOrgFuncId(Object bizObject) {
        if (StringUtils.isBlank((Object)bizObject)) {
            return DEFAULT_ORGFUNCID;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.toString());
        if (dataEntityType == null) {
            return DEFAULT_ORGFUNCID;
        }
        String mainOrg = dataEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            return DEFAULT_ORGFUNCID;
        }
        MainOrgProp org = (MainOrgProp)dataEntityType.getProperty(mainOrg);
        if (org == null) {
            return DEFAULT_ORGFUNCID;
        }
        String orgfuncid = org.getOrgFunc();
        return StringUtils.isBlank((CharSequence)orgfuncid) ? DEFAULT_ORGFUNCID : orgfuncid;
    }

    public void click(EventObject evt) {
        String itemkey;
        Control c = (Control)evt.getSource();
        switch (itemkey = c.getKey().toLowerCase()) {
            case "btnsave": {
                String codeRuleId = (String)this.getView().getFormShowParameter().getCustomParam(CODE_RULE_ID);
                if (!this.checkData(codeRuleId)) {
                    return;
                }
                this.deleteEntry(codeRuleId);
                this.saveData();
                String type = CodeRuleCacheMrg.getType4EntityCodeRules();
                String entityId = this.getModel().getValue("bizobjectid").toString();
                CodeRuleCacheMrg.clearCache(type, entityId);
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_coderule"));
                cacheManager.removeByDt();
                this.getView().close();
                break;
            }
        }
    }

    private boolean checkData(String codeRuleId) {
        String bizObjectId = CodeRuleUtils.queryBizObjectById(codeRuleId);
        DynamicObjectCollection list = this.getModel().getEntryEntity("orgentity");
        HashSet<String> newOrgSet = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            Object org = this.getModel().getValue("orgid", i);
            if (!(org instanceof DynamicObject)) continue;
            Object pkValue = ((DynamicObject)org).getPkValue();
            newOrgSet.add(String.valueOf(pkValue));
        }
        String msg = null;
        if (CodeRuleUtils.isEnable(codeRuleId)) {
            msg = CodeRuleUtils.isDuplicateCodeRule(bizObjectId, codeRuleId, newOrgSet, null);
        }
        if (StringUtils.isNotBlank(msg)) {
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private boolean isHasGlobalOrg(ORM orm, String codeRuleId, String bizNumber) {
        QFilter orgEntryFiler = new QFilter("orgentry.orgid", "is null", null);
        QFilter enableFiler = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter bizFiler = new QFilter("bizobjectid", "=", (Object)bizNumber);
        QFilter curRuleFiler = new QFilter("id", "!=", (Object)codeRuleId);
        QFilter[] qFilter = new QFilter[]{orgEntryFiler, enableFiler, bizFiler, curRuleFiler};
        DynamicObject org = orm.queryOne("bos_coderule", "id, orgentry.id", qFilter);
        if (org != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u9002\u7528\u7ec4\u7ec7\uff0c\u8be5\u4e1a\u52a1\u5bf9\u8c61\u5df2\u5b58\u5728\u542f\u7528\u7684\u672a\u6307\u5b9a\u9002\u7528\u7ec4\u7ec7\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"CoderuleOrgEditPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        this.clearAllEntryRow();
        IDataModel model = this.getModel();
        String codeRuleId = (String)this.getView().getFormShowParameter().getCustomParam(CODE_RULE_ID);
        QFilter cudeRuleFilter = new QFilter("id", "=", (Object)codeRuleId);
        QFilter[] filters = new QFilter[]{cudeRuleFilter};
        DynamicObjectCollection coderuleOrgEntry = QueryServiceHelper.query((String)"bos_coderule", (String)"id,enable,ispreset,bizobjectid.number bizobjectid,orgentry.orgid orgid,orgentry.isincludesuborg isincludesuborg,orgentry.orgid.number number,orgentry.orgid.name name", (QFilter[])filters);
        HashSet<String> orgSet = new HashSet<String>();
        if (coderuleOrgEntry != null && coderuleOrgEntry.size() > 0) {
            Object isPresetObj = ((DynamicObject)coderuleOrgEntry.get(0)).get("ispreset");
            if ("1".equals(((DynamicObject)coderuleOrgEntry.get(0)).get("enable")) || isPresetObj instanceof Boolean && ((Boolean)isPresetObj).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnaddline", "btndeleteline", "btnsave"});
            }
            this.getModel().setValue("bizobjectid", (Object)((DynamicObject)coderuleOrgEntry.get(0)).getString("bizobjectid"));
            for (int i = 0; i < coderuleOrgEntry.size(); ++i) {
                DynamicObject orgObj = (DynamicObject)coderuleOrgEntry.get(i);
                String orgid = orgObj.getString("orgid");
                if (StringUtils.isBlank((Object)orgObj.get("number"))) break;
                model.createNewEntryRow("orgentity");
                model.setValue("orgid", orgObj.get("orgid"), i);
                model.setValue("isincludesuborg", orgObj.get("isincludesuborg"), i);
                orgSet.add(orgid);
            }
        }
        Set orgs = orgSet.stream().map(Long::valueOf).collect(Collectors.toSet());
        this.getModel().setValue("orgf7", (Object)orgs.toArray());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("orgf7".equals(proName)) {
            this.refreshOrgEntity(e);
        }
    }

    private void refreshOrgEntity(PropertyChangedArgs e) {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity("orgentity");
        HashMap<Long, Object> subOrgMap = new HashMap<Long, Object>();
        for (DynamicObject curOrgObj : curOrgList) {
            subOrgMap.put(curOrgObj.getDynamicObject("orgid").getLong("id"), curOrgObj.get("isincludesuborg"));
        }
        this.clearAllEntryRow();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
        if (orgCol.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("orgentity", orgCol.size());
        int m = orgCol.size();
        for (int i = 0; i < m; ++i) {
            DynamicObject orgObj = (DynamicObject)orgCol.get(i);
            DynamicObject org = orgObj.getDynamicObject("fbasedataId");
            if (org == null) continue;
            this.getModel().setValue("orgid", (Object)org, i);
            Object isIncludeSubOrg = subOrgMap.get(org.getLong("id"));
            if (isIncludeSubOrg == null) continue;
            this.getModel().setValue("isincludesuborg", isIncludeSubOrg, i);
        }
    }

    private void saveData() {
        IDataModel model = this.getModel();
        String codeRuleId = (String)this.getView().getFormShowParameter().getCustomParam(CODE_RULE_ID);
        DynamicObjectCollection list = model.getEntryEntity("orgentity");
        DynamicObject[] orgArr = new DynamicObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_coderule_orgentity");
            DynamicObject coderuleOrg = new DynamicObject((DynamicObjectType)dt);
            coderuleOrg.set("id", (Object)codeRuleId);
            coderuleOrg.set("orgid", model.getValue("orgid", i));
            coderuleOrg.set("isincludesuborg", model.getValue("isincludesuborg", i));
            coderuleOrg.set("seq", (Object)i);
            orgArr[i] = coderuleOrg;
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CodeRuleConditionEditPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
        DynamicObject codeRuleObj = BusinessDataServiceHelper.loadSingle((Object)codeRuleId, (String)"bos_coderule");
        AppLogUtil.insertAppLog(this.getView(), codeRuleObj, new MultiLangEnumBridge("\u8bbe\u7f6e\u53d7\u63a7\u7ec4\u7ec7", "CoderuleOrgEditPlugin_2", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\u3002", "BOS_CODERULE_10", BOS_CODERULE), true, codeRuleId, CommonUtil.getDynamicObjProperties(codeRuleObj, "name").toString());
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void deleteEntry(String id) {
        try (TXHandle h = TX.beginRequired();){
            try {
                Object[] params = new SqlParameter[]{new SqlParameter(":Fid", 1, (Object)id)};
                String SQL = "delete from t_cr_apporg where Fid = ?;";
                DB.execute((DBRoute)DBRoute.basedata, (String)SQL, (Object[])params);
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void clearAllEntryRow() {
        IDataModel model = this.getModel();
        model.deleteEntryData("orgentity");
    }
}

