/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.adaptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.handler.SyncHandler;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.coderule.util.CodeRuleSystemParam;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.common.GeneratorWithNumException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractCodeRuleSigner
implements CodeRuleSigner {
    Log logger = LogFactory.getLog(AbstractCodeRuleSigner.class);

    @Override
    public String getSerialNumber(CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntry, String sortItem, boolean isReadNumber) {
        String serialNumber;
        if (codeRuleInfo.getIsNonBreak().booleanValue() && StringUtils.isNotBlank((CharSequence)(serialNumber = this.getBreakNumber(codeRuleInfo, sortItem, isReadNumber)))) {
            String breakNum = this.buildSerialNumber(codeRuleInfo, codeRuleEntry, Long.parseLong(serialNumber));
            this.logger.info("CodeRuleServiceImp: \u83b7\u5f97\u65ad\u53f7\uff1a" + breakNum);
            return breakNum;
        }
        long number = this.signerNumber(codeRuleInfo, codeRuleEntry, sortItem, isReadNumber);
        return this.buildSerialNumber(codeRuleInfo, codeRuleEntry, number);
    }

    private String buildSerialNumber(CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntry, long number) {
        try {
            return CodeRuleSerialNumUtil.addChar(codeRuleEntry, "" + number, codeRuleInfo.getName(), codeRuleInfo.isFillWithZero(), codeRuleInfo.isAutoIncrLength());
        }
        catch (Exception e) {
            throw new GeneratorWithNumException(GeneratorException.ErrorCode.ERRCODE_CODERULE_VALIDATE_NUMBER.getCode(), e.getMessage(), e, new int[]{(int)number});
        }
    }

    protected String getBreakNumber(CodeRuleInfo codeRuleInfo, String sortItem, boolean isReadNumber) {
        List<Integer> breakNums = this.getBreakNums(codeRuleInfo, sortItem, 1, isReadNumber);
        if (CollectionUtils.isEmpty(breakNums)) {
            return "";
        }
        return String.valueOf(breakNums.get(0));
    }

    @Override
    public String[] getBatchSerialNumber(CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntry, String sortItem, int count) {
        String[] serialNumbers = new String[count];
        int index = 0;
        if (codeRuleInfo.getIsNonBreak().booleanValue()) {
            List<Integer> breakNums = this.getBreakNums(codeRuleInfo, sortItem, count, false);
            for (Integer breakNum : breakNums) {
                serialNumbers[index++] = String.valueOf(breakNum);
            }
        }
        if (index < count) {
            try {
                this.signerNumbers(codeRuleInfo, codeRuleEntry, sortItem, serialNumbers, index);
            }
            catch (Exception e) {
                ErrorCode errorCode = new ErrorCode("getSerialNumber error", e.getMessage());
                throw new KDException((Throwable)e, errorCode, new Object[0]);
            }
        }
        boolean isError = false;
        String errorMessage = "";
        for (int i = 0; i < count; ++i) {
            try {
                serialNumbers[i] = CodeRuleSerialNumUtil.addChar(codeRuleEntry, serialNumbers[i], codeRuleInfo.getName(), codeRuleInfo.isFillWithZero(), codeRuleInfo.isAutoIncrLength());
                continue;
            }
            catch (Exception e) {
                isError = true;
                errorMessage = e.getMessage();
            }
        }
        if (isError) {
            int[] recycleArr = new int[serialNumbers.length];
            for (int i = 0; i < serialNumbers.length; ++i) {
                recycleArr[i] = Integer.parseInt(serialNumbers[i]);
            }
            throw new GeneratorWithNumException(GeneratorException.ErrorCode.ERRCODE_CODERULE_VALIDATE_NUMBER.getCode(), errorMessage, recycleArr);
        }
        return serialNumbers;
    }

    protected abstract void signerNumbers(CodeRuleInfo var1, CodeRuleEntryInfo var2, String var3, String[] var4, int var5);

    @Override
    public List<Integer> getBreakNums(final CodeRuleInfo codeRuleInfo, final String sortItem, final int intermitNum, boolean isReadNumber) {
        final ArrayList<Integer> allBreakNumbers = new ArrayList<Integer>(intermitNum > 0 ? intermitNum : 8);
        if (isReadNumber) {
            allBreakNumbers.addAll(this.readBreakNums(codeRuleInfo, sortItem, intermitNum));
        } else {
            boolean isNewWay = CodeRuleSystemParam.getCustomParameter("CODERULE_OPTIMISTICALLY_GET_BREAKNUMBER", true);
            if (isNewWay) {
                List<Integer> readBreakNums = this.readBreakNums(codeRuleInfo, sortItem, intermitNum);
                if (CollectionUtils.isNotEmpty(readBreakNums)) {
                    allBreakNumbers.addAll(this.getBreakNumbersFast(codeRuleInfo, sortItem, readBreakNums));
                }
            } else {
                new SyncHandler(CodeRuleSerialNumUtil.getDLockKey(codeRuleInfo, sortItem), codeRuleInfo.getName(), codeRuleInfo.getId()){

                    @Override
                    protected void syncProcess() {
                        allBreakNumbers.addAll(AbstractCodeRuleSigner.this.readBreakNums(codeRuleInfo, sortItem, intermitNum));
                        if (CollectionUtils.isEmpty((Collection)allBreakNumbers)) {
                            AbstractCodeRuleSigner.this.logger.info("CodeRuleServiceImp.getBreakNumber()\uff1a\u6ca1\u6709\u5408\u9002\u7684\u65ad\u53f7");
                        }
                        if (CollectionUtils.isNotEmpty((Collection)allBreakNumbers)) {
                            AbstractCodeRuleSigner.this.deleteBreakNumber(codeRuleInfo, sortItem, allBreakNumbers);
                        }
                    }
                }.process();
            }
            if (CollectionUtils.isNotEmpty(allBreakNumbers)) {
                this.logger.info("CodeRuleServiceImp.getBreakNumber()\uff1a\u83b7\u53d6\u65ad\u53f7" + allBreakNumbers.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
        }
        return allBreakNumbers;
    }

    private List<Integer> readBreakNums(CodeRuleInfo codeRuleInfo, String sortItem, int intermitNum) {
        ArrayList<Integer> allBreakNumbers = new ArrayList<Integer>(intermitNum > 0 ? intermitNum : 8);
        if (codeRuleInfo.getIsNonBreak().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)sortItem)) {
                sortItem = "_split_";
            }
            Object[] params = new SqlParameter[]{new SqlParameter(":FCodeRuleID", 12, (Object)codeRuleInfo.getId()), new SqlParameter(":FSortItemValue", 12, (Object)sortItem)};
            String sql = intermitNum == -1 ? "SELECT FSerial FROM T_CR_IntermitNO WHERE FCodeRuleID = ? and FSortItemValue = ? order by FSerial" : "SELECT TOP " + intermitNum + " FSerial FROM T_CR_IntermitNO WHERE FCodeRuleID = ? and FSortItemValue = ? order by FSerial";
            ArrayList breakNumbers = new ArrayList(intermitNum > 0 ? intermitNum : 8);
            DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
                while (rs.next()) {
                    breakNumbers.add(rs.getInt(1));
                }
                return null;
            });
            allBreakNumbers.addAll(breakNumbers);
        }
        return allBreakNumbers;
    }

    private int[] deleteBreakNumber(CodeRuleInfo codeRuleInfo, String sortItem, List<Integer> breakNums) {
        int[] result = new int[breakNums.size()];
        if (StringUtils.isBlank((CharSequence)sortItem)) {
            sortItem = "_split_";
        }
        String sql = "delete from T_CR_IntermitNO where FCodeRuleID = ? and FSortItemValue = ? and FSerial = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(breakNums.size());
        for (Integer breakNum : breakNums) {
            params.add(new Object[]{codeRuleInfo.getId(), sortItem, breakNum});
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                result = DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
            }
            catch (Exception e) {
                this.logger.error(String.format("\u5220\u9664\u65ad\u53f7\u53d1\u751f\u5f02\u5e38\uff0c codeRuleId: %s, sortItemVaule: %s", codeRuleInfo.getId(), sortItem), (Throwable)e);
                h.markRollback();
            }
        }
        return result;
    }

    private List<Integer> getBreakNumbersFast(CodeRuleInfo codeRuleInfo, String sortItem, List<Integer> breakNums) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int[] deleteResult = this.deleteBreakNumber(codeRuleInfo, sortItem, breakNums);
        for (int i = 0; i < deleteResult.length; ++i) {
            if (deleteResult[i] != 1) continue;
            numbers.add(breakNums.get(i));
        }
        return numbers;
    }

    @Override
    public void reset(String codeRuleId, String sortItem, long initNumber) {
    }

    @Override
    public void updateStep(String codeRuleId, String sortItem, int step) {
    }

    @Override
    public void clean(String codeRuleId, String sortItem) {
    }

    @Override
    public boolean isUseDB() {
        return true;
    }

    @Override
    public void growup(String codeRuleId) {
    }
}

