/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.adaptor;

import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.DBCodeRuleSigner;
import kd.bos.coderule.adaptor.FastCodeRuleSigner;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.cache.CodeRuleCache;

public class CodeRuleSignerFactory {
    public static CodeRuleSigner newInstanceFast() {
        return new FastCodeRuleSigner();
    }

    public static CodeRuleSigner newInstanceDB() {
        return new DBCodeRuleSigner();
    }

    public static CodeRuleSigner newInstance(String codeRuleId) {
        CodeRuleInfo codeRuleInfo = CodeRuleCache.reloadCodeRuleById(codeRuleId);
        return CodeRuleSignerFactory.newInstance(codeRuleInfo);
    }

    public static CodeRuleSigner newInstance(CodeRuleInfo codeRuleInfo) {
        return new FastCodeRuleSigner();
    }

    public static CodeRuleSigner newInstance() {
        return new FastCodeRuleSigner();
    }

    public static CodeRuleSigner newInstance(boolean isDBGenerator) {
        return new FastCodeRuleSigner(isDBGenerator);
    }
}

