/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.adaptor;

import java.math.BigDecimal;
import java.sql.ResultSet;
import kd.bos.coderule.adaptor.AbstractCodeRuleSigner;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.constant.CodeRuleConstant;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.coderule.util.CodeRuleInfoBuilder;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DBCodeRuleSigner
extends AbstractCodeRuleSigner
implements CodeRuleConstant {
    private static final Log logger = LogFactory.getLog(DBCodeRuleSigner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long signerNumber(CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntry, String sortItem, boolean isReadNumber) {
        long number;
        block21: {
            String codeRuleID = codeRuleInfo.getId();
            String codeRuleName = codeRuleInfo.getName();
            String key = (codeRuleID + sortItem).intern();
            String dLockKey = key;
            if (dLockKey.endsWith("/")) {
                dLockKey = dLockKey.replace("/", "").intern();
            }
            try (DLock dl = DLock.create((String)("bas/coderule/" + dLockKey));){
                dl.lock();
                try {
                    logger.info("CodeRuleServiceImp: \u7f16\u7801\u89c4\u5219 " + codeRuleName + " (" + codeRuleID + ") \u83b7\u5f97\u9501 " + "bas/coderule/" + dLockKey);
                    long maxNumber = 0L;
                    String maxSerialNumber = CodeRuleCache.getMaxSerialNumber(key);
                    logger.info("CodeRuleServiceImp.getMaxSerialNumber \u5f53\u524d\u7f13\u5b58\u6700\u5927\u53f7:(" + maxSerialNumber + "), codeRuleID=(" + codeRuleID + ")");
                    maxNumber = StringUtils.isBlank((CharSequence)maxSerialNumber) || "DATA_LOADED".equals(maxSerialNumber) ? this.getMaxNumber(codeRuleInfo.getId(), sortItem) : Long.parseLong(maxSerialNumber);
                    if (maxNumber < codeRuleEntry.getInitial()) {
                        maxNumber = codeRuleEntry.getInitial() - codeRuleEntry.getStep();
                    }
                    String serialNumber = String.valueOf(maxNumber += codeRuleEntry.getStep());
                    number = maxNumber;
                    if (isReadNumber) break block21;
                    logger.info(String.format("CodeRuleServiceImp \u7f16\u7801\u89c4\u5219 (%s, %s, %s) \u6d88\u8017\u4e86\u6d41\u6c34\u53f7 (%s)", codeRuleID, codeRuleName, sortItem, serialNumber));
                    CodeRuleCache.updateMaxSerialNumber(key, serialNumber);
                    maxSerialNumber = CodeRuleCache.getMaxSerialNumber(key);
                    String errorInfo = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6bd4\u5bf9\u53d1\u73b0:\u7f16\u7801\u89c4\u5219 (%1$s\uff0c%2$s)\u7684\u6700\u5927\u53f7\u7f13\u5b58\u6ca1\u6709\u66f4\u65b0\u6210\u529f\u3002 newNum:%3$s\uff0coldNum:%4$s", (String)"DBCodeRuleSigner_0", (String)"bos-coderule", (Object[])new Object[0]), codeRuleID, codeRuleName, serialNumber, maxSerialNumber);
                    int loopCount = 0;
                    while (!serialNumber.equals(maxSerialNumber)) {
                        logger.error(errorInfo);
                        if (++loopCount > 2) break;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            logger.error((Throwable)e);
                        }
                        maxSerialNumber = CodeRuleCache.getMaxSerialNumber(key);
                    }
                    if (!serialNumber.equals(maxSerialNumber)) {
                        logger.error(errorInfo);
                        throw new KDException(new ErrorCode("ErrCode_CodeRule", errorInfo), new Object[0]);
                    }
                    logger.info(String.format("CodeRuleServiceImp \u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7\u7f13\u5b58\u66f4\u65b0\u6210\u529f (%s, %s, %s), \u6700\u5927\u53f7 (%s)", codeRuleID, codeRuleName, sortItem, serialNumber));
                    this.updateMaxNumber(codeRuleInfo.getId(), sortItem, maxNumber);
                }
                finally {
                    logger.info("CodeRuleServiceImp: \u7f16\u7801\u89c4\u5219: " + codeRuleName + " (" + codeRuleID + ") \u91ca\u653e\u9501\uff1a" + "bas/coderule/" + dLockKey);
                    dl.unlock();
                }
            }
        }
        return number;
    }

    private long getMaxNumber(String ruleId, String sortItem) {
        Object[] params = new SqlParameter[2];
        params[0] = new SqlParameter(":FCodeRuleID", 12, (Object)ruleId);
        if (StringUtils.isBlank((CharSequence)sortItem)) {
            sortItem = " ";
        }
        params[1] = new SqlParameter(":FSortItemValue", 12, (Object)sortItem);
        String sql = "SELECT FMaxSerial FROM T_CR_MaxSerial WHERE FCodeRuleID = ? and FSortItemValue = ?";
        String fnummax = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        });
        if (fnummax != null) {
            BigDecimal max = new BigDecimal(fnummax);
            logger.info(String.format("CodeRuleServiceImp: \u7f16\u7801\u89c4\u5219\uff08%s, %s\uff09\u4ece\u6700\u5927\u53f7\u8868\u83b7\u53d6\u5230\u6700\u5927\u53f7 %s,", ruleId, sortItem, max));
            return max.longValue();
        }
        int initMaxNumber = 0;
        DynamicObject dynaObj = CodeRuleInfoBuilder.buildCodeRuleMaxSerial(ruleId, sortItem, initMaxNumber);
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_coderule_maxserial"), (Object[])new DynamicObject[]{dynaObj});
        logger.info(String.format("CodeRuleServiceImp: \u7f16\u7801\u89c4\u5219\uff08%s, %s\uff09\u7b2c\u4e00\u6b21\u63d2\u5165\u6700\u5927\u53f7\u8868", ruleId, sortItem));
        return initMaxNumber;
    }

    @Override
    public boolean updateMaxNumber(String ruleId, String sortItem, long maxNumber) {
        BigDecimal max = new BigDecimal(maxNumber);
        Object[] updateParam = new SqlParameter[3];
        updateParam[0] = new SqlParameter(":FMaxSerial", 2, (Object)max);
        updateParam[1] = new SqlParameter(":FCodeRuleID", 12, (Object)ruleId);
        if (StringUtils.isBlank((CharSequence)sortItem)) {
            sortItem = " ";
        }
        updateParam[2] = new SqlParameter(":FSortItemValue", 12, (Object)sortItem);
        String strSQL = "update T_CR_MaxSerial set FMaxSerial = ? where FCodeRuleID = ? and FSortItemValue = ? ";
        int count = DB.update((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])updateParam);
        if (count >= 1) {
            logger.info("CodeRuleServiceImp.updateMaxNumber Sucess:ruleId=(" + ruleId + "),maxNumber=(" + maxNumber + "),sortItem=(" + sortItem + ")");
            return true;
        }
        logger.info("CodeRuleServiceImp.updateMaxNumber Fail:ruleId=(" + ruleId + "),maxNumber=(" + maxNumber + "),sortItem=(" + sortItem + ")");
        return false;
    }

    @Override
    public boolean updateMaxNumber(CodeRuleInfo codeRuleInfo, String sortItem, long maxNumber) {
        return this.updateMaxNumber(codeRuleInfo.getId(), sortItem, maxNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signerNumbers(CodeRuleInfo codeRuleInfo, CodeRuleEntryInfo codeRuleEntry, String sortItem, String[] serialNumbers, int start) {
        String codeRuleID = codeRuleInfo.getId();
        String codeRuleName = codeRuleInfo.getName();
        String seqSegmentEntryID = "";
        String key = (codeRuleID + seqSegmentEntryID + sortItem).intern();
        String dLockKey = key;
        if (dLockKey.endsWith("/")) {
            dLockKey = dLockKey.replace("/", "").intern();
        }
        try (DLock dl = DLock.create((String)("bas/coderule/" + dLockKey));){
            dl.lock();
            try {
                long maxNumber = 0L;
                String maxSerialNumber = CodeRuleCache.getMaxSerialNumber(key);
                maxNumber = StringUtils.isBlank((CharSequence)maxSerialNumber) || "DATA_LOADED".equals(maxSerialNumber) ? this.getMaxNumber(codeRuleInfo.getId(), sortItem) : Long.parseLong(maxSerialNumber);
                for (int i = start; i < serialNumbers.length; ++i) {
                    serialNumbers[i] = String.valueOf(maxNumber + codeRuleEntry.getStep() * (long)(i - start + 1));
                }
                String strMaxNum = String.valueOf(maxNumber += codeRuleEntry.getStep() * (long)(serialNumbers.length - start));
                CodeRuleCache.updateMaxSerialNumber(key, strMaxNum);
                maxSerialNumber = CodeRuleCache.getMaxSerialNumber(key);
                String errorInfo = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6bd4\u5bf9\u53d1\u73b0:\u66f4\u65b0\u7f16\u7801\u89c4\u5219 %1$s(%2$s) \u6700\u5927\u53f7\u7f13\u5b58\u6ca1\u6709\u6210\u529f\u3002newNum:%3$s\uff0coldNum:%4$s", (String)"DBCodeRuleSigner_1", (String)"bos-coderule", (Object[])new Object[0]), codeRuleName, codeRuleID, strMaxNum, maxSerialNumber);
                int loopCount = 0;
                while (!strMaxNum.equals(maxSerialNumber)) {
                    logger.error(errorInfo);
                    if (++loopCount > 2) break;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Throwable)e);
                    }
                    maxSerialNumber = CodeRuleCache.getMaxSerialNumber(key);
                }
                if (!strMaxNum.equals(maxSerialNumber)) {
                    throw new KDException(new ErrorCode("", errorInfo), new Object[0]);
                }
                logger.info(String.format("CodeRuleServiceImp: \u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7\u7f13\u5b58\u66f4\u65b0\u6210\u529f (%s, %s, %s), \u6700\u5927\u53f7 (%s)", codeRuleID, codeRuleName, sortItem, strMaxNum));
                this.updateMaxNumber(codeRuleInfo.getId(), sortItem, maxNumber);
            }
            finally {
                dl.unlock();
            }
        }
    }
}

