/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.domain.DynamicObjectDTO;
import kd.bos.coderule.domain.GroupHandlerDataEntity;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.coderule.util.CodeRuleInfoUtil;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.dataentity.entity.DynamicObject;
import org.apache.commons.collections4.CollectionUtils;

public abstract class GroupHandler {
    private final CodeRuleServiceImp codeRuleService;
    private final String entityId;
    private final List<GroupHandlerDataEntity> dataEntities;
    private final CodeRuleInfo customCodeRuleInfo;

    public GroupHandler(CodeRuleServiceImp codeRuleService, String entityId, List<GroupHandlerDataEntity> dataEntities) {
        this.codeRuleService = codeRuleService;
        this.entityId = entityId;
        this.dataEntities = dataEntities;
        this.customCodeRuleInfo = null;
    }

    public GroupHandler(CodeRuleServiceImp codeRuleService, String entityId, List<GroupHandlerDataEntity> dataEntities, CodeRuleInfo customCodeRuleInfo) {
        this.codeRuleService = codeRuleService;
        this.entityId = entityId;
        this.dataEntities = dataEntities;
        this.customCodeRuleInfo = customCodeRuleInfo;
    }

    public void process() {
        ArrayList<DynamicObjectDTO> dynamicCodeRuleDTOS = new ArrayList<DynamicObjectDTO>(this.dataEntities.size());
        List<CodeRuleInfo> codeRuleList = this.codeRuleService.getAllCodeRuleByEntity(this.entityId);
        if (CollectionUtils.isNotEmpty(codeRuleList)) {
            CodeRuleInfoUtil codeRuleInfoUtil = new CodeRuleInfoUtil();
            for (GroupHandlerDataEntity groupHandlerDataEntity : this.dataEntities) {
                DynamicObject dynamicObject = groupHandlerDataEntity.getDynamicObject();
                CodeRuleInfo codeRule = this.customCodeRuleInfo;
                if (codeRule == null) {
                    if (this.codeRuleService.getCodeRuleInfoFun() == null) {
                        Long userOrgId = this.codeRuleService.getUserOrgId(dynamicObject, CodeRuleSerialNumUtil.getMainOrgId(dynamicObject));
                        codeRule = codeRuleInfoUtil.getUsableCodeRuleIdCache(codeRuleList, userOrgId, dynamicObject);
                        if (codeRule != null) {
                            codeRule.setEntityId(this.entityId);
                            codeRule.setOrgId(userOrgId.longValue());
                        }
                    } else {
                        codeRule = this.codeRuleService.getCodeRuleInfoFun().apply(dynamicObject);
                    }
                }
                if (codeRule == null) continue;
                dynamicCodeRuleDTOS.add(new DynamicObjectDTO(groupHandlerDataEntity, codeRule));
            }
        }
        this.groupByCodeRule(dynamicCodeRuleDTOS);
    }

    protected void groupByCodeRule(List<DynamicObjectDTO> dynamicCodeRuleDTOS) {
        HashMap<String, CodeRuleInfo> codeRuleInfoMap = new HashMap<String, CodeRuleInfo>();
        HashMap<String, List> dataInfoGroupByCodeRule = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(dynamicCodeRuleDTOS)) {
            for (DynamicObjectDTO dynamicObjectDTO : dynamicCodeRuleDTOS) {
                codeRuleInfoMap.putIfAbsent(dynamicObjectDTO.getCodeRuleInfo().getId(), dynamicObjectDTO.getCodeRuleInfo());
                dataInfoGroupByCodeRule.computeIfAbsent(dynamicObjectDTO.getCodeRuleInfo().getId(), k -> new ArrayList()).add(dynamicObjectDTO.getDataEntity());
            }
        }
        for (Map.Entry entry : dataInfoGroupByCodeRule.entrySet()) {
            CodeRuleInfo codeRuleInfo = (CodeRuleInfo)codeRuleInfoMap.get(entry.getKey());
            List dataEntitysByGroup = (List)entry.getValue();
            this.groupBySortItem(codeRuleInfo, dataEntitysByGroup);
        }
    }

    private void groupBySortItem(CodeRuleInfo codeRuleInfo, List<GroupHandlerDataEntity> dataEntitysByGroup) {
        HashMap<String, List> dataInfoGroupBySortItem = new HashMap<String, List>();
        for (GroupHandlerDataEntity groupHandlerDataEntity : dataEntitysByGroup) {
            String sortItemValue = this.codeRuleService.getSortItem(codeRuleInfo, groupHandlerDataEntity.getDynamicObject());
            dataInfoGroupBySortItem.computeIfAbsent(sortItemValue, k -> new ArrayList()).add(groupHandlerDataEntity);
        }
        for (Map.Entry entry : dataInfoGroupBySortItem.entrySet()) {
            List dataEntities = (List)entry.getValue();
            String sortItem = (String)entry.getKey();
            this.groupProcess(codeRuleInfo, sortItem, dataEntities);
        }
    }

    protected abstract void groupProcess(CodeRuleInfo var1, String var2, List<GroupHandlerDataEntity> var3);
}

