/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.handler;

import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public abstract class TraceHandler {
    private static final Log logger = LogFactory.getLog(TraceHandler.class);
    private final CodeRuleInfo codeRuleInfo;
    private final List<DynamicObject> dynamicObjects;

    public TraceHandler(CodeRuleInfo codeRuleInfo, List<DynamicObject> dynamicObjects) {
        this.codeRuleInfo = codeRuleInfo;
        this.dynamicObjects = dynamicObjects;
    }

    public void process() {
        try (TraceSpan span = Tracer.create((String)"CodeRuleServiceImp", (String)"getNumber");){
            span.addTag("codeRuleInfo.id", this.codeRuleInfo.getId());
            span.addTag("codeRuleInfo.getEntityId", this.codeRuleInfo.getEntityId());
            span.addTag("isReadNumber", String.valueOf(false));
            logger.info(String.format("CodeRuleServiceImp.getNumber(): codeRuleInfo(%s , %s) , codeRuleInfo.getEntityId: %s , isReadNumber: %s", this.codeRuleInfo.getId(), this.codeRuleInfo.getName(), this.codeRuleInfo.getEntityId(), Boolean.FALSE));
            this.traceProcess();
        }
    }

    public abstract void traceProcess();
}

