/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.handler;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class TransactionHandler {
    private static final Log logger = LogFactory.getLog(TransactionHandler.class);

    public TransactionHandler(String errMsg) {
        try (TXHandle h = TX.requiresNew();){
            try {
                this.transactionProcess();
            }
            catch (Exception e) {
                logger.error(errMsg, (Throwable)e);
                h.markRollback();
                this.doError(e);
            }
        }
        this.afterSucess();
    }

    @Deprecated
    public void process() {
    }

    protected abstract void transactionProcess();

    protected void doError(Exception e) {
    }

    protected void afterSucess() {
    }
}

