/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.newedit;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;

public class FieldUtil {
    private AbstractFormPlugin formPlugin;
    private IDataModel dataModel;
    private boolean isCreateNewData;

    public FieldUtil(AbstractFormPlugin formPlugin, IDataModel dataModel) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
        this.isCreateNewData = false;
    }

    public FieldUtil(AbstractFormPlugin formPlugin, IDataModel dataModel, boolean isCreateNewData) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
        this.isCreateNewData = isCreateNewData;
    }

    public void setFieldValueWithDefault(String fieldName, int row) {
        Object defaultValue = this.getDefaultValue(fieldName);
        if (defaultValue == null) {
            return;
        }
        this.setFieldValue(fieldName, defaultValue.toString(), row);
    }

    private Object getDefaultValue(String fieldName) {
        Control control = this.formPlugin.getView().getControl(fieldName);
        if (control == null) {
            return null;
        }
        FieldEdit fieldEdit = (FieldEdit)control;
        IDataEntityProperty property = fieldEdit.getProperty();
        FieldProp fieldProp = (FieldProp)property;
        return fieldProp.getDefValue();
    }

    public void setFieldValue(String fieldName, String fieldValue, int row) {
        if (this.isCreateNewData) {
            this.dataModel.setValue(fieldName, (Object)fieldValue, row);
            return;
        }
        this.setFieldValueForSafe(fieldName, fieldValue, row);
    }

    private void setFieldValueForSafe(String fieldName, String fieldValue, int row) {
        this.dataModel.beginInit();
        this.dataModel.setValue(fieldName, (Object)fieldValue, row);
        this.dataModel.endInit();
        this.formPlugin.getView().updateView(fieldName, row);
    }
}

