/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.newedit;

import java.util.Collection;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.enums.SerialBasisEnum;
import kd.bos.coderule.newedit.SplitsignUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class PageDataEntryPlugin {
    public static final String FORMAT = "format";
    public static final String ATTRIBUTETYPE = "attributetype";
    private IDataModel dataModel;

    public PageDataEntryPlugin(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void saveCodeRuleEntry(DynamicObject coderule) {
        Integer oldStep = null;
        DynamicObjectCollection ruleentry = coderule.getDynamicObjectCollection("ruleentry");
        if (CollectionUtils.isNotEmpty((Collection)ruleentry)) {
            for (DynamicObject dynamicObject : ruleentry) {
                String attributetype = dynamicObject.getString(ATTRIBUTETYPE);
                if (!attributetype.equals(CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr())) continue;
                oldStep = dynamicObject.getInt("step");
            }
        }
        int rowCount = this.dataModel.getEntryRowCount("entryentity");
        MainEntityType dtEntry = EntityMetadataCache.getDataEntityType((String)"bos_coderule_entry");
        DynamicObject[] coderuleEntryArr = new DynamicObject[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dtEntry);
            dynamicObject.set("id", (Object)coderule);
            dynamicObject.set("seq", (Object)row);
            dynamicObject.set(ATTRIBUTETYPE, this.dataModel.getValue(ATTRIBUTETYPE, row));
            if (row != 0) {
                boolean isSplitsign = StringUtils.isBlank((CharSequence)SplitsignUtil.convertSpecialToEmpty(this.dataModel.getValue("splitsignentry", row).toString()));
                if (isSplitsign) {
                    dynamicObject.set("issplitsign", (Object)Boolean.FALSE);
                    dynamicObject.set("splitsign", null);
                } else {
                    dynamicObject.set("issplitsign", (Object)Boolean.TRUE);
                    dynamicObject.set("splitsign", (Object)SplitsignUtil.convertSpecialToEmpty(this.dataModel.getValue("splitsignentry", row).toString()));
                }
            }
            Object fixval = this.dataModel.getValue("fixval", row);
            Object format = this.dataModel.getValue(FORMAT, row);
            if (CodeRuleEntryTypeEnum.TYPE_DATE_FIELD.getTypeStr().equals(this.dataModel.getValue(ATTRIBUTETYPE, row).toString()) || CodeRuleEntryTypeEnum.TYPE_SYSTEM_TIME_FIELD.getTypeStr().equals(this.dataModel.getValue(ATTRIBUTETYPE, row).toString())) {
                dynamicObject.set(FORMAT, format);
            } else if (fixval != null && !"".equals(fixval.toString())) {
                dynamicObject.set(FORMAT, fixval);
            } else if (format != null && !"".equals(format.toString())) {
                dynamicObject.set(FORMAT, format);
            }
            dynamicObject.set("attusingmode", this.dataModel.getValue("attusingmode", row));
            dynamicObject.set("length", this.dataModel.getValue("length", row));
            dynamicObject.set("step", this.dataModel.getValue("step", row));
            dynamicObject.set("initial", this.dataModel.getValue("initial", row));
            dynamicObject.set("valueatribute", this.dataModel.getValue("valueatribute", row));
            dynamicObject.set("addchar", this.dataModel.getValue("addchar", row));
            dynamicObject.set("addstyle", this.dataModel.getValue("addstyle", row));
            dynamicObject.set("cutstyle", this.dataModel.getValue("cutstyle", row));
            Object serialbasisObj = this.dataModel.getValue("serialbasis", row);
            int serialbasis = Integer.parseInt(serialbasisObj.toString());
            boolean issortitem = false;
            boolean isvisable = true;
            if (SerialBasisEnum.ISNOT_BASIS.getType() == serialbasis) {
                issortitem = false;
                isvisable = true;
            } else if (SerialBasisEnum.IS_BASIS.getType() == serialbasis) {
                issortitem = true;
                isvisable = true;
            } else if (SerialBasisEnum.IS_BASIS_BUT_UNSHOW.getType() == serialbasis) {
                issortitem = true;
                isvisable = false;
            }
            dynamicObject.set("issortitem", (Object)issortitem);
            dynamicObject.set("isvisable", (Object)isvisable);
            coderuleEntryArr[row] = dynamicObject;
            if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(dynamicObject.getString(ATTRIBUTETYPE))) continue;
            Integer newStep = dynamicObject.getInt("step");
            if (oldStep == null || newStep.equals(oldStep)) continue;
            String codeRuleId = coderule.getString("id");
            this.updateStepForSortItems(codeRuleId, newStep);
        }
        SaveServiceHelper.save((DynamicObject[])coderuleEntryArr);
    }

    private void updateStepForSortItems(String codeRuleId, Integer newStep) {
        DynamicObject[] objs;
        QFilter qf = new QFilter("coderuleid", "=", (Object)codeRuleId);
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"bos_coderule_maxserial", (String)"sortitemvalue", (QFilter[])new QFilter[]{qf})) {
            String sortitemvalue = obj.getString("sortitemvalue");
            CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance();
            codeRuleSigner.updateStep(codeRuleId, sortitemvalue, newStep);
        }
    }
}

