/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.newedit;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.newedit.NumberUtil;
import kd.bos.coderule.newedit.PageCacheUtil;
import kd.bos.coderule.newedit.PageDataEntryPlugin;
import kd.bos.coderule.newedit.SplitsignUtil;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleFastUtil;
import kd.bos.coderule.util.CodeRuleUtils;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PageDataPlugin {
    public static final String ENABLE = "enable";
    public static final String ENTRYENTITY = "entryentity";
    public static final String FIXVAL = "fixval";
    public static final String ADDCHAR = "addchar";
    public static final String ATTRIBUTETYPE = "attributetype";
    public static final String FORMAT = "format";
    public static final String LENGTH = "length";
    public static final String NUMBER = "number";
    public static final String BIZOBJECTID = "bizobjectid";
    public static final String SPLITSIGN = "splitsign";
    public static final String APPMODE = "appmode";
    public static final String ISADDVIEW = "isaddview";
    public static final String ISMATCHCODERULE = "ismatchcoderule";
    public static final String IS_CHECK_NUMBER = "ischecknumber";
    public static final String ISMODIFIABLE = "ismodifiable";
    public static final String ISUNIQUE = "isunique";
    public static final String ISNONBREAK = "isnonbreak";
    private static final String IS_FILL_WITH_ZERO = "isfillwithzero";
    private static final String IS_AUTO_INCR_LENGTH = "isautoincrlength";
    private static final String BOS_CODERULE = "bos-coderule";
    private AbstractFormPlugin formPlugin;
    private IDataModel dataModel;
    private PageDataEntryPlugin pageDataEntryPlugin;
    private static final Log log = LogFactory.getLog(PageDataPlugin.class);

    public PageDataPlugin(AbstractFormPlugin formPlugin, IDataModel dataModel) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
        this.pageDataEntryPlugin = new PageDataEntryPlugin(dataModel);
    }

    public void save(String codeRuleId, DynamicObject bizobject) {
        String str;
        boolean enable;
        ILocaleString ruleName = (ILocaleString)this.dataModel.getValue("name");
        if (StringUtils.isNotBlank((CharSequence)codeRuleId) && !"0".equals(codeRuleId) && (enable = PageCacheUtil.getDynamicObjectFromPageCache(this.formPlugin).getBoolean(ENABLE)) && StringUtils.isNotBlank((CharSequence)(str = CodeRuleUtils.isDuplicateCodeRule(bizobject.getString("id"), codeRuleId, null, null)))) {
            this.formPlugin.getView().showErrorNotification(str);
            return;
        }
        String id = this.saveData();
        this.dataModel.setValue("id", (Object)id);
        this.dataModel.setDataChanged(false);
    }

    public boolean checkData(StringBuilder errMsg) {
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        if (rowCount == 0) {
            errMsg.append(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u4e00\u6761\u7f16\u7801\u89c4\u5219\u5206\u6bb5\u3002", (String)"PageDataPlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
            return false;
        }
        ILocaleString ruleName = (ILocaleString)this.dataModel.getValue("name");
        if (ruleName.getLocaleValue() == null || "null".equals(ruleName.getLocaleValue()) || ruleName.getLocaleValue().trim().length() == 0) {
            errMsg.append(ResManager.loadKDString((String)"\u201c\u89c4\u5219\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return false;
        }
        if (this.checkCodeRuleName(errMsg, ruleName)) {
            return false;
        }
        if (this.checkCodeRuleNumber(errMsg)) {
            return false;
        }
        int seqTypeNum = 0;
        int randomTypeNum = 0;
        boolean isNumber = true;
        int numLen = 0;
        boolean isUnsureLength = false;
        boolean isContainRandom = false;
        String splitCountStr = "";
        boolean isFillWithZero = true;
        boolean isAutoIncrLength = false;
        block9: for (int row = 0; row < rowCount; ++row) {
            int entryNum = row;
            splitCountStr = NumberUtil.toChinese(String.valueOf(entryNum + 1));
            String fixval = (String)this.dataModel.getValue(FIXVAL, entryNum);
            String addchar = (String)this.dataModel.getValue(ADDCHAR, entryNum);
            if (StringUtils.isNotBlank((CharSequence)fixval) && fixval.contains("!")) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u8bbe\u7f6e\u503c\u201d\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\u201c!\u201d", (String)"PageDataPlugin_27", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)addchar) && addchar.contains("!")) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u8865\u4f4d\u7b26\u53f7\u201d\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\u201c!\u201d", (String)"PageDataPlugin_28", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                return false;
            }
            String attributetype = String.valueOf(this.dataModel.getValue(ATTRIBUTETYPE, entryNum));
            CodeRuleEntryTypeEnum typeEnum = CodeRuleEntryTypeEnum.getEnums(attributetype);
            switch (typeEnum) {
                case TYPE_FIX_TEXT: {
                    if (this.isEmpty(this.dataModel.getValue(FIXVAL, entryNum))) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u8bbe\u7f6e\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_29", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    if (isNumber) {
                        isNumber = this.validationNum(this.dataModel.getValue(FIXVAL, entryNum).toString());
                    }
                    numLen += this.dataModel.getValue(FIXVAL, entryNum).toString().length();
                    continue block9;
                }
                case TYPE_RANDOM_NUMBER: {
                    isContainRandom = true;
                    ++randomTypeNum;
                    continue block9;
                }
                case TYPE_SYSTEM_TIME_FIELD: {
                    if (this.isEmpty(this.dataModel.getValue(FORMAT, entryNum))) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u663e\u793a\u683c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_30", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    String sysDateStr = this.dataModel.getValue(FORMAT, entryNum).toString();
                    if (!this.validationDateNum(sysDateStr)) {
                        isNumber = false;
                        continue block9;
                    }
                    numLen += sysDateStr.length();
                    continue block9;
                }
                case TYPE_DATE_FIELD: {
                    if (this.isEmpty(this.dataModel.getValue(FORMAT, entryNum))) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u663e\u793a\u683c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_30", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    if (this.isEmpty(this.dataModel.getValue("valueatributeshow", entryNum))) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%s\u6bb5\u201d\u7684\u201c\u7f16\u7801\u6765\u6e90\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    String dateStr = this.dataModel.getValue(FORMAT, entryNum).toString();
                    if (!this.validationDateNum(dateStr)) {
                        isNumber = false;
                        continue block9;
                    }
                    numLen += dateStr.length();
                    continue block9;
                }
                case TYPE_ITEM_FIELD: 
                case TYPE_LIST_FIELD: {
                    if (this.isEmpty(this.dataModel.getValue("valueatributeshow", entryNum))) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u7f16\u7801\u6765\u6e90\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_31", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    int attusingmode = Integer.parseInt(String.valueOf(this.dataModel.getValue("attusingmode", entryNum)));
                    if (attusingmode == 4) {
                        if (null != this.dataModel.getValue(ADDCHAR, entryNum) && this.isEmpty(this.dataModel.getValue(ADDCHAR, entryNum))) {
                            errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u8865\u4f4d\u7b26\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_32", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                            return false;
                        }
                        if (null != this.dataModel.getValue("addstyle", entryNum) && this.isEmpty(this.dataModel.getValue("addstyle", entryNum))) {
                            errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u8865\u4f4d\u680f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_33", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                            return false;
                        }
                        if (null != this.dataModel.getValue("cutstyle", entryNum) && this.isEmpty(this.dataModel.getValue("cutstyle", entryNum))) {
                            errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u622a\u53bb\u680f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_34", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                            return false;
                        }
                        if (Integer.parseInt(this.dataModel.getValue(LENGTH, entryNum).toString()) == 0) {
                            errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u957f\u5ea6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_35", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                            return false;
                        }
                    }
                    isUnsureLength = true;
                    continue block9;
                }
                case TYPE_SEQ: {
                    ++seqTypeNum;
                    if (Integer.parseInt(this.dataModel.getValue("step", entryNum).toString()) == 0) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u6b65\u957f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_36", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    if (Integer.parseInt(this.dataModel.getValue("initial", entryNum).toString()) == 0) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u8d77\u59cb\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_37", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    if (Integer.parseInt(this.dataModel.getValue(LENGTH, entryNum).toString()) == 0) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u957f\u5ea6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_35", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    if (this.dataModel.getValue("initial", entryNum).toString().length() > Integer.parseInt(this.dataModel.getValue(LENGTH, entryNum).toString())) {
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801%1$s\u6bb5\u201d\u7684\u201c\u8d77\u59cb\u503c\u201d\u4f4d\u6570\u8981\u5c0f\u4e8e\u7b49\u4e8e\u201c\u957f\u5ea6\u201d\u3002", (String)"PageDataPlugin_38", (String)BOS_CODERULE, (Object[])new Object[0]), splitCountStr));
                        return false;
                    }
                    numLen += Integer.parseInt(this.dataModel.getValue(LENGTH, entryNum).toString());
                    isFillWithZero = (Boolean)this.dataModel.getValue(IS_FILL_WITH_ZERO, entryNum);
                    isAutoIncrLength = (Boolean)this.dataModel.getValue(IS_AUTO_INCR_LENGTH, entryNum);
                    continue block9;
                }
                case CHECK_CODE: {
                    if (row + 1 < rowCount) {
                        errMsg.append(ResManager.loadKDString((String)"\u201c\u6821\u9a8c\u7801\u201d\u53ea\u80fd\u88ab\u8bbe\u7f6e\u4e3a\u6700\u540e\u4e00\u6bb5\u3002", (String)"PageDataPlugin_15", (String)BOS_CODERULE, (Object[])new Object[0]));
                        return false;
                    }
                    for (int j = 1; j < rowCount; ++j) {
                        String isSplitSign = this.dataModel.getValue("splitsignentry", j).toString();
                        if (!StringUtils.isNotBlank((CharSequence)(isSplitSign = SplitsignUtil.convertSpecialToEmpty(isSplitSign)))) continue;
                        errMsg.append(ResManager.loadKDString((String)"\u6b64\u89c4\u5219\u5b9a\u4e49\u4e86\u201c\u6821\u9a8c\u7801\u201d\uff0c\u8bf7\u53bb\u6389\u201c\u6bb5\u95f4\u5206\u9694\u7b26\u201d\u3002", (String)"PageDataPlugin_16", (String)BOS_CODERULE, (Object[])new Object[0]));
                        return false;
                    }
                    if (!isNumber) {
                        errMsg.append(ResManager.loadKDString((String)"\u672c\u89c4\u5219\u5b9a\u4e49\u4e86\u201c\u6821\u9a8c\u7801\u201d\uff0c\u7f16\u7801\u4e2d\u4e0d\u80fd\u5b58\u5728\u9664\u6570\u5b57\u4ee5\u5916\u7684\u5176\u4ed6\u5b57\u7b26\u3002", (String)"PageDataPlugin_17", (String)BOS_CODERULE, (Object[])new Object[0]));
                        return false;
                    }
                    if (isContainRandom) {
                        errMsg.append(ResManager.loadKDString((String)"\u6b64\u89c4\u5219\u5b9a\u4e49\u4e86\u201c\u6821\u9a8c\u7801\u201d\uff0c\u8bf7\u53bb\u6389\u201c\u968f\u673a\u7801\u201d\u3002", (String)"PageDataPlugin_39", (String)BOS_CODERULE, (Object[])new Object[0]));
                        return false;
                    }
                    if (isUnsureLength && numLen > 12) {
                        errMsg.append(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u7b26\u5408\u201c\u6821\u9a8c\u7801\u201d\u957f\u5ea6\u8981\u6c42(\u201c\u6821\u9a8c\u7801\u201d\u524d\u4e3a12\u4f4d\u6570\u5b57)\u3002", (String)"PageDataPlugin_40", (String)BOS_CODERULE, (Object[])new Object[0]));
                        return false;
                    }
                    if (!isUnsureLength && numLen != 12) {
                        errMsg.append(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u7b26\u5408\u201c\u6821\u9a8c\u7801\u201d\u957f\u5ea6\u8981\u6c42(\u201c\u6821\u9a8c\u7801\u201d\u524d\u4e3a12\u4f4d\u6570\u5b57)\u3002", (String)"PageDataPlugin_40", (String)BOS_CODERULE, (Object[])new Object[0]));
                        return false;
                    }
                    if (!isFillWithZero) {
                        errMsg.append(ResManager.loadKDString((String)"\u6821\u9a8c\u7801\u524d\u7684\u6570\u5b57\u987b\u4e3a12\u4f4d\uff0c\u8bf7\u5f00\u542f\u6d41\u6c34\u53f7\u201c\u75280\u8865\u4f4d\u201d\u53c2\u6570\u6216\u7f16\u7801\u6bb5\u4e0d\u4f7f\u7528\u6821\u9a8c\u7801\u3002", (String)"PageDataPlugin_41", (String)BOS_CODERULE, (Object[])new Object[0]));
                        return false;
                    }
                    if (isAutoIncrLength) continue block9;
                    errMsg.append(ResManager.loadKDString((String)"\u6821\u9a8c\u7801\u524d\u7684\u6570\u5b57\u987b\u4e3a12\u4f4d\uff0c\u8bf7\u5f00\u542f\u6d41\u6c34\u53f7\u201c\u8d85\u8fc7\u8bbe\u7f6e\u957f\u5ea6\u65f6\u81ea\u52a8\u5347\u4f4d\u201d\u53c2\u6570\u6216\u7f16\u7801\u6bb5\u4e0d\u4f7f\u7528\u6821\u9a8c\u7801\u3002", (String)"PageDataPlugin_42", (String)BOS_CODERULE, (Object[])new Object[0]));
                    return false;
                }
            }
        }
        if (randomTypeNum == 0 && seqTypeNum == 0) {
            errMsg.append(ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u5fc5\u987b\u5305\u542b\u4e00\u6bb5\u201c\u968f\u673a\u7801\u201d\u6216\u8005\u201c\u6d41\u6c34\u53f7\u201d\u7c7b\u578b\u7684\u7f16\u7801\u6bb5\u3002", (String)"PageDataPlugin_19", (String)BOS_CODERULE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCodeRuleName(StringBuilder errMsg, ILocaleString ruleName) {
        DynamicObject[] dot;
        QFilter[] qFilter = new QFilter[2];
        qFilter[0] = new QFilter("name", "=", (Object)ruleName.getLocaleValue());
        String codeRuleId = (String)this.dataModel.getValue("id");
        if (StringUtils.isNotBlank((CharSequence)codeRuleId)) {
            qFilter[1] = new QFilter("id", "!=", (Object)codeRuleId);
        }
        if (null != (dot = BusinessDataServiceHelper.load((String)"bos_coderule", (String)"id,name", (QFilter[])qFilter)) && dot.length > 0) {
            errMsg.append(ResManager.loadKDString((String)"\u201c\u89c4\u5219\u540d\u79f0\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"PageDataPlugin_20", (String)BOS_CODERULE, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkCodeRuleNumber(StringBuilder errMsg) {
        DynamicObject[] dot;
        QFilter[] qFilter = new QFilter[2];
        Object numberObj = this.dataModel.getValue(NUMBER);
        if (numberObj == null || StringUtils.isBlank((CharSequence)("" + numberObj))) {
            errMsg.append(ResManager.loadKDString((String)"\u201c\u89c4\u5219\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDataPlugin_21", (String)BOS_CODERULE, (Object[])new Object[0]));
            return true;
        }
        qFilter[0] = new QFilter(NUMBER, "=", (Object)("" + numberObj));
        String codeRuleId = (String)this.dataModel.getValue("id");
        if (StringUtils.isNotBlank((CharSequence)codeRuleId)) {
            qFilter[1] = new QFilter("id", "!=", (Object)codeRuleId);
        }
        if (null != (dot = BusinessDataServiceHelper.load((String)"bos_coderule", (String)"id,number", (QFilter[])qFilter)) && dot.length > 0) {
            errMsg.append(ResManager.loadKDString((String)"\u201c\u89c4\u5219\u7f16\u7801\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"PageDataPlugin_22", (String)BOS_CODERULE, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validationDateNum(String dateStr) {
        String str = "^[A-Za-z0-9]+$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(dateStr);
        return m.matches();
    }

    private boolean validationNum(String substring) {
        String str = "^[0-9]*$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(substring);
        return m.matches();
    }

    private boolean isEmpty(Object obj) {
        return obj == null || String.valueOf(obj).trim().length() == 0;
    }

    private String saveData() {
        IDataModel model = this.dataModel;
        String id = (String)model.getValue("id");
        if (id == null || id.trim().length() == 0) {
            id = this.saveDataForInsert();
        } else {
            this.saveDataForUpdate(id);
        }
        return id;
    }

    private String saveDataForInsert() {
        DynamicObject dynamicObject = PageCacheUtil.getDynamicObjectFromPageCache(this.formPlugin);
        dynamicObject = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)dynamicObject);
        dynamicObject.set(BIZOBJECTID, this.dataModel.getValue(BIZOBJECTID));
        dynamicObject.set("name", this.dataModel.getValue("name"));
        dynamicObject.set(SPLITSIGN, (Object)SplitsignUtil.convertSpecialToEmpty(this.dataModel.getValue(SPLITSIGN).toString()));
        dynamicObject.set(APPMODE, this.dataModel.getValue(APPMODE));
        dynamicObject.set("ctrlmode", (Object)"1");
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set(ENABLE, (Object)0);
        dynamicObject.set(NUMBER, this.dataModel.getValue(NUMBER));
        dynamicObject.set(ISADDVIEW, this.dataModel.getValue(ISADDVIEW));
        dynamicObject.set(ISMATCHCODERULE, this.dataModel.getValue(ISMATCHCODERULE));
        dynamicObject.set(IS_CHECK_NUMBER, this.dataModel.getValue(IS_CHECK_NUMBER));
        dynamicObject.set(ISMODIFIABLE, this.dataModel.getValue(ISMODIFIABLE));
        dynamicObject.set(ISUNIQUE, this.dataModel.getValue(ISUNIQUE));
        dynamicObject.set("isupdaterecover", this.dataModel.getValue("isupdaterecover"));
        dynamicObject.set("ispreset", this.dataModel.getValue("ispreset"));
        dynamicObject.set("useinterruption", StringUtils.isNotBlank((Object)this.dataModel.getValue("useinterruption")) ? this.dataModel.getValue("useinterruption") : "-1");
        dynamicObject.set("updatemaxnumber", StringUtils.isNotBlank((Object)this.dataModel.getValue("updatemaxnumber")) ? this.dataModel.getValue("updatemaxnumber") : "-1");
        boolean isnonbreak = false;
        boolean isFillWithZero = true;
        boolean isAutoIncrLength = false;
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        if (rowCount != 0) {
            for (int row = 0; row < rowCount; ++row) {
                Object attributetype = this.dataModel.getValue(ATTRIBUTETYPE, row);
                if (!attributetype.toString().equalsIgnoreCase(CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr())) continue;
                isnonbreak = (Boolean)this.dataModel.getValue(ISNONBREAK, row);
                isFillWithZero = (Boolean)this.dataModel.getValue(IS_FILL_WITH_ZERO, row);
                isAutoIncrLength = (Boolean)this.dataModel.getValue(IS_AUTO_INCR_LENGTH, row);
                break;
            }
        }
        dynamicObject.set(ISNONBREAK, (Object)isnonbreak);
        dynamicObject.set(IS_FILL_WITH_ZERO, (Object)isFillWithZero);
        dynamicObject.set(IS_AUTO_INCR_LENGTH, (Object)isAutoIncrLength);
        dynamicObject.set("isfast", (Object)Boolean.TRUE);
        String genStringId = DBServiceHelper.genStringId();
        dynamicObject.set("id", (Object)genStringId);
        dynamicObject.set("masterid", (Object)genStringId);
        this.convertAppModeValue(this.dataModel, dynamicObject);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.pageDataEntryPlugin.saveCodeRuleEntry(dynamicObject);
        String id = dynamicObject.getString("id");
        DynamicObject bizobject = dynamicObject.getDynamicObject(BIZOBJECTID);
        boolean isSuccess = true;
        if (bizobject != null) {
            String msg = CodeRuleUtils.isDuplicateCodeRule(bizobject.getString("id"), id, null, null);
            if (StringUtils.isBlank((CharSequence)msg)) {
                dynamicObject.set(ENABLE, (Object)1);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                this.formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpaneltips"});
                this.formPlugin.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpresettips"});
            } else {
                this.formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u53d7\u63a7\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u7f16\u7801\u89c4\u5219\uff0c\u5f53\u524d\u7f16\u7801\u89c4\u5219\u4fdd\u5b58\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"PageDataPlugin_50", (String)BOS_CODERULE, (Object[])new Object[0]));
                isSuccess = false;
            }
        }
        if (isSuccess) {
            this.formPlugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PageDataPlugin_24", (String)BOS_CODERULE, (Object[])new Object[0]), Integer.valueOf(1000));
        }
        this.dataModel.setValue(ENABLE, dynamicObject.get(ENABLE));
        this.dataModel.setDataChanged(false);
        AppLogUtil.insertAppLog(this.formPlugin.getView(), dynamicObject, new MultiLangEnumBridge("\u65b0\u589e\u89c4\u5219", "PageDataPlugin_51", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\u3002", "BOS_CODERULE_10", BOS_CODERULE), true, id, CommonUtil.getDynamicObjProperties(dynamicObject, "name").toString());
        return id;
    }

    private void convertAppModeValue(IDataModel dataModel, DynamicObject dynamicObject) {
        String appmode;
        Control control = this.formPlugin.getControl(APPMODE);
        if (control == null) {
            return;
        }
        Object appmodeObj = dataModel.getValue(APPMODE);
        if (appmodeObj != null && StringUtils.isNotBlank((CharSequence)(appmode = appmodeObj.toString()))) {
            if ("1".equals(appmode)) {
                dynamicObject.set(ISADDVIEW, (Object)0);
                dynamicObject.set(ISMODIFIABLE, (Object)0);
                dynamicObject.set(ISNONBREAK, (Object)1);
            } else if ("2".equals(appmode)) {
                dynamicObject.set(ISADDVIEW, (Object)1);
                dynamicObject.set(ISMODIFIABLE, (Object)0);
                dynamicObject.set(ISNONBREAK, (Object)0);
            } else if ("3".equals(appmode)) {
                dynamicObject.set(ISADDVIEW, (Object)1);
                dynamicObject.set(ISMODIFIABLE, (Object)1);
                dynamicObject.set(ISNONBREAK, (Object)0);
            }
        }
    }

    private void saveDataForUpdate(String id) {
        DynamicObject dynamicObject = PageCacheUtil.getDynamicObjectFromPageCache(this.formPlugin);
        DynamicObject updateCoderule = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_coderule");
        updateCoderule.set(BIZOBJECTID, this.dataModel.getValue(BIZOBJECTID));
        updateCoderule.set("name", this.dataModel.getValue("name"));
        updateCoderule.set(NUMBER, this.dataModel.getValue(NUMBER));
        updateCoderule.set(SPLITSIGN, (Object)SplitsignUtil.convertSpecialToEmpty(this.dataModel.getValue(SPLITSIGN).toString()));
        updateCoderule.set(APPMODE, this.dataModel.getValue(APPMODE));
        updateCoderule.set("modifier", (Object)RequestContext.get().getUserId());
        updateCoderule.set("modifytime", (Object)new Date());
        updateCoderule.set(ISADDVIEW, this.dataModel.getValue(ISADDVIEW));
        updateCoderule.set(ISMATCHCODERULE, this.dataModel.getValue(ISMATCHCODERULE));
        updateCoderule.set(IS_CHECK_NUMBER, this.dataModel.getValue(IS_CHECK_NUMBER));
        updateCoderule.set(ISMODIFIABLE, this.dataModel.getValue(ISMODIFIABLE));
        updateCoderule.set(ISUNIQUE, this.dataModel.getValue(ISUNIQUE));
        updateCoderule.set("isupdaterecover", this.dataModel.getValue("isupdaterecover"));
        updateCoderule.set("ispreset", this.dataModel.getValue("ispreset"));
        updateCoderule.set("useinterruption", StringUtils.isNotBlank((Object)this.dataModel.getValue("useinterruption")) ? this.dataModel.getValue("useinterruption") : "-1");
        updateCoderule.set("updatemaxnumber", StringUtils.isNotBlank((Object)this.dataModel.getValue("updatemaxnumber")) ? this.dataModel.getValue("updatemaxnumber") : "-1");
        boolean isnonbreak = false;
        boolean isFillWithZero = true;
        boolean isAutoIncrLength = false;
        int rowCount = this.dataModel.getEntryRowCount(ENTRYENTITY);
        if (rowCount != 0) {
            for (int row = 0; row < rowCount; ++row) {
                Object attributetype = this.dataModel.getValue(ATTRIBUTETYPE, row);
                if (!attributetype.toString().equalsIgnoreCase(CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr())) continue;
                isnonbreak = (Boolean)this.dataModel.getValue(ISNONBREAK, row);
                isFillWithZero = (Boolean)this.dataModel.getValue(IS_FILL_WITH_ZERO, row);
                isAutoIncrLength = (Boolean)this.dataModel.getValue(IS_AUTO_INCR_LENGTH, row);
                break;
            }
        }
        updateCoderule.set(ISNONBREAK, (Object)isnonbreak);
        updateCoderule.set(IS_FILL_WITH_ZERO, (Object)isFillWithZero);
        updateCoderule.set(IS_AUTO_INCR_LENGTH, (Object)isAutoIncrLength);
        if (isnonbreak) {
            updateCoderule.set("isfast", (Object)Boolean.TRUE);
        }
        updateCoderule.set("isserialnumber", (Object)true);
        updateCoderule.set("islog", (Object)dynamicObject.getBoolean("islog"));
        updateCoderule.set("isapporg", (Object)true);
        updateCoderule.set("isappcondition", (Object)dynamicObject.getBoolean("isappcondition"));
        updateCoderule.set("ischeckcode", (Object)dynamicObject.getBoolean("ischeckcode"));
        this.convertAppModeValue(this.dataModel, updateCoderule);
        boolean isfast = dynamicObject.getBoolean("isfast");
        if (isfast) {
            Object name = this.dataModel.getValue("name");
            String nameStr = name.toString();
            if (nameStr.contains(CodeRuleFastUtil.getTagName())) {
                nameStr = nameStr.replaceAll(CodeRuleFastUtil.getTagName(), "");
            }
            if (nameStr.contains("[]")) {
                nameStr = nameStr.replaceAll("\\[]", "");
            }
            updateCoderule.set("name", (Object)nameStr);
        }
        SaveServiceHelper.save((IDataEntityType)updateCoderule.getDataEntityType(), (Object[])new DynamicObject[]{updateCoderule});
        this.deleteEntryById(id);
        this.pageDataEntryPlugin.saveCodeRuleEntry(updateCoderule);
        this.formPlugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PageDataPlugin_24", (String)BOS_CODERULE, (Object[])new Object[0]), Integer.valueOf(1000));
        AppLogUtil.insertAppLog(this.formPlugin.getView(), dynamicObject, new MultiLangEnumBridge("\u7f16\u8f91\u89c4\u5219", "PageDataPlugin_26", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\u3002", "BOS_CODERULE_10", BOS_CODERULE), true, id, CommonUtil.getDynamicObjProperties(dynamicObject, "name").toString());
    }

    private void deleteEntryById(String coderuleId) {
        try (TXHandle h = TX.requiresNew();){
            try {
                String sql = "delete from t_cr_coderuleentry where fid = '" + coderuleId + "'";
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, null);
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    public Map<Boolean, String> disable(String id) {
        HashMap<Boolean, String> tipMap = new HashMap<Boolean, String>(16);
        DynamicObject rule = this.getRule(id);
        Boolean isSuccess = Boolean.FALSE;
        String disableMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"CodeRuleTreeListPlugin_22", (String)BOS_CODERULE, (Object[])new Object[0]);
        if (rule != null) {
            if (rule.getBoolean(ENABLE)) {
                rule.set(ENABLE, (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rule});
                this.dataModel.setValue(ENABLE, (Object)"0");
                this.dataModel.setDataChanged(false);
                isSuccess = Boolean.TRUE;
                disableMsg = ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CodeRuleTreeListPlugin_20", (String)BOS_CODERULE, (Object[])new Object[0]);
            }
            if (isSuccess.booleanValue()) {
                AppLogUtil.insertAppLog(this.formPlugin.getView(), rule, new MultiLangEnumBridge("\u7981\u7528\u89c4\u5219", "CodeRuleTreeListPlugin_24", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u7981\u7528\u6210\u529f\u3002", "CodeRuleTreeListPlugin_16", BOS_CODERULE), id, CommonUtil.getDynamicObjProperties(rule, "name").toString());
            } else {
                AppLogUtil.insertAppLog(this.formPlugin.getView(), rule, new MultiLangEnumBridge("\u7981\u7528\u89c4\u5219", "CodeRuleTreeListPlugin_24", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u7981\u7528\u3002", "CodeRuleTreeListPlugin_16", BOS_CODERULE), id, CommonUtil.getDynamicObjProperties(rule, "name").toString());
            }
        } else {
            disableMsg = ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u7f16\u7801\u89c4\u5219\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"PageDataPlugin_3", (String)BOS_CODERULE, (Object[])new Object[0]);
        }
        tipMap.put(isSuccess, disableMsg);
        return tipMap;
    }

    private DynamicObject getRule(String id) {
        String selectFields = "id,enable,bizobjectid,name";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)id)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_coderule", (String)selectFields, (QFilter[])filters);
    }

    public Map<Boolean, String> enable(String id) {
        HashMap<Boolean, String> tipMap = new HashMap<Boolean, String>(16);
        DynamicObject rule = this.getRule(id);
        Boolean isSuccess = Boolean.FALSE;
        String enableMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u53ef\u7528\u72b6\u6001\u3002", (String)"CodeRuleTreeListPlugin_37", (String)BOS_CODERULE, (Object[])new Object[0]);
        String opDescStatus = ResManager.loadKDString((String)"\u6570\u636e\u672a\u7981\u7528\uff0c\u4e0d\u80fd\u542f\u7528", (String)"CodeRuleTreeListPlugin_16", (String)BOS_CODERULE, (Object[])new Object[0]);
        if (rule == null) {
            enableMsg = ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u7f16\u7801\u89c4\u5219\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"PageDataPlugin_3", (String)BOS_CODERULE, (Object[])new Object[0]);
            tipMap.put(isSuccess, enableMsg);
            return tipMap;
        }
        if (this.dataModel.getDataChanged()) {
            enableMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6709\u66f4\u6539\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u542f\u7528\u3002", (String)"PageDataPlugin_14", (String)BOS_CODERULE, (Object[])new Object[0]);
            tipMap.put(isSuccess, enableMsg);
            return tipMap;
        }
        DynamicObject bizobject = rule.getDynamicObject(BIZOBJECTID);
        String bizObjectId = bizobject.getString("id");
        String msg = CodeRuleUtils.isDuplicateCodeRule(bizObjectId, id, null, null);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            enableMsg = msg;
            AppLogUtil.insertAppLog(this.formPlugin.getView(), rule, new MultiLangEnumBridge("\u542f\u7528\u89c4\u5219", "CodeRuleTreeListPlugin_15", BOS_CODERULE), new MultiLangEnumBridge("\u5b58\u5728\u91cd\u590d\u7684\u7f16\u7801\u89c4\u5219\u3002", "CodeRuleTreeListPlugin_15", BOS_CODERULE), new String[0]);
        } else if (!rule.getBoolean(ENABLE)) {
            rule.set(ENABLE, (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rule});
            this.dataModel.setValue(ENABLE, (Object)"1");
            this.dataModel.setDataChanged(false);
            isSuccess = Boolean.TRUE;
            enableMsg = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CodeRuleTreeListPlugin_17", (String)BOS_CODERULE, (Object[])new Object[0]);
            AppLogUtil.insertAppLog(this.formPlugin.getView(), rule, new MultiLangEnumBridge("\u542f\u7528\u89c4\u5219", "CodeRuleTreeListPlugin_15", BOS_CODERULE), new MultiLangEnumBridge("\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\u3002", "BOS_CODERULE_10", BOS_CODERULE), id, CommonUtil.getDynamicObjProperties(rule, "name").toString());
        }
        tipMap.put(isSuccess, enableMsg);
        return tipMap;
    }
}

