/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.newedit;

import java.util.HashMap;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.enums.SerialBasisEnum;
import kd.bos.coderule.newedit.AttributetypeUtil;
import kd.bos.coderule.newedit.EntryUtil;
import kd.bos.coderule.newedit.ShowFormUtil;
import kd.bos.coderule.newedit.SplitsignUtil;
import kd.bos.coderule.util.CodeRuleNumberCheckUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class PageShowEntryPlugin {
    public static final String ENTRYENTITY = "entryentity";
    public static final String ATTRIBUTETYPE = "attributetype";
    public static final String FORMAT = "format";
    public static final String ATTUSINGMODE = "attusingmode";
    public static final String VALUEATRIBUTE = "valueatribute";
    public static final String SERIALBASIS = "serialbasis";
    private static final String BOS_CODERULE = "bos-coderule";
    private AbstractFormPlugin formPlugin;
    private IDataModel dataModel;
    private AttributetypeUtil attributetypeUtil;
    private ShowFormUtil showFormUtil;
    private EntryUtil entryUtil;

    public PageShowEntryPlugin(AbstractFormPlugin formPlugin, IDataModel dataModel) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
        this.attributetypeUtil = new AttributetypeUtil(formPlugin, dataModel);
        this.showFormUtil = new ShowFormUtil(formPlugin, dataModel);
        this.entryUtil = new EntryUtil(formPlugin, dataModel);
    }

    public void initRuleEntry(DynamicObject dynamicObject, DynamicObjectCollection ruleentrys, DynamicObject bizobject) {
        this.initRuleEntryWithNum(ruleentrys.size());
        try {
            for (int row = 0; row < ruleentrys.size(); ++row) {
                DynamicObject ruleEntry = (DynamicObject)ruleentrys.get(row);
                this.initRuleEntry(dynamicObject, ruleEntry, bizobject, row);
                int type = ruleEntry.getInt(ATTRIBUTETYPE);
                if (CodeRuleEntryTypeEnum.TYPE_SEQ != CodeRuleEntryTypeEnum.getEnums(String.valueOf(type)) || this.formPlugin.getPageCache().get("isCopy") != null || !CodeRuleNumberCheckUtil.isCodeRuleUsed((String)dynamicObject.getPkValue())) continue;
                CardEntry cardEntry = (CardEntry)this.formPlugin.getControl(ENTRYENTITY);
                cardEntry.setChildEnable(false, row, new String[]{"isfillwithzero"});
            }
        }
        catch (KDBizException e) {
            this.formPlugin.getView().showErrorNotification(e.getMessage());
        }
    }

    public void checkFillWithZero() {
        DynamicObjectCollection entryEntity = this.dataModel.getEntryEntity(ENTRYENTITY);
        int index = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            int type = dynamicObject.getInt(ATTRIBUTETYPE);
            if (CodeRuleEntryTypeEnum.TYPE_SEQ == CodeRuleEntryTypeEnum.getEnums(String.valueOf(type))) {
                boolean codeRuleUsed = this.formPlugin.getPageCache().get("isCopy") == null && CodeRuleNumberCheckUtil.isCodeRuleUsed(this.dataModel.getDataEntity().getString("id"));
                CardEntry cardEntry = (CardEntry)this.formPlugin.getControl(ENTRYENTITY);
                cardEntry.setChildEnable(!codeRuleUsed, index, new String[]{"isfillwithzero"});
                break;
            }
            ++index;
        }
    }

    private void initRuleEntryWithNum(int count) {
        for (int i = 0; i < count - 1; ++i) {
            this.dataModel.createNewEntryRow(ENTRYENTITY);
        }
    }

    private void initRuleEntry(DynamicObject dynamicObject, DynamicObject dynamicObjectEntry, DynamicObject bizObject, int entryNo) {
        String attributetypeStr;
        int attributetype = dynamicObjectEntry.getInt(ATTRIBUTETYPE);
        this.entryUtil.formatEntry(entryNo, "" + attributetype);
        this.entryUtil.initDefaultValueFormEntry(entryNo, "" + attributetype, true);
        this.dataModel.setValue(ATTRIBUTETYPE, (Object)attributetype, entryNo);
        this.dataModel.setValue("fixval", dynamicObjectEntry.get(FORMAT), entryNo);
        this.dataModel.setValue(FORMAT, dynamicObjectEntry.get(FORMAT), entryNo);
        this.dataModel.setValue(ATTUSINGMODE, dynamicObjectEntry.get(ATTUSINGMODE), entryNo);
        this.dataModel.setValue("length", dynamicObjectEntry.get("length"), entryNo);
        this.dataModel.setValue("initial", dynamicObjectEntry.get("initial"), entryNo);
        this.dataModel.setValue("step", dynamicObjectEntry.get("step"), entryNo);
        this.dataModel.setValue(VALUEATRIBUTE, dynamicObjectEntry.get(VALUEATRIBUTE), entryNo);
        this.dataModel.setValue("addchar", dynamicObjectEntry.get("addchar"), entryNo);
        this.dataModel.setValue("addstyle", (Object)(dynamicObjectEntry.getBoolean("addstyle") ? 1 : 0), entryNo);
        this.dataModel.setValue("cutstyle", (Object)(dynamicObjectEntry.getBoolean("cutstyle") ? 1 : 0), entryNo);
        this.dataModel.setValue("entryid", dynamicObjectEntry.getPkValue(), entryNo);
        this.dataModel.setValue("isnonbreak", (Object)dynamicObject.getBoolean("isnonbreak"), entryNo);
        this.dataModel.setValue("isfillwithzero", (Object)dynamicObject.getBoolean("isfillwithzero"), entryNo);
        this.dataModel.setValue("isautoincrlength", (Object)dynamicObject.getBoolean("isautoincrlength"), entryNo);
        if (entryNo != 0) {
            String splitsignentry = dynamicObjectEntry.getString("splitsignentry");
            this.dataModel.setValue("splitsignentry", (Object)SplitsignUtil.convertEmptyToSpecial(splitsignentry), entryNo);
        }
        if ((attributetypeStr = "" + attributetype).equals(CodeRuleEntryTypeEnum.TYPE_ITEM_FIELD.getTypeStr()) || attributetypeStr.equals(CodeRuleEntryTypeEnum.TYPE_DATE_FIELD.getTypeStr()) || attributetypeStr.equals(CodeRuleEntryTypeEnum.TYPE_LIST_FIELD.getTypeStr())) {
            String attrName = this.attributetypeUtil.getAttrNameById(attributetype, bizObject.getString("number"), dynamicObjectEntry.getString(VALUEATRIBUTE));
            this.dataModel.setValue("valueatributeshow", (Object)attrName, entryNo);
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicObjectEntry.getString(ATTUSINGMODE))) {
            this.entryUtil.formatEntryFullValue(entryNo);
        }
        boolean issortitem = dynamicObjectEntry.getBoolean("issortitem");
        boolean isvisable = dynamicObjectEntry.getBoolean("isvisable");
        if (!issortitem && isvisable) {
            this.dataModel.setValue(SERIALBASIS, (Object)SerialBasisEnum.ISNOT_BASIS.getType(), entryNo);
        } else if (issortitem && isvisable) {
            this.dataModel.setValue(SERIALBASIS, (Object)SerialBasisEnum.IS_BASIS.getType(), entryNo);
        } else if (issortitem && !isvisable) {
            this.dataModel.setValue(SERIALBASIS, (Object)SerialBasisEnum.IS_BASIS_BUT_UNSHOW.getType(), entryNo);
        } else {
            this.formPlugin.getPageCache().put("error_tag", String.valueOf(true));
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u89c4\u5219\u6570\u636e\u5df2\u635f\u574f\uff0c\u53ef\u80fd\u662f\u6d41\u6c34\u53f7\u4f9d\u636e\u51fa\u73b0\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u8fd4\u56de\u5217\u8868\u5220\u9664\u6b64\u7f16\u7801\u89c4\u5219\u5e76\u91cd\u65b0\u521b\u5efa\u3002", (String)"PageShowEntryPlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
        }
    }

    public void showFormByFormat() {
        int row = this.dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("currentRow", row);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.formPlugin, "selectDateFormat");
        this.showFormUtil.showForm("bos_coderule_dateformat", params, closeCallBack, ShowType.Modal);
    }

    public void showFormByValueatribute() {
        int row = this.dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
        if (this.dataModel.getValue("bizobjectid") == null) {
            this.formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"PageShowEntryPlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            return;
        }
        DynamicObject bizobject = (DynamicObject)this.dataModel.getValue("bizobjectid");
        int attributetype = Integer.parseInt((String)this.dataModel.getValue(ATTRIBUTETYPE, row));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dynamicObjectType", bizobject.get(1));
        params.put(ATTRIBUTETYPE, attributetype);
        params.put("currentRow", row);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.formPlugin, "selectValueatribute");
        this.showFormUtil.showForm("bos_coderule_attr", params, closeCallBack, ShowType.Modal);
    }
}

