/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.opplugin.pagecache;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;

public class BillNoChangeCache {
    private static final String PAGECACHE_KEY_BILLNO_FROM_INIT = "coderule_billno_from_init";
    private static final String PAGECACHE_KEY_BILLNO_FROM_INIT_SPECIAL_WITH_NULL = "coderule_billno_from_init_special_with_null";
    private static final String PAGECACHE_KEY_BILLNO_FROM_INIT_VALUE_OF_NO_OPERATION = "coderule_billno_from_init_value_of_no_operation";
    private static final String PAGECACHE_KEY_BILLNO_FROM_INIT_VALUE_OF_OPERATION = "coderule_billno_from_init_value_of_operation";
    private static final String PAGECACHE_KEY_BILLNO_FROM_BEFORE_OP = "coderule_billno_from_before_do_operation";
    private IPageCache pageCache;
    private String className;
    private boolean isPageCache;

    private String getMessageUninitPagecache() {
        return ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316pageCache", (String)"BillNoChangeCache_0", (String)"bos-coderule", (Object[])new Object[0]);
    }

    public BillNoChangeCache(IPageCache pageCache, String className) {
        this.pageCache = pageCache;
        this.className = className;
        this.isPageCache = true;
    }

    public BillNoChangeCache(String className) {
        this.className = className;
        this.isPageCache = false;
    }

    public BillNoChangeCache(IPageCache pageCache) {
        this.className = "AbstractCodeRule";
        this.pageCache = pageCache;
        this.isPageCache = true;
    }

    public String getPagecacheKeyBillnoFromInit() {
        return PAGECACHE_KEY_BILLNO_FROM_INIT + this.className;
    }

    public String getPagecacheKeyBillnoFromInit(Object pkId) {
        return pkId + PAGECACHE_KEY_BILLNO_FROM_INIT + this.className;
    }

    private String getPagecacheKeyBillnoFromBeforeOp(Object pkId) {
        return pkId + PAGECACHE_KEY_BILLNO_FROM_BEFORE_OP;
    }

    public boolean isChange(OperateOption operateOption) {
        return this.isChange(operateOption, "");
    }

    public boolean isChange(OperateOption operateOption, Object pkId) {
        String operationTag;
        String billnoFromInit = this.getPagecacheKeyBillnoFromInit(pkId);
        return operateOption.tryGetVariableValue(billnoFromInit, new RefObject()) && PAGECACHE_KEY_BILLNO_FROM_INIT_VALUE_OF_OPERATION.equals(operationTag = operateOption.getVariableValue(billnoFromInit));
    }

    public void saveBeforeOpValue(String billNo, Object pkId) {
        if (StringUtils.isNotBlank((CharSequence)billNo)) {
            this.pageCache.put(this.getPagecacheKeyBillnoFromBeforeOp(pkId), billNo);
        }
    }

    public boolean isChangedOnOp(String billNo, Object pkId) {
        String cacheValue = this.pageCache.get(this.getPagecacheKeyBillnoFromBeforeOp(pkId));
        if (StringUtils.isBlank((CharSequence)cacheValue) || StringUtils.isBlank((CharSequence)billNo)) {
            return false;
        }
        return !StringUtils.equals((CharSequence)billNo, (CharSequence)cacheValue);
    }

    public void saveEmpty() {
        this.saveEmpty("");
    }

    public void saveEmpty(Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)this.getMessageUninitPagecache(), (String)"BillNoChangeCache_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        this.pageCache.put(this.getPagecacheKeyBillnoFromInit(pkId), PAGECACHE_KEY_BILLNO_FROM_INIT_SPECIAL_WITH_NULL);
    }

    public void saveValue(String billno) {
        this.saveValue(billno, "");
    }

    public void saveValue(String billno, Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)this.getMessageUninitPagecache(), (String)"BillNoChangeCache_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        this.pageCache.put(this.getPagecacheKeyBillnoFromInit(pkId), billno);
    }

    public void saveValueWhenEmpty(String billno, Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)this.getMessageUninitPagecache(), (String)"BillNoChangeCache_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        String billNoFromInitKey = this.getPagecacheKeyBillnoFromInit(pkId);
        if (null == this.pageCache.get(billNoFromInitKey)) {
            this.pageCache.put(billNoFromInitKey, billno);
        }
    }

    public void updateInitBillNoCache(Object oldPkId, Object newPkId) {
        if (!this.isPageCache || StringUtils.isBlank((CharSequence)this.className)) {
            return;
        }
        String initBillNo = this.pageCache.get(this.getPagecacheKeyBillnoFromInit(oldPkId));
        if (StringUtils.isBlank((CharSequence)initBillNo)) {
            return;
        }
        this.pageCache.put(this.getPagecacheKeyBillnoFromInit(newPkId), initBillNo);
    }

    public void convertPageCacheToOperate(OperateOption operateOption, String billno) {
        this.convertPageCacheToOperate(operateOption, billno, "");
    }

    public void convertPageCacheToOperate(OperateOption operateOption, String billno, Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)this.getMessageUninitPagecache(), (String)"BillNoChangeCache_0", (String)"BillNoChangeCache_1", (Object[])new Object[0]));
        }
        String billnoFromInit = this.getPagecacheKeyBillnoFromInit(pkId);
        String cacheBillno = this.pageCache.get(billnoFromInit);
        if (StringUtils.isNotBlank((CharSequence)cacheBillno)) {
            if (cacheBillno.equals(PAGECACHE_KEY_BILLNO_FROM_INIT_SPECIAL_WITH_NULL) && StringUtils.isBlank((CharSequence)billno)) {
                operateOption.setVariableValue(billnoFromInit, PAGECACHE_KEY_BILLNO_FROM_INIT_VALUE_OF_NO_OPERATION);
                return;
            }
            if (cacheBillno.equals(billno)) {
                operateOption.setVariableValue(billnoFromInit, PAGECACHE_KEY_BILLNO_FROM_INIT_VALUE_OF_NO_OPERATION);
                return;
            }
            operateOption.setVariableValue(billnoFromInit, PAGECACHE_KEY_BILLNO_FROM_INIT_VALUE_OF_OPERATION);
        }
    }
}

