/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.opplugin.pagecache;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;

public class PushNumberCache {
    private static final String PUSH_WITH_NUMBER_KEY = "coderule_push_with_number";
    private static final String PUSH_SIGNER_NUMBER_KEY = "coderule_push_signer_number";
    private static final String PUSH_READ_NUMBER_KEY = "coderule_push_read_number_tag";
    private IPageCache pageCache;
    private String className;

    public PushNumberCache(IPageCache pageCache, String className) {
        this.pageCache = pageCache;
        this.className = className;
    }

    public PushNumberCache(String className) {
        this.className = className;
    }

    public void signPushWithNumberCache(Object id) {
        if (this.pageCache == null) {
            return;
        }
        this.pageCache.put(this.getPushWithNumberKey(id), Boolean.toString(true));
    }

    public boolean isPushWithNumber(Object id) {
        if (this.pageCache == null) {
            return false;
        }
        return Boolean.parseBoolean(this.pageCache.get(this.getPushWithNumberKey(id)));
    }

    public void signPushSignerNumber(Object id) {
        if (this.pageCache == null) {
            return;
        }
        this.pageCache.put(this.getPushSignerNumberKey(id), Boolean.toString(true));
    }

    public boolean isPushSignerNumber(Object id) {
        if (this.pageCache == null) {
            return false;
        }
        return Boolean.parseBoolean(this.pageCache.get(this.getPushSignerNumberKey(id)));
    }

    public void clearPushSign(Object id) {
        if (this.pageCache == null) {
            return;
        }
        this.pageCache.remove(this.getPushWithNumberKey(id));
        this.pageCache.remove(this.getPushSignerNumberKey(id));
    }

    public void removePushWaySign(FormShowParameter parameter) {
        if (this.isPushWay(parameter)) {
            parameter.setCustomParam("botptag_of_datasource", (Object)"used");
        }
    }

    public boolean isPushWay(FormShowParameter parameter) {
        if (parameter == null) {
            return false;
        }
        return Boolean.parseBoolean((String)parameter.getCustomParam("botptag_of_datasource"));
    }

    public void convertPushWayToOperation(OperateOption operateOption, FormShowParameter parameter) {
        if (parameter == null || operateOption == null) {
            return;
        }
        operateOption.setVariableValue("botptag_of_datasource", (String)parameter.getCustomParam("botptag_of_datasource"));
    }

    public void convertReadNumberSignToOperation(OperateOption operateOption, Object id) {
        if (operateOption == null) {
            return;
        }
        operateOption.setVariableValue(this.getPushReadNumberKey(id), Boolean.toString(true));
    }

    public boolean isPushReadNumber(OperateOption operateOption, Object id) {
        if (operateOption == null) {
            return false;
        }
        RefObject result = new RefObject();
        if (operateOption.tryGetVariableValue(this.getPushReadNumberKey(id), result)) {
            return Boolean.parseBoolean((String)result.getValue());
        }
        return false;
    }

    public void convertSignToOperation(OperateOption operateOption, Object id) {
        if (this.pageCache == null) {
            return;
        }
        String key = this.getPushSignerNumberKey(id);
        operateOption.setVariableValue(key, this.pageCache.get(key));
    }

    public String getSignerNumberSign(OperateOption operateOption, Object id) {
        RefObject refObject = new RefObject();
        if (operateOption.tryGetVariableValue(this.getPushSignerNumberKey(id), refObject)) {
            return (String)refObject.getValue();
        }
        return "";
    }

    private String getPushWithNumberKey(Object id) {
        return PUSH_WITH_NUMBER_KEY + this.className + id;
    }

    private String getPushSignerNumberKey(Object id) {
        return PUSH_SIGNER_NUMBER_KEY + this.className + id;
    }

    private String getPushReadNumberKey(Object id) {
        return PUSH_READ_NUMBER_KEY + this.className + id;
    }
}

