/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.opplugin.pagecache;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class RecycleCache {
    private static final String PAGECACHE_KEY_RECYCLE_NUMBER_FOR_CHANGE_PROPERTY = "CODERULE_RECYCLE_NUMBER_FOR_CHANGE_PROPERTY";
    private static final String PAGECACHE_KEY_RECYCLE_DYNAMICOBJECT_FOR_CHANGE_PROPERTY = "CODERULE_RECYCLE_DYNAMICOBJECT_FOR_CHANGE_PROPERTY";
    private IPageCache pageCache;
    private String className;
    private boolean isPageCache;

    private static String getExceptionMessageUninitPagecache() {
        return ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316pageCache", (String)"RecycleCache_0", (String)"bos-coderule", (Object[])new Object[0]);
    }

    public RecycleCache(IPageCache pageCache, String className) {
        this.pageCache = pageCache;
        this.className = className;
        this.isPageCache = true;
    }

    public RecycleCache(String className) {
        this.className = className;
        this.isPageCache = false;
    }

    public String getPagecacheKeyRecycleNumberForChangeProperty() {
        return PAGECACHE_KEY_RECYCLE_NUMBER_FOR_CHANGE_PROPERTY + this.className;
    }

    public String getPagecacheKeyRecycleNumberForChangeProperty(Object pkId) {
        return pkId + PAGECACHE_KEY_RECYCLE_NUMBER_FOR_CHANGE_PROPERTY + this.className;
    }

    public String getPagecacheKeyRecycleDynamicobjectForChangeProperty() {
        return PAGECACHE_KEY_RECYCLE_DYNAMICOBJECT_FOR_CHANGE_PROPERTY + this.className;
    }

    public String getPagecacheKeyRecycleDynamicobjectForChangeProperty(Object pkId) {
        return pkId + PAGECACHE_KEY_RECYCLE_DYNAMICOBJECT_FOR_CHANGE_PROPERTY + this.className;
    }

    public void saveRecycleNumberAndDynamicObj(String recycleNumber, DynamicObject dynamicObject) {
        this.saveRecycleNumberAndDynamicObj(recycleNumber, dynamicObject, "");
    }

    public void saveRecycleNumberAndDynamicObj(String recycleNumber, DynamicObject dynamicObject, Object pkId) {
        this.saveRecycleNumber(recycleNumber, pkId);
        this.saveRecycleDynamicObj(dynamicObject, pkId);
    }

    public void saveRecycleNumber(String recycleNumber) {
        this.saveRecycleNumber(recycleNumber, "");
    }

    public void saveRecycleNumber(String recycleNumber, Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)RecycleCache.getExceptionMessageUninitPagecache(), (String)"RecycleCache_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        this.pageCache.put(this.getPagecacheKeyRecycleNumberForChangeProperty(pkId), recycleNumber);
    }

    public void saveRecycleDynamicObj(DynamicObject dynamicObject) {
        this.saveRecycleDynamicObj(dynamicObject, "");
    }

    public void saveRecycleDynamicObj(DynamicObject dynamicObject, Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)RecycleCache.getExceptionMessageUninitPagecache(), (String)"RecycleCache_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        if (dynamicObject != null) {
            String dynamicObjStr = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dynamicObject}, (DynamicObjectType)((DynamicObjectType)dynamicObject.getDataEntityType()));
            this.pageCache.put(this.getPagecacheKeyRecycleDynamicobjectForChangeProperty(pkId), dynamicObjStr);
        }
    }

    public boolean isEmpty() {
        return this.isEmpty("");
    }

    public boolean isEmpty(Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)RecycleCache.getExceptionMessageUninitPagecache(), (String)"RecycleCache_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        String recycleNumber = this.pageCache.get(this.getPagecacheKeyRecycleNumberForChangeProperty(pkId));
        return StringUtils.isBlank((CharSequence)recycleNumber);
    }

    public void clear() {
        this.clear("");
    }

    public void clear(Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)RecycleCache.getExceptionMessageUninitPagecache(), (String)"RecycleCache_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        this.pageCache.remove(this.getPagecacheKeyRecycleNumberForChangeProperty(pkId));
    }

    public void convertPageCacheToOperate(OperateOption operateOption) {
        this.convertPageCacheToOperate(operateOption, "");
    }

    public void convertPageCacheToOperate(OperateOption operateOption, Object pkId) {
        if (!this.isPageCache) {
            throw new RuntimeException(ResManager.loadKDString((String)RecycleCache.getExceptionMessageUninitPagecache(), (String)"RecycleCache_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        String recycleNumberForChangeProperty = this.getPagecacheKeyRecycleNumberForChangeProperty(pkId);
        operateOption.setVariableValue(recycleNumberForChangeProperty, this.pageCache.get(recycleNumberForChangeProperty));
        String recycleDynamicobjectForChangeProperty = this.getPagecacheKeyRecycleDynamicobjectForChangeProperty(pkId);
        operateOption.setVariableValue(recycleDynamicobjectForChangeProperty, this.pageCache.get(recycleDynamicobjectForChangeProperty));
    }

    public String getNumber(OperateOption operateOption) {
        return this.getNumber(operateOption, "");
    }

    public String getNumber(OperateOption operateOption, Object pkId) {
        String recycleNumberForChangeProperty = this.getPagecacheKeyRecycleNumberForChangeProperty(pkId);
        if (operateOption.tryGetVariableValue(recycleNumberForChangeProperty, new RefObject())) {
            return operateOption.getVariableValue(recycleNumberForChangeProperty);
        }
        return null;
    }

    public DynamicObject getDynamicObj(OperateOption operateOption, DynamicObjectType dynamicObjectType) {
        return this.getDynamicObj(operateOption, dynamicObjectType, "");
    }

    public DynamicObject getDynamicObj(OperateOption operateOption, DynamicObjectType dynamicObjectType, Object pkId) {
        String dynamicObjStr;
        String recycleDynamicobjectForChangeProperty = this.getPagecacheKeyRecycleDynamicobjectForChangeProperty(pkId);
        if (operateOption.tryGetVariableValue(recycleDynamicobjectForChangeProperty, new RefObject()) && StringUtils.isNotEmpty((CharSequence)(dynamicObjStr = operateOption.getVariableValue(recycleDynamicobjectForChangeProperty)))) {
            Object[] dynamicObjects = DynamicObjectSerializeUtil.deserialize((String)dynamicObjStr, (DynamicObjectType)dynamicObjectType);
            return (DynamicObject)dynamicObjects[0];
        }
        return null;
    }
}

