/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.opplugin.pagecache;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.param.ParameterReader;

public class SerialNumberPageCache {
    private static final String PAGE_CACHE_KEY_SERIAL_NUMBER = "coderule_serial_number_operate_fail";
    private static final String PAGE_CACHE_KEY_IS_OPEN_BILLNO = "coderule_is_open_billno_pagecache";
    private IPageCache pageCache;
    private String className;

    public SerialNumberPageCache(IPageCache pageCache, String className) {
        this.pageCache = pageCache;
        this.className = className;
    }

    public boolean isOpenBillNoPageCache() {
        String isOpen = this.pageCache.get(PAGE_CACHE_KEY_IS_OPEN_BILLNO);
        if (StringUtils.isNotBlank((CharSequence)isOpen)) {
            return Boolean.parseBoolean(isOpen);
        }
        return false;
    }

    public boolean saveOpenBillNoParam(String entityName, OperateOption option) {
        DynamicObject billParameter = ParameterReader.getBillParameter((String)entityName);
        if (null == billParameter) {
            return false;
        }
        boolean isOpenBillNoPageCache = billParameter.getBoolean("openbillnopagecache");
        this.pageCache.put(PAGE_CACHE_KEY_IS_OPEN_BILLNO, String.valueOf(isOpenBillNoPageCache));
        option.setVariableValue(PAGE_CACHE_KEY_IS_OPEN_BILLNO, String.valueOf(isOpenBillNoPageCache));
        return isOpenBillNoPageCache;
    }

    public void convertPageCacheToOperate(OperateOption option, String codeRuleKey) {
        String serialNumberKey = this.getPageCacheKeySerialNumber(codeRuleKey);
        option.setVariableValue(serialNumberKey, this.pageCache.get(serialNumberKey));
    }

    public void convertOperateToPageCache(OperateOption option, String codeRuleKey) {
        String serialNumberKey = this.getPageCacheKeySerialNumber(codeRuleKey);
        if (option.tryGetVariableValue(serialNumberKey, new RefObject())) {
            this.pageCache.put(serialNumberKey, option.getVariableValue(serialNumberKey));
        }
    }

    public String getPageCacheKeySerialNumber(String codeRuleKey) {
        return PAGE_CACHE_KEY_SERIAL_NUMBER + this.className + codeRuleKey;
    }
}

