/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.opplugin.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;

public class FormViewUtil {
    private static final Log log = LogFactory.getLog(FormViewUtil.class);
    private static final String PAGE_CACHE_KEY_BILLNO_EMPTY_TIPS = "coderule_billno_empty_tips";

    public static void updateEmptyTips(IFormView formView, String billNoField) {
        HashMap controlMap = new HashMap();
        HashMap<String, LocaleString> itemMap = new HashMap<String, LocaleString>();
        controlMap.put("item", itemMap);
        itemMap.put("emptytip", new LocaleString(ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210", (String)"FormViewUtil_0", (String)"bos-coderule", (Object[])new Object[0])));
        formView.updateControlMetadata(billNoField, controlMap);
    }

    public static void updateLockEmptyTips(IFormView formView, String billNoField) {
        HashMap controlMap = new HashMap();
        HashMap<String, LocaleString> itemMap = new HashMap<String, LocaleString>();
        controlMap.put("item", itemMap);
        itemMap.put("lockedemptytip", new LocaleString(ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210", (String)"FormViewUtil_0", (String)"bos-coderule", (Object[])new Object[0])));
        formView.updateControlMetadata(billNoField, controlMap);
    }

    public static void clearEmptyTips(IFormView formView, String billNoField) {
        HashMap controlMap = new HashMap();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        controlMap.put("item", itemMap);
        itemMap.put("emptytip", "");
        formView.updateControlMetadata(billNoField, controlMap);
    }

    public static void clearLockEmptyTips(IFormView formView, String billNoField) {
        HashMap controlMap = new HashMap();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        controlMap.put("item", itemMap);
        itemMap.put("lockedemptytip", "");
        formView.updateControlMetadata(billNoField, controlMap);
    }

    public static void recoverEmptyTips(IFormView formView, String billNoField) {
        FormViewUtil.updateControlMetaDate(formView, billNoField, "emptytip");
    }

    public static void recoverLockEmptyTips(IFormView formView, String billNoField) {
        FormViewUtil.updateControlMetaDate(formView, billNoField, "lockedemptytip");
    }

    private static void updateControlMetaDate(IFormView formView, String billNoField, String type) {
        HashMap controlMap = new HashMap();
        HashMap<String, LocaleString> itemMap = new HashMap<String, LocaleString>();
        controlMap.put("item", itemMap);
        Map<String, String> tips = FormViewUtil.getBillNoTips(formView, billNoField);
        String emptyTip = tips.get(type) == null ? "" : tips.get(type);
        itemMap.put(type, new LocaleString(emptyTip));
        formView.updateControlMetadata(billNoField, controlMap);
    }

    private static Map<String, String> getBillNoTips(IFormView formView, String billNoField) {
        String tips = formView.getPageCache().get(PAGE_CACHE_KEY_BILLNO_EMPTY_TIPS);
        if (StringUtils.isNotBlank((CharSequence)tips)) {
            return (Map)SerializationUtils.fromJsonString((String)tips, Map.class);
        }
        HashMap<String, String> tipsMap = new HashMap<String, String>(2);
        try {
            String localId = Lang.get().getLocale().toString();
            Map designerMetadata = MetadataDao.loadDesignerMetadata((String)MetadataDao.getIdByNumber((String)formView.getEntityId(), (MetaCategory)MetaCategory.Form), (String)localId);
            Map entityMeta = (Map)designerMetadata.get("entitymeta");
            List formMetaItems = (List)entityMeta.get("Items");
            for (Map item : formMetaItems) {
                if (!StringUtils.equals((CharSequence)billNoField, (CharSequence)((String)item.get("Key")))) continue;
                String emptyTip = item.get("EmptyText") == null ? "" : (String)item.get("EmptyText");
                String lockEmptyTip = item.get("LockedEmptyTip") == null ? "" : (String)item.get("LockedEmptyTip");
                tipsMap.put("emptytip", emptyTip);
                tipsMap.put("lockedemptytip", lockEmptyTip);
                break;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return new HashMap<String, String>();
        }
        formView.getPageCache().put(PAGE_CACHE_KEY_BILLNO_EMPTY_TIPS, SerializationUtils.toJsonString(tipsMap));
        return tipsMap;
    }
}

