/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.domain.GroupHandlerDataEntity;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.handler.GroupHandler;
import kd.bos.coderule.handler.SyncHandler;
import kd.bos.coderule.handler.TransactionHandler;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.coderule.util.AppLogUtil;
import kd.bos.coderule.util.CodeRuleNumberDTO;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.coderule.util.CommonUtil;
import kd.bos.coderule.util.GroupHandlerUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

class BatchRecycleServiceImpl {
    private static final Log logger = LogFactory.getLog(BatchRecycleServiceImpl.class);
    private CodeRuleServiceImp codeRuleServiceImp;

    public BatchRecycleServiceImpl(CodeRuleServiceImp codeRuleServiceImp) {
        this.codeRuleServiceImp = codeRuleServiceImp;
    }

    public boolean[] recycleBatchNumber(String entityId, DynamicObject[] dataInfoArr, String orgID, String[] numberArr) {
        if (dataInfoArr == null || dataInfoArr.length == 0) {
            return new boolean[0];
        }
        ArrayList<DynamicObject> dataInfos = new ArrayList<DynamicObject>(dataInfoArr.length);
        final ArrayList<String> numbers = new ArrayList<String>(dataInfoArr.length);
        for (int i = 0; i < dataInfoArr.length; ++i) {
            if (dataInfoArr[i] == null || StringUtils.isBlank((CharSequence)numberArr[i])) continue;
            dataInfos.add(dataInfoArr[i]);
            numbers.add(numberArr[i]);
        }
        StringBuilder sbDataInfoIds = new StringBuilder();
        for (int i = 0; i < dataInfos.size(); ++i) {
            sbDataInfoIds.append(((DynamicObject)dataInfos.get(i)).getPkValue());
            if (i == dataInfos.size() - 1) continue;
            sbDataInfoIds.append(',');
        }
        logger.info(String.format("CodeRuleServiceImp.recycleBatchNumber(): entityId: %s, dataInfo: [%s], orgID: %s, number: %s ", entityId, sbDataInfoIds, orgID, Arrays.toString(numbers.toArray(new String[0]))));
        List<GroupHandlerDataEntity> dataEntitys = GroupHandlerUtil.convertToGroupHandlerDataEntitys(Arrays.asList(dataInfoArr));
        if (CollectionUtils.isNotEmpty(dataEntitys)) {
            new GroupHandler(this.codeRuleServiceImp, entityId, dataEntitys){

                @Override
                protected void groupProcess(CodeRuleInfo codeRuleInfo, String sortItem, List<GroupHandlerDataEntity> dataEntities) {
                    List<DynamicObject> dynamicObjects = GroupHandlerUtil.convertToDynamicObjects(dataEntities);
                    ArrayList recNumbers = new ArrayList(dynamicObjects.size());
                    for (GroupHandlerDataEntity dataEntity : dataEntities) {
                        recNumbers.add(numbers.get(dataEntity.getRowIndex()));
                    }
                    BatchRecycleServiceImpl.this.recycleNumber(codeRuleInfo, sortItem, dynamicObjects, recNumbers);
                }
            }.process();
        }
        return null;
    }

    private boolean recycleNumber(final CodeRuleInfo codeRuleInfo, final String sortItem, List<DynamicObject> dataInfos, List<String> numbers) {
        if (codeRuleInfo == null) {
            logger.info("CodeRuleServiceImp.recycleNumber(): \u65e0\u5408\u9002\u7f16\u7801\u89c4\u5219\uff0c\u4e0d\u56de\u6536\u7f16\u7801");
            return true;
        }
        if (!codeRuleInfo.getIsNonBreak().booleanValue()) {
            logger.info("CodeRuleServiceImp.recycleNumber(): \u5f53\u524d\u89c4\u5219\u4e0d\u662f\u201c\u4e0d\u5141\u8bb8\u65ad\u53f7\u201d\u7684\u60c5\u51b5\uff0c\u4e0d\u56de\u6536\u7f16\u7801");
            return true;
        }
        CodeRuleEntryInfo codeRuleEntryInfo = this.getCodeRuleEntityWithSerialNum(codeRuleInfo);
        if (codeRuleEntryInfo == null) {
            logger.info("CodeRuleServiceImp.recycleNumber():\u89c4\u5219\u7f3a\u5c11\u6d41\u6c34\u53f7\u6bb5,\u4e0d\u7ee7\u7eed\u56de\u6536");
            return true;
        }
        final ArrayList<DynamicObject> newDataInfos = new ArrayList<DynamicObject>(dataInfos.size());
        final ArrayList<String> newNumbers = new ArrayList<String>(dataInfos.size());
        for (int i = 0; i < dataInfos.size(); ++i) {
            CodeRuleNumberDTO codeRuleNumberDTO = this.getSerialNumber(codeRuleInfo, dataInfos.get(i), numbers.get(i));
            if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) {
                logger.info("[CodeRuleServiceImp#recycleNumber]\u6d41\u6c34\u53f7\u4e0d\u5339\u914d\u89c4\u5219:" + numbers.get(i));
                continue;
            }
            newDataInfos.add(dataInfos.get(i));
            newNumbers.add(codeRuleNumberDTO.getSerialNumber());
        }
        if (newDataInfos.size() == 0) {
            return true;
        }
        new TransactionHandler(ResManager.loadKDString((String)"\u56de\u6536\u7f16\u7801\u53d1\u751f\u5f02\u5e38", (String)"CodeRuleServiceImp_4", (String)"bos-coderule", (Object[])new Object[0])){

            @Override
            protected void transactionProcess() {
                new SyncHandler(CodeRuleSerialNumUtil.getDLockKey(codeRuleInfo, sortItem), codeRuleInfo.getName(), codeRuleInfo.getId()){

                    @Override
                    protected void syncProcess() {
                        BatchRecycleServiceImpl.this.saveIntermitNumber(codeRuleInfo, sortItem, newDataInfos, newNumbers);
                    }
                }.process();
            }
        }.process();
        return true;
    }

    private CodeRuleEntryInfo getCodeRuleEntityWithSerialNum(CodeRuleInfo codeRuleInfo) {
        if (codeRuleInfo != null) {
            for (CodeRuleEntryInfo codeRuleEntryInfo : codeRuleInfo.getRuleEntry()) {
                if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(codeRuleEntryInfo.getAttributeType())) continue;
                return codeRuleEntryInfo;
            }
        }
        return null;
    }

    private CodeRuleNumberDTO getSerialNumber(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, String number) {
        return CodeRuleSerialNumUtil.getSerialNumberWithoutSplitSign(codeRuleInfo, dataInfo, number);
    }

    private Boolean saveIntermitNumber(CodeRuleInfo codeRuleInfo, String sortItemValue, List<DynamicObject> dynamicObjects, List<String> numbers) {
        if (codeRuleInfo == null) {
            return Boolean.FALSE;
        }
        if (StringUtils.isBlank((CharSequence)sortItemValue)) {
            sortItemValue = "_split_";
        }
        HashMap<String, DynamicObject> numberDynamicMap = new HashMap<String, DynamicObject>(numbers.size());
        for (int i = 0; i < numbers.size(); ++i) {
            numberDynamicMap.put(numbers.get(i), dynamicObjects.get(i));
        }
        List<String> newNumbers = this.getNumbersWithoutInDB(codeRuleInfo, sortItemValue, numbers);
        if (CollectionUtils.isEmpty(newNumbers)) {
            return Boolean.FALSE;
        }
        for (String newNumber : newNumbers) {
            AppLogUtil.buildAppLog(((DynamicObject)numberDynamicMap.get(newNumber)).getDataEntityType().getName(), ResManager.loadKDString((String)"\u4fdd\u5b58\u65ad\u53f7", (String)"CodeRuleServiceImp_7", (String)"bos-coderule", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219ID:%1$s\uff0c\u7f16\u7801\u89c4\u5219\u540d\u79f0:%2$s\uff0c\u4f9d\u636e:%3$s\uff0c\u56de\u6536\u53f7:%4$s\uff0c\u56de\u6536\u5224\u5b9a:%5$s", (String)"CodeRuleServiceImp_27", (String)"bos-coderule", (Object[])new Object[0]), codeRuleInfo.getId(), codeRuleInfo.getName(), CommonUtil.convertSortItem(sortItemValue), Long.valueOf(newNumber), ResManager.loadKDString((String)"\u9700\u8981\u4fdd\u5b58\u6b64\u65ad\u53f7", (String)"CodeRuleServiceImp_10", (String)"bos-coderule", (Object[])new Object[0])));
        }
        this.insertIntermitNumbers(codeRuleInfo, sortItemValue, newNumbers);
        logger.info(String.format("CodeRuleServiceImp.insertIntermitNumber(): codeRuleInfo.Id: %s , codeRuleInfo.name: %s , codeRuleInfo.getEntityId: %s , sortItemValue: %s, serialNumber:%s", codeRuleInfo.getId(), codeRuleInfo.getName(), codeRuleInfo.getEntityId(), sortItemValue, Arrays.toString(newNumbers.toArray(new String[0]))));
        return Boolean.TRUE;
    }

    private List<String> getNumbersWithoutInDB(CodeRuleInfo codeRuleInfo, String sortItemValue, List<String> serialNumbers) {
        QFilter[] qfArr = new QFilter[]{new QFilter("codeRuleID", "=", (Object)codeRuleInfo.getId()), new QFilter("sortitemvalue", "=", (Object)sortItemValue), new QFilter("serial", "in", (Object)serialNumbers.stream().mapToLong(Long::parseLong).toArray())};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_coderule_intermitno", (String)"serial", (QFilter[])qfArr);
        Set numbersInDB = Optional.ofNullable(query).orElseGet(DynamicObjectCollection::new).stream().map(dynamicObject -> dynamicObject.getLong("serial")).collect(Collectors.toSet());
        return serialNumbers.stream().filter(s -> !numbersInDB.contains(Long.valueOf(s))).collect(Collectors.toList());
    }

    private Boolean insertIntermitNumbers(CodeRuleInfo codeRuleInfo, String sortItemValue, List<String> serialNumbers) {
        DynamicObject[] dynamicObjects = new DynamicObject[serialNumbers.size()];
        for (int i = 0; i < serialNumbers.size(); ++i) {
            Long intermitNumber = Long.valueOf(serialNumbers.get(i));
            DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_coderule_intermitno");
            dObj.set("codeRuleID", (Object)codeRuleInfo.getId());
            dObj.set("sortitemvalue", (Object)sortItemValue);
            dObj.set("serial", (Object)intermitNumber);
            dObj.set("createdate", (Object)new Date());
            dObj.set("creater", (Object)RequestContext.get().getUserId());
            dynamicObjects[i] = dObj;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        return Boolean.TRUE;
    }
}

