/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.service.cache;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import org.apache.commons.collections4.CollectionUtils;

public class CodeRuleCacheMrg {
    private static final String BS_CODE_RULE_REGION = "CODE_RULE";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("CODE_RULE", new DistributeCacheHAPolicy(true, true));
    private static final String BS_CODE_RULE = "BS_CODE_RULE_";
    public static final String DATA_CODE_RULE_BREAK_NUMBER = "BS_CODE_RULE_BREAK_NUMBER";
    public static final String DATA_CODE_RULE_SERIAL_NUMBER = "BS_CODE_RULE_SERIAL_NUMBER";
    public static final String DATA_CODE_RULE_MAX_SERIAL_NUMBER = "BS_CODE_RULE_MAX_SERIAL_NUMBER";
    public static final String DATA_CODE_RULE_ENITY_ALL = "BS_CODE_RULE_ENITY_ALL";
    public static final String LOADED = "DATA_LOADED";

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"CodeRuleCacheMrg_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static String getType4BreakNumber() {
        return "BS_CODE_RULE_BREAK_NUMBER_" + CodeRuleCacheMrg.getAcctId();
    }

    public static String getType4SerialNumber() {
        return "BS_CODE_RULE_SERIAL_NUMBER_" + CodeRuleCacheMrg.getAcctId();
    }

    public static String getType4MaxSerialNumber() {
        return "BS_CODE_RULE_MAX_SERIAL_NUMBER_" + CodeRuleCacheMrg.getAcctId();
    }

    public static String getType4EntityCodeRules() {
        return "BS_CODE_RULE_ENITY_ALL_" + CodeRuleCacheMrg.getAcctId();
    }

    public static void clearAllCache() {
        cache.removeType(CodeRuleCacheMrg.getType4BreakNumber());
        cache.removeType(CodeRuleCacheMrg.getType4SerialNumber());
    }

    public static void clearCache(String type) {
        cache.removeType(type);
    }

    public static void clearCache(String type, String key) {
        cache.remove(type, key);
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        Map kvs = cache.getAll(type);
        ArrayList<String> keys = new ArrayList<String>(8);
        if (kvs != null && kvs.size() > 0) {
            for (String key : kvs.keySet()) {
                if (!key.startsWith(keyPrefix)) continue;
                keys.add(key);
            }
            if (CollectionUtils.isNotEmpty(keys)) {
                cache.remove(type, keys.toArray(new String[keys.size()]));
            }
        }
    }

    public static String getCache(String type, String key) {
        return (String)cache.get(type, key);
    }

    public static void putCache(String type, String key, String value) {
        cache.put(type, key, (Object)value);
    }

    public static void putCache(String type, Map<String, String> values) {
        cache.put(type, values);
    }

    public static Map<String, String> getCache(String type) {
        return cache.getAll(type);
    }

    public static void putLoaded(String type, String key) {
        cache.put(type, key, (Object)LOADED);
    }

    public static boolean isData(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !value.equals(LOADED);
    }

    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0;
    }
}

