/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.util.Date;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ConditionEntryInfo;
import kd.bos.coderule.api.OrgEntryInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CodeRuleInfoBuilder {
    private static final Log logger = LogFactory.getLog(CodeRuleInfoBuilder.class);

    public static DynamicObject buildCodeRuleMaxSerial(String ruleId, String sortItem, int maxserial) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_coderule_maxserial");
        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
        dynaObj.set("codeRuleID", (Object)ruleId);
        dynaObj.set("seqsegmententryid", (Object)"");
        dynaObj.set("sortitemvalue", (Object)sortItem);
        dynaObj.set("maxserial", (Object)maxserial);
        dynaObj.set("initserial", (Object)0);
        dynaObj.set("createdate", (Object)new Date());
        dynaObj.set("creater", (Object)RequestContext.get().getUserId());
        return dynaObj;
    }

    public static CodeRuleInfo buildCodeRuleInfo(DynamicObject codeRule) {
        DynamicObjectCollection ruleentry;
        CodeRuleInfo codeRuleInfo = new CodeRuleInfo();
        codeRuleInfo.setId(codeRule.getString("id"));
        codeRuleInfo.setName(codeRule.getString("name"));
        codeRuleInfo.setSplitSign(codeRule.getString("splitsign"));
        String appMode = codeRule.getString("appmode");
        codeRuleInfo.setAppMode(appMode);
        codeRuleInfo.setIsAddView(Boolean.valueOf(codeRule.getBoolean("isaddview")));
        codeRuleInfo.setMatchCodeRule(codeRule.getBoolean("ismatchcoderule"));
        codeRuleInfo.setCheckNumber(Boolean.valueOf(codeRule.getBoolean("ischecknumber")));
        codeRuleInfo.setIsModifiable(Boolean.valueOf(codeRule.getBoolean("ismodifiable")));
        codeRuleInfo.setIsNonBreak(Boolean.valueOf(codeRule.getBoolean("isnonbreak")));
        codeRuleInfo.setFillWithZero(Boolean.valueOf(codeRule.getBoolean("isfillwithzero")));
        codeRuleInfo.setAutoIncrLength(Boolean.valueOf(codeRule.getBoolean("isautoincrlength")));
        codeRuleInfo.setUseInterruption(codeRule.getString("useinterruption"));
        codeRuleInfo.setUpdateMaxNumber(codeRule.getString("updatemaxnumber"));
        codeRuleInfo.setFast(codeRule.getBoolean("isfast"));
        codeRuleInfo.setUpdateRecover(codeRule.getBoolean("isupdaterecover"));
        DynamicObjectCollection orgentry = codeRule.getDynamicObjectCollection("orgentry");
        if (orgentry != null && orgentry.size() > 0) {
            for (Object orgEntry : orgentry) {
                DynamicObject orgDynamicObject = orgEntry.getDynamicObject("orgid");
                if (orgDynamicObject == null) {
                    logger.error("\u5f15\u7528\u7684\u53d7\u63a7\u7ec4\u7ec7\u88ab\u5220\u9664, \u7f16\u7801\u89c4\u5219ID:" + codeRuleInfo.getId());
                    continue;
                }
                OrgEntryInfo orgEntryInfo = new OrgEntryInfo();
                orgEntryInfo.setOrgId((Long)orgDynamicObject.getPkValue());
                orgEntryInfo.setIsIncludeSubOrg(Boolean.valueOf(orgEntry.getBoolean("isincludesuborg")));
                codeRuleInfo.getOrgEntry().add(orgEntryInfo);
            }
        }
        codeRuleInfo.setEnableCondition(codeRule.getString("filtercondition"));
        DynamicObjectCollection conditionentry = codeRule.getDynamicObjectCollection("conditionentry");
        if (conditionentry != null && conditionentry.size() > 0) {
            for (DynamicObject conditionEntry : conditionentry) {
                ConditionEntryInfo conditionEntryInfo = new ConditionEntryInfo();
                DynamicObject property = conditionEntry.getDynamicObject("property");
                if (property == null) {
                    logger.error("\u5f15\u7528\u7684\u9002\u7528\u5c5e\u6027\u88ab\u5220\u9664, \u7f16\u7801\u89c4\u5219ID:" + codeRuleInfo.getId());
                    continue;
                }
                conditionEntryInfo.setProperty(property.getString("number"));
                DynamicObject propertyvalue = conditionEntry.getDynamicObject("propertyvalue");
                if (propertyvalue == null) {
                    logger.error("\u5f15\u7528\u7684\u9002\u7528\u5c5e\u6027\u88ab\u5220\u9664, \u7f16\u7801\u89c4\u5219ID:" + codeRuleInfo.getId());
                    continue;
                }
                conditionEntryInfo.setPropertyValue(propertyvalue.getString("value"));
                codeRuleInfo.getConditionEntry().add(conditionEntryInfo);
            }
        }
        if ((ruleentry = codeRule.getDynamicObjectCollection("ruleentry")) != null && ruleentry.size() > 0) {
            for (DynamicObject ruleEntry : ruleentry) {
                CodeRuleEntryInfo codeRuleEntryInfo = new CodeRuleEntryInfo();
                codeRuleEntryInfo.setSeq(ruleEntry.getInt("seq"));
                codeRuleEntryInfo.setAttributeType(ruleEntry.getString("attributeType"));
                codeRuleEntryInfo.setValueAtribute(ruleEntry.getString("valueAtribute"));
                codeRuleEntryInfo.setAttUsingMode(ruleEntry.getString("attusingmode"));
                codeRuleEntryInfo.setLength(ruleEntry.getInt("length"));
                codeRuleEntryInfo.setCutstyle(Boolean.valueOf(ruleEntry.getBoolean("cutstyle")));
                codeRuleEntryInfo.setFormat(ruleEntry.getString("format"));
                codeRuleEntryInfo.setAddchar(ruleEntry.getString("addchar"));
                codeRuleEntryInfo.setAddstyle(Boolean.valueOf(ruleEntry.getBoolean("addstyle")));
                codeRuleEntryInfo.setInitial(ruleEntry.getLong("initial"));
                codeRuleEntryInfo.setStep(ruleEntry.getLong("step"));
                codeRuleEntryInfo.setIsSortItem(Boolean.valueOf(ruleEntry.getBoolean("isSortItem")));
                codeRuleEntryInfo.setIsSplitSign(Boolean.valueOf(ruleEntry.getBoolean("issplitsign")));
                codeRuleEntryInfo.setVisable(ruleEntry.getBoolean("isvisable"));
                if (StringUtils.isBlank((CharSequence)ruleEntry.getString("splitsignentry"))) {
                    codeRuleEntryInfo.setSplitSign("");
                } else {
                    codeRuleEntryInfo.setSplitSign(ruleEntry.getString("splitsignentry"));
                }
                codeRuleInfo.getRuleEntry().add(codeRuleEntryInfo);
            }
        }
        return codeRuleInfo;
    }
}

