/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.service.cache.CodeRuleCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractCodeRulePlugin;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CodeRuleUtils {
    private static final String FORMID_BOS_LIST = "bos_list";
    private static final String BOS_CODERULE = "bos-coderule";
    private static final Log log = LogFactory.getLog(CodeRuleUtils.class);
    private static final String BOTP_WITH_NULL_VALUE_BILLNO = "botptag_of_datasource_with_null_fields";

    public static String queryBizObjectById(String codeRuleId) {
        if (StringUtils.isBlank((CharSequence)codeRuleId)) {
            return "";
        }
        ORM orm = ORM.create();
        QFilter codeRuleFiler = new QFilter("id", "=", (Object)codeRuleId);
        QFilter[] crFilter = new QFilter[]{codeRuleFiler};
        DynamicObject bizObj = orm.queryOne("bos_coderule", "id, bizobjectid.number", crFilter);
        return bizObj.getString("bizobjectid.number");
    }

    public static String isDuplicateCodeRule(String bizObjectId, String codeRuleId, Set<String> orgSet, Map<String, Object> conditionMap) {
        if (StringUtils.isBlank((CharSequence)bizObjectId) || StringUtils.isBlank((CharSequence)codeRuleId)) {
            return null;
        }
        if (CodeRuleUtils.isExistEnableCondition(codeRuleId)) {
            return "";
        }
        if (orgSet == null) {
            orgSet = CodeRuleUtils.genOrgSet(codeRuleId);
        }
        if (conditionMap == null) {
            conditionMap = CodeRuleUtils.genPropertyMap(codeRuleId);
        }
        QFilter[] qFilter = CodeRuleUtils.genDuplicateCodeRuleFilters(bizObjectId, codeRuleId, orgSet, conditionMap);
        StringBuilder select_fileds = new StringBuilder();
        select_fileds.append(" id");
        select_fileds.append(", name, filtercondition");
        select_fileds.append(", orgentry.orgid org");
        select_fileds.append(", orgentry.orgid.number number");
        DynamicObjectCollection col = QueryServiceHelper.query((String)CodeRuleUtils.class.getName(), (String)"bos_coderule", (String)select_fileds.toString(), (QFilter[])qFilter, null);
        if (CollectionUtils.isEmpty((Collection)col)) {
            return null;
        }
        ArrayList<DynamicObject> needCheckCodeRuleList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : col) {
            if (CodeRuleUtils.isContainFilterCondition(obj)) continue;
            needCheckCodeRuleList.add(obj);
        }
        if (CollectionUtils.isEmpty(needCheckCodeRuleList)) {
            return null;
        }
        ArrayList<String> duplicateOrgList = new ArrayList<String>();
        String codeRuleName = "";
        for (DynamicObject obj : needCheckCodeRuleList) {
            codeRuleName = obj.getString("name");
            String number = obj.getString("number");
            if (!StringUtils.isNotBlank((CharSequence)number)) continue;
            duplicateOrgList.add(obj.getString("number"));
        }
        String msg = null;
        if (duplicateOrgList.size() == 0 && conditionMap.isEmpty()) {
            msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u53d7\u63a7\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u7f16\u7801\u89c4\u5219[%s]\uff0c\u8bf7\u4fee\u6539\u53d7\u63a7\u7ec4\u7ec7\u6216\u914d\u7f6e\u542f\u52a8\u6761\u4ef6\u3002", (String)"CodeRuleUtils_3", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleName);
        } else if (duplicateOrgList.size() > 0 && conditionMap.isEmpty()) {
            msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u53d7\u63a7\u7ec4\u7ec7\u7684\u7f16\u7801\u89c4\u5219[%1$s]\uff0c\u8bf7\u4fee\u6539\u53d7\u63a7\u7ec4\u7ec7[%2$s]\u6216\u914d\u7f6e\u542f\u52a8\u6761\u4ef6\u3002", (String)"CodeRuleUtils_4", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleName, String.join((CharSequence)"\uff0c", duplicateOrgList));
        } else if (duplicateOrgList.size() == 0 && !conditionMap.isEmpty()) {
            msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u9002\u7528\u6761\u4ef6\u548c\u53d7\u63a7\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u7f16\u7801\u89c4\u5219[%s]\uff0c\u8bf7\u4fee\u6539\u9002\u7528\u6761\u4ef6\u6216\u53d7\u63a7\u7ec4\u7ec7\u3002", (String)"CodeRuleUtils_5", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleName, String.join((CharSequence)"\uff0c", duplicateOrgList));
        } else if (duplicateOrgList.size() > 0 && !conditionMap.isEmpty()) {
            msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u53d7\u63a7\u7ec4\u7ec7\u548c\u9002\u7528\u6761\u4ef6\u7684\u7f16\u7801\u89c4\u5219[%1$s]\uff0c\u8bf7\u4fee\u6539\u53d7\u63a7\u7ec4\u7ec7[%2$s]\u6216\u9002\u7528\u6761\u4ef6\u3002", (String)"CodeRuleUtils_6", (String)BOS_CODERULE, (Object[])new Object[0]), codeRuleName, String.join((CharSequence)"\uff0c", duplicateOrgList));
        }
        return msg;
    }

    private static boolean isExistEnableCondition(String codeRuleId) {
        QFilter curRuleFiler = new QFilter("id", "=", (Object)codeRuleId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_coderule", (String)"id, filtercondition", (QFilter[])new QFilter[]{curRuleFiler});
        if (CollectionUtils.isEmpty((Collection)col)) {
            return false;
        }
        return CodeRuleUtils.isContainFilterCondition((DynamicObject)col.get(0));
    }

    private static boolean isContainFilterCondition(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return false;
        }
        String conditionString = dynamicObject.getString("filtercondition");
        if (StringUtils.isBlank((CharSequence)conditionString)) {
            return false;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionString, FilterCondition.class);
        List filterRow = filterCondition.getFilterRow();
        return filterRow != null && !filterRow.isEmpty();
    }

    private static Set<String> genOrgSet(String codeRuleId) {
        QFilter curRuleFiler = new QFilter("id", "=", (Object)codeRuleId);
        QFilter[] qFilter = new QFilter[]{curRuleFiler};
        DynamicObjectCollection col = QueryServiceHelper.query((String)CodeRuleUtils.class.getName(), (String)"bos_coderule", (String)"id, orgentry.orgid org", (QFilter[])qFilter, null);
        HashSet<String> orgSet = new HashSet<String>();
        if (col == null || col.size() == 0) {
            return orgSet;
        }
        for (DynamicObject obj : col) {
            String org = obj.getString("org");
            if (org == null || "0".equals(org)) continue;
            orgSet.add(org);
        }
        return orgSet;
    }

    private static Map<String, Object> genPropertyMap(String codeRuleId) {
        QFilter curRuleFiler = new QFilter("id", "=", (Object)codeRuleId);
        QFilter[] qFilter = new QFilter[]{curRuleFiler};
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_coderule", (String)"id, conditionentry.property property, conditionentry.propertyvalue propertyvalue", (QFilter[])qFilter);
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        if (obj == null) {
            conditionMap.put("property", null);
            conditionMap.put("propertyvalue", null);
            return conditionMap;
        }
        if (StringUtils.isNotBlank((CharSequence)obj.getString("property")) && StringUtils.isNotBlank((CharSequence)obj.getString("propertyvalue"))) {
            conditionMap.put("property", obj.getString("property"));
            conditionMap.put("propertyvalue", obj.getString("propertyvalue"));
        }
        return conditionMap;
    }

    private static QFilter[] genDuplicateCodeRuleFilters(String bizObjectId, String codeRuleId, Set<String> orgSet, Map<String, Object> conditionMap) {
        String propertyOrgentryOrgid = "orgentry.orgid";
        QFilter orgFiler = new QFilter(propertyOrgentryOrgid, "in", orgSet);
        if (orgSet.size() == 0) {
            orgFiler = QFilter.isNull((String)propertyOrgentryOrgid);
        } else {
            Set orgs = orgSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            orgFiler = new QFilter(propertyOrgentryOrgid, "in", orgs);
        }
        Object property = conditionMap.get("property");
        QFilter pFiler = null;
        pFiler = property == null ? QFilter.isNull((String)"conditionentry.id") : new QFilter("conditionentry.property", "=", (Object)((String)property));
        Object propertyValue = conditionMap.get("propertyvalue");
        QFilter pvFiler = null;
        pvFiler = propertyValue == null ? QFilter.isNull((String)"conditionentry.propertyvalue") : new QFilter("conditionentry.propertyvalue", "=", (Object)((String)propertyValue));
        QFilter enableFiler = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter curRuleFiler = new QFilter("id", "!=", (Object)codeRuleId);
        QFilter bizFiler = new QFilter("bizobjectid", "=", (Object)bizObjectId);
        return new QFilter[]{orgFiler, pFiler, pvFiler, enableFiler, curRuleFiler, bizFiler};
    }

    public static boolean isCodeRuleUsed(String algoKey, String codeRuleId) {
        if (StringUtils.isBlank((CharSequence)codeRuleId)) {
            return false;
        }
        DynamicObjectCollection list = QueryServiceHelper.query((String)algoKey, (String)"bos_coderule_maxserial", (String)"id", (QFilter[])new QFilter[]{new QFilter("coderuleid", "=", (Object)codeRuleId)}, null);
        return list != null && list.size() > 0;
    }

    public static String getNameByBizObjectId(String bizobjectId, String attrId) {
        String langName = RequestContext.get().getLang().name();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)bizobjectId);
        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
        DataEntityPropertyCollection entitySet = dynaObj.getDataEntityType().getProperties();
        if (attrId.contains(".")) {
            String firstName = attrId.split("\\.")[0];
            String secondName = attrId.split("\\.")[1];
            String attrName = "";
            List complexFileds = entitySet.getComplexProperties(false);
            for (IComplexProperty property : complexFileds) {
                if (!property.getName().equalsIgnoreCase(firstName)) continue;
                BasedataProp prop = (BasedataProp)property;
                attrName = attrName + prop.getDisplayName() + ".";
                MainEntityType secDt = EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId());
                DynamicObject secDynaObj = new DynamicObject((DynamicObjectType)secDt);
                DataEntityPropertyCollection secEntitySet = secDynaObj.getDataEntityType().getProperties();
                for (IDataEntityProperty simpleProperty : secEntitySet) {
                    if (!simpleProperty.getName().equalsIgnoreCase(secondName)) continue;
                    DynamicProperty secProp = (DynamicProperty)simpleProperty;
                    return attrName + (String)secProp.getDisplayName().get((Object)langName);
                }
            }
        } else {
            List simpleFileds = entitySet.getSimpleProperties(true);
            for (ISimpleProperty property : simpleFileds) {
                if (!property.getName().equalsIgnoreCase(attrId)) continue;
                DynamicProperty prop = (DynamicProperty)property;
                return (String)prop.getDisplayName().get((Object)langName);
            }
        }
        return "";
    }

    public static DynamicObjectType getDynamicObjectType() {
        String selectProperties = "id, splitsign, appmode, isupdaterecover,orgentry.id, orgentry.orgid, orgentry.isincludesuborg, conditionentry.id, conditionentry.property, conditionentry.propertyvalue, ruleentry.id, ruleentry.seq,ruleentry.attributeType,ruleentry.valueAtribute,ruleentry.attusingmode,ruleentry.length,ruleentry.cutstyle,ruleentry.format,ruleentry.addchar,ruleentry.addstyle,ruleentry.initial,ruleentry.step,ruleentry.isSortItem,ruleentry.issplit,sign,ruleentry.issplitsign,ruleentry.splitsignentry,ruleentry.isvisable";
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        String[] type = properties;
        int arg4 = properties.length;
        for (int arg5 = 0; arg5 < arg4; ++arg5) {
            String prop = type[arg5];
            select.add(prop.trim());
        }
        DynamicObjectType dynamicObjectType = EntityMetadataCache.getSubDataEntityType((String)"bos_coderule", select);
        return dynamicObjectType;
    }

    public static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        String[] type = properties;
        int arg4 = properties.length;
        for (int arg5 = 0; arg5 < arg4; ++arg5) {
            String prop = type[arg5];
            select.add(prop.trim());
        }
        DynamicObjectType arg7 = EntityMetadataCache.getSubDataEntityType((String)entityName, select);
        return arg7;
    }

    public static void waitLog(AppLogInfo appLogInfo) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        appLogInfo.setUserID(userId);
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(new Date());
        appLogInfo.setBizAppID("83bfebc8000037ac");
        appLogInfo.setBizObjID("bos_coderule");
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    public static void clearCache(String[] codeRuleIds) {
        String selectFields = "id,enable,bizobjectid,name";
        DynamicObject[] ruleArr = BusinessDataServiceHelper.load((String)"bos_coderule", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)codeRuleIds)});
        StringBuilder ruleNumbers = new StringBuilder();
        for (DynamicObject rule : ruleArr) {
            DynamicObject bizObject = rule.getDynamicObject("bizobjectid");
            if (bizObject == null) continue;
            DynamicObjectType dObjType = CodeRuleUtils.getDynamicObjectType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dObjType);
            cacheManager.removeByPrimaryKey(new Object[]{bizObject.getString("number")});
            CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4BreakNumber(), rule.getString("id"));
            CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4SerialNumber(), rule.getString("id"));
            CodeRuleCacheMrg.clearCacheWithPrefix(CodeRuleCacheMrg.getType4MaxSerialNumber(), rule.getString("id"));
            ruleNumbers.append(rule.getString("number")).append(',');
        }
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setOpName("ruleCodeOp", new MultiLangEnumBridge("\u6e05\u7406\u7f16\u7801\u89c4\u5219\u7f13\u5b58", "CodeRuleUtils_2", BOS_CODERULE));
        appLogInfo.setOpDesc(new MultiLangEnumBridge("\u6e05\u7406\u7f16\u7801\u89c4\u5219\u7f13\u5b58%s\u6210\u529f", "CodeRuleUtils_7", BOS_CODERULE), new String[]{ruleNumbers.toString()});
        CodeRuleUtils.waitLog((AppLogInfo)appLogInfo);
    }

    public static void bindSortItem(IDataModel model) {
        Object sortItemObj = model.getValue("sortitemvalue");
        if (kd.bos.util.StringUtils.isNotEmpty((String)((String)sortItemObj))) {
            String sortItem = (String)sortItemObj;
            if ("_split_".equals(sortItem)) {
                sortItem = "";
            }
            model.setValue("sortitemvalue1", (Object)sortItem);
            model.setDataChanged(false);
        }
    }

    public static void openBillFormListSingle(AbstractFormPlugin form, String entity, List<QFilter> filters, String unionId, Map<String, Object> customParams) {
        ListShowParameter param = new ListShowParameter();
        param.setPageId(unionId);
        IFormView iFormView = form.getView().getView(unionId);
        if (iFormView != null) {
            iFormView.activate();
            form.getView().sendFormAction(iFormView);
            return;
        }
        if (customParams != null) {
            param.setCustomParams(customParams);
        }
        param.setBillFormId(entity);
        param.setFormId(FORMID_BOS_LIST);
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void openBillFormListSingle(AbstractFormPlugin form, String entity, List<QFilter> filters, String unionId, Map<String, Object> customParams, String caption) {
        ListShowParameter param = new ListShowParameter();
        param.setPageId(unionId);
        IFormView iFormView = form.getView().getView(unionId);
        if (iFormView != null) {
            iFormView.activate();
            form.getView().sendFormAction(iFormView);
            return;
        }
        if (customParams != null) {
            param.setCustomParams(customParams);
        }
        param.setBillFormId(entity);
        param.setCaption(caption);
        param.setFormId(FORMID_BOS_LIST);
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void openBillFormList(AbstractFormPlugin form, String entity, List<QFilter> filters) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        param.setFormId(FORMID_BOS_LIST);
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void openBillFormList(AbstractFormPlugin form, String entity, List<QFilter> filters, Map<String, Object> customParams) {
        ListShowParameter param = new ListShowParameter();
        param.setCustomParams(customParams);
        param.setBillFormId(entity);
        param.setFormId(FORMID_BOS_LIST);
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.getView().showForm((FormShowParameter)param);
    }

    public static void openBillFormListByPks(AbstractFormPlugin form, String entity, List<Object> pks, List<Object> selectPks) {
        QFilter qFilter = new QFilter("id", "in", (Object)pks.toArray(new String[pks.size()]));
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        param.setFormId(FORMID_BOS_LIST);
        param.setShowTitle(false);
        param.getListFilterParameter().setFilter(qFilter);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getListFilterParameter().setOrderBy("createdate desc");
        param.setSelectedRows(selectPks.toArray(new Object[0]));
        form.getView().showForm((FormShowParameter)param);
    }

    public static void openBillFormListByDynamicObject(AbstractFormPlugin form, String entity, List<DynamicObject> dynamicObjects) {
        ArrayList<Object> pks = new ArrayList<Object>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            pks.add(dynamicObject.getPkValue());
        }
        CodeRuleUtils.openBillFormListByPks(form, entity, pks, new ArrayList<Object>());
    }

    public static void showForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.setCaption(caption);
        if (callback != null) {
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        }
        p.getOpenStyle().setShowType(ShowType.Modal);
        form.getView().showForm(p);
    }

    public static void cacheBlankNumberFields(String pageId, DynamicObject dataInfo) {
        if (StringUtils.isBlank((CharSequence)pageId) || dataInfo == null) {
            return;
        }
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        Map<Object, List<String>> fieldsMap = new HashMap(1);
        String fieldsString = pageCache.get(BOTP_WITH_NULL_VALUE_BILLNO);
        if (StringUtils.isNotBlank((CharSequence)fieldsString)) {
            fieldsMap = (Map)SerializationUtils.fromJsonString((String)fieldsString, Map.class);
        }
        IDataEntityType dataEntityType = dataInfo.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String entityName = dataEntityType.getName();
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return;
        }
        List<String> fields = CodeRuleUtils.getBlankNumberFields(dataInfo, properties, entityName);
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        fieldsMap.put(dataInfo.getPkValue(), fields);
        pageCache.put(BOTP_WITH_NULL_VALUE_BILLNO, SerializationUtils.toJsonString(fieldsMap));
    }

    public static void convertPageCacheToOperateOption(String pageId, OperateOption operateOption) {
        if (StringUtils.isBlank((CharSequence)pageId) || operateOption == null) {
            return;
        }
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        operateOption.setVariableValue(BOTP_WITH_NULL_VALUE_BILLNO, pageCache.get(BOTP_WITH_NULL_VALUE_BILLNO));
    }

    private static List<String> getBlankNumberFields(DynamicObject dataInfo, DataEntityPropertyCollection properties, String entityName) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityName);
        List plugins = formConfig.getPlugins();
        if (CollectionUtils.isEmpty((Collection)plugins)) {
            return null;
        }
        String className = "";
        ArrayList<String> fields = new ArrayList<String>();
        for (Plugin plugin : plugins) {
            if (!plugin.isEnabled() || StringUtils.isBlank((CharSequence)(className = plugin.getClassName()))) continue;
            try {
                Object value;
                String billNoField;
                Object object = TypesContainer.createInstance((String)className);
                if (!(object instanceof AbstractCodeRulePlugin) || properties.get((Object)(billNoField = ((AbstractCodeRulePlugin)((Object)object)).getBillNoFieldForService(dataInfo))) == null || !StringUtils.isBlank((Object)(value = dataInfo.get(billNoField)))) continue;
                fields.add(billNoField);
            }
            catch (Exception e) {
                log.error("[AbstractCodeRulePlugin]\u63d2\u4ef6\u5b9e\u4f8b\u5316\u5931\u8d25", (Throwable)e);
            }
        }
        return fields;
    }

    public static boolean isEnable(String codeRuleId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_coderule", (String)"enable", (QFilter[])new QFilter("id", "=", (Object)codeRuleId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            DynamicObject dynamicObject = (DynamicObject)query.get(0);
            return dynamicObject.getBoolean("enable");
        }
        return false;
    }
}

