/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class StandradSettingUtil {
    private static Log logger = LogFactory.getLog(StandradSettingUtil.class);

    public static String getBlackListIdsAtCloud() {
        String cloudListFormBlack = RunModeServiceHelper.getCloudIdsFromBlackList();
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List cloudListFormHiddens = service.getCloudIdBlackList();
        return StandradSettingUtil.splicingBlackListIdsOrNumbers(cloudListFormBlack, cloudListFormHiddens);
    }

    public static String getBlackListIdsAtApp() {
        String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List appListFormHiddens = service.getAppIdBlackList();
        return StandradSettingUtil.splicingBlackListIdsOrNumbers(appBlacklist, appListFormHiddens);
    }

    public static String getBlackListNumbersAtEntity(String appId) {
        String appNumber = AppMetadataCache.getAppNumberById((String)appId);
        String entityNumBlacklist = RunModeServiceHelper.getEntityNumFromBlacklist((String)appNumber);
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List fnumbers = service.getFormBlackListByAppId(appId);
        return StandradSettingUtil.splicingBlackListIdsOrNumbers(entityNumBlacklist, fnumbers);
    }

    private static String splicingBlackListIdsOrNumbers(String runModeNumbers, List<String> numberList) {
        StringBuilder sb = new StringBuilder();
        if (kd.bos.util.StringUtils.isNotEmpty((String)runModeNumbers)) {
            sb.append(runModeNumbers).append(',');
        }
        for (String number : numberList) {
            sb.append('\'').append(number).append('\'').append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static QFilter[] getBlackListQFilterAtApp(QFilter[] qFilters) {
        String filterKey = "id";
        qFilters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])qFilters, (String)filterKey);
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List appListFormHiddens = service.getAppIdBlackList();
        QFilter qFilter = StandradSettingUtil.wrapNotInFilterBy(appListFormHiddens, filterKey);
        return StandradSettingUtil.addFilterToFilters(qFilters, qFilter);
    }

    private static QFilter[] addFilterToFilters(QFilter[] filters, QFilter qf) {
        try {
            if (qf == null) {
                return filters;
            }
            if (filters == null) {
                filters = new QFilter[]{qf};
            } else {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
                filterList.add(qf);
                filters = filterList.toArray(new QFilter[filterList.size()]);
            }
        }
        catch (Exception var3) {
            logger.error("\u6dfb\u52a0\u8fd0\u884c\u6a21\u5f0f\u9ed1\u540d\u5355\u5230QFilter[]\u6709\u8bef\uff01", (Throwable)var3);
        }
        return filters;
    }

    private static QFilter wrapNotInFilterBy(List<String> ids, String filsterKey) {
        try {
            return !StringUtils.isEmpty((CharSequence)filsterKey) && ids != null && !ids.isEmpty() ? new QFilter(filsterKey, "not in", ids) : null;
        }
        catch (Exception var3) {
            logger.error("\u6839\u636e" + filsterKey + "\u5c01\u88c5\u8fd0\u884c\u6a21\u5f0f\u9ed1\u540d\u5355\u5230QFilter[]\u6709\u8bef\uff01", (Throwable)var3);
            return null;
        }
    }

    public static QFilter[] getBlackListQFilterAtEntity(QFilter[] qFilters, String appId) {
        String filterKey = "form";
        qFilters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])qFilters, (String)filterKey);
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List ids = service.getFormIdBlackListByAppId(appId);
        QFilter qFilter = StandradSettingUtil.wrapNotInFilterBy(ids, filterKey);
        return StandradSettingUtil.addFilterToFilters(qFilters, qFilter);
    }
}

