/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.newedit.PageCacheUtil;
import kd.bos.coderule.util.StandradSettingUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;
import org.apache.commons.collections4.CollectionUtils;

public class TreeListUtil {
    private static final String FORMNUM_CODERULE_EDIT = "bos_coderule_edit";
    public static final String ID_SPLIT = "_split_";
    public static final String CODERULE_TREENODE_LOAD = "coderule_treenode_load_";
    public static final String CODERULE_TREE_NODES = "coderule_tree_nodes";
    public static final String CODERULE_TREENODE_BY_CLOUD = "coderule_treenode_by_cloud";
    public static final String CODERULE_TREENODE_BY_APP_PRE = "coderule_treenode_by_app_";
    public static final String CODERULE_TREENODE_BY_ENTITY_ = "coderule_treenode_by_entity_";

    public static void showForm(IFormView formView, String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, OperationStatus operationStatus) {
        FormShowParameter fsp = new FormShowParameter();
        if (FORMNUM_CODERULE_EDIT.equals(formId) && !"true".equals(params.get("iscopy"))) {
            String pageId = formView.getPageId();
            String codeRuleId = (String)params.get("id");
            String entityNum = (String)params.get("objId");
            String newPageId = "";
            if (StringUtils.isNotBlank((CharSequence)codeRuleId)) {
                newPageId = pageId + "|" + formId + "|" + codeRuleId;
            } else if (StringUtils.isNotBlank((CharSequence)entityNum)) {
                newPageId = pageId + "|" + formId + "|" + entityNum;
            }
            IFormView iformView = formView.getView(newPageId);
            if (iformView != null) {
                iformView.activate();
                formView.sendFormAction(iformView);
                return;
            }
            fsp.setPageId(newPageId);
        }
        fsp.getOpenStyle().setShowType(showType);
        fsp.setFormId(formId);
        if (params != null) {
            fsp.setCustomParams(params);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        if (operationStatus != null) {
            fsp.setStatus(operationStatus);
        }
        formView.showForm(fsp);
    }

    public static List<TreeNode> getAllCloudNodes(IPageCache pageCache) {
        List<TreeNode> cloudNodes = PageCacheUtil.getListFromPageCache(pageCache, CODERULE_TREENODE_BY_CLOUD, TreeNode.class);
        if (CollectionUtils.isNotEmpty(cloudNodes)) {
            return cloudNodes;
        }
        String localeid = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, al.fname ");
        sql.append(" from t_meta_bizcloud a ");
        sql.append(" inner join t_meta_bizcloud_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(" where al.flocaleid = '").append(localeid).append("' ");
        sql.append(" and a.fvisible = '1' ");
        String cloudBlacklist = StandradSettingUtil.getBlackListIdsAtCloud();
        if (StringUtils.isNotBlank((CharSequence)cloudBlacklist)) {
            sql.append(" and a.fid not in (").append(cloudBlacklist).append(") ");
        }
        sql.append(" order by a.fid asc");
        List bizCloudList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<List<Map<String, String>>>(){

            public List<Map<String, String>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(30);
                while (rs.next()) {
                    HashMap<String, String> bizCloudMap = new HashMap<String, String>();
                    String id = rs.getString(1);
                    bizCloudMap.put("treeNodeId", "1_split_" + id);
                    bizCloudMap.put("id", id);
                    bizCloudMap.put("name", rs.getString(2));
                    result.add(bizCloudMap);
                }
                return result;
            }
        });
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_CLOUD);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(bizCloudList.size());
        for (Map subsystemData : bizCloudList) {
            String id = (String)subsystemData.get("id");
            if (treeNodeFilter.isDisableCloud(id)) continue;
            TreeNode treeNode = new TreeNode();
            String treeNodeId = (String)subsystemData.get("treeNodeId");
            String name = (String)subsystemData.get("name");
            treeNode.setParentid("0");
            treeNode.setId(treeNodeId);
            treeNode.setText(name);
            treeNode.addChildren(new ArrayList());
            treeNode.setData((Object)1);
            treeNodes.add(treeNode);
        }
        PageCacheUtil.addListToPageCache(pageCache, CODERULE_TREENODE_BY_CLOUD, treeNodes, TreeNode.class);
        return treeNodes;
    }

    public static List<TreeNode> getAppNodesByCloudId(IPageCache pageCache, String originalId) {
        List<TreeNode> appNodes = PageCacheUtil.getListFromPageCache(pageCache, CODERULE_TREENODE_BY_APP_PRE + originalId, TreeNode.class);
        if (CollectionUtils.isNotEmpty(appNodes)) {
            return appNodes;
        }
        String cloudId = originalId.split(ID_SPLIT)[1];
        String localeid = RequestContext.get().getLang().name();
        QFilter[] qfArr = new QFilter[1];
        DynamicObject[] load = null;
        List<String> ids = TreeListUtil.findBizappExistsEntity(cloudId);
        qfArr[0] = new QFilter("id", "in", ids);
        load = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"", (QFilter[])(qfArr = StandradSettingUtil.getBlackListQFilterAtApp(qfArr)), (String)"id");
        if (load == null) {
            return new ArrayList<TreeNode>(1);
        }
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(load.length);
        Map allAppInfo = AppMetadataCache.getAllAppInfo();
        for (DynamicObject obj : load) {
            String id;
            if (obj == null || treeNodeFilter.isDisableApp(id = (String)obj.get("id"))) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setParentid(originalId);
            treeNode.addChildren(new ArrayList());
            treeNode.setId("2_split_" + id);
            AppInfo appInfo = (AppInfo)allAppInfo.get(obj.getString("number"));
            if (appInfo == null) {
                appInfo = AppMetadataCache.getAppInfo((String)id);
            }
            LocaleString name = appInfo.getName();
            treeNode.setText((String)name.get((Object)localeid));
            treeNodes.add(treeNode);
        }
        PageCacheUtil.addListToPageCache(pageCache, CODERULE_TREENODE_BY_APP_PRE + originalId, treeNodes, TreeNode.class);
        return treeNodes;
    }

    public static List<TreeNode> getFormNodesByAppId(IPageCache pageCache, String originalId) {
        List<TreeNode> entityNodes = PageCacheUtil.getListFromPageCache(pageCache, CODERULE_TREENODE_BY_ENTITY_ + originalId, TreeNode.class);
        if (CollectionUtils.isNotEmpty(entityNodes)) {
            return entityNodes;
        }
        String appId = originalId.split(ID_SPLIT)[1];
        String localeid = RequestContext.get().getLang().name();
        QFilter[] qfArr = new QFilter[1];
        DynamicObject[] load = null;
        List<String> allExtAppId = TreeListUtil.getAllExtAppId(appId);
        allExtAppId.add(appId);
        qfArr[0] = new QFilter("bizapp", "in", allExtAppId);
        qfArr = StandradSettingUtil.getBlackListQFilterAtEntity(qfArr, appId);
        load = BusinessDataServiceHelper.load((String)"bos_devportal_unitrelform", (String)"form", (QFilter[])qfArr, (String)"form");
        HashSet<Object> idSet = new HashSet<Object>(load.length);
        for (DynamicObject dynamicObject : load) {
            idSet.add(dynamicObject.get("form"));
        }
        QFilter modelType = new QFilter("modeltype", "in", (Object)new String[]{"BaseFormModel", "BillFormModel"});
        QFilter isTemplate = new QFilter("istemplate", "=", (Object)false);
        QFilter[] qFilters = new QFilter[]{new QFilter("dentityid", "in", idSet), modelType, isTemplate};
        DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,codenumber,modeltype,dentityid,name", (QFilter[])qFilters);
        idSet = new HashSet();
        HashMap<Object, String> formName = new HashMap<Object, String>(8);
        for (DynamicObject dynamicObject : entitys) {
            if (dynamicObject.getBoolean("codenumber")) {
                idSet.add(dynamicObject.get("dentityid"));
            }
            formName.put(dynamicObject.get("dentityid"), dynamicObject.getString("name"));
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : load) {
            if (!idSet.contains(dynamicObject.get("form"))) continue;
            list.add(dynamicObject);
        }
        load = new DynamicObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            load[i] = (DynamicObject)list.get(i);
        }
        load = TreeListUtil.buildDynamicsWithFilter(load);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(load.length);
        for (DynamicObject obj : load) {
            if (obj == null) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setParentid(originalId);
            String formId = (String)obj.get("form");
            String name = (String)formName.get(formId);
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            treeNode.setId("3_split_" + formId);
            treeNode.setText(name);
            treeNodes.add(treeNode);
        }
        PageCacheUtil.addListToPageCache(pageCache, CODERULE_TREENODE_BY_ENTITY_ + originalId, treeNodes, TreeNode.class);
        return treeNodes;
    }

    private static List<String> findBizappExistsEntity(String bizCloudId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT A.FID, A.FMASTERID ");
        sql.append(" FROM T_META_BIZAPP A");
        sql.append(" WHERE A.FBIZCLOUDID = ?");
        sql.append(" AND a.fdeploystatus = '2' ");
        Object[] filters = new String[]{bizCloudId};
        Set idSet = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> ids = new HashSet<String>();
                while (rs.next()) {
                    String id = rs.getString(1);
                    String masterid = rs.getString(2);
                    if (StringUtils.isNotBlank((CharSequence)masterid)) {
                        ids.add(masterid);
                        continue;
                    }
                    ids.add(id);
                }
                return ids;
            }
        });
        return new ArrayList<String>(idSet);
    }

    public static List<String> getAllExtAppId(String originalAppId) {
        String sql = "select fid from t_meta_bizapp where fmasterid = ? and fid<> ?";
        Object[] params = new Object[]{originalAppId, originalAppId};
        ArrayList<String> result = new ArrayList<String>();
        DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                result.add(rs.getString("fid"));
            }
            return null;
        });
        return result;
    }

    private static DynamicObject[] buildDynamicsWithFilter(DynamicObject[] load) {
        LinkedHashMap<String, DynamicObject> dynamicMaps = new LinkedHashMap<String, DynamicObject>();
        if (load != null && load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                dynamicMaps.put(dynamicObject.getString("form"), dynamicObject);
            }
        }
        QFilter[] entitymetaQFilter = new QFilter[]{new QFilter("id", "in", dynamicMaps.keySet())};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_entitymeta", (String)"id", (QFilter[])entitymetaQFilter);
        Set idsFromEntitymeta = Optional.ofNullable(dynamicObjects).map(Collection::stream).orElseGet(Stream::empty).map(x -> x.getString("id")).collect(Collectors.toSet());
        DynamicObject[] newLoad = new DynamicObject[dynamicObjects.size()];
        int j = 0;
        for (Map.Entry entry : dynamicMaps.entrySet()) {
            if (!idsFromEntitymeta.contains(entry.getKey())) continue;
            newLoad[j++] = (DynamicObject)entry.getValue();
        }
        return newLoad;
    }

    public static Map<String, String> getBizObjectById(String id) {
        Map map = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.fid, b.fname,a.fcodenumber from t_meta_mainentityinfo a ");
        sql.append(" INNER JOIN t_meta_mainentityinfo_l b on (a.fid = b.fid and b.flocaleid = ?) ");
        sql.append(" where a.fdentityid = ? ");
        sql.append(" and a.fistemplate = '0'  ");
        sql.append(" and a.fmodeltype in ('BaseFormModel', 'BillFormModel') ");
        Object[] filters = new String[]{RequestContext.get().getLang().name(), id};
        map = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> result = new HashMap<String, String>(10000);
                while (rs.next()) {
                    if (!"1".equals(rs.getString("fcodenumber"))) continue;
                    result.put("number", rs.getString("fid"));
                    result.put("name", rs.getString("fname"));
                }
                return result;
            }
        });
        return map;
    }

    public static void addNodes(IPageCache pageCache, TreeView treeView, List<TreeNode> treeNodes, String parentId) {
        String flag = pageCache.get(CODERULE_TREENODE_LOAD + parentId);
        if (StringUtils.isBlank((CharSequence)flag) || String.valueOf(false).equals(flag)) {
            pageCache.put(CODERULE_TREENODE_LOAD + parentId, String.valueOf(true));
            TreeListUtil.addNodes(pageCache, treeView, treeNodes);
        }
    }

    public static void addNodes(IPageCache pageCache, TreeView treeView, List<TreeNode> treeNodes) {
        List nodes = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        PageCacheUtil.addSetToPageCache(pageCache, CODERULE_TREE_NODES, new HashSet<Object>(nodes));
        if (CollectionUtils.isNotEmpty(treeNodes)) {
            treeView.addNodes(treeNodes);
        }
    }
}

