/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util.intermitno;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.util.CodeRuleInfoBuilder;
import kd.bos.coderule.util.CodeRuleNumberDTO;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.coderule.util.intermitno.IntermitNoDetectDTO;
import kd.bos.coderule.util.intermitno.filter.Filter;
import kd.bos.coderule.util.intermitno.filter.HashSetFilter;
import kd.bos.coderule.util.intermitno.filter.MyBoolmFilter;
import kd.bos.coderule.util.intermitno.filter.NoElementFilter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.NoSuchPropertyException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class IntermitNoDetectUtil {
    private static final Log logger = LogFactory.getLog(IntermitNoDetectUtil.class);
    private static final String TYPE_SEQ = "16";
    private static final String EXCEPTION_CODE = IntermitNoDetectUtil.class.getName();
    private static final String INTERMITNO_ID = "bos_coderule_intermitno";
    private static final String ERRCODE_CODERULE = "ErrCode_CodeRule";
    public static final String CODERULEID = "coderuleid";
    public static final String BOS_CODERULE = "bos-coderule";

    public static IntermitNoDetectDTO checkCodeRuleIntermitNo(Object codeRulePk) {
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingle((Object)codeRulePk, (String)"bos_coderule");
        IntermitNoDetectUtil.checkCodeRule(codeRule);
        CodeRuleInfo codeRuleInfo = CodeRuleInfoBuilder.buildCodeRuleInfo(codeRule);
        if (CollectionUtils.isEmpty((Collection)codeRuleInfo.getRuleEntry())) {
            throw new KDException(new ErrorCode(ERRCODE_CODERULE, ResManager.loadKDString((String)"[IntermitNoDetectUtil.checkCodeRuleIntermitNo] codeRuleInfo\u4e3a\u7a7a \u6216\u8005 \u5206\u5f55\u884c\u4e3a\u7a7a", (String)"IntermitNoDetectUtil_0", (String)BOS_CODERULE, (Object[])new Object[0])), new Object[0]);
        }
        HashMap<String, List<Long>> seqNumbersInDBMapBySortitem = new HashMap<String, List<Long>>(16);
        HashMap<String, Long> maxNumberMapBySortItem = new HashMap<String, Long>(16);
        IntermitNoDetectUtil.generateSeqNumbersInDBGroupBySortItem(codeRule, codeRuleInfo, seqNumbersInDBMapBySortitem, maxNumberMapBySortItem);
        for (Map.Entry entry : seqNumbersInDBMapBySortitem.entrySet()) {
            StringBuilder seq = new StringBuilder();
            ((List)entry.getValue()).forEach(v -> seq.append(v).append(','));
            String seqStr = seq.toString();
            logger.info(String.format(ResManager.loadKDString((String)"[checkCodeRuleIntermitNo]\u641c\u7d22\u5230\u4e1a\u52a1\u6570\u636e\u5e93\u4e2d\u7684\u4f9d\u636e\u4e3a%1$s,\u5e8f\u53f7\u4e3a<%2$s>", (String)"IntermitNoDetectUtil_7", (String)BOS_CODERULE, (Object[])new Object[0]), entry.getKey(), seqStr));
            logger.info(String.format(ResManager.loadKDString((String)"[checkCodeRuleIntermitNo]\u641c\u7d22\u5230\u4e1a\u52a1\u6570\u636e\u5e93\u4e2d\u7684\u4f9d\u636e\u4e3a%1$s,\u6700\u5927\u503c\u4e3a<%2$s>", (String)"IntermitNoDetectUtil_1", (String)BOS_CODERULE, (Object[])new Object[0]), entry.getKey(), maxNumberMapBySortItem.get(entry.getKey())));
        }
        Filter filter = IntermitNoDetectUtil.buildFilter(codeRuleInfo);
        Optional<CodeRuleEntryInfo> seqEntryInfo = IntermitNoDetectUtil.getSeqEntryInfo(codeRuleInfo);
        ArrayList<String> lostIntermitIds = new ArrayList<String>(16);
        ArrayList<String> allIntermitIds = new ArrayList<String>(16);
        for (Map.Entry maxNumberMap : maxNumberMapBySortItem.entrySet()) {
            String sortItem = (String)maxNumberMap.getKey();
            long maxNumber = IntermitNoDetectUtil.getCodeRuleMaxserialNumber(codeRuleInfo.getId(), sortItem);
            logger.info(String.format(ResManager.loadKDString((String)"[checkCodeRuleIntermitNo]\u67e5\u8be2\u5230\u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7\u4e2d\u7684\u4f9d\u636e\u4e3a%1$s,\u6700\u5927\u503c\u4e3a<%2$s>", (String)"IntermitNoDetectUtil_2", (String)BOS_CODERULE, (Object[])new Object[0]), sortItem, maxNumber));
            List<Long> seqNumbersInRule = IntermitNoDetectUtil.buildSeqNumbersInCodeRule(maxNumber, seqEntryInfo);
            List<Long> allIntermitNumbers = IntermitNoDetectUtil.filterWithoutDBIntermitNumbers((List)seqNumbersInDBMapBySortitem.get(sortItem), seqNumbersInRule);
            lostIntermitIds.addAll(IntermitNoDetectUtil.filterLostIntermitNoInCodeRuleDB(codeRule, sortItem, filter, allIntermitNumbers));
            allIntermitIds.addAll(IntermitNoDetectUtil.convertSeqNumToId(codeRuleInfo.getId(), sortItem, allIntermitNumbers));
        }
        return new IntermitNoDetectDTO(lostIntermitIds, allIntermitIds);
    }

    private static long getCodeRuleMaxserialNumber(String id, String sortItem) {
        if ("_split_".equals(sortItem)) {
            sortItem = "";
        }
        String sql = "select fmaxserial from T_CR_MaxSerial where fcoderuleid = ? and fsortitemvalue = ?";
        Object[] params = new Object[]{id, sortItem};
        Object fmaxserial = DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, resultSet -> {
            long maxserial = 0L;
            while (resultSet.next()) {
                maxserial = resultSet.getLong("fmaxserial");
            }
            return maxserial;
        });
        return (Long)fmaxserial;
    }

    private static void checkCodeRule(DynamicObject coderule) {
        if (coderule.getInt("enable") == 0) {
            String errorInfo = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\uff1a%s \u672a\u542f\u7528\uff01", (String)"IntermitNoDetectUtil_3", (String)BOS_CODERULE, (Object[])new Object[0]), coderule.getString("name"));
            throw new KDException(new ErrorCode(EXCEPTION_CODE, errorInfo), new Object[0]);
        }
        if (!coderule.getBoolean("isnonbreak")) {
            String errorInfo = String.format(ResManager.loadKDString((String)"%s : \u4e0d\u5141\u8bb8\u65ad\u53f7\u7684\u7f16\u7801\u89c4\u5219\u624d\u9700\u8981\u68c0\u6d4b", (String)"IntermitNoDetectUtil_4", (String)BOS_CODERULE, (Object[])new Object[0]), coderule.getString("name"));
            throw new KDException(new ErrorCode(EXCEPTION_CODE, errorInfo), new Object[0]);
        }
    }

    private static void generateSeqNumbersInDBGroupBySortItem(DynamicObject codeRule, CodeRuleInfo codeRuleInfo, Map<String, List<Long>> seqNumbersInDBMapBySortitem, Map<String, Long> maxNumberMapBySortitem) {
        block17: {
            DynamicObject bizObj = codeRule.getDynamicObject("bizobjectid");
            String billNoKey = IntermitNoDetectUtil.getBillNoKey(bizObj);
            String bizEntityId = bizObj.getString("number");
            Set<String> properties = IntermitNoDetectUtil.getUsedProperties(codeRuleInfo);
            properties.add("id");
            properties.add(billNoKey);
            try (DataSet dataSet = ORM.create().queryDataSet(IntermitNoDetectUtil.class.getName(), bizEntityId, IntermitNoDetectUtil.join(properties, ","), null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    DynamicObject data = IntermitNoDetectUtil.installDynamicObjectFromRow(row, bizEntityId, properties);
                    CodeRuleNumberDTO codeRuleNumberDTO = CodeRuleSerialNumUtil.getSerialNumberWithoutSplitSign(codeRuleInfo, data, row.getString(billNoKey));
                    if ("-1".equals(codeRuleNumberDTO.getSerialNumber())) continue;
                    Long serialNumber = Long.valueOf(codeRuleNumberDTO.getSerialNumber());
                    String sortItemValue = codeRuleNumberDTO.getSortItemValue();
                    if (StringUtils.isBlank((CharSequence)sortItemValue)) {
                        sortItemValue = "_split_";
                    }
                    Long maxNumber = Math.max(maxNumberMapBySortitem.getOrDefault(sortItemValue, 0L), serialNumber);
                    maxNumberMapBySortitem.put(sortItemValue, maxNumber);
                    List<Long> seqNumbers = seqNumbersInDBMapBySortitem.get(sortItemValue);
                    if (CollectionUtils.isEmpty(seqNumbers)) {
                        seqNumbers = new ArrayList<Long>();
                        seqNumbersInDBMapBySortitem.put(sortItemValue, seqNumbers);
                    }
                    seqNumbers.add(serialNumber);
                }
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof NoSuchPropertyException)) break block17;
                logger.warn((Throwable)e);
                throw new KDException(new ErrorCode(EXCEPTION_CODE, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u4e2d\u7684\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\uff0c\u5728\u5b9e\u9645\u4e1a\u52a1\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"IntermitNoDetectUtil_5", (String)BOS_CODERULE, (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    private static String getBillNoKey(DynamicObject bizObj) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)bizObj.getString("number"));
        if (type instanceof BillEntityType) {
            return ((BillEntityType)type).getBillNo();
        }
        String errorInfo = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\uff1a%s\uff0c \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7f16\u7801\u5b57\u6bb5", (String)"IntermitNoDetectUtil_6", (String)BOS_CODERULE, (Object[])new Object[0]), type.getName());
        throw new KDException(new ErrorCode(EXCEPTION_CODE, errorInfo), new Object[0]);
    }

    private static Set<String> getUsedProperties(CodeRuleInfo codeRuleInfo) {
        HashSet<String> properties = new HashSet<String>();
        for (CodeRuleEntryInfo codeRuleEntryInfo : codeRuleInfo.getRuleEntry()) {
            if (!StringUtils.isNotEmpty((CharSequence)codeRuleEntryInfo.getValueAtribute())) continue;
            if (codeRuleEntryInfo.getValueAtribute().contains(".")) {
                String[] strs = codeRuleEntryInfo.getValueAtribute().split("\\.");
                properties.add(strs[0]);
                continue;
            }
            properties.add(codeRuleEntryInfo.getValueAtribute());
        }
        return properties;
    }

    private static DynamicObject installDynamicObjectFromRow(Row row, String entityId, Set<String> properties) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityId);
        for (String property : properties) {
            dynamicObject.set(property, row.get(property));
        }
        return dynamicObject;
    }

    private static Filter buildFilter(CodeRuleInfo codeRuleInfo) {
        QFilter qf = new QFilter(CODERULEID, "=", (Object)codeRuleInfo.getId());
        int size = ORM.create().count(IntermitNoDetectUtil.class.getName(), INTERMITNO_ID, new QFilter[]{qf});
        if (size > 1000) {
            return new MyBoolmFilter(size, codeRuleInfo);
        }
        if (size <= 0) {
            return new NoElementFilter();
        }
        return new HashSetFilter(size, codeRuleInfo);
    }

    private static Optional<CodeRuleEntryInfo> getSeqEntryInfo(CodeRuleInfo codeRuleInfo) {
        Optional<CodeRuleEntryInfo> seqEntryInfo = codeRuleInfo.getRuleEntry().stream().filter(codeRuleEntryInfo -> TYPE_SEQ.equals(codeRuleEntryInfo.getAttributeType())).findFirst();
        if (!seqEntryInfo.isPresent()) {
            throw new KDException(new ErrorCode(ERRCODE_CODERULE, ""), new Object[0]);
        }
        return seqEntryInfo;
    }

    private static List<Long> buildSeqNumbersInCodeRule(long maxNumber, Optional<CodeRuleEntryInfo> seqEntryInfo) {
        long currentSeqNumber;
        long step = seqEntryInfo.get().getStep();
        int capacity = (int)((maxNumber - currentSeqNumber) / step + 1L);
        ArrayList<Long> seqNumbersInRule = new ArrayList<Long>(capacity);
        for (currentSeqNumber = seqEntryInfo.get().getInitial(); currentSeqNumber <= maxNumber; currentSeqNumber += step) {
            seqNumbersInRule.add(currentSeqNumber);
        }
        return seqNumbersInRule;
    }

    private static List<Long> filterWithoutDBIntermitNumbers(List<Long> seqNumbersInDB, List<Long> seqNumbersInRule) {
        ArrayList<Long> allIntermitNumbers = new ArrayList<Long>(seqNumbersInRule.size() - seqNumbersInDB.size() > 0 ? seqNumbersInRule.size() - seqNumbersInDB.size() : 16);
        Set seqNumberSetInDB = Optional.ofNullable(seqNumbersInDB).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
        for (Long seqNumberInRule : seqNumbersInRule) {
            if (seqNumberSetInDB.contains(seqNumberInRule)) continue;
            allIntermitNumbers.add(seqNumberInRule);
        }
        return allIntermitNumbers;
    }

    private static List<String> filterLostIntermitNoInCodeRuleDB(DynamicObject codeRule, String sortItem, Filter filter, List<Long> allIntermitNumbers) {
        ArrayList<DynamicObject> intermitNos = new ArrayList<DynamicObject>(10);
        for (Long intermitNumber : allIntermitNumbers) {
            if (filter.contains(codeRule, sortItem, intermitNumber)) continue;
            DynamicObject dynamicObject = IntermitNoDetectUtil.convertSeqNumToCodeRuleDynamicSimple(codeRule, sortItem, intermitNumber);
            intermitNos.add(dynamicObject);
        }
        ArrayList<String> intermitNoIds = new ArrayList<String>(intermitNos.size());
        if (!intermitNos.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])intermitNos.toArray(new DynamicObject[0]));
            for (DynamicObject intermitNo : intermitNos) {
                intermitNoIds.add(String.valueOf(intermitNo.getPkValue()));
            }
        }
        return intermitNoIds;
    }

    private static DynamicObject convertSeqNumToCodeRuleDynamicSimple(DynamicObject codeRule, String sortItem, Long intermitNumber) {
        DynamicObject intermitNoObj = BusinessDataServiceHelper.newDynamicObject((String)INTERMITNO_ID);
        intermitNoObj.set(CODERULEID, (Object)codeRule);
        intermitNoObj.set("sortitemvalue", (Object)sortItem);
        intermitNoObj.set("serial", (Object)intermitNumber);
        intermitNoObj.set("createdate", (Object)new Date());
        intermitNoObj.set("creater", (Object)RequestContext.get().getUserId());
        return intermitNoObj;
    }

    private static List<String> convertSeqNumToId(String id, String sortItem, List<Long> allIntermitNumbers) {
        QFilter qfilter = new QFilter(CODERULEID, "=", (Object)id).and(new QFilter("sortitemvalue", "=", (Object)sortItem));
        DynamicObjectCollection query = QueryServiceHelper.query((String)INTERMITNO_ID, (String)"id, serial", (QFilter[])new QFilter[]{qfilter});
        Set allIntermitNumberSet = Optional.ofNullable(allIntermitNumbers).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
        ArrayList<String> result = new ArrayList<String>(allIntermitNumberSet.size());
        for (DynamicObject dynamicObject : query) {
            long serial = dynamicObject.getLong("serial");
            if (!allIntermitNumberSet.contains(serial)) continue;
            result.add(dynamicObject.getString("id"));
        }
        return result;
    }

    public static String buildNumber(String sortItemValue, long intermitNo) {
        return sortItemValue + "**" + intermitNo;
    }

    public static String join(Collection<?> c, String seperator) {
        StringBuilder sb = new StringBuilder(c.size() * 8);
        for (Object o : c) {
            if (sb.length() > 0) {
                sb.append(seperator);
            }
            sb.append(o);
        }
        return sb.toString();
    }
}

