/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ConditionEntryInfo;
import kd.bos.coderule.opplugin.pagecache.BillNoChangeCache;
import kd.bos.coderule.opplugin.pagecache.CodeRuleCache;
import kd.bos.coderule.opplugin.pagecache.MainOrgCache;
import kd.bos.coderule.opplugin.pagecache.PageCreateDataCache;
import kd.bos.coderule.opplugin.pagecache.PageLoadCache;
import kd.bos.coderule.opplugin.pagecache.PushNumberCache;
import kd.bos.coderule.opplugin.pagecache.RecycleCache;
import kd.bos.coderule.opplugin.pagecache.SerialNumberPageCache;
import kd.bos.coderule.opplugin.pagecache.UseCodeRuleCache;
import kd.bos.coderule.opplugin.util.DynamicObjUtil;
import kd.bos.coderule.opplugin.util.FormViewUtil;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.coderule.util.CodeRuleInfoUtil;
import kd.bos.coderule.util.CodeRuleNumberCheckUtil;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.coderule.util.CodeRuleSystemParam;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MainOrgEdit;
import kd.bos.form.field.events.AfterChangeMainOrgEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.MainOrgChangeListener;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.CodeRulePluginUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;

public class AbstractCodeRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
MainOrgChangeListener {
    private static final Log logger = LogFactory.getLog(AbstractCodeRulePlugin.class);
    private static final String BOS_CODERULE = "bos-coderule";
    public static final String SKIPBILLNOVALIDATOR = "skipbillnovalidator";
    private static final String SKIPBILLNOVALIDATOR_VALUE = "skipbillnovalidator_value";
    private CodeRuleServiceImp codeRuleService = new CodeRuleServiceImp();
    private DynamicObject dynamicObject;
    private MainEntityType mainEntityType;
    private String billNoField;
    private boolean isSettedNumber = false;
    private BillNoChangeCache billChangeCache;
    private CodeRuleCache codeRuleCache;
    private MainOrgCache mainOrgCache;
    private PageLoadCache pageLoadCache;
    private RecycleCache recycleCache;
    private UseCodeRuleCache useCodeRuleCache;
    private PageCreateDataCache pageCreateDataCache;
    private SerialNumberPageCache serialNumberCache;
    private PushNumberCache pushNumberCache;

    protected String getSkipbillnovalidator() {
        return SKIPBILLNOVALIDATOR + this.getClassName();
    }

    protected String getSkipbillnovalidatorValue() {
        return SKIPBILLNOVALIDATOR_VALUE + this.getClassName();
    }

    public void initialize() {
        MainOrgEdit mainOrgEdit;
        this.billChangeCache = new BillNoChangeCache(this.getPageCache(), this.getClassName());
        this.codeRuleCache = new CodeRuleCache(this.getPageCache(), this.getClassName());
        this.mainOrgCache = new MainOrgCache(this.getPageCache(), this.getClassName());
        this.pageLoadCache = new PageLoadCache(this.getPageCache(), this.getClassName());
        this.recycleCache = new RecycleCache(this.getPageCache(), this.getClassName());
        this.useCodeRuleCache = new UseCodeRuleCache(this.getPageCache(), this.getClassName());
        this.pageCreateDataCache = new PageCreateDataCache(this.getPageCache(), this.getClassName());
        this.serialNumberCache = new SerialNumberPageCache(this.getPageCache(), this.getClassName());
        this.pushNumberCache = new PushNumberCache(this.getPageCache(), this.getClassName());
        this.loadAllCodeRuleFieldCache();
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String mainOrgKey = dataEntityType.getMainOrg();
        if (StringUtils.isNotEmpty((CharSequence)mainOrgKey) && (mainOrgEdit = (MainOrgEdit)this.getView().getControl(mainOrgKey)) != null) {
            mainOrgEdit.addMainOrgChangeListener((MainOrgChangeListener)this);
        }
    }

    protected String getClassName() {
        return "AbstractCodeRule";
    }

    private void loadAllCodeRuleFieldCache() {
        if (this.pageLoadCache.isLoad()) {
            return;
        }
        this.pageLoadCache.load();
        List<CodeRuleInfo> allCodeRuleByEntity = this.codeRuleService.getAllCodeRuleByEntity(this.getModel().getDataEntityType().getName());
        this.codeRuleCache.saveCodeRuleNum(String.valueOf(allCodeRuleByEntity.size()));
        Map<String, Set<String>> relateFields = this.buildRelateFields(allCodeRuleByEntity);
        this.codeRuleCache.saveRelateFields(relateFields);
    }

    private Map<String, Set<String>> buildRelateFields(List<CodeRuleInfo> allCodeRuleByEntity) {
        HashMap<String, Set<String>> relateFields = new HashMap<String, Set<String>>();
        for (CodeRuleInfo codeRuleInfo : allCodeRuleByEntity) {
            Set<String> filterConditionFields;
            for (Object codeRuleEntry : codeRuleInfo.getRuleEntry()) {
                if (!StringUtils.isNotBlank((CharSequence)codeRuleEntry.getValueAtribute())) continue;
                relateFields.computeIfAbsent(codeRuleInfo.getId(), s -> new HashSet()).add(codeRuleEntry.getValueAtribute().split("\\.")[0]);
            }
            List conditionEntry = codeRuleInfo.getConditionEntry();
            if (conditionEntry != null && conditionEntry.size() > 0) {
                Object codeRuleEntry;
                codeRuleEntry = conditionEntry.iterator();
                while (codeRuleEntry.hasNext()) {
                    ConditionEntryInfo entryInfo = (ConditionEntryInfo)codeRuleEntry.next();
                    String conditionPropKey = entryInfo.getProperty();
                    if (StringUtils.isBlank((CharSequence)conditionPropKey)) continue;
                    String[] splitKey = StringUtils.split((String)conditionPropKey, (String)".");
                    relateFields.computeIfAbsent(codeRuleInfo.getId(), s -> new HashSet()).add(splitKey[0]);
                }
            }
            if (CollectionUtils.isEmpty(filterConditionFields = CodeRuleInfoUtil.getFilterConditionFields(codeRuleInfo))) continue;
            relateFields.computeIfAbsent(codeRuleInfo.getId(), s -> new HashSet()).addAll(filterConditionFields);
        }
        return relateFields;
    }

    public void registerListener(EventObject e) {
        MainOrgEdit mainOrgEdit;
        super.registerListener(e);
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String mainOrgKey = dataEntityType.getMainOrg();
        if (kd.bos.util.StringUtils.isNotEmpty((String)mainOrgKey) && (mainOrgEdit = (MainOrgEdit)this.getView().getControl(mainOrgKey)) != null) {
            mainOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterChangeMainOrg(AfterChangeMainOrgEventArgs e) {
        this.initData();
        if (!this.validateCommon()) {
            this.injectBillnoToPageCache();
            return;
        }
        logger.info("[AbstractCodeRulePlugin]\u5207\u6362\u4e3b\u4e1a\u52a1\u7ec4\u7ec7");
        CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
        boolean hasSaved = false;
        this.recordRecycleNumber(codeRuleInfo);
        if (codeRuleInfo != null && (!(hasSaved = this.dynamicObject.getDataEntityState().getFromDatabase()) && codeRuleInfo.getIsAddView().booleanValue() || hasSaved && codeRuleInfo.isUpdateRecover())) {
            this.updateBillNo(codeRuleInfo);
            this.injectBillnoToPageCache();
        }
        if (codeRuleInfo == null || !hasSaved && !codeRuleInfo.getIsAddView().booleanValue()) {
            this.updateViewForBillNo(null);
        }
        this.setBillNoFieldStatus();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object value;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)this.getModel().getDataEntityType().getMainOrg()) && (value = this.getModel().getValue(fieldKey)) != null) {
            this.mainOrgCache.save((DynamicObject)value, this.getModel().getDataEntity().getPkValue());
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.pageCreateDataCache.save();
    }

    private void createNewNumber() {
        this.initData();
        if (!this.validateCommon()) {
            this.injectBillnoToPageCache();
            return;
        }
        CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
        if (codeRuleInfo == null || !codeRuleInfo.getIsAddView().booleanValue()) {
            this.injectBillnoToPageCache();
            return;
        }
        this.updateBillNo(codeRuleInfo);
        this.injectBillnoToPageCache();
    }

    public void afterCopyData(EventObject e) {
        this.createNewNumber();
        this.pushNumberCache.removePushWaySign(this.getView().getFormShowParameter());
    }

    protected CodeRuleInfo getCodeRuleInfo() {
        CodeRuleInfo codeRuleInfo;
        block2: {
            codeRuleInfo = null;
            try {
                codeRuleInfo = CodeRulePluginUtil.getCodeRuleInfoByDynamicObj(this.dynamicObject);
            }
            catch (KDException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (errorCode == null || !StringUtils.equals((CharSequence)errorCode.getCode(), (CharSequence)"CODERULE_VALID_CONDITION_ERROR")) break block2;
                throw new KDBizException(e.getMessage());
            }
        }
        return codeRuleInfo;
    }

    private void injectBillnoToPageCache() {
        if (StringUtils.isBlank((CharSequence)this.getBillNoField()) || this.mainEntityType.getProperty(this.getBillNoField()) == null) {
            return;
        }
        String billno = this.dynamicObject.getString(this.getBillNoField());
        if (StringUtils.isNotEmpty((CharSequence)billno)) {
            this.billChangeCache.saveValue(billno, this.dynamicObject.getPkValue());
            return;
        }
        this.billChangeCache.saveEmpty(this.dynamicObject.getPkValue());
    }

    private void initData() {
        try {
            this.dynamicObject = this.getModel().getDataEntity();
            this.mainEntityType = (MainEntityType)this.dynamicObject.getDataEntityType();
            this.billNoField = DynamicObjUtil.getNumField(this.mainEntityType);
        }
        catch (KDException e) {
            logger.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5173\u6ce8\u9875\u9762\u6253\u5f00\u65f6\u7684\u9519\u8bef\u63d0\u793a\u4fe1\u606f\uff0c\u5e76\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"AbstractCodeRulePlugin_0", (String)BOS_CODERULE, (Object[])new Object[0]));
        }
    }

    private boolean validateCommon() {
        IBillModel billModel;
        if (this.pushNumberCache.isPushWithNumber(this.dynamicObject.getPkValue())) {
            return false;
        }
        this.codeRuleCache.isHave();
        if (StringUtils.isBlank((CharSequence)this.getBillNoField()) || this.mainEntityType.getProperty(this.getBillNoField()) == null) {
            return false;
        }
        return !(this.getModel() instanceof IBillModel) || !(billModel = (IBillModel)this.getModel()).isFromImport();
    }

    protected String getBillNoField() {
        return this.billNoField;
    }

    public final String getBillNoFieldForService(DynamicObject dataInfo) {
        this.mainEntityType = (MainEntityType)dataInfo.getDataEntityType();
        this.billNoField = DynamicObjUtil.getNumField(this.mainEntityType);
        return this.getBillNoField();
    }

    public void updateBillNo(CodeRuleInfo codeRuleInfo) {
        if (this.isSettedNumber || this.pushNumberCache.isPushWithNumber(this.dynamicObject.getPkValue())) {
            return;
        }
        String readNumber = this.getReadNumber(codeRuleInfo);
        this.useCodeRuleCache.tagForUseCodeRule(this.dynamicObject.getPkValue());
        this.useCodeRuleCache.saveUsedCodeRuleId(codeRuleInfo.getId(), this.dynamicObject.getPkValue());
        this.updateViewForBillNo(readNumber);
    }

    private String getReadNumber(CodeRuleInfo codeRuleInfo) {
        String readNumber = null;
        try {
            logger.info("[AbstractCodeRulePlugin]\u8c03\u7528\u670d\u52a1\u9884\u8bfb\u7f16\u53f7");
            readNumber = CodeRuleServiceHelper.readNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)this.dynamicObject);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)"CodeRule_Specific_PageCacheKey_propertiesMap")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u5bf9,\u4e0d\u80fd\u751f\u6210\u6821\u9a8c\u7801", (String)"AbstractCodeRulePlugin_1", (String)BOS_CODERULE, (Object[])new Object[0]));
            }
            ErrorCode errorCode = e.getErrorCode();
            String errMsg = "";
            if (errorCode != null && "ERRCODE_CODERULE_VALIDATE_NUMBER".equals(errorCode.getCode())) {
                errMsg = errorCode.getMessage();
            }
            this.showErrorTips(errMsg, (Exception)((Object)e));
        }
        return readNumber;
    }

    private void showErrorTips(String errMsg, Exception e) {
        if (StringUtils.isBlank((CharSequence)errMsg)) {
            errMsg = ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u9884\u8bfb\u7f16\u53f7\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"AbstractCodeRulePlugin_4", (String)BOS_CODERULE, (Object[])new Object[0]);
        }
        this.getView().showErrorNotification(errMsg);
        logger.error((Throwable)e);
    }

    protected void updateViewForBillNo(String readNumber) {
        if (CodeRuleSystemParam.getMcParam("abstract_coderule_plugin.update_view_for_billno")) {
            this.getModel().setValue(this.getBillNoField(), (Object)readNumber);
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(this.getBillNoField(), (Object)readNumber);
            this.getModel().endInit();
            this.getView().updateView(this.getBillNoField());
        }
    }

    public void afterLoadData(EventObject e) {
        this.initData();
        this.injectBillnoToPageCache();
    }

    public void afterBindData(EventObject e) {
        this.pageCreateProcess();
        this.createNewNumberWhenPushChanged();
        this.initData();
        if (!this.validateCommon()) {
            return;
        }
        this.clearBillNoStatusWhenMainOrgChange();
        this.setBillNoFieldStatus();
    }

    private void pageCreateProcess() {
        if (this.pageCreateDataCache.isCreate()) {
            logger.info("[AbstractCodeRulePlugin]\u65b0\u5efa\u6d41\u7a0b");
            DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
            long[] bizChangeFlags = dataEntityState.getBizChangeFlags();
            this.createNewNumber();
            dataEntityState.setBizChangeFlags(bizChangeFlags);
            this.pageCreateDataCache.clear();
        }
    }

    protected void createNewNumberWhenPushChanged() {
        this.initData();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (this.pushNumberCache.isPushSignerNumber(pkValue) || this.pushNumberCache.isPushWithNumber(pkValue)) {
            return;
        }
        boolean fromDatabase = dataEntity.getDataEntityState().getFromDatabase();
        String billNoField = this.getBillNoField();
        if (StringUtils.isBlank((CharSequence)billNoField)) {
            return;
        }
        String number = dataEntity.getString(billNoField);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (this.pushNumberCache.isPushWay(parameter) && !fromDatabase && StringUtils.isBlank((CharSequence)number)) {
            logger.info("[AbstractCodeRulePlugin]\u4e0b\u63a8\u6d41\u7a0b\u672a\u643a\u5e26\u5355\u636e\u7f16\u53f7");
            DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
            long[] bizChangeFlags = dataEntityState.getBizChangeFlags();
            this.createNewNumber();
            dataEntityState.setBizChangeFlags(bizChangeFlags);
            this.pushNumberCache.signPushSignerNumber(pkValue);
            return;
        }
        if (this.pushNumberCache.isPushWay(parameter) && !fromDatabase && StringUtils.isNotBlank((CharSequence)number)) {
            logger.info("[AbstractCodeRulePlugin]\u4e0b\u63a8\u6d41\u7a0b\u643a\u5e26\u5355\u636e\u7f16\u53f7");
            this.injectBillnoToPageCache();
            this.pushNumberCache.signPushWithNumberCache(pkValue);
        }
        this.recordSwitchPushBillNo();
    }

    private void recordSwitchPushBillNo() {
        if (StringUtils.isBlank((CharSequence)this.getBillNoField()) || this.mainEntityType.getProperty(this.getBillNoField()) == null) {
            return;
        }
        String billNo = this.dynamicObject.getString(this.getBillNoField());
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            this.billChangeCache.saveValueWhenEmpty(billNo, this.dynamicObject.getPkValue());
        }
    }

    private void clearBillNoStatusWhenMainOrgChange() {
        String newOrgObjId;
        DynamicObject org;
        String mainOrg;
        String orgObjId = this.mainOrgCache.get(this.dynamicObject.getPkValue());
        if (kd.bos.util.StringUtils.isNotEmpty((String)orgObjId) && kd.bos.util.StringUtils.isNotEmpty((String)(mainOrg = this.getModel().getDataEntityType().getMainOrg())) && (org = (DynamicObject)this.getModel().getValue(mainOrg)) != null && !StringUtils.equals((CharSequence)orgObjId, (CharSequence)(newOrgObjId = org.getPkValue().toString()))) {
            this.mainOrgCache.save(newOrgObjId, this.dynamicObject.getPkValue());
            this.setBillNoFieldLockStatus(true);
            FormViewUtil.recoverEmptyTips(this.getView(), this.getBillNoField());
            FormViewUtil.recoverLockEmptyTips(this.getView(), this.getBillNoField());
            this.useCodeRuleCache.tagForUnUseCodeRule(this.dynamicObject.getPkValue());
        }
    }

    private void setBillNoFieldStatus() {
        CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
        if (codeRuleInfo != null) {
            this.setBillNoFieldLockStatus(codeRuleInfo.getIsModifiable());
            FormViewUtil.updateEmptyTips(this.getView(), this.getBillNoField());
            FormViewUtil.updateLockEmptyTips(this.getView(), this.getBillNoField());
            this.useCodeRuleCache.tagForUseCodeRule(this.dynamicObject.getPkValue());
            this.useCodeRuleCache.saveUsedCodeRuleId(codeRuleInfo.getId(), this.dynamicObject.getPkValue());
            if (codeRuleInfo.isUpdateRecover() && StringUtils.isNotBlank((CharSequence)this.dynamicObject.getString(this.getBillNoField()))) {
                this.isSettedNumber = true;
            }
        }
    }

    private void setBillNoFieldLockStatus(boolean isLock) {
        this.getView().setEnable(Boolean.valueOf(isLock), new String[]{this.getBillNoField()});
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        this.initData();
        if (!this.validateCommon() || e.getProperty().getParent() instanceof EntryProp) {
            return;
        }
        this.recordRecycleBillNo(e.getProperty().getName());
    }

    private void recordRecycleBillNo(String propertyName) {
        if (propertyName.equals(this.getBillNoField())) {
            CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return;
            }
            this.recordRecycleNumber(codeRuleInfo);
            return;
        }
        Map<String, Set<String>> codeRuleFieldsMap = this.codeRuleCache.getRelateFields();
        if (CollectionUtils.isEmpty(codeRuleFieldsMap)) {
            return;
        }
        Set propSetAll = codeRuleFieldsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (propSetAll.contains(propertyName)) {
            CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return;
            }
            Set<String> propSet = codeRuleFieldsMap.get(codeRuleInfo.getId());
            if (codeRuleInfo.isUpdateRecover() && !CollectionUtils.isEmpty(propSet) && propSet.contains(propertyName)) {
                logger.info("[CodeRulePlugin]\u53d1\u73b0\u7f16\u7801\u7684\u7ec4\u6210\u5c5e\u6027\u53d1\u751f\u4e86\u53d8\u5316");
                this.recordRecycleNumber(codeRuleInfo);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.validateCommon() || e.getProperty().getParent() instanceof EntryProp) {
            return;
        }
        if (this.validateUpdateBillNo(e.getProperty().getName())) {
            CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
            if (CodeRuleSystemParam.getMcParam("abstract_coderule_plugin.propertyChanged") && !this.dynamicObject.getDataEntityState().getFromDatabase() && !codeRuleInfo.getIsAddView().booleanValue()) {
                return;
            }
            boolean hasSaved = this.dynamicObject.getDataEntityState().getFromDatabase();
            if (!hasSaved || hasSaved && codeRuleInfo != null && codeRuleInfo.isUpdateRecover()) {
                this.updateBillNo(codeRuleInfo);
                this.injectBillnoToPageCache();
                this.setBillNoFieldLockStatus(codeRuleInfo.getIsModifiable());
            }
        }
    }

    private boolean validateUpdateBillNo(String propertyName) {
        if (propertyName.equals(this.getBillNoField())) {
            return false;
        }
        Map<String, Set<String>> codeRuleFieldsMap = this.codeRuleCache.getRelateFields();
        if (CollectionUtils.isEmpty(codeRuleFieldsMap)) {
            return false;
        }
        Set<String> propSetAll = codeRuleFieldsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Boolean validateIfCodeRulePropertyChange = this.validateIfCodeRulePropertyChange(propertyName, codeRuleFieldsMap, propSetAll);
        if (validateIfCodeRulePropertyChange != null) {
            return validateIfCodeRulePropertyChange;
        }
        return false;
    }

    private Boolean validateIfCodeRulePropertyChange(String propertyName, Map<String, Set<String>> codeRuleFieldsMap, Set<String> propSetAll) {
        if (propSetAll.contains(propertyName)) {
            CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return false;
            }
            Set<String> propSet = codeRuleFieldsMap.get(codeRuleInfo.getId());
            if (CollectionUtils.isEmpty(propSet) || !propSet.contains(propertyName)) {
                return null;
            }
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
                logger.info("[CodeRulePlugin]\u5f53\u524d\u662f\u65b0\u589e\u5355\u636e, \u53d1\u73b0\u7f16\u7801\u7684\u7ec4\u6210\u5c5e\u6027\u53d1\u751f\u4e86\u53d8\u5316");
                return true;
            }
            if (codeRuleInfo.isUpdateRecover()) {
                logger.info("[CodeRulePlugin]\u53d1\u73b0\u7f16\u7801\u7684\u7ec4\u6210\u5c5e\u6027\u53d1\u751f\u4e86\u53d8\u5316");
                return true;
            }
        }
        return null;
    }

    private void recordRecycleNumber(CodeRuleInfo codeRuleInfo) {
        boolean fromDatabase = this.dynamicObject.getDataEntityState().getFromDatabase();
        if (fromDatabase && this.recycleCache.isEmpty(this.dynamicObject.getPkValue()) && StringUtils.isNotBlank((CharSequence)this.dynamicObject.getString(this.getBillNoField()))) {
            this.recycleCache.saveRecycleNumberAndDynamicObj(this.dynamicObject.getString(this.getBillNoField()), DynamicObjUtil.getSimpleDynamicObject(codeRuleInfo, this.dynamicObject), this.dynamicObject.getPkValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (this.validateOperateKey(operate.getType()) && !this.validateBillStateForCodeRule()) {
            args.setCancel(true);
            return;
        }
        operate.getOption().setVariableValue(this.getSkipbillnovalidator(), String.valueOf(false));
        operate.getOption().setVariableValue(SKIPBILLNOVALIDATOR, String.valueOf(false));
        if (this.validateOperateKey(operate.getType())) {
            boolean isMatch;
            logger.info("[AbstractCodeRulePlugin][beforeDoOperation]\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b\u7b26\u5408\u6821\u9a8c");
            this.initData();
            this.recycleCache.convertPageCacheToOperate(operate.getOption(), this.dynamicObject.getPkValue());
            if (StringUtils.isNotEmpty((CharSequence)this.getBillNoField())) {
                String billNo = this.dynamicObject.getString(this.getBillNoField());
                this.billChangeCache.saveBeforeOpValue(billNo, this.dynamicObject.getPkValue());
                this.billChangeCache.convertPageCacheToOperate(operate.getOption(), billNo, this.dynamicObject.getPkValue());
            }
            if (!(isMatch = this.checkModifiedNumberFormat(operate))) {
                args.setCancel(true);
                return;
            }
            if (this.useCodeRuleCache.checkUseCodceRule(this.dynamicObject.getPkValue())) {
                logger.info("[AbstractCodeRulePlugin][beforeDoOperation]\u8868\u5355\u63d2\u4ef6\u6709\u8c03\u7528\u5230\u7f16\u7801\u89c4\u5219\u751f\u6210\u7f16\u53f7");
                if (!this.billChangeCache.isChange(operate.getOption(), this.dynamicObject.getPkValue())) {
                    logger.info("[AbstractCodeRulePlugin][beforeDoOperation]\u8868\u5355\u63d2\u4ef6\u751f\u6210\u7684\u7f16\u53f7\u7528\u6237\u672a\u4fee\u6539");
                    boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (!fromDatabase) {
                        logger.info("[AbstractCodeRulePlugin][beforeDoOperation]\u6807\u8bb0\u6807\u7b7e");
                        this.tagForOperation(operate);
                        if (this.pushNumberCache.isPushWay(this.getView().getFormShowParameter())) {
                            this.pushNumberCache.convertReadNumberSignToOperation(operate.getOption(), this.dynamicObject.getPkValue());
                        }
                    }
                }
            }
            this.putSerialNumToOperateOption(operate.getOption());
            this.pushNumberCache.convertPushWayToOperation(operate.getOption(), this.getView().getFormShowParameter());
        }
    }

    private boolean checkModifiedNumberFormat(FormOperate operate) {
        String billNoField = this.getBillNoField();
        if (StringUtils.isBlank((CharSequence)billNoField)) {
            return true;
        }
        if (!this.billChangeCache.isChange(operate.getOption(), this.dynamicObject.getPkValue())) {
            return true;
        }
        CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
        if (null == codeRuleInfo || !codeRuleInfo.getIsModifiable().booleanValue() || !codeRuleInfo.isCheckNumber().booleanValue()) {
            return true;
        }
        String billNo = this.dynamicObject.getString(billNoField);
        boolean checkNumber = CodeRuleNumberCheckUtil.checkNumberFormat(codeRuleInfo, this.dynamicObject, billNo);
        if (!checkNumber) {
            IDataEntityProperty property = this.getModel().getProperty(billNoField);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u683c\u5f0f\u4e0e\u7cfb\u7edf\u751f\u6210\u7f16\u7801\u7684\u683c\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u53c2\u8003\u7f16\u7801\u683c\u5f0f\u201c%2$s\u201d\u4fee\u6539\u6216\u5173\u95ed\u201c\u6821\u9a8c\u7f16\u7801\u683c\u5f0f\u201d\u53c2\u6570\u3002", (String)"AbstractCodeRulePlugin_3", (String)BOS_CODERULE, (Object[])new Object[0]), property.getDisplayName().getLocaleValue(), this.getReadNumber(codeRuleInfo)));
            this.focusBillNoField(billNoField, checkNumber);
            return false;
        }
        return true;
    }

    private void focusBillNoField(String billNoField, boolean checkNumber) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setTip("");
        fieldTip.setFieldKey(billNoField);
        fieldTip.setTipsType(FieldTip.FieldTipsTypes.others);
        fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
        fieldTip.setSuccess(checkNumber);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        ArrayList<String> fields = new ArrayList<String>(1);
        fields.add(billNoField);
        deleteRule.setFields(fields);
        fieldTip.setDeleteRule(deleteRule);
        this.getView().showFieldTip(fieldTip);
    }

    private boolean validateBillStateForCodeRule() {
        if (!CodeRuleSystemParam.getMcParam("abstract_coderule_plugin.validate_bill_state_for_coderule")) {
            return true;
        }
        this.initData();
        boolean useFlag = this.useCodeRuleCache.checkUseCodceRule(this.dynamicObject.getPkValue());
        String usedCodeRuleId = this.useCodeRuleCache.getUsedCodeRuleId(this.dynamicObject.getPkValue());
        if (useFlag && null == this.getEnableCodeRule(usedCodeRuleId) && null == this.getEnableCodeRule(usedCodeRuleId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u5bf9\u5e94\u7684\u7f16\u7801\u89c4\u5219\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractCodeRulePlugin_2", (String)BOS_CODERULE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private CodeRuleInfo getEnableCodeRule(String codeRuleId) {
        String entityId = this.dynamicObject.getDataEntityType().getName();
        List<CodeRuleInfo> enableCodeRuleInfo = this.codeRuleService.getAllCodeRuleByEntity(entityId);
        CodeRuleInfo enableCodeRule = null;
        for (CodeRuleInfo codeRuleInfo : enableCodeRuleInfo) {
            if (!StringUtils.equals((CharSequence)codeRuleId, (CharSequence)codeRuleInfo.getId())) continue;
            enableCodeRule = codeRuleInfo;
            break;
        }
        return enableCodeRule;
    }

    protected void tagForOperation(FormOperate operate) {
        operate.getOption().setVariableValue(this.getSkipbillnovalidatorValue(), (String)this.getModel().getValue(this.getBillNoField()));
        operate.getOption().setVariableValue(this.getSkipbillnovalidator(), String.valueOf(true));
        operate.getOption().setVariableValue(SKIPBILLNOVALIDATOR, String.valueOf(true));
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().setValue(this.getBillNoField(), (Object)"");
        this.getModel().setDataChanged(dataChanged);
    }

    private void putSerialNumToOperateOption(OperateOption operateOption) {
        boolean isOpenBillNoParam = this.serialNumberCache.saveOpenBillNoParam(this.dynamicObject.getDataEntityType().getName(), operateOption);
        if (!isOpenBillNoParam) {
            return;
        }
        String sortItem = this.getSerialNumSortItem(false);
        if (null == sortItem) {
            return;
        }
        String serialNumKey = this.useCodeRuleCache.getUsedCodeRuleId(this.dynamicObject.getPkValue()) + sortItem;
        this.serialNumberCache.convertPageCacheToOperate(operateOption, serialNumKey);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (this.validateOperateKey(formOperate.getType()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            logger.info("[AbstractCodeRulePlugin][afterDoOperation]\u79fb\u9664\u9700\u8981\u56de\u6536\u7f16\u53f7\u7684\u6807\u8bb0");
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            this.recycleCache.clear(pkValue);
            this.pushNumberCache.clearPushSign(pkValue);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBillNoField())) {
            this.getView().updateView(this.getBillNoField());
        }
        FormOperate operate = (FormOperate)args.getSource();
        String skipBillnoValidator = this.getSkipbillnovalidator();
        boolean haveSkipbillnoValidator = operate.getOption().tryGetVariableValue(skipBillnoValidator, new RefObject());
        if (haveSkipbillnoValidator && operate.getOption().getVariableValue(skipBillnoValidator).equals(String.valueOf(true)) && this.getModel().getValue(this.getBillNoField()).toString().equals("")) {
            logger.info("[AbstractCodeRulePlugin][afterDoOperation]\u8fd8\u539f\u88ab\u8bbe\u7f6e\u4e3a\u7a7a\u7684\u7f16\u53f7");
            DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
            long[] bizChangeFlags = dataEntityState.getBizChangeFlags();
            this.getModel().setValue(this.getBillNoField(), (Object)operate.getOption().getVariableValue(this.getSkipbillnovalidatorValue()));
            dataEntityState.setBizChangeFlags(bizChangeFlags);
        }
        if (this.validateOperateKey(formOperate.getType())) {
            this.clearBillNoIfOperateError(args);
            this.convertSerialNumIfOperationFailed(args);
            this.flushBillNoCahe(args.getOperationResult());
        }
    }

    private void flushBillNoCahe(OperationResult opResult) {
        String billNo;
        this.initData();
        if (StringUtils.isNotBlank((CharSequence)this.getBillNoField()) && opResult.isSuccess()) {
            String billNo2 = this.dynamicObject.getString(this.getBillNoField());
            this.billChangeCache.saveValue(billNo2, this.dynamicObject.getPkValue());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBillNoField()) && this.billChangeCache.isChangedOnOp(billNo = this.dynamicObject.getString(this.getBillNoField()), this.dynamicObject.getPkValue())) {
            this.billChangeCache.saveValue(billNo, this.dynamicObject.getPkValue());
        }
    }

    protected boolean validateOperateKey(String operateKey) {
        return StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey);
    }

    private void clearBillNoIfOperateError(AfterDoOperationEventArgs args) {
        if (!CodeRuleSystemParam.getMcParam("abstract_coderule_plugin.clear_billno_if_operate_error")) {
            return;
        }
        this.initData();
        boolean fromDatabase = this.dynamicObject.getDataEntityState().getFromDatabase();
        FormOperate formOperate = (FormOperate)args.getSource();
        boolean operateStatusFlag = this.validateOperateKey(formOperate.getType()) && args.getOperationResult() != null && !args.getOperationResult().isSuccess();
        boolean useCodceRuleFlag = this.useCodeRuleCache.checkUseCodceRule(this.dynamicObject.getPkValue());
        if (!fromDatabase && operateStatusFlag && useCodceRuleFlag) {
            CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return;
            }
            Boolean isAddView = codeRuleInfo.getIsAddView();
            Boolean isModifiable = codeRuleInfo.getIsModifiable();
            boolean billChangeFlag = this.billChangeCache.isChange(formOperate.getOption(), this.dynamicObject.getPkValue());
            if (!isAddView.booleanValue() && !isModifiable.booleanValue()) {
                this.updateViewForBillNo("");
            }
            if (!isAddView.booleanValue() && isModifiable.booleanValue() && !billChangeFlag) {
                this.updateViewForBillNo("");
            }
        }
    }

    private void convertSerialNumIfOperationFailed(AfterDoOperationEventArgs args) {
        if (!this.serialNumberCache.isOpenBillNoPageCache()) {
            return;
        }
        if (null != args.getOperationResult() && args.getOperationResult().isSuccess()) {
            return;
        }
        this.initData();
        String sortItemValue = this.getSerialNumSortItem(true);
        if (null == sortItemValue) {
            return;
        }
        String codeRuleKey = this.useCodeRuleCache.getUsedCodeRuleId(this.dynamicObject.getPkValue()) + sortItemValue;
        FormOperate formOperate = (FormOperate)args.getSource();
        this.serialNumberCache.convertOperateToPageCache(formOperate.getOption(), codeRuleKey);
    }

    private String getSerialNumSortItem(boolean isJudgeBreak) {
        this.initData();
        if (!this.useCodeRuleCache.checkUseCodceRule(this.dynamicObject.getPkValue())) {
            return null;
        }
        String codeRuleId = this.useCodeRuleCache.getUsedCodeRuleId(this.dynamicObject.getPkValue());
        CodeRuleInfo codeRuleInfo = this.getEnableCodeRule(codeRuleId);
        if (null == codeRuleInfo) {
            return null;
        }
        if (isJudgeBreak && codeRuleInfo.getIsNonBreak().booleanValue()) {
            return null;
        }
        String number = this.dynamicObject.getString(this.getBillNoField());
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        if (!CodeRuleInfoUtil.validateCodeRuleContainSerialNum(codeRuleInfo)) {
            return null;
        }
        return CodeRuleSerialNumUtil.getSortItemValue(codeRuleInfo, this.dynamicObject, number);
    }
}

