/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.common.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

public class DistributeCacheUtil {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("id_generator", new DistributeCacheHAPolicy(true, true));
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("id_generator");

    private static String getAcctId() {
        String acctId = new StringBuilder(64).append(RequestContext.get().getAccountId()).toString();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"CodeRuleCacheMrg_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static long incr(String key) {
        return cache.inc(DistributeCacheUtil.getAcctId() + key);
    }

    public static long incrNum(String key, int num) {
        return cache.incrBy(DistributeCacheUtil.getAcctId() + key, num);
    }

    public static void put(String key, String value) {
        cache.put(DistributeCacheUtil.getAcctId() + key, (Object)value);
    }

    public static void put(String key, String value, int timeoutSeconds) {
        cache.put(DistributeCacheUtil.getAcctId() + key, (Object)value, timeoutSeconds);
    }

    public static String get(String key) {
        return (String)cache.get(DistributeCacheUtil.getAcctId() + key);
    }

    public static void put(String key, DynamicObject dynamicObject, String ... mapKeys) {
        HashMap<String, String> map = new HashMap<String, String>(mapKeys.length);
        for (String mapKey : mapKeys) {
            map.put(mapKey, dynamicObject.getString(mapKey));
        }
        cache.put(DistributeCacheUtil.getAcctId() + key, map);
    }

    public static void put(String key, Map<String, String> map) {
        cache.put(DistributeCacheUtil.getAcctId() + key, map);
    }

    public static void put(String key, Map<String, String> map, int timeoutSeconds) {
        cache.put(DistributeCacheUtil.getAcctId() + key, map, timeoutSeconds);
    }

    public static void expireAfter(String key, int timeoutSeconds) {
        cache.expireAfter(DistributeCacheUtil.getAcctId() + key, timeoutSeconds);
    }

    public static String get(String key, String mapKey) {
        return (String)cache.get(DistributeCacheUtil.getAcctId() + key, mapKey);
    }

    public static Map<String, String> getAll(String key) {
        return cache.getAll(DistributeCacheUtil.getAcctId() + key);
    }

    public static void remove(String key) {
        cache.removeType(DistributeCacheUtil.getAcctId() + key);
    }

    @Deprecated
    public static Object lua(String luaStr, String key, List<String> param) {
        return redisCache.eval(luaStr, DistributeCacheUtil.getAcctId() + key, param);
    }

    public static boolean compareAndSet(String key, long number) {
        long curSeq;
        String curSeqStr;
        key = DistributeCacheUtil.getAcctId() + key;
        boolean isDemotion = false;
        boolean result = false;
        try {
            Object redisResult = redisCache.eval("local curseq = tonumber(redis.call('GET', KEYS[1]));\nif curseq==nil\nthen\nreturn 0;\nend\nlocal num = tonumber(ARGV[1]);\nif num>curseq\nthen\nredis.call('SET', KEYS[1], num);\nreturn 1;\nelse\nreturn 0;\nend", key, Collections.singletonList(String.valueOf(number)));
            result = redisResult.toString().equals("1");
        }
        catch (Exception e) {
            isDemotion = true;
        }
        if (isDemotion && StringUtils.isNotBlank((CharSequence)(curSeqStr = (String)cache.get(key))) && number > (curSeq = Long.parseLong(curSeqStr))) {
            cache.put(key, (Object)String.valueOf(number));
            result = true;
        }
        return result;
    }
}

