/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.openapi;

import java.util.Map;
import java.util.Objects;
import kd.bos.coderule.util.MultiLangEnumBridge;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.generator.Config;
import kd.bos.generator.IDGen;
import kd.bos.generator.IDGenImpl;
import kd.bos.generator.common.Result;
import kd.bos.generator.segment.RecordSegmentSigner;
import kd.bos.generator.segment.SegmentConfig;
import kd.bos.generator.segment.SegmentSigner;

class IDGenApiForSigner {
    IDGenApiForSigner() {
    }

    static ApiResult searchByParam(Map<String, Object> params) {
        Object key = params.get("key");
        if (key == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u672a\u4f20\u9012: key", (String)"IDGenApiForSigner_4", (String)"bos-coderule", (Object[])new Object[0]));
        }
        Object signerEnum = params.get("signerEnum");
        if (signerEnum == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u672a\u4f20\u9012: signerEnum", (String)"IDGenApiForSigner_5", (String)"bos-coderule", (Object[])new Object[0]));
        }
        Object initNumber = params.get("initNumber");
        if (initNumber == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u672a\u4f20\u9012: initNumber", (String)"IDGenApiForSigner_6", (String)"bos-coderule", (Object[])new Object[0]));
        }
        Object step = params.get("step");
        if (step == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u672a\u4f20\u9012: step", (String)"IDGenApiForSigner_7", (String)"bos-coderule", (Object[])new Object[0]));
        }
        Object segmentLength = params.get("segmentLength");
        if (segmentLength == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u672a\u4f20\u9012: segmentLength", (String)"IDGenApiForSigner_8", (String)"bos-coderule", (Object[])new Object[0]));
        }
        Object reqSequence = params.get("reqSequence");
        switch (Objects.requireNonNull(SignerEnum.getEnum(signerEnum.toString()))) {
            case READ: {
                return IDGenApiForSigner.readNum(key.toString(), Long.parseLong(initNumber.toString()), Integer.parseInt(step.toString()), Long.parseLong(segmentLength.toString()));
            }
            case CONSUME: {
                return IDGenApiForSigner.consumeNum(key.toString(), Long.parseLong(initNumber.toString()), Integer.parseInt(step.toString()), Long.parseLong(segmentLength.toString()), reqSequence);
            }
            case READ_AND_RECORD: {
                return IDGenApiForSigner.readAndRecordNum(key.toString(), Long.parseLong(initNumber.toString()), Integer.parseInt(step.toString()), Long.parseLong(segmentLength.toString()));
            }
            case CONSUME_AND_RECORD: {
                return IDGenApiForSigner.consumeAndRecordNum(key.toString(), Long.parseLong(initNumber.toString()), Integer.parseInt(step.toString()), Long.parseLong(segmentLength.toString()), reqSequence);
            }
        }
        return ApiResult.success(null);
    }

    private static ApiResult readNum(String key, long initNumber, int step, long segmentLength) {
        Config config = IDGenApiForSigner.buildConfig(key, initNumber, step, segmentLength);
        IDGen idGen = IDGenApiForSigner.buildIDGen(false, key, config);
        Result result = idGen.read();
        return ApiResult.success((Object)result);
    }

    private static ApiResult readAndRecordNum(String key, long initNumber, int step, long segmentLength) {
        Config config = IDGenApiForSigner.buildConfig(key, initNumber, step, segmentLength);
        IDGen idGen = IDGenApiForSigner.buildIDGen(true, key, config);
        Result result = idGen.read();
        return ApiResult.success((Object)result);
    }

    private static ApiResult consumeNum(String key, long initNumber, int step, long segmentLength, Object reqSequence) {
        Config config = IDGenApiForSigner.buildConfig(key, initNumber, step, segmentLength);
        IDGen idGen = IDGenApiForSigner.buildIDGen(false, key, config);
        Result result = idGen.getBy(reqSequence == null ? 0 : Integer.parseInt(reqSequence.toString()));
        return ApiResult.success((Object)result);
    }

    private static ApiResult consumeAndRecordNum(String key, long initNumber, int step, long segmentLength, Object reqSequence) {
        Config config = IDGenApiForSigner.buildConfig(key, initNumber, step, segmentLength);
        IDGen idGen = IDGenApiForSigner.buildIDGen(true, key, config);
        Result result = idGen.getBy(reqSequence == null ? 0 : Integer.parseInt(reqSequence.toString()));
        return ApiResult.success((Object)result);
    }

    private static Config buildConfig(String key, long initNumber, int step, long segmentLength) {
        return new SegmentConfig.Buidler().setKey(key).setInitNumber(initNumber).setStep(step).setSegmentLength(segmentLength).build();
    }

    private static IDGen buildIDGen(boolean isFast, String key, Config config) {
        if (isFast) {
            return new IDGenImpl(key, config, new RecordSegmentSigner.Buidler().build());
        }
        return new IDGenImpl(key, config, new SegmentSigner.Buidler().build());
    }

    static enum SignerEnum {
        READ("read", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u666e\u901a\u578b\u8bfb\u53d6\u53f7\u7801", (String)"IDGenApiForSigner_0", (String)"bos-coderule", (Object[])new Object[0]), "IDGenApiForSigner_0", "bos-coderule")),
        READ_AND_RECORD("read_and_record", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u8bb0\u5f55\u578b\u8bfb\u53d6\u53f7\u7801", (String)"IDGenApiForSigner_1", (String)"bos-coderule", (Object[])new Object[0]), "IDGenApiForSigner_1", "bos-coderule")),
        CONSUME("consume", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u666e\u901a\u578b\u53d1\u5e03\u53f7\u7801", (String)"IDGenApiForSigner_2", (String)"bos-coderule", (Object[])new Object[0]), "IDGenApiForSigner_2", "bos-coderule")),
        CONSUME_AND_RECORD("consume_and_record", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u8bb0\u5f55\u578b\u53d1\u5e03\u53f7\u7801", (String)"IDGenApiForSigner_3", (String)"bos-coderule", (Object[])new Object[0]), "IDGenApiForSigner_3", "bos-coderule"));

        String value;
        MultiLangEnumBridge bridge;

        private SignerEnum(String value, MultiLangEnumBridge bridge) {
            this.value = value;
            this.bridge = bridge;
        }

        static SignerEnum getEnum(String value) {
            for (SignerEnum searchEnum : SignerEnum.values()) {
                if (!searchEnum.value.equals(value)) continue;
                return searchEnum;
            }
            return null;
        }
    }
}

