/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Consumer;
import kd.bos.coderule.handler.SyncHandler;
import kd.bos.coderule.handler.TransactionHandler;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.generator.ConfigFactory;
import kd.bos.generator.Signer;
import kd.bos.generator.common.CommonUtil;
import kd.bos.generator.common.ErrorType;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.common.Result;
import kd.bos.generator.common.ResultStatus;
import kd.bos.generator.common.ResultUtil;
import kd.bos.generator.common.SegmentInfo;
import kd.bos.generator.constants.SyncConstants;
import kd.bos.generator.constants.TableConstants;
import kd.bos.generator.constants.field.SignerFieldConstants;
import kd.bos.generator.segment.ReleaseTypeEnum;
import kd.bos.generator.segment.SignerCache;
import kd.bos.generator.segment.db.SignerDAOImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public abstract class AbstractSegmentSigner
implements Signer,
TableConstants,
SyncConstants,
SignerFieldConstants {
    private static final Log logger = LogFactory.getLog(AbstractSegmentSigner.class);
    public static final float THRESHOLD_MULTIPLE = 0.1f;
    protected SignerCache signerCache;
    protected Consumer<ReleaseTypeEnum> callbackAtPrintLogByRelease;

    @Deprecated
    public AbstractSegmentSigner() {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }

    public AbstractSegmentSigner(SignerCache signerCache, Consumer<ReleaseTypeEnum> callbackAtPrintLogByRelease) {
        this.signerCache = signerCache;
        this.callbackAtPrintLogByRelease = callbackAtPrintLogByRelease;
    }

    @Override
    public Result read(String key) {
        try {
            SegmentInfo segmentInfo = this.buildSegmentInfo(key);
            long curseq = this.signerCache.getCurSeq(key);
            return ResultUtil.success(curseq, segmentInfo.getMaxseq(), segmentInfo.getSegmentLength());
        }
        catch (GeneratorException e) {
            logger.error((Throwable)e);
            return new Result(ResultStatus.FAIL, ErrorType.INIT_DB_ERRPR, e);
        }
    }

    protected SegmentInfo buildSegmentInfo(String key) {
        return this.buildSegmentInfo(key, 0);
    }

    protected SegmentInfo buildSegmentInfo(String key, int reqSequence) {
        this.beforeCheckSegment(key);
        this.checkAndRebuildSemgntCache(key, reqSequence);
        return this.buildSegmentInfoFromCache(key);
    }

    private void beforeCheckSegment(final String key) {
        boolean exists = QueryServiceHelper.exists((String)"bos_signer_segment", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
        if (exists) {
            return;
        }
        final SignerDAOImpl signerDAO = new SignerDAOImpl();
        final Long curSeq = signerDAO.getCurSeq(key);
        if (curSeq == null) {
            return;
        }
        new SyncHandler("resotre_segment_" + key){

            @Override
            protected void syncProcess() {
                new TransactionHandler(String.format(ResManager.loadKDString((String)"\u91cd\u5efa\u53f7\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c key=%s", (String)"BOS_CODERULE_4", (String)"bos-coderule", (Object[])new Object[0]), key)){

                    @Override
                    protected void transactionProcess() {
                        AbstractSegmentSigner.this.insertSegment(key, curSeq);
                        signerDAO.clear(key);
                    }
                };
            }
        }.process();
    }

    private void insertSegment(String key, Long curSeq) {
        boolean exists = QueryServiceHelper.exists((String)"bos_signer_segment", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
        if (exists) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_signer_segment");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
        CommonUtil.buildCommonParam(dynamicObject);
        dynamicObject.set("key", (Object)key);
        long segmentLength = ConfigFactory.getInstanceForSearch(key).getSegmentLength();
        dynamicObject.set("curseq", (Object)curSeq);
        dynamicObject.set("segmentlength", (Object)segmentLength);
        dynamicObject.set("maxseq", (Object)(curSeq + segmentLength));
        dynamicObject.set("version", (Object)1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        logger.info("[beforeCheckSegment]\u4ece\u6d41\u6c34\u53f7\u751f\u6210\u5668\u6062\u590d\u5bf9\u5e94key\u7684\u53f7\u6bb5\u8868\u4fe1\u606f\uff0ckey:" + key);
    }

    private void checkAndRebuildSemgntCache(final String key, final int reqSequence) {
        if (ReleaseTypeEnum.NORMAL != this.checkReleaseType(key, reqSequence)) {
            new SyncHandler("IDGEN_SIGNER_LOCK_SEGMENT_" + key){

                @Override
                protected void syncProcess() {
                    ReleaseTypeEnum releaseTypeEnum = AbstractSegmentSigner.this.checkReleaseType(key, reqSequence);
                    if (ReleaseTypeEnum.NORMAL != releaseTypeEnum) {
                        AbstractSegmentSigner.this.rebuildSegmentCacheByReleaseType(releaseTypeEnum, key, reqSequence);
                    }
                }

                @Override
                protected void beforeSyncProcess() {
                    logger.info("[SegmentSigner][\u6392\u4ed6\u9501]\u5f00\u59cb\u53d1\u53f7\u64cd\u4f5c-key:" + key);
                }

                @Override
                protected void afterSyncProcess() {
                    logger.info("[SegmentSigner][\u6392\u4ed6\u9501]\u7ed3\u675f\u53d1\u53f7\u64cd\u4f5c-key:" + key);
                }
            }.process();
        }
    }

    private ReleaseTypeEnum checkReleaseType(String key, int reqSequence) {
        if (!this.signerCache.isExistAtomatic(key)) {
            boolean exists = QueryServiceHelper.exists((String)"bos_signer_segment", (QFilter[])new QFilter("key", "=", (Object)key).and(new QFilter("version", "=", (Object)0L)).toArray());
            if (exists) {
                return ReleaseTypeEnum.INIT;
            }
            return ReleaseTypeEnum.DOWNTIME;
        }
        Long curSeq = this.signerCache.getCurSeq(key);
        Long maxSeq = this.signerCache.getMaxSeq(key);
        Integer step = ConfigFactory.getInstanceForSearch(key).getStep();
        if (reqSequence > 0 && curSeq + (long)reqSequence > maxSeq) {
            logger.info("[checkReleaseType]\u4e34\u754c\u6807\u8bb0,\u7f13\u5b58\u4e2dcurseq:" + curSeq);
            return ReleaseTypeEnum.CRITICAL;
        }
        if (curSeq + (long)step.intValue() > maxSeq) {
            logger.info("[checkReleaseType]\u4e34\u754c\u6807\u8bb0,\u7f13\u5b58\u4e2dcurseq:" + curSeq);
            return ReleaseTypeEnum.CRITICAL;
        }
        return ReleaseTypeEnum.NORMAL;
    }

    @VisibleForTesting
    protected boolean checkReleaseTypeAtPreheat(Long curSeq, Long maxSeq, Long segmentLength) {
        double growth = segmentLength - (maxSeq - curSeq);
        if (growth >= (double)((float)segmentLength.longValue() * 0.1f)) {
            logger.info("[checkReleaseType]\u9884\u70ed\u6807\u8bb0,\u7f13\u5b58\u4e2dcurseq:" + curSeq);
            return true;
        }
        return false;
    }

    protected abstract void rebuildSegmentCacheByReleaseType(ReleaseTypeEnum var1, String var2, int var3);

    protected void releaseSegment(String key, ReleaseTypeEnum releaseTypeEnum, int reqSequence) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_signer_segment", (String)"curseq,maxseq,segmentlength,version", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_FOR_DB.getCode(), ResManager.loadKDString((String)"\u6301\u4e45\u5c42\u4e2d\u65e0\u5bf9\u5e94\u6570\u636e, \u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316\u8fc7\u914d\u7f6e\u3002", (String)"AbstractSegmentSigner_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        long curSeq = dynamicObjects[0].getLong("curseq");
        long maxSeq = dynamicObjects[0].getLong("maxseq");
        long segmentLength = dynamicObjects[0].getLong("segmentlength");
        long version = dynamicObjects[0].getLong("version");
        this.printReleaseTypeLog(curSeq, releaseTypeEnum);
        long finalChangeSegmentLength = this.calculateSegmentByReqSequence(reqSequence, segmentLength);
        boolean[] isExecute = this.releaseSegmentFromDB(key, curSeq, version, finalChangeSegmentLength, releaseTypeEnum);
        if (isExecute[0]) {
            Long curSeqFromDB = (Long)DB.query((DBRoute)DBRoute.basedata, (String)"select top 1 fcurseq from t_signer_segment where fkey = ?", (Object[])new Object[]{key}, rs -> {
                if (rs.next()) {
                    return rs.getLong("fcurseq");
                }
                return maxSeq;
            });
            if (ReleaseTypeEnum.PREHEAT == releaseTypeEnum) {
                this.signerCache.putWithPreHeat(key, curSeqFromDB, version);
                return;
            }
            if (ReleaseTypeEnum.INIT == releaseTypeEnum) {
                this.signerCache.putAll(key, ConfigFactory.getInstanceForSearch(key).getInitNumber(), curSeqFromDB, segmentLength, version);
                return;
            }
            if (ReleaseTypeEnum.DOWNTIME == releaseTypeEnum) {
                this.signerCache.putAll(key, curSeq, curSeqFromDB, segmentLength, version);
                return;
            }
            this.signerCache.putAllWithoutCurseq(key, curSeqFromDB, segmentLength, version);
        }
    }

    protected boolean[] releaseSegmentFromDB(final String key, long curSeq, long version, final long finalChangeSegmentLength, ReleaseTypeEnum releaseTypeEnum) {
        final boolean[] isExecute = new boolean[]{false};
        new TransactionHandler(ResManager.loadKDString((String)"[SegmentSigner][releaseSegment]\u9ad8\u6027\u80fd\u53d1\u5e03\u53f7\u6bb5\u5931\u8d25", (String)"AbstractSegmentSigner_1", (String)"bos-coderule", (Object[])new Object[0])){

            @Override
            protected void transactionProcess() {
                String sql = "update t_signer_segment set fcurseq = fcurseq + ?, fmaxseq = fmaxseq + ?, fversion = fversion + 1 where fkey = ?";
                isExecute[0] = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{finalChangeSegmentLength, finalChangeSegmentLength, key});
            }
        };
        logger.info("[releaseSegment]\u53d1\u5e03\u53f7\u6bb5\u7684\u72b6\u6001:" + isExecute[0]);
        return isExecute;
    }

    private long calculateSegmentByReqSequence(int reqSequence, long segmentLength) {
        if (reqSequence <= 0) {
            return segmentLength;
        }
        long changeSegmentLength = segmentLength;
        if ((long)reqSequence > changeSegmentLength) {
            int multi = (int)((long)reqSequence / changeSegmentLength) + ((long)reqSequence % changeSegmentLength > 0L ? 1 : 0);
            changeSegmentLength = (long)multi * segmentLength;
        }
        return changeSegmentLength;
    }

    protected void printReleaseTypeLog(long curSeq, ReleaseTypeEnum releaseTypeEnum) {
        switch (releaseTypeEnum) {
            case INIT: {
                logger.info("[SegmentSigner]\u53d1\u53f7\u72b6\u6001\u4e3a\u521d\u59cb\u5316");
                this.callbackAtPrintLogByRelease.accept(ReleaseTypeEnum.INIT);
                break;
            }
            case DOWNTIME: {
                logger.info("[SegmentSigner]\u53d1\u53f7\u72b6\u6001\u4e3a\u5b95\u673a");
                this.callbackAtPrintLogByRelease.accept(ReleaseTypeEnum.DOWNTIME);
                break;
            }
            case CRITICAL: {
                logger.info("[SegmentSigner]\u53d1\u53f7\u72b6\u6001\u4e3a\u4e34\u754c,DB\u4e2dcurseq:" + curSeq);
                this.callbackAtPrintLogByRelease.accept(ReleaseTypeEnum.CRITICAL);
                break;
            }
            case PREHEAT: {
                logger.info("[SegmentSigner]\u53d1\u53f7\u72b6\u6001\u4e3a\u9884\u70ed,DB\u4e2dcurseq:" + curSeq);
                this.callbackAtPrintLogByRelease.accept(ReleaseTypeEnum.PREHEAT);
                break;
            }
        }
    }

    protected SegmentInfo buildSegmentInfoFromCache(String key) {
        Long curSeq = this.signerCache.getCurSeq(key);
        Long maxSeq = this.signerCache.getMaxSeq(key);
        Long segmentLength = this.signerCache.getSegmentLength(key);
        Integer step = ConfigFactory.getInstanceForSearch(key).getStep();
        Long version = this.signerCache.getVersion(key);
        SegmentInfo segmentInfo = new SegmentInfo();
        segmentInfo.setCurseq(curSeq);
        segmentInfo.setMaxseq(maxSeq);
        segmentInfo.setSegmentLength(segmentLength);
        segmentInfo.setStep(step);
        segmentInfo.setVersion(version);
        return segmentInfo;
    }

    @Override
    public Result get(String key) {
        return this.getBy(key, 0);
    }

    @Override
    public Result getBy(String key, int reqSequence) {
        SegmentInfo segmentInfo = this.buildSegmentInfo(key, reqSequence);
        if (reqSequence > 0) {
            long curseq = this.signerCache.incrStep(key, reqSequence);
            return ResultUtil.success(curseq, segmentInfo.getMaxseq(), segmentInfo.getSegmentLength());
        }
        Integer step = segmentInfo.getStep();
        if (step != 1) {
            long curseq = this.signerCache.incrStep(key, step);
            return ResultUtil.success(curseq, segmentInfo.getMaxseq(), segmentInfo.getSegmentLength());
        }
        long curseq = this.signerCache.incr(key);
        return ResultUtil.success(curseq, segmentInfo.getMaxseq(), segmentInfo.getSegmentLength());
    }

    @Override
    @Deprecated
    public Result sendMQ(String key, SegmentInfo segmentInfo) {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }
}

