/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment;

import java.util.function.Consumer;
import kd.bos.coderule.handler.TransactionHandler;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.generator.Config;
import kd.bos.generator.ConfigFactory;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.common.Result;
import kd.bos.generator.common.ResultStatus;
import kd.bos.generator.segment.AbstractSegmentSigner;
import kd.bos.generator.segment.RecordSegmentUtil;
import kd.bos.generator.segment.ReleaseTypeEnum;
import kd.bos.generator.segment.SignerCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;

public class RecordSegmentSigner
extends AbstractSegmentSigner {
    private static final Log logger = LogFactory.getLog(RecordSegmentSigner.class);

    public RecordSegmentSigner(Buidler buidler) {
        super(buidler.signerCache, buidler.callbackAtRelease);
    }

    @Override
    public Result getBy(String key, int reqSequence) {
        Result result = super.getBy(key, reqSequence);
        this.insertDBForConsume(key, result);
        return result;
    }

    private void insertDBForConsume(String key, Result result) {
        if (result.getStatus() == ResultStatus.SUCCESS) {
            RecordSegmentUtil.insertRecordInfo(key, this.signerCache.getVersion(key), result.getCurseq());
        }
    }

    @Override
    protected void rebuildSegmentCacheByReleaseType(ReleaseTypeEnum releaseTypeEnum, String key, int reqSequence) {
        if (ReleaseTypeEnum.INIT == releaseTypeEnum) {
            this.releaseSegment(key, releaseTypeEnum, reqSequence);
            return;
        }
        if (ReleaseTypeEnum.CRITICAL == releaseTypeEnum) {
            long version = this.signerCache.getVersion(key);
            this.releaseSegmentWhenCritical(releaseTypeEnum, key, reqSequence, version);
            return;
        }
        if (ReleaseTypeEnum.DOWNTIME == releaseTypeEnum) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_signer_segment", (String)"curseq,maxseq,segmentlength,version", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
            if (dynamicObjects == null || dynamicObjects.length <= 0) {
                throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_CHECK_DB_WITHOUT_INIT.getCode(), ResManager.loadKDString((String)"\u6301\u4e45\u5c42\u4e2d\u65e0\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316\u8fc7\u914d\u7f6e\u3002", (String)"RecordSegmentSigner_1", (String)"bos-coderule", (Object[])new Object[0]));
            }
            long curSeq = dynamicObjects[0].getLong("curseq");
            long segmentLength = dynamicObjects[0].getLong("segmentlength");
            long version = dynamicObjects[0].getLong("version");
            long curVersion = version - 1L;
            Long maxConsumeSeqAtRecord = this.getMaxConsumeSeqAtRecord(key, curVersion);
            if (maxConsumeSeqAtRecord == null) {
                this.releaseSegmentAndDeleteRecord(releaseTypeEnum, key, reqSequence, curVersion);
                return;
            }
            if (maxConsumeSeqAtRecord < curSeq) {
                this.signerCache.putAll(key, maxConsumeSeqAtRecord, curSeq, segmentLength, curVersion);
                return;
            }
            if (maxConsumeSeqAtRecord > curSeq) {
                this.signerCache.putAll(key, maxConsumeSeqAtRecord, curSeq, segmentLength, curVersion);
                logger.error(String.format("[\u53d1\u53f7\u5668\u5f02\u5e38-\u72b6\u6001\u5b95\u673a]\u56de\u6eaf\u8df3\u53f7\u6bb5\u65f6,\u6700\u5927\u6d88\u8d39\u53f7\u5927\u4e8e\u5f53\u524d\u53f7\u6bb5,key:%s--version:%s--maxConsumeSeqAtRecord:%s--curSeq:%s", key, curVersion, maxConsumeSeqAtRecord, curSeq));
                return;
            }
            this.releaseSegmentAndDeleteRecord(releaseTypeEnum, key, reqSequence, curVersion);
        }
    }

    private void releaseSegmentWhenCritical(ReleaseTypeEnum releaseTypeEnum, String key, int reqSequence, long version) {
        this.releaseSegmentCritical(key, releaseTypeEnum, reqSequence, version);
        ThreadPools.executeOnce((String)ResManager.loadKDString((String)"\u5220\u9664\u672c\u53f7\u6bb5\u7248\u672c\u5bf9\u5e94\u7684\u6d88\u8d39\u8bb0\u5f55", (String)"RecordSegmentSigner_0", (String)"bos-coderule", (Object[])new Object[0]), () -> {
            String sql = "delete from t_signer_record where fkey = ? and fversion = ?";
            boolean execute = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{key, version});
            if (!execute) {
                logger.error(String.format("[\u53d1\u53f7\u5668\u5f02\u5e38-\u72b6\u6001\u4e34\u754c]\u5f02\u6b65\u5220\u9664\u6d88\u8d39\u8bb0\u5f55\u5931\u8d25,key: %s--version: %s", key, version));
            }
        });
    }

    private void releaseSegmentCritical(String key, ReleaseTypeEnum releaseTypeEnum, int reqSequence, long cacheVersion) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_signer_segment", (String)"curseq,maxseq,segmentlength,version", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_FOR_DB.getCode(), ResManager.loadKDString((String)"\u6301\u4e45\u5c42\u4e2d\u65e0\u5bf9\u5e94\u6570\u636e, \u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316\u8fc7\u914d\u7f6e\u3002", (String)"AbstractSegmentSigner_0", (String)"bos-coderule", (Object[])new Object[0]));
        }
        long curSeq = dynamicObjects[0].getLong("curseq");
        long maxSeq = dynamicObjects[0].getLong("maxseq");
        long segmentLength = dynamicObjects[0].getLong("segmentlength");
        long version = dynamicObjects[0].getLong("version");
        this.printReleaseTypeLog(curSeq, releaseTypeEnum);
        Long maxConsumeSeqAtRecord = this.getMaxConsumeSeqAtRecord(key, cacheVersion);
        long maxConsumeSeq = maxConsumeSeqAtRecord == null ? 0L : maxConsumeSeqAtRecord;
        long differSeq = 0L;
        if (maxConsumeSeq > curSeq) {
            differSeq = maxConsumeSeq - curSeq;
        }
        long finalChangeSegmentLength = this.calculateSegment(reqSequence, segmentLength, differSeq);
        boolean[] isExecute = this.releaseSegmentFromDB(key, Math.max(curSeq, maxConsumeSeq), version, finalChangeSegmentLength, releaseTypeEnum);
        if (isExecute[0]) {
            Long curSeqFromDB = (Long)DB.query((DBRoute)DBRoute.basedata, (String)"select top 1 fcurseq from t_signer_segment where fkey = ?", (Object[])new Object[]{key}, rs -> {
                if (rs.next()) {
                    return rs.getLong("fcurseq");
                }
                return maxSeq;
            });
            this.signerCache.putAllWithoutCurseq(key, curSeqFromDB, segmentLength, version);
        }
    }

    private long calculateSegment(int reqSequence, long segmentLength, long consumeSeq) {
        long consumeIntegerSeq = consumeSeq / segmentLength * segmentLength;
        if (reqSequence <= 0) {
            return segmentLength + consumeIntegerSeq;
        }
        long changeSegmentLength = segmentLength;
        if ((long)reqSequence > changeSegmentLength) {
            int multi = (int)((long)reqSequence / changeSegmentLength) + ((long)reqSequence % changeSegmentLength > 0L ? 1 : 0);
            changeSegmentLength = (long)multi * segmentLength;
        }
        return changeSegmentLength + consumeIntegerSeq;
    }

    private void releaseSegmentAndDeleteRecord(ReleaseTypeEnum releaseTypeEnum, String key, int reqSequence, long version) {
        this.releaseSegment(key, releaseTypeEnum, reqSequence);
        ThreadPools.executeOnce((String)ResManager.loadKDString((String)"\u5220\u9664\u672c\u53f7\u6bb5\u7248\u672c\u5bf9\u5e94\u7684\u6d88\u8d39\u8bb0\u5f55", (String)"RecordSegmentSigner_0", (String)"bos-coderule", (Object[])new Object[0]), () -> {
            String sql = "delete from t_signer_record where fkey = ? and fversion = ?";
            boolean execute = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{key, version});
            if (!execute) {
                logger.error(String.format("[\u53d1\u53f7\u5668\u5f02\u5e38-\u72b6\u6001\u4e34\u754c]\u5f02\u6b65\u5220\u9664\u6d88\u8d39\u8bb0\u5f55\u5931\u8d25,key: %s--version: %s", key, version));
            }
        });
    }

    private Long getMaxConsumeSeqAtRecord(String key, long version) {
        String sql = "select top 1 FCONSUMESEQ from t_signer_record where fkey = ? and fversion = ? order by FCONSUMESEQ desc";
        return (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{key, version}, rs -> {
            if (rs.next()) {
                return rs.getLong("FCONSUMESEQ");
            }
            return null;
        });
    }

    @Override
    protected boolean[] releaseSegmentFromDB(final String key, final long curSeq, final long version, final long finalChangeSegmentLength, final ReleaseTypeEnum releaseTypeEnum) {
        final boolean[] isExecute = new boolean[]{false};
        new TransactionHandler(ResManager.loadKDString((String)"[SegmentSigner][releaseSegment]\u9ad8\u6027\u80fd\u53d1\u5e03\u53f7\u6bb5\u5931\u8d25", (String)"AbstractSegmentSigner_1", (String)"bos-coderule", (Object[])new Object[0])){

            @Override
            protected void transactionProcess() {
                String sql = "update t_signer_segment set fcurseq = fcurseq + ?, fmaxseq = fmaxseq + ?, fversion = fversion + 1 where fkey = ?";
                isExecute[0] = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{finalChangeSegmentLength, finalChangeSegmentLength, key});
                if (!isExecute[0]) {
                    return;
                }
                RecordSegmentUtil.insertRecordInfo(key, version, curSeq);
                if (ReleaseTypeEnum.INIT == releaseTypeEnum) {
                    Config config = ConfigFactory.getInstanceForSearch(key);
                    long initNumber = config.getInitNumber();
                    RecordSegmentUtil.insertRecordInfo(key, version, initNumber);
                }
            }
        };
        logger.info("[releaseSegment]\u53d1\u5e03\u53f7\u6bb5\u7684\u72b6\u6001:" + isExecute[0]);
        return isExecute;
    }

    public static class Buidler {
        private SignerCache signerCache = SignerCache.getInstance();
        private Consumer<ReleaseTypeEnum> callbackAtRelease = releaseTypeEnum -> {};

        public RecordSegmentSigner build() {
            return new RecordSegmentSigner(this);
        }

        public Buidler setCallbackAtRelease(Consumer<ReleaseTypeEnum> callbackAtRelease) {
            this.callbackAtRelease = callbackAtRelease;
            return this;
        }
    }
}

