/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment.db;

import kd.bos.atomicincr.AtomicIncrement;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.generator.segment.db.SignerDAO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SignerDAOImpl
implements SignerDAO {
    private static final Log log = LogFactory.getLog(SignerDAOImpl.class);
    private static final String KEY = "number";
    private static final AtomicIncrement atomicIncrement = AtomicIncrement.getInstance((String)"coderule");

    @Override
    public Long getCurSeq(String key) {
        return atomicIncrement.get(key);
    }

    @Override
    public Long incr(String key) {
        return atomicIncrement.incr(key);
    }

    @Override
    public Long incrStep(String key, int step) {
        return atomicIncrement.incr(key, step);
    }

    @Override
    public boolean isExist(String key) {
        return atomicIncrement.exist(key);
    }

    @Override
    public void init(String key, Long initNum) {
        if (this.isExist(key)) {
            return;
        }
        if (initNum == null || initNum < 0L) {
            DynamicObject config = QueryServiceHelper.queryOne((String)"bos_signer_config", (String)"initnumber", (QFilter[])new QFilter(KEY, "=", (Object)key).toArray());
            initNum = config.getLong("initnumber");
        }
        atomicIncrement.setnx(key, initNum.longValue());
    }

    @Override
    public void clear(String key) {
        atomicIncrement.del(key);
    }
}

