/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business;

import java.time.LocalDate;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class LogAutoCleaningTask
extends AbstractTask {
    public static final String ENTITY_LOG_SETTING = "bos_log_appsetting";
    public static final String ENTITY_LOG_OPERATION = "bos_log_operation";
    public static final String ENTITY_LOG_ARCHIVE = "bos_log_archive";

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
    }

    private void loadLogSetData() {
        String selectList = "id,autoarchiveamt,autocleartime";
        DynamicObject logSetting = BusinessDataServiceHelper.loadSingle((String)ENTITY_LOG_SETTING, (String)selectList, (QFilter[])new QFilter[0]);
        if (logSetting == null) {
            return;
        }
        if (Long.parseLong(logSetting.get("autocleartime").toString()) <= 0L) {
            return;
        }
        Long clearTime = Long.parseLong(logSetting.get("autocleartime").toString());
        this.autoClear(clearTime);
    }

    private void autoClear(long clearTime) {
        LocalDate localDate = LocalDate.now();
        LocalDate endDate = localDate.minusMonths(clearTime);
        LogAutoCleaningTask.autoClean(endDate);
    }

    public static boolean autoClean(LocalDate endDate) {
        String selectList = "id";
        ORM orm = ORM.create();
        QFilter endDateFilter = new QFilter("optime", "<=", (Object)endDate);
        QFilter[] filters = new QFilter[]{endDateFilter};
        DynamicObjectCollection colArchive = orm.query(ENTITY_LOG_ARCHIVE, selectList, filters);
        if (colArchive.size() > 0) {
            QFilter qFilter = null;
            for (DynamicObject dynArchive : colArchive) {
                if (qFilter == null) {
                    qFilter = new QFilter("id", "=", dynArchive.get("id"));
                }
                qFilter = qFilter.or(new QFilter("id", "=", dynArchive.get("id")));
            }
            DeleteServiceHelper.delete((String)ENTITY_LOG_ARCHIVE, (QFilter[])new QFilter[]{qFilter});
        }
        return true;
    }
}

