/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business.es;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import kd.bos.dataentity.Tuple;
import kd.bos.log.business.es.StrategyEnum;
import kd.bos.log.business.es.config.CapacityConfig;
import kd.bos.log.business.es.config.CombineConfig;
import kd.bos.log.business.es.config.StrategyConfig;
import kd.bos.log.business.es.config.TimeConfig;
import kd.bos.log.service.elasticsearch.ElasticsearchService;
import kd.bos.log.service.util.EsPropertiesUtils;
import org.apache.commons.lang3.StringUtils;

public class StrategyUtil {
    public static boolean compareDate(LocalDate compareDate, LocalDate currentDate, long interval) {
        long diffDay = compareDate.until(currentDate, ChronoUnit.DAYS);
        return diffDay >= interval;
    }

    public static boolean checkCapacity(ElasticsearchService service, String currentIndex, String capacity) {
        String regx;
        if (StringUtils.isNotEmpty((CharSequence)capacity) && capacity.matches(regx = "^[1-9]\\d+[KMGTkmgt][bB]$")) {
            double currentCapacity = service.getIndexCapacity(currentIndex);
            String unit = capacity.substring(capacity.length() - 2);
            String num = capacity.substring(0, capacity.indexOf(unit));
            double limitCapacity = 0.0;
            if (unit.equalsIgnoreCase("kb")) {
                limitCapacity = Double.parseDouble(num);
            } else if (unit.equalsIgnoreCase("mb")) {
                limitCapacity = Double.parseDouble(num) * 1024.0;
            } else if (unit.equalsIgnoreCase("gb")) {
                limitCapacity = Double.parseDouble(num) * 1024.0 * 1024.0;
            } else if (unit.equalsIgnoreCase("tb")) {
                limitCapacity = Double.parseDouble(num) * 1024.0 * 1024.0 * 1024.0;
            }
            if (currentCapacity > limitCapacity) {
                return true;
            }
        }
        return false;
    }

    public static Tuple<StrategyEnum, StrategyConfig> buildStrategy(LocalDate lastDate, ElasticsearchService service, String currentIndex, String createIndex) {
        JSONObject properties = EsPropertiesUtils.getTenantEsIndexStrategy();
        if (properties != null) {
            StrategyEnum strategy = StrategyEnum.NO_ONE;
            StrategyConfig config = null;
            if (properties.containsKey((Object)"time") && properties.containsKey((Object)"capacity")) {
                strategy = StrategyEnum.TIMEWITHCAPACITY;
                config = new CombineConfig(service, currentIndex, createIndex);
                TimeConfig timeConfig = new TimeConfig(lastDate, properties.getJSONObject("time").getLong("interval"), service, currentIndex, createIndex);
                ((CombineConfig)config).setTimeConfig(timeConfig);
                CapacityConfig capacityConfig = new CapacityConfig(properties.getJSONObject("capacity").getString("num"), service, currentIndex, createIndex);
                ((CombineConfig)config).setCapacityConfig(capacityConfig);
            } else if (properties.containsKey((Object)"time")) {
                strategy = StrategyEnum.TIME;
                config = new TimeConfig(lastDate, properties.getJSONObject("time").getLong("interval"), service, currentIndex, createIndex);
            } else if (properties.containsKey((Object)"capacity")) {
                strategy = StrategyEnum.CAPACITY;
                config = new CapacityConfig(properties.getJSONObject("capacity").getString("num"), service, currentIndex, createIndex);
            }
            return new Tuple((Object)strategy, (Object)config);
        }
        return null;
    }

    public static StrategyEnum getCurrentStrategy() {
        JSONObject properties = EsPropertiesUtils.getTenantEsIndexStrategy();
        StrategyEnum strategy = StrategyEnum.NO_ONE;
        if (properties != null) {
            if (properties.containsKey((Object)"time") && properties.containsKey((Object)"capacity")) {
                strategy = StrategyEnum.TIMEWITHCAPACITY;
            } else if (properties.containsKey((Object)"time")) {
                strategy = StrategyEnum.TIME;
            } else if (properties.containsKey((Object)"capacity")) {
                strategy = StrategyEnum.CAPACITY;
            }
        }
        return strategy;
    }
}

