/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business.etl;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.log.business.etl.EtlJobService;
import kd.bos.log.business.etl.dto.EtlJob;
import kd.bos.log.business.etl.utils.GenIDUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public abstract class AbstractEtlJobService
implements EtlJobService {
    private static String ENTITY_LOG_ETL_TASK = "bos_log_etl_task";
    private static String ENTITY_TASK_ID = "taskid";
    private DynamicObject job;

    protected EtlJob create() {
        EtlJob etlJob = new EtlJob();
        etlJob.setStartTime(new Date());
        etlJob.setStatus("STARTING");
        etlJob.setFinishCount(0L);
        String lastJobId = this.getLastJobId();
        etlJob.setTaskCode(GenIDUtils.nextID(etlJob.getStartTime(), lastJobId));
        etlJob.setMoveCount(this.countTaskNum(etlJob));
        this.saveDB(etlJob);
        return etlJob;
    }

    protected void updateDB(EtlJob etlJob) {
        if (null != this.job) {
            this.job.set("finishcount", (Object)etlJob.getFinishCount());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{this.job});
        }
    }

    private void saveDB(EtlJob etlJob) {
        DynamicObject dobj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_LOG_ETL_TASK);
        dobj.set("taskid", (Object)etlJob.getTaskCode());
        dobj.set("status", (Object)etlJob.getStatus());
        dobj.set("movecount", (Object)etlJob.getMoveCount());
        dobj.set("finishcount", (Object)etlJob.getFinishCount());
        dobj.set("starttime", (Object)etlJob.getStartTime());
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        this.job = (DynamicObject)result[0];
        etlJob.setPkid((Long)this.job.get("id"));
    }

    private String getLastJobId() {
        DynamicObject[] dobj = BusinessDataServiceHelper.load((String)ENTITY_LOG_ETL_TASK, (String)ENTITY_TASK_ID, null, (String)"id desc", (int)1);
        if (dobj.length == 0) {
            return null;
        }
        return dobj[dobj.length - 1].getString(ENTITY_TASK_ID);
    }
}

