/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business.etl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.log.business.etl.AbstractEtlJobService;
import kd.bos.log.business.etl.EtlService;
import kd.bos.log.business.etl.dto.EtlJob;
import kd.bos.log.service.ArchiveLogSettingService;
import kd.bos.log.service.dto.LogSetting;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ArchiveJobService
extends AbstractEtlJobService {
    private static final Log logger = LogFactory.getLog(ArchiveJobService.class);
    private static final String[] COLUMN = new String[]{"FID", "FOPTIME", "FKEYWORD", "FUSERID", "FUSERNAME", "FBIZAPPID", "FBIZOBJID", "FBIZOBJNAME", "FORGID", "FCLIENTTYPE", "FCLIENTIP", "FOPKEY", "FOPNAME", "FOPPROJID", "FOPRESID", "FOPDESC", "FOPDESCPROJID", "FOPDESCRESID", "FSTATUS", "FEXT1", "FEXT2", "FEXT3", "FEXT4", "FEXT5", "FEXT6", "FEXT7", "FEXT8"};
    private static String[] ARCHIVE_COLUMN = new String[COLUMN.length + 1];
    private static final String OPTIME_KEY = "optime";
    private static final String BIZAPPID_KEY = "bizappid";
    private static final String OPNAME_KEY = "opname";
    private static final String DESCRIPTION_KEY = "opdescription";
    private static final String CLIENTNAME_KEY = "clientname";
    private EtlService etlService;
    private LogSetting logSetting;
    private ArchiveLogSettingService archiveLogSettingService;

    public ArchiveJobService() {
        LogSetting logSetting;
        EtlService etlService = new EtlService();
        ArchiveLogSettingService archiveLogSettingService = new ArchiveLogSettingService();
        this.logSetting = logSetting = archiveLogSettingService.getLogSetting();
        this.etlService = etlService;
        this.archiveLogSettingService = archiveLogSettingService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() {
        if (this.logSetting == null) return;
        if ("false".equals(this.logSetting.getStatus())) {
            return;
        }
        if (this.archiveLogSettingService.exists()) {
            return;
        }
        EtlJob etlJob = super.create();
        Date dateTime = this.etlService.getArchiveDateTime(etlJob.getStartTime(), this.logSetting);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int batchSize = 3000;
        long executeTime = 10800000L;
        long startTime = System.currentTimeMillis();
        Long count = this.countTaskNum(etlJob);
        int batch = (int)Math.ceil((double)count.longValue() / (double)batchSize);
        String writeRecordSql = this.calcWriteRecordSql(ARCHIVE_COLUMN, "t_log_app_archive_v3");
        String sql = "SELECT " + String.format("TOP %s 0,", batchSize) + StringUtils.join((Object[])COLUMN, (String)",") + String.format(" FROM %s WHERE FOPTIME < ", "t_log_app_v3") + String.format("{ts'%s'}", format.format(dateTime));
        int archiveCount = 0;
        etlJob.setStatus("Finish");
        for (int i = 0; i < batch && System.currentTimeMillis() - startTime < executeTime; ++i) {
            TXHandle h;
            block33: {
                h = TX.required();
                Throwable throwable = null;
                try {
                    block32: {
                        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
                            ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(batchSize);
                            ArrayList<String> pkList = new ArrayList<String>(batchSize);
                            while (ds.hasNext()) {
                                Row row = ds.next();
                                Object[] record = new Object[ARCHIVE_COLUMN.length];
                                for (int j = 0; j < ARCHIVE_COLUMN.length - 1; ++j) {
                                    record[j] = row.get(j + 1);
                                }
                                record[ArchiveJobService.ARCHIVE_COLUMN.length - 1] = etlJob.getStartTime();
                                pkList.add(row.getString("FID"));
                                writeBuffer.add(record);
                            }
                            if (writeBuffer.isEmpty()) break block32;
                            this.batchInsert(writeBuffer, writeRecordSql);
                            this.deleteOri(pkList);
                            archiveCount += writeBuffer.size();
                            if (i != batch - 1) {
                                etlJob.setFinishCount(Long.valueOf(archiveCount));
                                this.updateDB(etlJob);
                            }
                            writeBuffer.clear();
                        }
                        catch (Exception e) {
                            h.markRollback();
                            etlJob.setStatus("Fialed");
                            logger.error("\u4e1a\u52a1\u65e5\u5fd7\u5f52\u6863\u53d1\u751f\u5f02\u5e38\uff0c\u672c\u6b21\u6570\u636e\u5e93\u4e8b\u7269\u56de\u6eda" + e);
                            if (h == null) break;
                            if (throwable != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break;
                            }
                            h.close();
                            break;
                        }
                    }
                    if (h == null) continue;
                    if (throwable == null) break block33;
                }
                catch (Throwable throwable4) {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (h == null) throw throwable5;
                        if (throwable == null) {
                            h.close();
                            throw throwable5;
                        }
                        try {
                            h.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                }
                try {
                    h.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                continue;
            }
            h.close();
        }
        etlJob.setFinishCount(Long.valueOf(archiveCount));
        etlJob.setEndTime(new Date());
        this.saveTaskInfo(etlJob);
    }

    private void saveTaskInfo(EtlJob etlJob) {
        DynamicObject etlJobDo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_log_etl_task", (String)"id,status,finishcount,endtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)etlJob.getPkid())});
        etlJobDo.set("status", (Object)etlJob.getStatus());
        etlJobDo.set("finishcount", (Object)etlJob.getFinishCount());
        etlJobDo.set("endtime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject)etlJobDo);
    }

    private void deleteOri(List<String> pkList) {
        DeleteServiceHelper.delete((String)"bos_log_operation_v3", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
    }

    private Integer getLogSetting() {
        return this.logSetting.getDay();
    }

    private void batchInsert(List<Object[]> records, String writeRecordSql) {
        try (TXHandle h = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.log, (String)writeRecordSql, records);
        }
        catch (Exception e) {
            String errorMsg = e.getCause().toString();
            if (errorMsg.contains("ORA-00001") || errorMsg.contains("Duplicate entry") || errorMsg.contains("duplicate key value violates unique")) {
                logger.info("\u6570\u636e\u552f\u4e00\u6027\u7ea6\u675f\u7684\u6761\u4ef6\u5ffd\u7565");
            }
            throw e;
        }
    }

    public String calcWriteRecordSql(String[] column, String table) {
        ArrayList<String> valueHolders = new ArrayList<String>(column.length);
        for (int i = 0; i < column.length; ++i) {
            valueHolders.add("?");
        }
        String writeSqlTemplate = "INSERT INTO %s (" + StringUtils.join((Object[])column, (String)",") + ") VALUES(" + StringUtils.join(valueHolders, (String)",") + ")";
        return String.format(writeSqlTemplate, table);
    }

    @Override
    public long countTaskNum(EtlJob job) {
        return this.etlService.getCountByTime(job.getStartTime());
    }

    static {
        for (int i = 0; i < COLUMN.length; ++i) {
            ArchiveJobService.ARCHIVE_COLUMN[i] = COLUMN[i];
        }
        ArchiveJobService.ARCHIVE_COLUMN[ArchiveJobService.COLUMN.length] = "FARCHIVETIME";
    }
}

