/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business.historylog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.IndexInfo;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.log.business.historylog.HistoryLogUpgradeHelpService;
import kd.bos.log.business.historylog.HistoryLogUpgradeUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.QueryTimeout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class HistoryLogUpgradeJob
implements Runnable {
    private static final Log logger = LogFactory.getLog(HistoryLogUpgradeJob.class);
    private static final String[] COLUMN = new String[]{"FID", "FUSERID", "FBIZAPPID", "FORGID", "FBIZOBJID", "FCLIENTIP", "FCLIENTTYPE", "FOPTIME", "FOPNAMEE", "FOPDESCRIPTIONE", "FCLIENTNAMEE", "FUSERNAME", "FBIZAPPNAME", "FBIZOBJNAME", "FORGNAME", "FMODIFYBILLID", "FMODIFYCONTENT", "FMODIFYCONTENT_TAG", "FMODIFYFIELDS", "FMODIFYBILLNO"};
    private static final int BATCH_SIZE = 1000;
    private static final int REPEAT_TIME = 48;
    private static final int QUERY_TIMEOUT = 1800;

    @Override
    public void run() {
        try {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            String upgradeStatus = HistoryLogUpgradeHelpService.getUpgradeStatus();
            if (!"1".equals(upgradeStatus) && !HistoryLogUpgradeUtils.isUpgradeThreadExist()) {
                HistoryLogUpgradeHelpService.saveUpgradeStartTime();
                HistoryLogUpgradeHelpService.updateHeartBeatTime();
                Map<Integer, Object> userMap = HistoryLogUpgradeHelpService.getUserMap();
                Map<Integer, Object> orgMap = HistoryLogUpgradeHelpService.getOrgMap();
                Map<Integer, Object> appMap = HistoryLogUpgradeHelpService.getAppMap();
                Map<Integer, Object> objMap = HistoryLogUpgradeHelpService.getObjMap();
                String currentStep = HistoryLogUpgradeHelpService.getUpgradeCurrentStep();
                if (kd.bos.login.utils.StringUtils.isEmpty((String)currentStep)) {
                    logger.info("\u64cd\u4f5c\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f00\u59cb\uff0c\u5f53\u524d\u4e3a\u521d\u6b21\u5347\u7ea7");
                    HistoryLogUpgradeHelpService.saveUpgradeCurrentStep("1");
                    this.syncLogInAppToArchive(userMap, orgMap, appMap, objMap);
                    this.syncLogInAppBakToArchive(userMap, orgMap, appMap, objMap);
                    HistoryLogUpgradeHelpService.saveUpgradeCurrentStep("2");
                    this.deleteLogInApp();
                    HistoryLogUpgradeHelpService.saveUpgradeCurrentStep("3");
                    this.syncLogInArchiveToApp();
                } else {
                    logger.info("\u64cd\u4f5c\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f00\u59cb\uff0c\u5f53\u524d\u4e3a\u7eed\u5347");
                    if (currentStep.equals("1")) {
                        this.syncLogInAppToArchive(userMap, orgMap, appMap, objMap);
                        this.syncLogInAppBakToArchive(userMap, orgMap, appMap, objMap);
                        HistoryLogUpgradeHelpService.saveUpgradeCurrentStep("2");
                        this.deleteLogInApp();
                        HistoryLogUpgradeHelpService.saveUpgradeCurrentStep("3");
                        this.syncLogInArchiveToApp();
                    } else if (currentStep.equals("2")) {
                        this.deleteLogInApp();
                        HistoryLogUpgradeHelpService.saveUpgradeCurrentStep("3");
                        this.syncLogInArchiveToApp();
                    } else if (currentStep.equals("3")) {
                        this.syncLogInArchiveToApp();
                    }
                }
                HistoryLogUpgradeHelpService.saveUpgradeFinalStatus("1");
            }
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5931\u8d25\uff1a", (Throwable)e);
            HistoryLogUpgradeHelpService.saveUpgradeFinalStatus("-1");
        }
    }

    private void syncLogInAppToArchive(Map<Integer, Object> userMap, Map<Integer, Object> orgMap, Map<Integer, Object> appMap, Map<Integer, Object> objMap) {
        String insertSql = HistoryLogUpgradeUtils.calcWriteRecordSql(COLUMN, "T_LOG_ARCHIVE");
        String sql = "SELECT A.FID,A.FUSERID,A.FBIZAPPID,A.FORGID,A.FBIZOBJID,A.FCLIENTIP,A.FCLIENTTYPE,A.FOPTIME,B.FOPNAME,B.FOPDESCRIPTION,B.FCLIENTNAME,B.FLOCALEID,A.FOPNAMEE,A.FOPDESCRIPTIONE,A.FCLIENTNAMEE,A.FMODIFYBILLID,A.FMODIFYCONTENT,A.FMODIFYCONTENT_TAG,A.FMODIFYFIELDS,A.FMODIFYBILLNO FROM T_LOG_APP A LEFT JOIN T_LOG_APP_L B ON A.FID=B.FID";
        Long searchStartTime = HistoryLogUpgradeHelpService.getDataSearchStartTime("FSEARCHAPPTIME");
        boolean shouldDo = true;
        int emptyTimes = 0;
        while (shouldDo) {
            HistoryLogUpgradeHelpService.updateHeartBeatTime();
            long searchEndTime = searchStartTime - 2592000L;
            String searchSql = sql + " WHERE A.FOPTIME <=" + String.format("{ts'%s'}", HistoryLogUpgradeUtils.formatTime(searchStartTime)) + " AND A.FOPTIME >" + String.format("{ts'%s'}", HistoryLogUpgradeUtils.formatTime(searchEndTime));
            logger.info("\u64cd\u4f5c\u5386\u53f2\u65e5\u5fd7\u67e5\u8be2sql:" + searchSql);
            try (QueryTimeout timeout = DB.timeout((int)1800);){
                ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(1000);
                try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)searchSql);){
                    if (!ds.isEmpty()) {
                        emptyTimes = 0;
                        while (ds.hasNext()) {
                            Object obj;
                            Object[] record = new Object[COLUMN.length];
                            Row row = ds.next();
                            for (int j = 0; j < 12; ++j) {
                                obj = row.get(j);
                                if (j == 1 || j == 3) {
                                    record[j] = obj == null ? Integer.valueOf(0) : obj;
                                } else {
                                    Object object = record[j] = obj == null ? "" : obj;
                                    if (j == 8 && obj == null) {
                                        Object opNameObj = row.get(12);
                                        Object object2 = record[j] = opNameObj == null ? "" : opNameObj;
                                    }
                                    if (j == 9 && obj == null) {
                                        Object descriptionObj = row.get(13);
                                        Object object3 = record[j] = descriptionObj == null ? "" : descriptionObj;
                                    }
                                    if (j == 10 && obj == null) {
                                        Object clientNameObj = row.get(14);
                                        Object object4 = record[j] = clientNameObj == null ? "" : clientNameObj;
                                    }
                                }
                                if (j != 11) continue;
                                Object userID = row.get(1);
                                Object appId = row.get(2);
                                Object orgId = row.get(3);
                                Object objId = row.get(4);
                                record[11] = HistoryLogUpgradeUtils.getName(userMap, userID, obj);
                                record[12] = HistoryLogUpgradeUtils.getName(appMap, appId, obj);
                                record[13] = HistoryLogUpgradeUtils.getName(objMap, objId, obj);
                                record[14] = HistoryLogUpgradeUtils.getName(orgMap, orgId, obj);
                            }
                            for (int k = 15; k < 20; ++k) {
                                obj = row.get(k);
                                record[k] = obj == null ? "" : obj;
                            }
                            writeBuffer.add(record);
                            if (writeBuffer.size() < 1000) continue;
                            this.batchInsertWithDowngrade(writeBuffer, insertSql);
                            writeBuffer.clear();
                        }
                        if (!writeBuffer.isEmpty()) {
                            this.batchInsertWithDowngrade(writeBuffer, insertSql);
                            writeBuffer.clear();
                        }
                    } else if (++emptyTimes > 48) {
                        shouldDo = false;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            searchStartTime = searchEndTime;
            HistoryLogUpgradeHelpService.saveDataSearchStartTime(searchStartTime, "FSEARCHAPPTIME");
        }
    }

    private void syncLogInAppBakToArchive(Map<Integer, Object> userMap, Map<Integer, Object> orgMap, Map<Integer, Object> appMap, Map<Integer, Object> objMap) {
        String indexName;
        String insertSql = HistoryLogUpgradeUtils.calcWriteRecordSql(COLUMN, "T_LOG_ARCHIVE");
        List<String> bakTableColumns = this.getBakColumns();
        if (CollectionUtils.isEmpty(bakTableColumns)) {
            logger.error("\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u3010T_LOG_APP_BAK\u8868\u4e0d\u5b58\u5728\u3011");
            return;
        }
        boolean haveIndex = this.checkIndex();
        if (!haveIndex && !DB.exitsIndex((DBRoute)DBRoute.log, (String)"T_LOG_APP_BAK", (String)(indexName = "IX_LOG_OPTIME_" + HistoryLogUpgradeHelpService.getUpgradeStartTime()))) {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7T_LOG_APP_BAK\u8868\u521b\u5efa\u7d22\u5f15");
            try (QueryTimeout timeout = DB.timeout((int)1800);){
                DB.execute((DBRoute)DBRoute.log, (String)String.format("CREATE INDEX %s ON T_LOG_APP_BAK ( FOPTIME )", indexName));
            }
            catch (Exception e) {
                logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5347\u7ea7T_LOG_APP_BAK\u8868\u521b\u5efa\u7d22\u5f15\u5f02\u5e38\uff1a", (Throwable)e);
                throw e;
            }
        }
        ArrayList<String> searchColumn = new ArrayList<String>(bakTableColumns.size());
        for (String column : bakTableColumns) {
            searchColumn.add("A." + column);
        }
        String sql = "SELECT " + String.join((CharSequence)",", searchColumn) + ",B.FOPNAME FOPNAMEX,B.FOPDESCRIPTION FOPDESCRIPTIONX,B.FCLIENTNAME FCLIENTNAMEX,B.FLOCALEID  FROM T_LOG_APP_BAK A LEFT JOIN T_LOG_APP_L B ON A.FID=B.FID";
        Long searchStartTime = HistoryLogUpgradeHelpService.getDataSearchStartTime("FSEARCHAPPBAKTIME");
        boolean shouldDo = true;
        int doTimes = 0;
        while (shouldDo) {
            long searchEndTime;
            block60: {
                HistoryLogUpgradeHelpService.updateHeartBeatTime();
                searchEndTime = searchStartTime - 2592000L;
                String searchSql = sql + " WHERE A.FOPTIME <=" + String.format("{ts'%s'}", HistoryLogUpgradeUtils.formatTime(searchStartTime)) + " AND A.FOPTIME >" + String.format("{ts'%s'}", HistoryLogUpgradeUtils.formatTime(searchEndTime));
                logger.info("\u64cd\u4f5c\u5386\u53f2\u65e5\u5fd7\u67e5\u8be2sql:" + searchSql);
                try (QueryTimeout timeout = DB.timeout((int)1800);){
                    ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(1000);
                    try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)searchSql);){
                        if (!ds.isEmpty()) {
                            doTimes = 0;
                            while (ds.hasNext()) {
                                Object[] record = new Object[COLUMN.length];
                                Row row = ds.next();
                                try {
                                    for (int i = 0; i < COLUMN.length; ++i) {
                                        Object localeId;
                                        String column = COLUMN[i];
                                        Object value = null;
                                        if (this.contain(bakTableColumns, column.toLowerCase())) {
                                            value = row.get(column.toLowerCase());
                                        }
                                        if (i == 1 || i == 3) {
                                            record[i] = value == null ? Integer.valueOf(0) : value;
                                            continue;
                                        }
                                        Object object = record[i] = value == null ? "" : value;
                                        if (i == 8 && HistoryLogUpgradeUtils.isObjectEmpty(value)) {
                                            Object opNameObj = row.get("fopnamex");
                                            Object object2 = record[i] = opNameObj == null ? "" : opNameObj;
                                        }
                                        if (i == 9 && HistoryLogUpgradeUtils.isObjectEmpty(value)) {
                                            Object descriptionObj = row.get("fopdescriptionx");
                                            Object object3 = record[i] = descriptionObj == null ? "" : descriptionObj;
                                        }
                                        if (i == 10 && HistoryLogUpgradeUtils.isObjectEmpty(value)) {
                                            Object clientNameObj = row.get("fclientnamex");
                                            Object object4 = record[i] = clientNameObj == null ? "" : clientNameObj;
                                        }
                                        if (i == 11) {
                                            localeId = row.get("flocaleid");
                                            Object userID = row.get("fuserid");
                                            record[i] = HistoryLogUpgradeUtils.getName(userMap, userID, localeId);
                                        }
                                        if (i == 12) {
                                            localeId = row.get("flocaleid");
                                            Object appId = row.get("fbizappid");
                                            record[i] = HistoryLogUpgradeUtils.getName(appMap, appId, localeId);
                                        }
                                        if (i == 13) {
                                            localeId = row.get("flocaleid");
                                            Object objId = row.get("fbizobjid");
                                            record[i] = HistoryLogUpgradeUtils.getName(objMap, objId, localeId);
                                        }
                                        if (i != 14) continue;
                                        localeId = row.get("flocaleid");
                                        Object orgId = row.get("forgid");
                                        record[i] = HistoryLogUpgradeUtils.getName(orgMap, orgId, localeId);
                                    }
                                    writeBuffer.add(record);
                                }
                                catch (Exception ignore) {
                                    logger.error((Throwable)ignore);
                                }
                                if (writeBuffer.size() < 1000) continue;
                                this.batchInsertWithDowngrade(writeBuffer, insertSql);
                                writeBuffer.clear();
                            }
                            if (!writeBuffer.isEmpty()) {
                                this.batchInsertWithDowngrade(writeBuffer, insertSql);
                                writeBuffer.clear();
                            }
                            break block60;
                        }
                        if (++doTimes > 48) {
                            shouldDo = false;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
            }
            searchStartTime = searchEndTime;
            HistoryLogUpgradeHelpService.saveDataSearchStartTime(searchStartTime, "FSEARCHAPPBAKTIME");
        }
    }

    public List<String> getBakColumns() {
        boolean exist = DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_APP_BAK");
        if (exist) {
            return DB.getColumnNames((DBRoute)DBRoute.log, (String)"T_LOG_APP_BAK");
        }
        return null;
    }

    public boolean contain(List<String> columns, String target) {
        for (String column : columns) {
            if (!target.equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    private void deleteLogInApp() {
        String sql = "DELETE FROM T_LOG_APP A";
        Long searchStartTime = HistoryLogUpgradeHelpService.getDataSearchStartTime("FDELETEAPPTIME");
        int doTimes = 0;
        boolean shouldDo = true;
        while (shouldDo) {
            HistoryLogUpgradeHelpService.updateHeartBeatTime();
            long searchEndTime = searchStartTime - 2592000L;
            String deleteSql = sql + " WHERE A.FOPTIME <=" + String.format("{ts'%s'}", HistoryLogUpgradeUtils.formatTime(searchStartTime)) + " AND A.FOPTIME >" + String.format("{ts'%s'}", HistoryLogUpgradeUtils.formatTime(searchEndTime));
            logger.info("\u64cd\u4f5c\u5386\u53f2\u65e5\u5fd7\u5220\u9664sql:" + deleteSql);
            try (QueryTimeout timeout = DB.timeout((int)1800);){
                int deleteRows = DB.update((DBRoute)DBRoute.log, (String)deleteSql);
                doTimes = deleteRows <= 0 ? ++doTimes : 0;
                if (doTimes > 48) {
                    shouldDo = false;
                }
            }
            searchStartTime = searchEndTime;
            HistoryLogUpgradeHelpService.saveDataSearchStartTime(searchStartTime, "FDELETEAPPTIME");
        }
    }

    private void syncLogInArchiveToApp() {
        String insertSql = HistoryLogUpgradeUtils.calcWriteRecordSql(COLUMN, "T_LOG_APP");
        String sql = "SELECT " + StringUtils.join((Object[])COLUMN, (String)",") + " FROM T_LOG_ARCHIVE A";
        Long searchStartTime = HistoryLogUpgradeHelpService.getDataSearchStartTime("FSEARCHARCHIVETIME");
        boolean shouldDo = true;
        int doTimes = 0;
        while (shouldDo) {
            HistoryLogUpgradeHelpService.updateHeartBeatTime();
            long searchEndTime = searchStartTime - 2592000L;
            String searchSql = sql + " WHERE A.FOPTIME <=" + String.format("{ts'%s'}", HistoryLogUpgradeUtils.formatTime(searchStartTime)) + " AND A.FOPTIME >" + String.format("{ts'%s'}", HistoryLogUpgradeUtils.formatTime(searchEndTime));
            logger.info("\u64cd\u4f5c\u5386\u53f2\u65e5\u5fd7\u67e5\u8be2sql:" + searchSql);
            try (QueryTimeout timeout = DB.timeout((int)1800);){
                ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(1000);
                try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)searchSql);){
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        Object[] record = new Object[COLUMN.length];
                        for (int j = 0; j < COLUMN.length; ++j) {
                            record[j] = row.get(j);
                        }
                        writeBuffer.add(record);
                        if (writeBuffer.size() < 1000) continue;
                        this.batchInsertWithDowngrade(writeBuffer, insertSql);
                        writeBuffer.clear();
                    }
                    if (!writeBuffer.isEmpty()) {
                        this.batchInsertWithDowngrade(writeBuffer, insertSql);
                        writeBuffer.clear();
                    }
                    if (++doTimes > 6) {
                        shouldDo = false;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            searchStartTime = searchEndTime;
            HistoryLogUpgradeHelpService.saveDataSearchStartTime(searchStartTime, "FSEARCHARCHIVETIME");
        }
    }

    private void batchInsertWithDowngrade(List<Object[]> records, String writeRecordSql) {
        try (TXHandle h = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.log, (String)writeRecordSql, records);
        }
        catch (Exception e) {
            if (e.getCause().toString().contains("java.sql.SQLException")) {
                for (Object[] record : records) {
                    try {
                        this.insertOne(record, writeRecordSql);
                    }
                    catch (Exception exception) {}
                }
            }
            throw e;
        }
    }

    private void insertOne(Object[] record, String writeRecordSql) {
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.log, (String)writeRecordSql, (Object[])record);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkIndex() {
        List indexInfos = DB.getIndexInfo((DBRoute)DBRoute.log, (String)"T_LOG_APP_BAK");
        if (CollectionUtils.isNotEmpty((Collection)indexInfos)) {
            for (IndexInfo indexInfo : indexInfos) {
                List indexFieldInfos = indexInfo.getIndexFieldInfo();
                for (IndexInfo.IndexFieldInfo temp : indexFieldInfos) {
                    String fieldName = temp.getFieldName();
                    if (!"foptime".equals(fieldName.toLowerCase(Locale.ENGLISH))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

