/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business.historylog;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.lang.Lang;
import kd.bos.log.business.historylog.HistoryLogUpgradeHelpService;
import org.apache.commons.lang3.StringUtils;

public class HistoryLogUpgradeUtils {
    public static int getKey(Object id, Object localeId) {
        int key = id != null && localeId != null ? id.hashCode() + localeId.hashCode() : (id == null && localeId != null ? localeId.hashCode() : (id != null ? id.hashCode() : -1));
        return key;
    }

    private static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        return StringUtils.isEmpty((CharSequence)StringUtils.deleteWhitespace((String)String.valueOf(obj)));
    }

    public static boolean isObjectEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        try {
            return StringUtils.isEmpty((CharSequence)String.valueOf(obj).trim());
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static Object getName(Map<Integer, Object> map, Object id, Object localeId) {
        if (map != null && !map.isEmpty()) {
            Object name = map.get(HistoryLogUpgradeUtils.getKey(id, localeId));
            if (HistoryLogUpgradeUtils.isEmpty(name)) {
                return HistoryLogUpgradeUtils.getActualName(map, id);
            }
            return name;
        }
        return "";
    }

    private static Object getActualName(Map<Integer, Object> map, Object id) {
        Object tempName = map.get(HistoryLogUpgradeUtils.getKey(id, Lang.zh_CN.toString()));
        Object actualName = HistoryLogUpgradeUtils.isEmpty(tempName) ? (HistoryLogUpgradeUtils.isEmpty(tempName = map.get(HistoryLogUpgradeUtils.getKey(id, Lang.zh_TW.toString()))) ? ((tempName = map.get(HistoryLogUpgradeUtils.getKey(id, Lang.en_US.toString()))) == null ? "" : tempName) : tempName) : tempName;
        return actualName;
    }

    public static String calcWriteRecordSql(String[] column, String table) {
        ArrayList<String> valueHolders = new ArrayList<String>(column.length);
        for (int i = 0; i < column.length; ++i) {
            valueHolders.add("?");
        }
        String writeSqlTemplate = "INSERT INTO %s (" + StringUtils.join((Object[])column, (String)",") + ") VALUES(" + StringUtils.join(valueHolders, (String)",") + ")";
        return String.format(writeSqlTemplate, table);
    }

    public static String formatTime(long time) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(time), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return localDateTime.format(formatter);
    }

    public static boolean isUpgradeThreadExist() {
        long cap;
        Long heartBeatTime = HistoryLogUpgradeHelpService.getHeartBeatTime();
        if (heartBeatTime == null || heartBeatTime <= 0L) {
            return false;
        }
        long interval = System.currentTimeMillis() / 1000L - heartBeatTime;
        return interval <= (cap = 86400L);
    }
}

