/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.servicehelper;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.log.business.es.StrategyUtil;
import kd.bos.log.service.elasticsearch.ElasticsearchService;
import kd.bos.log.service.util.EsPropertiesUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.lang.math.RandomUtils;

public class EsUpgradeServicePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(EsUpgradeServicePlugin.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog(ResManager.loadKDString((String)"\u811a\u672c\u5347\u7ea7\u5f00\u59cb\u6267\u884c\u521b\u5efa\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\u3002", (String)"EsUpgradeServicePlugin_0", (String)"bos-log-business", (Object[])new Object[0]));
            boolean upgradeResult = this.createIndex();
            result.setSuccess(upgradeResult);
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u811a\u672c\u5347\u7ea7\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\u521b\u5efa\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (String)"EsUpgradeServicePlugin_1", (String)"bos-log-business", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createIndex() throws IOException {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u811a\u672c\u5347\u7ea7\u6267\u884c\u521b\u5efa\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\uff0c\u64cd\u4f5c\u65e5\u5fd7ES\u914d\u7f6e\u4e3a\u7a7a\u3002", (String)"EsUpgradeServicePlugin_2", (String)"bos-log-business", (Object[])new Object[0]));
        }
        String indexTep = properties.getString("indexTep").toLowerCase();
        LocalDate now = LocalDate.now();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String time = now.format(timeFormatter);
        String tenantId = RequestContext.get().getTenantId().toLowerCase();
        String accountId = RequestContext.get().getAccountId().toLowerCase();
        if (!indexTep.contains(tenantId) || !indexTep.contains(accountId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u811a\u672c\u5347\u7ea7\u64cd\u4f5c\u65e5\u5fd7ES\u914d\u7f6e\u7d22\u5f15\u6a21\u677f\u7684\u79df\u6237ID\u548c\u6570\u636e\u4e2d\u5fc3ID\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u4e00\u81f4\uff0cindexTep\uff1a%1$s\uff0c\u5f53\u524d\u79df\u6237ID\uff1a%2$s\uff0c\u5f53\u524d\u6570\u636e\u4e2d\u5fc3ID\uff1a%3$s\u3002", (String)"EsUpgradeServicePlugin_3", (String)"bos-log-business", (Object[])new Object[0]), indexTep, tenantId, accountId));
        }
        String createIndex = indexTep.replace("*", time) + "-1";
        logger.info("\u811a\u672c\u5347\u7ea7\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\u521b\u5efa\u5347\u7ea7\uff0c\u521b\u5efa\u7d22\u5f15\u4e3a\uff1a" + createIndex);
        try (ElasticsearchService service = ElasticsearchService.getInstance();){
            boolean result = service.createIndex(createIndex);
            if (!result) {
                String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c\u5347\u7ea7\u6267\u884c\u4e0a\u673a\u65e5\u5fd7ES\u7d22\u5f15\u521b\u5efa\u5347\u7ea7,\u7d22\u5f15:%1$s\u521b\u5efa\u5931\u8d25", (String)"EsUpgradeServicePlugin_4", (String)"bos-log-business", (Object[])new Object[0]), createIndex);
                throw new KDBizException(msg);
            }
            long id = this.getId();
            String sql = "insert into t_log_index (fid,fname,fcreatetime,fstatus,fstrategy) values (?,?,?,?,?)";
            Object[] record = new Object[]{id, createIndex, new Date(System.currentTimeMillis()), "1", StrategyUtil.getCurrentStrategy().getValue()};
            DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])record);
            boolean bl = true;
            return bl;
        }
    }

    private long getId() {
        long time = System.currentTimeMillis();
        int max = 999999;
        int min = 100000;
        int randomValue = RandomUtils.nextInt((int)(max - min + 1)) + min;
        return time * 1000000L + (long)randomValue;
    }
}

