/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.rule.FieldRuleHelper;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.param.AppParamConsolePlugin;
import kd.bos.form.plugin.param.SysParamConsolePlugin;
import kd.bos.form.plugin.param.TabStatus;
import kd.bos.form.plugin.utils.LocalCacheUtils;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mvc.parameter.ParameterModel;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParamDcBinder;
import kd.bos.param.ParamOpLogUtils;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.param.impl.ParameterWriterServiceImpl;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public abstract class AbstractParamConsolePlugin
extends AbstractFormPlugin
implements TabSelectListener,
TreeNodeClickListener {
    protected static final String TAB_KEY = "tabKey";
    protected static final String SYS_LEFT_PANEL = "sysleftpanel";
    protected static final String SYS_RIGHT_PANEL = "sysrightpanel";
    protected static final String SYS_TREEKEY = "systreeviewap";
    protected static final String APP_LEFT_PANEL = "appleftpanel";
    protected static final String APP_RIGHT_PANEL = "apprightpanel";
    protected String APP_TREEKEY = "apptreeviewap";
    private static final String BTNSAVE = "save";
    private static final String BT_GROUP_CTRL = "groupcontrol";
    private static final String COMMON_PARAMETERS = "_commonparameters";
    protected static final String TABPARASETTINGS_PAGEID = "TabParaSettings_PageId";
    protected static final String SYS_PARAM_PAGE_ID = "SYS_PARAM_PAGE_ID";
    protected static final String BOS_PARAMETER = "bos-parameter";
    protected static final String SUCCESS = "success";
    protected static final String CUSTOM_KEY_CHECK_REGEX = "^\\w+$";
    private static final String BOS_PARAM_GC_CONSOLE = "bos_param_gc_console";
    private static final String OPEN_GC_PAGEID = "openGcPageid";
    protected static final String CACHE_CUR_APP_NODE = "app_curNodeId";
    protected static ParameterReaderServiceImpl parameterReaderService = new ParameterReaderServiceImpl();
    protected static ParameterWriterServiceImpl parameterWriterService = new ParameterWriterServiceImpl();
    protected static Log log = LogFactory.getLog(AbstractParamConsolePlugin.class);
    protected static final String LAST_SELECTED_PARAM = "last_selected_param";
    protected static final String PARAM_TYPE = "paramType";
    protected static final String SELECTED_NODE_ID = "selectedNodeId";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    abstract TreeView getTreeView();

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTNSAVE.equals(itemKey)) {
            if (!this.checkPermission("3J6/+NF038+5", this.getView().getEntityId())) {
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractParamConsolePlugin_2", (String)BOS_PARAMETER, (Object[])new Object[0]), this.getView().getFormShowParameter().getFormConfig().getCaption());
                this.getView().showErrorNotification(msg);
                return;
            }
            try (TXHandle tx = TX.required();){
                try {
                    this.save();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    tx.markRollback();
                    throw e;
                }
            }
        }
        if ("refresh".equals(itemKey)) {
            TreeView treeView = this.getTreeView();
            if (treeView == null) {
                return;
            }
            Map focusNode = treeView.getTreeState().getFocusNode();
            if (focusNode == null) {
                return;
            }
            Object id = focusNode.get("id");
            Object parentid = focusNode.get("parentid");
            treeView.treeNodeClick(String.valueOf(parentid), String.valueOf(id));
        }
        if (BT_GROUP_CTRL.equals(itemKey)) {
            if (!this.checkPermission("3J60C32DLPMD", this.getView().getEntityId())) {
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u96c6\u56e2\u7ba1\u63a7\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractParamConsolePlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]), this.getView().getFormShowParameter().getFormConfig().getCaption());
                this.getView().showErrorNotification(msg);
                return;
            }
            this.showGroupControlView();
        }
    }

    boolean checkPermission(String permItem, String entityId) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)entityId, (String)permItem);
    }

    private void showGroupControlView() {
        String gcPageId;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_PARAM_GC_CONSOLE);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (this instanceof AppParamConsolePlugin) {
            parameter.setCustomParam("appId", (Object)this.getPageCache().get(CACHE_CUR_APP_NODE));
        }
        if (StringUtils.isNotBlank((CharSequence)(gcPageId = this.getPageCache().get(OPEN_GC_PAGEID)))) {
            parameter.setPageId(gcPageId);
        } else {
            this.getPageCache().put(OPEN_GC_PAGEID, parameter.getPageId());
        }
        this.getView().showForm(parameter);
    }

    protected TabStatus getStatus() {
        String currStatusKey = "currStatus";
        String currStatusJson = this.getPageCache().get(currStatusKey);
        if (StringUtils.isBlank((CharSequence)currStatusJson)) {
            TabStatus tabStatus = new TabStatus();
            this.cacheStatus(tabStatus);
            return tabStatus;
        }
        return (TabStatus)SerializationUtils.fromJsonString((String)currStatusJson, TabStatus.class);
    }

    protected void cacheStatus(TabStatus tabStatus) {
        this.getPageCache().put("currStatus", SerializationUtils.toJsonString((Object)tabStatus));
    }

    protected void setAppParamPageId(ParameterShowParameter parameter) {
        TabStatus tabStatus = this.getStatus();
        tabStatus.setAppParamPageId(parameter.getPageId());
        this.cacheStatus(tabStatus);
    }

    protected void setSysParamPageId(FormShowParameter showParameter) {
        TabStatus tabStatus = this.getStatus();
        tabStatus.setSysParamPageId(showParameter.getPageId());
        this.cacheStatus(tabStatus);
    }

    protected void setCustomPageId(FormShowParameter showParameter) {
        TabStatus tabStatus = this.getStatus();
        tabStatus.setCustomPageId(showParameter.getPageId());
        this.cacheStatus(tabStatus);
    }

    protected void changeSysTob() {
        TabStatus tabStatus = this.getStatus();
        tabStatus.changeSysTob();
        this.cacheStatus(tabStatus);
    }

    protected void changeToAppTob() {
        TabStatus tabStatus = this.getStatus();
        tabStatus.changeToAppTob();
        this.cacheStatus(tabStatus);
    }

    protected void changeToBaseTob() {
        TabStatus tabStatus = this.getStatus();
        tabStatus.changeToBaseTob();
        this.cacheStatus(tabStatus);
    }

    protected void changeToCustomTob() {
        TabStatus tabStatus = this.getStatus();
        tabStatus.changeToCustomTob();
        this.cacheStatus(tabStatus);
    }

    abstract void save();

    protected void saveAppParam(IDataModel dataModel) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        Map<String, Object> jsonStringMap = this.getJsonStringMap(dataEntity);
        String jsonString = SerializationUtils.toJsonString(jsonStringMap);
        IParameterModel model = (IParameterModel)dataModel;
        AppParam appParam = this.buildAppParam(model);
        Map<String, Object> preDataMap = this.getDataMap(appParam);
        AppParam param = new AppParam(appParam.getCloudId(), appParam.getAppId(), appParam.getViewType(), appParam.getOrgId(), appParam.getActBookId(), appParam.getAcctingBookId());
        param.setFormId(appParam.getFormId());
        parameterWriterService.saveSystemParameter(param, jsonString);
        long rootOrgId = ParameterOrgUtils.getParamRootOrgId();
        if (null != model.getOrgId() && model.getOrgId().equals(rootOrgId)) {
            LocalCacheUtils.remove((String)(RequestContext.get().getAccountId() + COMMON_PARAMETERS));
        }
        this.sendMqMessage(model, appParam, jsonStringMap);
        Map<String, Object> currDataMap = this.getDataMap(appParam);
        this.addLog(preDataMap, currDataMap);
    }

    protected Map<String, Object> getJsonStringMap(DynamicObject dataEntity) {
        ParamDcBinder binder = new ParamDcBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        String jsonString = jser.serializeToString((Object)dataEntity, null);
        Map jsonStringMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof BooleanProp && ((BooleanProp)property).getDefValue() != null && jsonStringMap.get(property.getName()) == null) {
                if (((Boolean)((BooleanProp)property).getDefValue()).booleanValue()) {
                    jsonStringMap.put(property.getName(), Boolean.TRUE);
                } else {
                    jsonStringMap.put(property.getName(), Boolean.FALSE);
                }
            }
            if (!(property instanceof ComboProp) && !(property instanceof TextProp)) continue;
            this.setNullValue(jsonStringMap, property);
        }
        return jsonStringMap;
    }

    private void setNullValue(Map<String, Object> jsonStringMap, IDataEntityProperty p) {
        if (p instanceof FieldProp && ((FieldProp)p).getDefValue() != null && jsonStringMap.get(p.getName()) == null) {
            jsonStringMap.put(p.getName(), null);
        }
    }

    private Map<String, Object> getDataMap(AppParam appParam) {
        Map<String, Object> preDataMap = this instanceof SysParamConsolePlugin && StringUtils.isNotBlank((CharSequence)appParam.getFormId()) ? parameterReaderService.loadPublicParameterFromCache(appParam.getFormId()) : parameterReaderService.loadSystemParameterFromCache(appParam);
        return preDataMap;
    }

    protected void addLog(Map<String, Object> preDataMap, Map<String, Object> currDataMap) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : currDataMap.entrySet()) {
            String preValue;
            String key = entry.getKey();
            String currValue = String.valueOf(String.valueOf(entry.getValue()));
            if (currValue.equals(preValue = String.valueOf(String.valueOf(preDataMap.get(key))))) continue;
            builder.append(key).append(":").append(preValue).append("-->").append(currValue);
        }
        MultiLangEnumBridge msg = new MultiLangEnumBridge("\u7ed3\u679c\uff1a%s", "ParameterConsolePlugin_100", BOS_PARAMETER);
        if (builder.length() == 0) {
            msg = null;
        }
        ParamOpLogUtils.addLog(this.getView(), BTNSAVE, new MultiLangEnumBridge("\u4fdd\u5b58", "AbstractParamConsolePlugin_0", BOS_PARAMETER).getDescription(), "", msg, builder.toString());
    }

    protected void addCustomLog(Map<String, String> preDataMap, Map<String, String> currDataMap) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : currDataMap.entrySet()) {
            String preValue;
            String key = entry.getKey();
            String currValue = String.valueOf(entry.getValue());
            if (currValue.equals(preValue = String.valueOf(preDataMap.get(key)))) continue;
            builder.append(key).append(":").append(preValue).append("-->").append(currValue);
        }
        MultiLangEnumBridge msg = new MultiLangEnumBridge("\u7ed3\u679c\uff1a%s", "ParameterConsolePlugin_100", BOS_PARAMETER);
        if (builder.length() == 0) {
            msg = null;
        }
        ParamOpLogUtils.addLog(this.getView(), "saveCustomParam", new MultiLangEnumBridge("\u4fdd\u5b58\u81ea\u5b9a\u4e49\u53c2\u6570", "AbstractParamConsolePlugin_5", BOS_PARAMETER).getDescription(), "", msg, builder.toString());
    }

    protected AppParam buildAppParam(IParameterModel model) {
        String cloudId = model.getParamCloudId();
        String appId = model.getParamAppId();
        if (StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId) && model instanceof ParameterModel) {
            ParameterModel parameterModel = (ParameterModel)model;
            MainEntityType mainEntityType = parameterModel.getMainEntityType();
            String mainEntityTypeName = mainEntityType.getName();
            AppParam appParam = new AppParam(cloudId, appId, "0", Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L));
            appParam.setFormId(mainEntityTypeName);
            return appParam;
        }
        AppParam appParam = new AppParam(cloudId, appId, model.getViewType(), model.getOrgId(), Long.valueOf(0L), Long.valueOf(0L));
        return appParam;
    }

    private void sendMqMessage(IParameterModel model, AppParam appParam, Map<String, Object> jsonStringMap) {
        String cloudId = appParam.getCloudId();
        String appId = appParam.getAppId();
        try {
            Object region = jsonStringMap.get("kdsysparametermqregion");
            Object queue = jsonStringMap.get("kdsysparametermqqueue");
            if (region != null && queue != null) {
                MessagePublisher mq = MQFactory.get().createSimplePublisher(region.toString(), queue.toString());
                HashMap<String, Object> systemParameter = new HashMap<String, Object>();
                systemParameter.put("cloudId", cloudId);
                systemParameter.put("appId", appId);
                systemParameter.put("viewType", model.getViewType());
                systemParameter.put("orgId", appParam.getOrgId());
                systemParameter.put("acctBookId", appParam.getActBookId());
                systemParameter.put("acctingBookId", appParam.getAcctingBookId());
                systemParameter.put("data", SerializationUtils.toJsonString(jsonStringMap));
                mq.publish(systemParameter);
                log.info("MQ\u53d1\u9001\u7cfb\u7edf\u53c2\u6570\u6d88\u606f\uff1a" + SerializationUtils.toJsonString(systemParameter));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    protected boolean validate(IFormView parameterView, DynamicObject dataEntity, IDataModel model) {
        OperationResult result = parameterView.invokeOperation("donothing");
        List<FieldTip> fieldKeys = this.getMustInputKey(dataEntity, model);
        parameterView.showFieldTips(fieldKeys);
        this.getView().sendFormAction(parameterView.getParentView());
        int errotNum = fieldKeys.size();
        if (errotNum != 0) {
            StringBuilder describ = new StringBuilder().append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"ParameterConsolePlugin_13", (String)BOS_PARAMETER, (Object[])new Object[0]));
            ArrayList<String> fiedKeyTypes = new ArrayList<String>(16);
            for (int i = 0; i < errotNum; ++i) {
                if (i == errotNum - 1) {
                    describ.append("\u201c%s\u201d\u3002");
                } else {
                    describ.append("\u201c%s\u201d,");
                }
                String paramKey = fieldKeys.get(i).getFieldKey();
                String paramName = AbstractParamConsolePlugin.matchParamName(paramKey);
                if (paramName.equals(paramKey)) {
                    paramName = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)paramKey)).getDisplayName().getLocaleValue();
                }
                fiedKeyTypes.add(paramName);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)describ.toString(), (String)"Save_10", (String)BOS_PARAMETER, (Object[])new Object[0]), fiedKeyTypes.toArray()));
            return false;
        }
        if (!result.isSuccess()) {
            List allErrorInfo;
            List validateErrors = result.getValidateResult().getValidateErrors();
            if (validateErrors != null && !validateErrors.isEmpty() && (allErrorInfo = ((ValidateResult)validateErrors.get(0)).getAllErrorInfo()) != null && !allErrorInfo.isEmpty()) {
                this.getView().showTipNotification(((OperateErrorInfo)allErrorInfo.get(0)).getMessage());
                return false;
            }
            this.getView().showTipNotification(result.getMessage());
            return false;
        }
        return true;
    }

    protected boolean checkCustomParams(IFormView customView) {
        IDataModel customModel = (IDataModel)customView.getService(IDataModel.class);
        DynamicObjectCollection entryentity = customModel.getEntryEntity("entryentity");
        if (entryentity.isEmpty()) {
            return true;
        }
        if (!this.validate(customView, customModel.getDataEntity(), customModel)) {
            return false;
        }
        Set keys = entryentity.stream().map(e -> e.getString("key")).collect(Collectors.toSet());
        if (keys.size() < entryentity.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u540d\u79f0\u5b58\u5728\u91cd\u590d\u3002", (String)"ParameterConsolePlugin_22", (String)BOS_PARAMETER, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        for (String key : keys) {
            if (Pattern.matches(CUSTOM_KEY_CHECK_REGEX, key)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u540d\u79f0\u5fc5\u987b\u7531\u82f1\u6587\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"ParameterConsolePlugin_23", (String)BOS_PARAMETER, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    protected AppLogInfo buildLogInfo(String msg, Long orgId) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String bizApppnumber = this.getView().getFormShowParameter().getAppId();
        String bizAppid = BizAppServiceHelp.getAppIdByAppNumber((String)bizApppnumber);
        logInfo.setBizAppID(bizAppid);
        logInfo.setBizObjID(this.getView().getEntityId());
        logInfo.setOrgID(orgId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ParameterConsolePlugin_10", (String)BOS_PARAMETER, (Object[])new Object[0]));
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    private List<FieldTip> getMustInputKey(DynamicObject dataEntity, IDataModel model) {
        IDataEntityType type = dataEntity.getDataEntityType();
        DataEntityPropertyCollection props = type.getProperties();
        ArrayList<FieldTip> keys = new ArrayList<FieldTip>();
        if (type instanceof MainEntityType) {
            for (IDataEntityProperty prop : props) {
                boolean mustInput;
                if (prop instanceof BooleanProp) continue;
                if (prop instanceof AttachmentProp) {
                    mustInput = FieldRuleHelper.isMustInput((MainEntityType)((MainEntityType)type), (DynamicObject)dataEntity, (String)prop.getName());
                    Object col = dataEntity.get(prop.getName());
                    if (!mustInput || !(col instanceof Collection) || !CollectionUtils.isEmpty((Collection)((Collection)col))) continue;
                    keys.add(new FieldTip(FieldTip.FieldTipType.Error, prop.getName(), ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParameterConsolePlugin_26", (String)BOS_PARAMETER, (Object[])new Object[0])));
                    continue;
                }
                mustInput = FieldRuleHelper.isMustInput((MainEntityType)((MainEntityType)type), (DynamicObject)dataEntity, (String)prop.getName());
                if (!mustInput || !StringUtils.isBlank((Object)dataEntity.get(prop.getName()))) continue;
                keys.add(new FieldTip(FieldTip.FieldTipType.Error, prop.getName(), ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParameterConsolePlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0])));
            }
        }
        return keys;
    }

    private static String matchParamName(String paramKey) {
        String paramName;
        switch (paramKey) {
            case "yzjurl": {
                paramName = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5730\u5740", (String)"ParameterConsolePlugin_15", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "eid": {
                paramName = ResManager.loadKDString((String)"\u5de5\u4f5c\u5708EID", (String)"ParameterConsolePlugin_16", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "readkey": {
                paramName = ResManager.loadKDString((String)"\u53ea\u8bfb\u79d8\u94a5", (String)"ParameterConsolePlugin_17", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "yzjkey": {
                paramName = ResManager.loadKDString((String)"\u7cfb\u7edf\u96c6\u6210\u79d8\u94a5", (String)"ParameterConsolePlugin_18", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "imservicekey": {
                paramName = ResManager.loadKDString((String)"IM\u670d\u52a1\u79d8\u94a5", (String)"ParameterConsolePlugin_19", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            case "git_url": {
                paramName = ResManager.loadKDString((String)"\u9ed8\u8ba4git\u5730\u5740", (String)"ParameterConsolePlugin_20", (String)BOS_PARAMETER, (Object[])new Object[0]);
                break;
            }
            default: {
                paramName = paramKey;
            }
        }
        return paramName;
    }

    protected ParameterShowParameter getAppParameterFormShowParameter(String panel, String formId, long orgId, long acctBookId, long acctingBookId, String viewType, String cloudId, String appId) {
        ParameterShowParameter showParameter = new ParameterShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(panel);
        showParameter.setFormId(formId);
        showParameter.setCustomParam("orgid", (Object)orgId);
        showParameter.setCustomParam("acctbookid", (Object)acctBookId);
        showParameter.setCustomParam("acctingbookid", (Object)acctingBookId);
        showParameter.setCustomParam("paramcloudid", (Object)cloudId);
        showParameter.setCustomParam("paramappid", (Object)appId);
        showParameter.setCustomParam("viewtype", (Object)(viewType == null ? "15" : viewType));
        showParameter.setHasRight(true);
        return showParameter;
    }
}

