/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.param.AbstractParamConsolePlugin;
import kd.bos.form.plugin.param.AppParamConsolePlugin;
import kd.bos.form.plugin.param.FlatOrgAppParamConsolePlugin;
import kd.bos.form.plugin.param.SysParamConsolePlugin;
import kd.bos.form.plugin.param.TabStatus;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class ParamConsolePlugin
extends AbstractFormPlugin
implements TabSelectListener,
TreeNodeClickListener {
    private AbstractParamConsolePlugin paramConsolePlugin;
    private static final String TAB_KEY = "tabKey";
    private static final String BT_SYNC_PARAMS = "syncparams";
    private static final String CACHE_KEY_CLOSE_TYPE = "CACHE_KEY_CLOSE_TYPE";
    private static final String BT_PARAM_COPY = "paramcopy";
    private static final String BT_PARAM_COPY_RESULT = "paramcopy_result";
    private static final String BOS_PARAMETER = "bos-parameter";
    private static final Log log = LogFactory.getLog(ParamConsolePlugin.class);
    private static final String LAST_SELECTED_PARAM = "last_selected_param";
    private static final String PARAM_TYPE = "paramType";

    public void initialize() {
        this.paramConsolePlugin = this.isSysPanel() ? new SysParamConsolePlugin() : this.getAppPlugin();
        TreeView tree = (TreeView)this.getControl("systreeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        tree = (TreeView)this.getControl("apptreeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.paramConsolePlugin.setView(this.getView());
        this.paramConsolePlugin.initialize();
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("tabgroupap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.paramConsolePlugin.registerListener(e);
        this.addClickListeners(new String[]{"goto1", "goto2", "goto3", "goto4", "goto5", "opentips", "closetips"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String oldTabKey;
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)(oldTabKey = this.getPageCache().get(TAB_KEY)))) {
            return;
        }
        this.getView().getPageCache().put(TAB_KEY, tabKey);
        this.paramConsolePlugin = "tabpageapp".equals(tabKey) ? this.getAppPlugin() : new SysParamConsolePlugin();
        this.paramConsolePlugin.setView(this.getView());
        this.paramConsolePlugin.tabSelected(tabSelectEvent);
    }

    public void afterCreateNewData(EventObject e) {
        boolean initailVersion;
        String closeType = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)CACHE_KEY_CLOSE_TYPE);
        if ("close".equals(closeType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipscontent", "closetips"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"opentips"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"opentips"});
        }
        if (!ParameterOrgUtils.isTreeOrg()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BT_SYNC_PARAMS, "groupcontrol"});
        }
        if (initailVersion = InitailVersionServiceHelper.isInitailVersion((int)6)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    public void afterBindData(EventObject e) {
        this.switchToCustomApp();
    }

    private void switchToCustomApp() {
        Object switchToApp = this.getView().getFormShowParameter().getCustomParam("switchToApp");
        if (StringUtils.isNotBlank((Object)switchToApp)) {
            Tab tab = (Tab)this.getView().getControl("tabgroupap");
            tab.selectTab(TabStatus.SYS_APP_TAB[1]);
            tab.activeTab(TabStatus.SYS_APP_TAB[1]);
            this.initialize();
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("opentips".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tipscontent", "closetips"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"opentips"});
            UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)CACHE_KEY_CLOSE_TYPE);
            return;
        }
        if ("closetips".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipscontent", "closetips"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"opentips"});
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)CACHE_KEY_CLOSE_TYPE, (String)"close");
            return;
        }
        Map<String, String> itemMap = ParamConsolePlugin.getItemMap();
        if (itemMap.containsKey(key)) {
            String text = itemMap.get(key);
            this.gotoNode(text);
            return;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        this.paramConsolePlugin.closedCallBack(closedCallBackEvent);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BT_SYNC_PARAMS.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if (!(this.paramConsolePlugin instanceof AppParamConsolePlugin)) {
                return;
            }
            AppParamConsolePlugin appParamConsolePlugin = (AppParamConsolePlugin)this.paramConsolePlugin;
            TabStatus tabStatus = appParamConsolePlugin.getStatus();
            String appParamPageId = tabStatus.getAppParamPageId();
            IFormView parameterView = this.getView().getViewNoPlugin(appParamPageId);
            if (appParamPageId == null || parameterView == null) {
                String msg = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u662f\u5426\u6253\u5f00\u53c2\u6570\u8868\u5355\u6216\u68c0\u67e5\u64cd\u4f5c\u6743\u9650\u3002", (String)"AppParamConsolePlugin_0", (String)BOS_PARAMETER, (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            IDataModel dataModel = (IDataModel)parameterView.getService(IDataModel.class);
            DynamicObject dataEntity = dataModel.getDataEntity();
            if (!appParamConsolePlugin.checkPermission("3J6/5=U2R6L2", this.getView().getEntityId())) {
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u540c\u6b65\u4e0b\u7ea7\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractParamConsolePlugin_3", (String)BOS_PARAMETER, (Object[])new Object[0]), this.getView().getFormShowParameter().getFormConfig().getCaption());
                this.getView().showErrorNotification(msg);
                return;
            }
            if (!appParamConsolePlugin.validate(parameterView, dataEntity, dataModel)) {
                return;
            }
            appParamConsolePlugin.saveAppParam(dataModel);
            appParamConsolePlugin.syncParam((IParameterModel)dataModel, dataEntity);
        } else if (this.paramConsolePlugin != null) {
            this.paramConsolePlugin.confirmCallBack(messageBoxClosedEvent);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BT_SYNC_PARAMS.equals(itemKey)) {
            if (!(this.paramConsolePlugin instanceof AppParamConsolePlugin)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5e94\u7528\u8282\u70b9\u8fdb\u884c\u540c\u6b65\u4e0b\u7ea7\u64cd\u4f5c\u3002", (String)"AppParamConsolePlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0]);
                this.getView().showTipNotification(msg, Integer.valueOf(3000));
                return;
            }
            AppParamConsolePlugin appParamConsolePlugin = (AppParamConsolePlugin)this.paramConsolePlugin;
            if (!appParamConsolePlugin.checkIsAppNode()) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5e94\u7528\u8282\u70b9\u8fdb\u884c\u540c\u6b65\u4e0b\u7ea7\u64cd\u4f5c\u3002", (String)"AppParamConsolePlugin_4", (String)BOS_PARAMETER, (Object[])new Object[0]);
                this.getView().showTipNotification(msg, Integer.valueOf(3000));
                return;
            }
            if (!appParamConsolePlugin.checkPermission("3J6/5=U2R6L2", this.getView().getEntityId())) {
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u540c\u6b65\u4e0b\u7ea7\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractParamConsolePlugin_3", (String)BOS_PARAMETER, (Object[])new Object[0]), this.getView().getFormShowParameter().getFormConfig().getCaption());
                this.getView().showErrorNotification(msg);
                return;
            }
            String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5728\u96c6\u56e2\u7ba1\u63a7\u4e2d\u8bbe\u7f6e\u5305\u542b\u4e0b\u7ea7\u7684\u53c2\u6570\u503c\u5c06\u540c\u6b65\u81f3\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u786e\u5b9a\u8981\u540c\u6b65\u81f3\u4e0b\u7ea7\u5417\uff1f", (String)"ParamGroupControlPluginNew_2", (String)BOS_PARAMETER, (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BT_SYNC_PARAMS, (IFormPlugin)this);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, confirmCallBacks);
            return;
        }
        if (BT_PARAM_COPY.equals(itemKey)) {
            if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"3PA4XO=31M71")) {
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u53c2\u6570\u590d\u5236\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ParamConsolePlugin_0", (String)BOS_PARAMETER, (Object[])new Object[0]), this.getView().getFormShowParameter().getFormConfig().getCaption());
                this.getView().showErrorNotification(msg);
                return;
            }
            this.showParamCopyView();
        }
        if (BT_PARAM_COPY_RESULT.equals(itemKey)) {
            if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"3RQA8F3+C/3C")) {
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u53c2\u6570\u590d\u5236\u7ed3\u679c\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ParamConsolePlugin_1", (String)BOS_PARAMETER, (Object[])new Object[0]), this.getView().getFormShowParameter().getFormConfig().getCaption());
                this.getView().showErrorNotification(msg);
                return;
            }
            this.showCopyRes();
        }
    }

    private void showCopyRes() {
        ListShowParameter paramCopyResShow = new ListShowParameter();
        paramCopyResShow.setBillFormId("bos_svc_paramcopy_result");
        paramCopyResShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)paramCopyResShow);
    }

    private void showParamCopyView() {
        BillShowParameter paramCopyShow = new BillShowParameter();
        paramCopyShow.setCustomParam("isFromSettingForm", (Object)"true");
        boolean treeOrg = ParameterOrgUtils.isTreeOrg();
        if (treeOrg) {
            paramCopyShow.setFormId("bos_svc_parametercopy");
        } else {
            paramCopyShow.setFormId("bos_svc_parametercopy_xk");
        }
        paramCopyShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String gcPageId = this.getPageCache().get("copyParamPageId");
        if (StringUtils.isNotBlank((CharSequence)gcPageId)) {
            paramCopyShow.setPageId(gcPageId);
        } else {
            this.getPageCache().put("copyParamPageId", paramCopyShow.getPageId());
        }
        this.getView().showForm((FormShowParameter)paramCopyShow);
    }

    private static Map<String, String> getItemMap() {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        itemMap.put("goto1", "portal");
        itemMap.put("goto2", "thirdappparam");
        itemMap.put("goto3", "loginparam");
        itemMap.put("goto4", "baseservice");
        itemMap.put("goto5", "bos_fileserverconfig");
        return itemMap;
    }

    private void gotoNode(String text) {
        Map<String, String> treeNodeMap = this.getTreeNodeMapFromCache();
        if (!treeNodeMap.containsKey(text)) {
            return;
        }
        String nodeJson = treeNodeMap.get(text);
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)nodeJson, TreeNode.class);
        Tab tab = (Tab)this.getView().getControl("tabgroupap");
        tab.selectTab(TabStatus.SYS_APP_TAB[0]);
        tab.activeTab(TabStatus.SYS_APP_TAB[0]);
        this.initialize();
        TreeView tree = (TreeView)this.paramConsolePlugin.getControl("systreeviewap");
        tree.focusNode(treeNode);
        tree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private boolean isSysPanel() {
        String tableKey = this.getPageCache().get(TAB_KEY);
        return !"tabpageapp".equals(tableKey);
    }

    private Map<String, String> getTreeNodeMapFromCache() {
        String cacheKey = "systemNodes";
        IPageCache pageCache = this.getPageCache();
        String cacheJson = pageCache.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheJson)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)cacheJson, Map.class);
            return map;
        }
        Map bosSysparamGroup = BusinessDataServiceHelper.loadFromCache((String)"bos_sysparam_group", (String)"id,number,name,param_formid,plugins,pluginparam", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C")}, (String)"sort asc");
        HashMap<String, String> treeNodeMap = new HashMap<String, String>(bosSysparamGroup.size());
        for (DynamicObject dyObj : bosSysparamGroup.values()) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("formId", dyObj.getString("param_formid"));
            data.put("plugins", dyObj.getString("plugins"));
            data.put("pluginparam", dyObj.getString("pluginparam"));
            TreeNode treeNode = new TreeNode("", String.valueOf(dyObj.getLong("id")), dyObj.getString("number"), data);
            treeNodeMap.put(treeNode.getText(), SerializationUtils.toJsonString((Object)treeNode));
        }
        pageCache.put(cacheKey, SerializationUtils.toJsonString(treeNodeMap));
        return treeNodeMap;
    }

    private AbstractParamConsolePlugin getAppPlugin() {
        if (ParameterOrgUtils.isTreeOrg()) {
            return new AppParamConsolePlugin();
        }
        return new FlatOrgAppParamConsolePlugin();
    }
}

