/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.ParamConvert;
import kd.bos.entity.param.ParamKey;
import kd.bos.entity.param.ParamRow;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ParameterUtils {
    public static DynamicObjectCollection queryAllOrgParams(List<Long> orgs, String viewType, String paramId) {
        DynamicObjectType dt = new DynamicObjectType("tempObject");
        dt.registerSimpleProperty(new DynamicSimpleProperty("FORGID", Long.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("FDATA", String.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("FLOCKFIELDS", String.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("FPARAMCONFIG", String.class, (Object)""));
        DynamicObject tempObject = null;
        ORM orm = ORM.create();
        QFilter f1 = new QFilter("FVIEWTYPEID", "=", (Object)viewType);
        QFilter f2 = new QFilter("FPARAMID", "=", (Object)paramId);
        QFilter f3 = new QFilter("FACCTBOOKID", "=", (Object)0);
        QFilter f4 = new QFilter("FORGID", "in", orgs);
        QFilter f5 = new QFilter("FACCTINGBOOKID", "=", (Object)0);
        QFilter[] qf = new QFilter[]{f1, f2, f3, f4, f5};
        DynamicObjectCollection dynamicObjectCollection = orm.query("bos_svc_sysparameter", "id,FORGID,FDATA,FLOCKFIELDS,FPARAMCONFIG", qf);
        DynamicObjectCollection newDoc = new DynamicObjectCollection(dt, null);
        for (DynamicObject d : dynamicObjectCollection) {
            tempObject = new DynamicObject(dt);
            tempObject.set("FORGID", d.get("FORGID"));
            tempObject.set("FDATA", d.get("FDATA"));
            tempObject.set("FLOCKFIELDS", d.get("FLOCKFIELDS"));
            tempObject.set("FPARAMCONFIG", d.get("FPARAMCONFIG"));
            newDoc.add((Object)tempObject);
        }
        return newDoc;
    }

    public static List<Map<String, Object>> getOrgDataFromDB(String formId, List<Long> orgIds, String viewType, String subSystem) {
        DynamicObjectCollection collection = ParameterUtils.queryAllOrgParams(orgIds, viewType, subSystem);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = null;
        for (DynamicObject object : collection) {
            map = new HashMap<String, Object>();
            map.put("orgId", object.get(0));
            map.put("data", kd.bos.param.ParameterUtils.serializeToDataEntity(object.get(1).toString(), formId));
            map.put("lockfields", object.get(2));
            list.add(map);
        }
        return list;
    }

    public static Map<ParamKey, ParamRow> getOrgParamRows(String formId, String viewType, String paramId, List<Long> orgIds) {
        List<Map<String, Object>> list = ParameterUtils.getFormatOrgDataFromDB(formId, orgIds, viewType, paramId);
        List paramItems = ParamConvert.getParamItems((String)formId);
        Map rows = ParamConvert.getParamFormatRows(list, (List)paramItems);
        for (Map.Entry row : rows.entrySet()) {
            ParamRow paramRow = (ParamRow)row.getValue();
            if (paramRow.getValue() != null) continue;
            paramRow.setValue((Object)"");
        }
        return rows;
    }

    public static String getViewTypeName(String viewType) {
        Long id = StringUtils.isBlank((CharSequence)viewType) ? 0L : Long.parseLong(viewType);
        QFilter f1 = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{f1};
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"bos_org_biz", (String)"id, fnumber, ffieldname, fname", (QFilter[])filters, (String)"id");
        if (dynamicObject == null || dynamicObject.length == 0) {
            return "";
        }
        return dynamicObject[0].getLocaleString("fname").toString();
    }

    private static List<Map<String, Object>> getFormatOrgDataFromDB(String formId, List<Long> orgIds, String viewType, String paramId) {
        DynamicObjectCollection collection = ParameterUtils.queryAllOrgParams(orgIds, viewType, paramId);
        List list = ParameterHelper.getOrgsFormatParams((DynamicObjectCollection)collection, (String)formId);
        return list;
    }
}

