/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.control.Button;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;

public class PrintConditionPlugin
extends AbstractFormPlugin
implements BeforeFilterF7SelectListener {
    private static final String KEY_FILTERGRID = "filtergridap";
    private static final String FORMID = "formId";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        FilterGrid filtergridap = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        filtergridap.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        String printcondition;
        Map cusParams = this.getView().getFormShowParameter().getCustomParams();
        String formId = (String)cusParams.get(FORMID);
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
            ArrayList<Map> filterColumns = new ArrayList<Map>(10);
            List<FilterField> filterFields = this.getFilterFields((IDataEntityType)entityType, true);
            for (FilterField filterField : filterFields) {
                Map filterColumn = filterField.createFilterColumn();
                filterColumns.add(filterColumn);
            }
            ArrayList<Map> cols = filterColumns;
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(formId);
        }
        if (StringUtils.isNotBlank((CharSequence)(printcondition = (String)cusParams.get("printcondition")))) {
            this.getModel().setValue("conditionname", (Object)printcondition);
        }
    }

    public void afterBindData(EventObject e) {
        String printconditionvalue = (String)this.getView().getFormShowParameter().getCustomParam("printconditionvalue");
        if (StringUtils.isNotBlank((CharSequence)printconditionvalue)) {
            FilterCondition fCondition = (FilterCondition)SerializationUtils.fromJsonString((String)printconditionvalue, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
            filterGrid.SetValue(fCondition);
        }
    }

    private String getFilterInfo() {
        String filter = "";
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        if (condition != null) {
            filter = SerializationUtils.toJsonString((Object)condition);
        }
        return filter;
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("title", this.getModel().getValue("conditionname"));
                para.put("value", this.getFilterInfo());
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(para));
                this.getView().close();
                break;
            }
        }
    }

    private List<FilterField> getFilterFields(IDataEntityType dataEntityType, boolean isOnlyMainEntityField) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        MainEntityType mainType = (MainEntityType)dataEntityType;
        for (IDataEntityProperty fieldProp : mainType.getAllFields().values()) {
            if (!(fieldProp instanceof IFieldHandle)) continue;
            boolean isFilterField = true;
            IDataEntityType parentType = fieldProp.getParent();
            if (null != parentType && parentType instanceof LinkEntryType) continue;
            if (isOnlyMainEntityField && !(parentType instanceof MainEntityType)) {
                isFilterField = false;
            }
            if (!isFilterField) continue;
            List list = ((IFieldHandle)fieldProp).createFilterFields(mainType);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                FilterField ff = (FilterField)it.next();
                if (!ff.isFieldPropAliasEmpty()) continue;
                it.remove();
            }
            filterFields.addAll(list);
        }
        return filterFields;
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
        if ("bos_billtype".equals(arg0.getRefEntityId())) {
            Map cusParams = this.getView().getFormShowParameter().getCustomParams();
            String formId = (String)cusParams.get(FORMID);
            ArrayList<QFilter> qfList = new ArrayList<QFilter>();
            qfList.add(new QFilter("billformid.number", "=", (Object)formId));
            arg0.setCustomQFilters(qfList);
        }
    }
}

