/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.param.AbstractParamConsolePlugin;
import kd.bos.form.plugin.param.TabStatus;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterLog;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SysParamConsolePlugin
extends AbstractParamConsolePlugin {
    private static final String TREENODE_CACHEKEY = "sysparam_treeNode";
    private static final String CACHE_CUR_NODE = "sys_curNodeId";

    @Override
    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getControl("systreeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    @Override
    protected TreeView getTreeView() {
        TreeView tree = (TreeView)this.getControl("systreeviewap");
        return tree;
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"appleftpanel", "apprightpanel"});
        List<TreeNode> treeNodes = this.buildTreeNode();
        TreeView tree = (TreeView)this.getView().getControl("systreeviewap");
        tree.addNodes(treeNodes);
        TreeNode firstNode = treeNodes.get(0);
        tree.focusNode(firstNode);
        this.treeNodeClick(firstNode.getId());
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpagesys".equals(tabKey)) {
            this.changeSysTob();
            this.getView().setVisible(Boolean.TRUE, new String[]{"sysleftpanel", "sysrightpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"appleftpanel", "apprightpanel"});
            String curNodeId = this.getPageCache().get(CACHE_CUR_NODE);
            this.treeNodeClick(curNodeId);
        }
    }

    @Override
    protected void save() {
        String msg = "";
        TabStatus tabStatus = this.getStatus();
        String sysParamPageId = tabStatus.getSysParamPageId();
        IFormView parameterView = this.getSysView(sysParamPageId);
        if (sysParamPageId == null || parameterView == null) {
            msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u662f\u5426\u6253\u5f00\u53c2\u6570\u8868\u5355\u6216\u68c0\u67e5\u64cd\u4f5c\u6743\u9650\u3002", (String)"ParameterConsolePlugin_3", (String)"bos-parameter", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        IDataModel dataModel = (IDataModel)parameterView.getService(IDataModel.class);
        DynamicObject dataEntity = dataModel.getDataEntity();
        if (dataModel instanceof IParameterModel ? !this.validate(parameterView, dataEntity, dataModel) : !this.checkCustomParams(parameterView)) {
            return;
        }
        if (dataModel instanceof IParameterModel) {
            super.saveAppParam(dataModel);
        } else {
            this.saveCustomParams(dataModel);
        }
        msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ParameterConsolePlugin_2", (String)"bos-parameter", (Object[])new Object[0]);
        this.getView().showSuccessNotification(msg);
    }

    private IFormView getSysView(String sysParamPageId) {
        IFormView view = null;
        try {
            view = this.getView().getView(sysParamPageId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (view == null) {
            ParameterLog.info("view=null");
            view = this.getView().getViewNoPlugin(sysParamPageId);
        }
        return view;
    }

    private void saveCustomParams(IDataModel dataModel) {
        Map<String, String> preCustomMap = parameterReaderService.loadCustomParameterFromCache(new CustomParam());
        DynamicObjectCollection entryentity = dataModel.getEntryEntity("entryentity");
        String nodeId = this.getPageCache().get(CACHE_CUR_NODE);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_customparam");
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(10);
        for (DynamicObject dyObj : entryentity) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            dynamicObject.set("key", dyObj.get("key"));
            dynamicObject.set("number", (Object)ID.genStringId());
            dynamicObject.set("name", dyObj.get("name"));
            dynamicObject.set("value", dyObj.get("value"));
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("group", (Object)Long.parseLong(nodeId));
            saveObjs.add(dynamicObject);
        }
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(nodeId))});
        Object[] pkIds = dynamicObjectMap.keySet().toArray(new Object[0]);
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])pkIds);
        SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
        ThreadCache.remove((Object)"parameterCustom");
        Map<String, String> currCustomMap = parameterReaderService.loadCustomParameterFromCache(new CustomParam());
        this.addCustomLog(preCustomMap, currCustomMap);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.treeNodeClick(nodeId);
    }

    private void treeNodeClick(String nodeId) {
        String treeNodeStr = this.getPageCache().get(TREENODE_CACHEKEY);
        List treeNodeList = (List)SerializationUtils.fromJsonString((String)treeNodeStr, List.class);
        Map treeNode = treeNodeList.stream().filter(item -> StringUtils.equals((CharSequence)nodeId, (CharSequence)String.valueOf(item.get("id")))).findAny().get();
        Map data = (Map)treeNode.get("data");
        String formId = (String)data.get("formId");
        FormShowParameter showParameter = this.getFormShowParameter(nodeId, data, formId);
        this.setSysParamPageId(showParameter);
        this.getPageCache().put(CACHE_CUR_NODE, nodeId);
        this.getView().showForm(showParameter);
    }

    private FormShowParameter getFormShowParameter(String nodeId, Map<String, Object> data, String formId) {
        Object pluginParam;
        ParameterShowParameter showParameter;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"bizappid,modeltype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId)});
        if ("DynamicFormModel".equals(dynamicObject.getString("modeltype"))) {
            FormShowParameter showParameter2 = new FormShowParameter();
            showParameter2.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter2.getOpenStyle().setTargetKey("sysrightpanel");
            showParameter2.setCustomParam("groupId", (Object)nodeId);
            showParameter2.setFormId(formId);
            showParameter2.setCustomParam("isSys", (Object)"true");
            showParameter2.setHasRight(true);
            return showParameter2;
        }
        Set<String> appFormIdSet = this.getAppFormIdSet();
        if (appFormIdSet.contains(formId)) {
            String bizappid = dynamicObject.getString("bizappid");
            ORM orm = ORM.create();
            QFilter qFilter = new QFilter("id", "=", (Object)bizappid);
            DynamicObject bizApp = orm.queryOne("bos_devportal_bizapp", "id,orgfunc", new QFilter[]{qFilter});
            String viewType = bizApp.getString("orgfunc");
            viewType = StringUtils.isBlank((CharSequence)viewType) ? "15" : viewType;
            showParameter = this.getAppParameterFormShowParameter("sysrightpanel", formId, ParameterOrgUtils.getParamRootOrgId(), 0L, 0L, viewType, "", bizappid);
        } else {
            showParameter = new ParameterShowParameter();
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("sysrightpanel");
        showParameter.setFormId(formId);
        long rootOrgId = ParameterOrgUtils.getParamRootOrgId();
        showParameter.setCustomParam("orgid", (Object)rootOrgId);
        showParameter.setCustomParam("groupId", (Object)nodeId);
        String plugins = String.valueOf(data.get("plugins"));
        if (StringUtils.isNotBlank((CharSequence)plugins)) {
            String[] split;
            for (String plugin : split = plugins.split(";")) {
                showParameter.addCustPlugin(plugin);
            }
        }
        if ((pluginParam = data.get("pluginparam")) != null && StringUtils.isNotBlank((CharSequence)pluginParam.toString())) {
            showParameter.setCustomParam("pluginParam", (Object)pluginParam.toString());
        }
        showParameter.setHasRight(true);
        return showParameter;
    }

    private Set<String> getAppFormIdSet() {
        HashSet<String> appFormIdSet = new HashSet<String>(3);
        appFormIdSet.add("bos_base_parameter");
        appFormIdSet.add("isc_parasetting");
        appFormIdSet.add("bos_devp_paramconfig");
        appFormIdSet.add("kapiparameter");
        return appFormIdSet;
    }

    private List<TreeNode> buildTreeNode() {
        List<TreeNode> treeNodeList = this.getTreeNodesFromDB();
        this.getView().getPageCache().put(TREENODE_CACHEKEY, SerializationUtils.toJsonString(treeNodeList));
        return treeNodeList;
    }

    private List<TreeNode> getTreeNodesFromDB() {
        Map bosSysparamGroup = BusinessDataServiceHelper.loadFromCache((String)"bos_sysparam_group", (String)"id,number,name,param_formid,plugins,pluginparam", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C")}, (String)"sort asc");
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(bosSysparamGroup.size());
        for (DynamicObject dyObj : bosSysparamGroup.values()) {
            String paramFormId = dyObj.getString("param_formid");
            if (DevVerifyServiceHelper.isOEMEnv() && "isc_parasetting".equals(paramFormId)) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("formId", paramFormId);
            data.put("plugins", dyObj.getString("plugins"));
            data.put("pluginparam", dyObj.getString("pluginparam"));
            TreeNode treeNode = new TreeNode("", String.valueOf(dyObj.getLong("id")), dyObj.getString("name"), data);
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }
}

