/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param.groupcontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.form.plugin.param.groupcontrol.GroupControlConfig;
import kd.bos.form.plugin.param.groupcontrol.SelectParamConfig;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class GroupControlUtil {
    public static Map<Long, Map<String, Object>> getOrgParamValueMap(AppParam appParam, DynamicObjectCollection paramDynamicObjects) {
        HashMap<Long, Map<String, Object>> res = new HashMap<Long, Map<String, Object>>(16);
        if (CollectionUtils.isEmpty((Collection)paramDynamicObjects)) {
            return res;
        }
        List orgParams = ParameterHelper.getOrgsFormatParams((DynamicObjectCollection)paramDynamicObjects, (String)appParam.getFormId());
        if (CollectionUtils.isEmpty((Collection)orgParams)) {
            return res;
        }
        for (Map map : orgParams) {
            Map dataMap = new HashMap(16);
            Object data = map.get("data");
            if (data instanceof Map) {
                dataMap = (Map)data;
            }
            Long orgId = Long.valueOf(String.valueOf(map.get("orgId")));
            res.put(orgId, dataMap);
        }
        return res;
    }

    public static String getShowValue(String fieldKey, Map<String, Object> currOrgValueMap, Map<Long, Map<String, Object>> orgParamValueMap, List<Long> parentOrgIds, Map<Long, Set<String>> parentLockMap) {
        Set<String> parentLockSet = GroupControlUtil.getParentLockSet(parentLockMap);
        boolean isLockField = parentLockSet.contains(fieldKey);
        if (!isLockField) {
            if (!currOrgValueMap.isEmpty()) {
                Object v = currOrgValueMap.get(fieldKey);
                if (v == null) {
                    return "";
                }
                return String.valueOf(v);
            }
            for (Long parentOrgId : parentOrgIds) {
                if (!orgParamValueMap.containsKey(parentOrgId)) continue;
                Map<String, Object> parentValueMap = orgParamValueMap.get(parentOrgId);
                Object v = parentValueMap.get(fieldKey);
                if (v == null) {
                    return "";
                }
                return String.valueOf(v);
            }
            return "";
        }
        if (currOrgValueMap.containsKey(fieldKey)) {
            Object v = currOrgValueMap.get(fieldKey);
            if (StringUtils.isNotBlank((Object)v)) {
                return String.valueOf(v);
            }
            return GroupControlUtil.getControlOrgFieldValue(fieldKey, orgParamValueMap, parentOrgIds, parentLockMap);
        }
        return GroupControlUtil.getControlOrgFieldValue(fieldKey, orgParamValueMap, parentOrgIds, parentLockMap);
    }

    private static String getControlOrgFieldValue(String fieldKey, Map<Long, Map<String, Object>> orgParamValueMap, List<Long> parentOrgIds, Map<Long, Set<String>> parentLockMap) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, Set<String>> entry : parentLockMap.entrySet()) {
            Set<String> value = entry.getValue();
            if (!value.contains(fieldKey)) continue;
            orgIdList.add(entry.getKey());
        }
        HashMap<Long, Integer> orgIndexMap = new HashMap<Long, Integer>(16);
        for (int index = 0; index < parentOrgIds.size(); ++index) {
            orgIndexMap.put(parentOrgIds.get(index), index);
        }
        orgIdList.sort((o1, o2) -> (Integer)orgIndexMap.get(o2) - (Integer)orgIndexMap.get(o1));
        Long lockOrgId = (Long)orgIdList.get(0);
        Integer start = (Integer)orgIndexMap.get(lockOrgId);
        for (int i = start.intValue(); i < parentOrgIds.size(); ++i) {
            Long parentOrgId = parentOrgIds.get(i);
            if (!orgParamValueMap.containsKey(parentOrgId)) continue;
            Map<String, Object> parentValueMap = orgParamValueMap.get(parentOrgId);
            Object fieldValue = parentValueMap.get(fieldKey);
            return String.valueOf(fieldValue);
        }
        return "";
    }

    public static DynamicObjectCollection getParamDynamicObjects(AppParam appParam) {
        QFilter[] qFilters = new QFilter[]{new QFilter("FPARAMID", "=", (Object)appParam.getParamId()), new QFilter("FVIEWTYPEID", "=", (Object)appParam.getViewType()), new QFilter("FACCTBOOKID", "=", (Object)appParam.getActBookId()), new QFilter("FACCTINGBOOKID", "=", (Object)appParam.getAcctingBookId()), new QFilter("FORGID", "in", (Object)appParam.getOrgIds())};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_svc_sysparameter", (String)"forgid,fdata,fparamconfig,flockfields", (QFilter[])qFilters);
        return dynamicObjects;
    }

    public static Map<Long, GroupControlConfig> getParamGroupControlConfig(AppParam appParam, DynamicObjectCollection paramDynamicObjects) {
        HashMap<Long, GroupControlConfig> res = new HashMap<Long, GroupControlConfig>(16);
        for (Long orgId : appParam.getOrgIds()) {
            res.put(orgId, new GroupControlConfig());
        }
        for (DynamicObject dynamicObject : paramDynamicObjects) {
            long orgId = dynamicObject.getLong("forgid");
            String selectParamConfigJson = dynamicObject.getString("fparamconfig");
            String lockFieldsMapJson = dynamicObject.getString("flockfields");
            GroupControlConfig groupControlConfig = (GroupControlConfig)res.get(orgId);
            if (StringUtils.isNotBlank((CharSequence)selectParamConfigJson)) {
                SelectParamConfig selectParamConfig = (SelectParamConfig)SerializationUtils.fromJsonString((String)selectParamConfigJson, SelectParamConfig.class);
                groupControlConfig.setSelectParamConfig(selectParamConfig);
            }
            if (!StringUtils.isNotBlank((CharSequence)lockFieldsMapJson)) continue;
            Map lockMap = (Map)SerializationUtils.fromJsonString((String)lockFieldsMapJson, Map.class);
            groupControlConfig.getLockFieldMap().putAll(lockMap);
        }
        return res;
    }

    public static Set<String> getParentLockSet(Map<Long, Set<String>> parentLockMap) {
        HashSet<String> parentLockSet = new HashSet<String>(16);
        parentLockMap.values().forEach(parentLockSet::addAll);
        return parentLockSet;
    }

    public static Map<Long, Set<String>> getParentLockMap(Map<Long, GroupControlConfig> paramGroupControlConfig, List<Long> parentIds) {
        HashMap<Long, Set<String>> res = new HashMap<Long, Set<String>>(16);
        for (Long parentId : parentIds) {
            HashSet parentLockSet = new HashSet(16);
            GroupControlConfig parentConfig = paramGroupControlConfig.get(parentId);
            if (parentConfig == null) {
                res.put(parentId, parentLockSet);
                continue;
            }
            Map<String, Boolean> lockFieldMap = parentConfig.getLockFieldMap();
            List lockFields = lockFieldMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            parentLockSet.addAll(lockFields);
            res.put(parentId, parentLockSet);
        }
        return res;
    }
}

