/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param.groupcontrol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.param.groupcontrol.GroupControlConfig;
import kd.bos.form.plugin.param.groupcontrol.GroupControlUtil;
import kd.bos.form.plugin.param.groupcontrol.SearchResult;
import kd.bos.form.plugin.param.groupcontrol.SelectParam;
import kd.bos.form.plugin.param.groupcontrol.SelectParamConfig;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParamOpLogUtils;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;

public class ParamGroupControlPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(ParamGroupControlPlugin.class);
    private static final String APP_TREE = "app_treeviewap";
    private static final String SEARCH = "app_orgview_searchap";
    private static final String TOOL_BAR_SAVE_CLOSE = "btntoolbarap";
    private static final String BT_SAVE = "btnsave";
    private static final String CACHE_VIEW_TYPE = "CACHE_VIEW_TYPE";
    private static final String CACHE_TREE_NODES = "CACHE_TREE_NODES";
    private static final String CACHE_SEARCH_RESULT = "CACHE_SEARCH_RESULT";
    private static final String CACHE_ORG_IDS = "CACHE_ORG_IDS";
    private static final String CACHE_ORG_PARENT = "CACHE_ORG_PARENT";
    private static final String FOCUS_NODE_ID = "FOCUS_NODE_ID";
    private static final String BOS_PARAMETER = "bos-parameter";
    private static final IParameterReaderService readerService = new ParameterReaderServiceImpl();

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getControl(APP_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{TOOL_BAR_SAVE_CLOSE, "org_advcontoolbarap", "toolbar_param_list"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        this.focusAppNode();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if ("choose_org".equals(actionId)) {
            this.addOrgRows(returnData);
            return;
        }
        if ("btn_select_param".equals(actionId)) {
            this.fillParamRows(returnData);
            this.getModel().updateCache();
        }
    }

    private void fillParamRows(Object returnData) {
        String newSelectParamListJson;
        List newSelectParamList;
        if (returnData == null) {
            return;
        }
        Map paramsMap = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
        String selectedFields = (String)paramsMap.get("selectedFields");
        if (StringUtils.isBlank((CharSequence)selectedFields)) {
            this.getModel().deleteEntryData("param_entry");
            return;
        }
        String appId = this.getTreeFocusNodeId();
        ParamPublishObject parameterObject = readerService.getParameterObject(null, appId);
        String formId = parameterObject.getFormId();
        Map<String, SelectParam> metaDataParam = this.getMetaDataParamFromCache(formId);
        String delSelectParamListJson = (String)paramsMap.get("delSelectParamList");
        List delSelectParamList = SerializationUtils.fromJsonStringToList((String)delSelectParamListJson, SelectParam.class);
        if (!CollectionUtils.isEmpty((Collection)delSelectParamList)) {
            ArrayList deleteIndexList = new ArrayList(delSelectParamList.size());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("param_entry");
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>(entryEntity.size());
            for (int index = 0; index < entryEntity.size(); ++index) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
                indexMap.put(dynamicObject.getString("fieldid"), index);
            }
            for (SelectParam selectParam : delSelectParamList) {
                String id = selectParam.getId();
                deleteIndexList.add(indexMap.get(id));
            }
            int[] delRows = new int[deleteIndexList.size()];
            for (int i = 0; i < delRows.length; ++i) {
                delRows[i] = (Integer)deleteIndexList.get(i);
            }
            Arrays.sort(delRows);
            this.getModel().deleteEntryRows("param_entry", delRows);
        }
        String indexMapJson = (String)paramsMap.get("indexMap");
        Map indexMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)indexMapJson)) {
            indexMap = (Map)SerializationUtils.fromJsonString((String)indexMapJson, Map.class);
        }
        if (!CollectionUtils.isEmpty((Collection)(newSelectParamList = SerializationUtils.fromJsonStringToList((String)(newSelectParamListJson = (String)paramsMap.get("newSelectParamList")), SelectParam.class)))) {
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            tableValueSetter.addField("fieldid", new Object[0]);
            tableValueSetter.addField("fieldkey", new Object[0]);
            tableValueSetter.addField("param_value", new Object[0]);
            tableValueSetter.addField("param_name", new Object[0]);
            tableValueSetter.addField("lock_sub", new Object[0]);
            tableValueSetter.addField("lock_modify", new Object[0]);
            tableValueSetter.addField("synparam", new Object[0]);
            for (SelectParam selectParam : newSelectParamList) {
                tableValueSetter.addRow(new Object[]{selectParam.getId(), selectParam.getFieldKey(), selectParam.getValue(), selectParam.getName(), selectParam.checkIsControl(), selectParam.getLockModify(), selectParam.isSyncParams()});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("param_entry", tableValueSetter);
        }
        DynamicObjectCollection paramEntry = this.getModel().getEntryEntity("param_entry");
        Map finalIndexMap = indexMap;
        paramEntry.sort(Comparator.comparingInt(r -> finalIndexMap.getOrDefault(r.getString("fieldid"), 0)));
        this.getView().updateView("param_entry");
    }

    private void addOrgRows(Object returnData) {
        if (!(returnData instanceof ListSelectedRowCollection)) {
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"btn_select_param"});
        ListSelectedRowCollection selectedOrgRows = (ListSelectedRowCollection)returnData;
        String appId = this.getTreeFocusNodeId();
        Map<String, String> viewTypeMap = this.getAppViewTypeMapFromCache();
        String viewType = viewTypeMap.get(appId);
        List<Long> orgPkIds = selectedOrgRows.stream().map(selectedOrgRow -> (Long)selectedOrgRow.getPrimaryKeyValue()).collect(Collectors.toList());
        this.getSuperiorOrgMapFromCache(viewType, orgPkIds);
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("org", new Object[0]);
        tableValueSetter.addField("gc_count", new Object[0]);
        for (Long orgPkId : orgPkIds) {
            tableValueSetter.addRow(new Object[]{orgPkId, "0"});
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("orglist");
        int orgListSize = entryEntity == null ? 0 : entryEntity.size();
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("orglist", tableValueSetter);
        this.selectOrgListRow(orgListSize);
    }

    private int getOrgFocusRow() {
        EntryGrid eg = (EntryGrid)this.getControl("orglist");
        int focusRow = eg.getEntryState().getFocusRow();
        if (focusRow == -1) {
            focusRow = 0;
        }
        return focusRow;
    }

    boolean checkPermission(String permItem, String entityId) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)entityId, (String)permItem);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BT_SAVE.equals(itemKey)) {
            if (!this.checkPermission("3J6/+NF038+5", this.getView().getEntityId())) {
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractParamConsolePlugin_2", (String)BOS_PARAMETER, (Object[])new Object[0]), this.getView().getFormShowParameter().getFormConfig().getCaption());
                this.getView().showErrorNotification(msg);
                return;
            }
            this.save();
        }
        if ("choose_org".equals(itemKey)) {
            this.showOrgF7Form();
        }
        if ("btn_select_param".equals(itemKey)) {
            this.showSelectParamForm();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObjectCollection entryEntity;
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("deleteorgentry".equals(operateKey) && CollectionUtils.isEmpty((Collection)(entryEntity = this.getModel().getEntryEntity("orglist")))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_select_param"});
        }
    }

    private void save() {
        Serializable deleteOrgId2;
        SqlParameter[] sqlParams;
        DynamicObjectCollection orgEntry = this.getModel().getEntryEntity("orglist");
        Set<Long> preOrgIdSet = this.getPreOrgIdSetFromCache();
        Set orgSet = orgEntry.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("org") != null).map(dynamicObject -> dynamicObject.getLong("org_id")).collect(Collectors.toSet());
        Set deleteOrgIdSet = preOrgIdSet.stream().filter(preOgrId -> !orgSet.contains(preOgrId)).collect(Collectors.toSet());
        Set<Long> insertOrgIdSet = orgSet.stream().filter(ogrId -> !preOrgIdSet.contains(ogrId)).collect(Collectors.toSet());
        Set<Long> updateOrgIdSet = preOrgIdSet.stream().filter(orgSet::contains).collect(Collectors.toSet());
        String insertSql = " INSERT INTO T_BAS_SYSPARAMETER(fid,forgid,fviewtypeid,facctbookid,facctingbookid,fparamid,flockfields,fparamconfig) values(?,?,?,?,?,?,?,?) ";
        String updateSql = " UPDATE T_BAS_SYSPARAMETER SET flockfields=?, fparamconfig=? WHERE fparamid=? AND fviewtypeid=? AND forgid=? AND facctbookid=? AND facctingbookid=? ";
        AppParam appParam = this.buildDefaultAppParam();
        ArrayList<Object[]> updateSqlParamList = new ArrayList<Object[]>(10);
        ArrayList<SqlParameter[]> insertSqlParamList = new ArrayList<SqlParameter[]>(10);
        appParam.setOrgIds(new ArrayList(insertOrgIdSet));
        Set<Long> exitOrgSet = ParamGroupControlPlugin.getExitOrgSet(appParam);
        Set toInsertOrgIdSet = insertOrgIdSet.stream().filter(orgId -> !exitOrgSet.contains(orgId)).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(toInsertOrgIdSet)) {
            for (Long orgId2 : toInsertOrgIdSet) {
                sqlParams = new SqlParameter[]{new SqlParameter("fid", 12, (Object)Uuid16.create().toString()), new SqlParameter("forgid", -5, (Object)orgId2), new SqlParameter("fviewtypeid", 12, (Object)appParam.getViewType()), new SqlParameter("facctbookid", -5, (Object)appParam.getActBookId()), new SqlParameter("facctingbookid", -5, (Object)appParam.getAcctingBookId()), new SqlParameter("fparamid", 12, (Object)appParam.getParamId()), new SqlParameter("flockfields", 12, null), new SqlParameter("fparamconfig", 12, null)};
                insertSqlParamList.add(sqlParams);
            }
        }
        if (!CollectionUtils.isEmpty(deleteOrgIdSet)) {
            for (Serializable deleteOrgId2 : deleteOrgIdSet) {
                sqlParams = new SqlParameter[]{new SqlParameter("flockfields", 12, null), new SqlParameter("fparamconfig", 12, null), new SqlParameter("fparamid", 12, (Object)appParam.getParamId()), new SqlParameter("fviewtypeid", 12, (Object)appParam.getViewType()), new SqlParameter("forgid", -5, (Object)deleteOrgId2), new SqlParameter("facctbookid", -5, (Object)appParam.getActBookId()), new SqlParameter("facctingbookid", -5, (Object)appParam.getAcctingBookId())};
                updateSqlParamList.add(sqlParams);
            }
        }
        this.genUpdateSqlParamList(orgEntry, insertOrgIdSet, appParam, updateSqlParamList);
        this.genUpdateSqlParamList(orgEntry, updateOrgIdSet, appParam, updateSqlParamList);
        TXHandle tx = TX.required();
        deleteOrgId2 = null;
        try {
            try {
                if (!CollectionUtils.isEmpty(insertSqlParamList)) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertSqlParamList);
                }
                if (!CollectionUtils.isEmpty(updateSqlParamList)) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateSql, updateSqlParamList);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                throw e;
            }
        }
        catch (Throwable e) {
            deleteOrgId2 = e;
            throw e;
        }
        finally {
            if (tx != null) {
                if (deleteOrgId2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)deleteOrgId2).addSuppressed(e);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.cachePreOrgIdSet(orgEntry);
        String successMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ParameterDimenSetPlugin_0", (String)BOS_PARAMETER, (Object[])new Object[0]);
        this.getView().showSuccessNotification(successMsg);
        ParamOpLogUtils.addLog(this.getView(), "save", new MultiLangEnumBridge("\u4fdd\u5b58", "AbstractParamConsolePlugin_0", BOS_PARAMETER).getDescription(), null);
        int orgFocusRow = this.getOrgFocusRow();
        TreeNode root = this.getRootNodeFromCache();
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        TreeNode appNode = root.getTreeNode(focusNodeId);
        this.getPageCache().remove(FOCUS_NODE_ID);
        this.clickNode(appNode);
        this.selectOrgListRow(orgFocusRow);
    }

    private void genUpdateSqlParamList(DynamicObjectCollection orgEntry, Set<Long> updateOrgIdSet, AppParam appParam, List<Object[]> updateSqlParamList) {
        Map<Long, GroupControlConfig> updateConfigMap = this.getConfigMap(orgEntry, updateOrgIdSet);
        if (!CollectionUtils.isEmpty(updateOrgIdSet)) {
            for (Long orgId : updateOrgIdSet) {
                GroupControlConfig config = updateConfigMap.get(orgId);
                SqlParameter[] sqlParams = new SqlParameter[]{new SqlParameter("flockfields", 12, (Object)SerializationUtils.toJsonString(config.getLockFieldMap())), new SqlParameter("fparamconfig", 12, (Object)SerializationUtils.toJsonString((Object)config.getSelectParamConfig())), new SqlParameter("fparamid", 12, (Object)appParam.getParamId()), new SqlParameter("fviewtypeid", 12, (Object)appParam.getViewType()), new SqlParameter("forgid", -5, (Object)Long.parseLong(orgId.toString())), new SqlParameter("facctbookid", -5, (Object)appParam.getActBookId()), new SqlParameter("facctingbookid", -5, (Object)appParam.getAcctingBookId())};
                updateSqlParamList.add(sqlParams);
            }
        }
    }

    private Map<Long, GroupControlConfig> getConfigMap(DynamicObjectCollection orgEntry, Set<Long> filterOrgIdSet) {
        HashMap<Long, GroupControlConfig> configMap = new HashMap<Long, GroupControlConfig>(16);
        int index = 0;
        for (DynamicObject dynamicObject : orgEntry) {
            ++index;
            long orgId = dynamicObject.getLong("org_id");
            if (!filterOrgIdSet.contains(orgId)) continue;
            GroupControlConfig config = new GroupControlConfig();
            SelectParamConfig selectParamConfig = new SelectParamConfig();
            config.setSelectParamConfig(selectParamConfig);
            selectParamConfig.setOrder(index);
            configMap.put(orgId, config);
            DynamicObjectCollection paramEntry = dynamicObject.getDynamicObjectCollection("param_entry");
            if (CollectionUtils.isEmpty((Collection)paramEntry)) continue;
            for (DynamicObject param : paramEntry) {
                String fieldId = param.getString("fieldid");
                String fieldKey = param.getString("fieldkey");
                boolean syncParam = param.getBoolean("synparam");
                boolean lock = param.getBoolean("lock_sub");
                boolean lockByParentOrDesign = param.getBoolean("lock_modify");
                selectParamConfig.getSyncParams().put(fieldKey, syncParam);
                if (!lockByParentOrDesign) {
                    config.getLockFieldMap().put(fieldKey, lock);
                }
                selectParamConfig.getSelectedParams().add(fieldId);
            }
        }
        return configMap;
    }

    private void showOrgF7Form() {
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orglist");
        ArrayList<Long> orgIds = new ArrayList<Long>(orgEntity.size());
        for (DynamicObject dynamicObject : orgEntity) {
            DynamicObject org = dynamicObject.getDynamicObject("org");
            Object pkValue = org.getPkValue();
            orgIds.add((Long)pkValue);
        }
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true);
        List qFilters = showParam.getListFilterParameter().getQFilters();
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "choose_org"));
        showParam.setHasRight(true);
        if (!CollectionUtils.isEmpty(orgIds)) {
            qFilters.add(new QFilter("id", "not in", orgIds));
        }
        qFilters.add(new QFilter("enable", "=", (Object)true));
        showParam.setListFilterParameter(new ListFilterParameter(qFilters, null));
        String focusNodeId = this.getTreeFocusNodeId();
        Map<String, String> appViewTypeMapFromCache = this.getAppViewTypeMapFromCache();
        String viewType = appViewTypeMapFromCache.getOrDefault(focusNodeId, "15");
        showParam.setCustomParam("orgFuncId", (Object)viewType);
        this.getView().showForm((FormShowParameter)showParam);
    }

    private String getTreeFocusNodeId() {
        TreeView tree = (TreeView)this.getControl(APP_TREE);
        return tree.getTreeState().getFocusNodeId();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = String.valueOf(evt.getNodeId());
        if (this.checkRepeatedClickTreeNode(nodeId)) {
            return;
        }
        TreeNode root = this.getRootNodeFromCache();
        TreeNode node = root.getTreeNode(nodeId);
        Object nodeType = node.getData();
        if (!"app".equals(nodeType)) {
            this.getModel().deleteEntryData("orglist");
            this.getModel().deleteEntryData("param_entry");
            this.getModel().updateCache();
            this.getView().setEnable(Boolean.FALSE, new String[]{"choose_org", "delete_org", "btn_select_param", BT_SAVE});
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("orglist"))) {
            this.getModel().deleteEntryData("orglist");
        }
        if (!CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("param_entry"))) {
            this.getModel().deleteEntryData("param_entry");
        }
        this.getModel().updateCache();
        this.loadConfigFromDb();
        this.getModel().updateCache();
        this.getView().updateView("orglist");
        this.getView().updateView("param_entry");
        this.selectOrgListRow(0);
        this.getView().setEnable(Boolean.TRUE, new String[]{"choose_org", "delete_org", "btn_select_param", BT_SAVE});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("orglist");
        this.cachePreOrgIdSet(entryEntity);
        if (entryEntity.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_select_param"});
        }
    }

    private boolean checkRepeatedClickTreeNode(String nodeId) {
        IPageCache pageCache = this.getPageCache();
        String preNodeId = pageCache.get(FOCUS_NODE_ID);
        if (StringUtils.isBlank((CharSequence)preNodeId)) {
            preNodeId = "";
        }
        if (nodeId.equals(preNodeId)) {
            return true;
        }
        pageCache.put(FOCUS_NODE_ID, nodeId);
        return false;
    }

    private void loadConfigFromDb() {
        AppParam appParam = this.buildDefaultAppParam();
        List<Long> allConfigOrg = ParamGroupControlPlugin.getAllConfigOrg(appParam);
        if (allConfigOrg.isEmpty()) {
            return;
        }
        Map<Long, List<Long>> allSuperiorOrgIdsMap = this.getSuperiorOrgMapFromCache(appParam.getViewType(), allConfigOrg);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, List<Long>> entry : allSuperiorOrgIdsMap.entrySet()) {
            orgIdSet.add(entry.getKey());
            orgIdSet.addAll((Collection)entry.getValue());
        }
        ArrayList searchOrgIds = new ArrayList(orgIdSet);
        appParam.setOrgIds(searchOrgIds);
        DynamicObjectCollection paramDynamicObjects = GroupControlUtil.getParamDynamicObjects(appParam);
        Map<Long, GroupControlConfig> paramGroupControlConfig = GroupControlUtil.getParamGroupControlConfig(appParam, paramDynamicObjects);
        allConfigOrg = new ArrayList<Long>(allSuperiorOrgIdsMap.keySet());
        allConfigOrg.sort(Comparator.comparingInt(o -> ((GroupControlConfig)paramGroupControlConfig.get(o)).getSelectParamConfig().getOrder()));
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("org", new Object[0]);
        for (Long orgPkId : allConfigOrg) {
            tableValueSetter.addRow(new Object[]{orgPkId});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("orglist", tableValueSetter);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("orglist");
        EntryProp entryProp = (EntryProp)this.getModel().getProperty("param_entry");
        DynamicObjectType collectionItemPropertyType = entryProp._collectionItemPropertyType;
        Map<String, SelectParam> metaDataParamFromCache = this.getMetaDataParamFromCache(appParam.getFormId());
        HashMap fieldKeyToIdMap = new HashMap(metaDataParamFromCache.size());
        metaDataParamFromCache.values().forEach(selectParam -> fieldKeyToIdMap.put(selectParam.getFieldKey(), selectParam.getId()));
        Map<Long, Map<String, Object>> orgParamValueMap = GroupControlUtil.getOrgParamValueMap(appParam, paramDynamicObjects);
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObjectCollection paramEntry = dynamicObject.getDynamicObjectCollection("param_entry");
            long orgId = dynamicObject.getLong("org_id");
            List parentIds = allSuperiorOrgIdsMap.getOrDefault(orgId, new ArrayList(0));
            Map valueMap = orgParamValueMap.getOrDefault(orgId, new HashMap(0));
            GroupControlConfig groupControlConfig = paramGroupControlConfig.get(orgId);
            Map<Long, Set<String>> parentLockMap = GroupControlUtil.getParentLockMap(paramGroupControlConfig, parentIds);
            Set<String> parentLockSet = GroupControlUtil.getParentLockSet(parentLockMap);
            Collections.reverse(parentIds);
            SelectParamConfig selectParamConfig = groupControlConfig.getSelectParamConfig();
            List<String> selectedParams = selectParamConfig.getSelectedParams();
            if (CollectionUtils.isEmpty(selectedParams) && !CollectionUtils.isEmpty(groupControlConfig.getLockFieldMap())) {
                Map<String, Boolean> lockFieldMap = groupControlConfig.getLockFieldMap();
                for (Map.Entry entry : lockFieldMap.entrySet()) {
                    String fieldKey = (String)entry.getKey();
                    String string = (String)fieldKeyToIdMap.get(fieldKey);
                    if (StringUtils.isBlank((CharSequence)string)) continue;
                    selectedParams.add(string);
                }
                boolean isRootOrg = parentIds.isEmpty();
                if (isRootOrg) {
                    HashSet<String> hashSet = new HashSet<String>(selectedParams);
                    for (Map.Entry entry : metaDataParamFromCache.entrySet()) {
                        SelectParam selectParam2;
                        String id = (String)entry.getKey();
                        if (hashSet.contains(id) || !(selectParam2 = (SelectParam)entry.getValue()).isDesignGcControl()) continue;
                        selectedParams.add(selectParam2.getId());
                    }
                }
                selectedParams.sort(Comparator.comparingInt(p -> ((SelectParam)metaDataParamFromCache.get(p)).getIndex()));
            }
            int gcCount = 0;
            for (String string : selectedParams) {
                DynamicObject paramRow = new DynamicObject(collectionItemPropertyType);
                SelectParam selectParam2 = metaDataParamFromCache.get(string);
                if (selectParam2 == null) continue;
                SelectParam selectParam3 = selectParam2.copy();
                selectParam3.setValue(GroupControlUtil.getShowValue(selectParam3.getFieldKey(), valueMap, orgParamValueMap, parentIds, parentLockMap));
                selectParam3.setSyncParams(selectParamConfig.getSyncParams().getOrDefault(selectParam3.getFieldKey(), Boolean.FALSE));
                selectParam3.setOrgGcControl(groupControlConfig.getLockFieldMap().getOrDefault(selectParam3.getFieldKey(), Boolean.FALSE));
                selectParam3.setParentOrgGcControl(parentLockSet.contains(selectParam3.getFieldKey()));
                boolean isControl = selectParam3.checkIsControl();
                if (isControl) {
                    ++gcCount;
                }
                this.fillParamEntryRow(paramRow, selectParam3);
                paramEntry.add((Object)paramRow);
            }
            dynamicObject.set("gc_count", (Object)String.valueOf(gcCount));
        }
    }

    private void fillParamEntryRow(DynamicObject paramRow, SelectParam selectParam) {
        paramRow.set("param_name", (Object)selectParam.getName());
        paramRow.set("param_value", (Object)selectParam.getValue());
        paramRow.set("synparam", (Object)selectParam.isSyncParams());
        paramRow.set("fieldkey", (Object)selectParam.getFieldKey());
        paramRow.set("lock_sub", (Object)selectParam.checkIsControl());
        paramRow.set("fieldid", (Object)selectParam.getId());
        paramRow.set("lock_modify", (Object)selectParam.getLockModify());
    }

    private void cachePreOrgIdSet(DynamicObjectCollection entryEntity) {
        ArrayList<Long> orgIdSet = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            long org_id = dynamicObject.getLong("org_id");
            orgIdSet.add(org_id);
        }
        this.getPageCache().put(CACHE_ORG_IDS, SerializationUtils.toJsonString(orgIdSet));
    }

    private Set<Long> getPreOrgIdSetFromCache() {
        String json = this.getPageCache().get(CACHE_ORG_IDS);
        if (StringUtils.isBlank((CharSequence)json)) {
            return new HashSet<Long>(0);
        }
        List idList = SerializationUtils.fromJsonStringToList((String)json, Long.class);
        return new HashSet<Long>(idList);
    }

    private void showSelectParamForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_param_gc_paramselect");
        String appId = this.getTreeFocusNodeId();
        ParamPublishObject parameterObject = readerService.getParameterObject(null, appId);
        String formId = parameterObject.getFormId();
        Map<String, SelectParam> metaDataParam = this.getMetaDataParamFromCache(formId);
        AppParam appParam = this.buildNowFocusAppParam();
        List orgIds = appParam.getOrgIds();
        List parentOrgIds = this.getSuperiorOrgMapFromCache(appParam.getViewType(), orgIds).getOrDefault(orgIds.get(0), new ArrayList(0));
        orgIds.addAll(parentOrgIds);
        parameter.setCustomParam("paramFormId", (Object)formId);
        parameter.setCustomParam("appParam", (Object)SerializationUtils.toJsonString((Object)appParam));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("param_entry");
        ArrayList<String> selectedFieldList = new ArrayList<String>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            selectedFieldList.add(dynamicObject.getString("fieldid"));
        }
        parameter.setCustomParam("selectedFields", (Object)String.join((CharSequence)",", selectedFieldList));
        parameter.setCustomParam("appId", (Object)appId);
        parameter.setCustomParam("metaDataParam", (Object)SerializationUtils.toJsonString(metaDataParam));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_select_param"));
        this.getView().showForm(parameter);
    }

    private void selectOrgListRow(int rowIndex) {
        EntryGrid eg = (EntryGrid)this.getControl("orglist");
        int entryCount = this.getModel().getEntryRowCount("orglist");
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        eg.selectRows(rowIndex);
        eg.getEntryState().selectRow(rowIndex);
        eg.getEntryState().setFocusRow(rowIndex);
        eg.entryRowClick(Integer.valueOf(rowIndex));
    }

    private void focusAppNode() {
        TreeNode root = this.getRootNodeFromCache();
        List cloudNodes = root.getChildren();
        if (CollectionUtils.isEmpty((Collection)cloudNodes)) {
            this.clickNode(null);
            return;
        }
        Object appId = this.getView().getFormShowParameter().getCustomParam("appId");
        if (ObjectUtils.isEmpty((Object)appId)) {
            TreeNode firstNode = this.getFirstNode(cloudNodes);
            this.clickNode(firstNode);
            return;
        }
        String nodeId = String.valueOf(appId);
        TreeNode appNode = root.getTreeNode(nodeId);
        this.clickNode(appNode);
    }

    private TreeNode getFirstNode(List<TreeNode> cloudNodes) {
        TreeNode cloudNode = cloudNodes.get(0);
        List appNodes = cloudNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)appNodes)) {
            return null;
        }
        return (TreeNode)appNodes.get(0);
    }

    private void clickNode(TreeNode node) {
        if (node == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"choose_org", "delete_org", "btn_select_param", BT_SAVE});
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(APP_TREE);
        TreeNode root = this.getRootNodeFromCache();
        treeView.focusNode(node);
        List childPathNodes = root.getChildPathNodes(node.getId());
        for (TreeNode pathNode : childPathNodes) {
            treeView.expand(pathNode.getParentid());
        }
        this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)node.getParentid(), (Object)node.getId()));
    }

    private Map<Long, List<Long>> getSuperiorOrgMapFromCache(String viewType, List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, List<Long>>(0);
        }
        IPageCache pageCache = this.getPageCache();
        String cacheKey = this.getCacheKey(CACHE_ORG_PARENT, viewType);
        String json = pageCache.get(cacheKey);
        Map<String, String> superiorOrgMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            superiorOrgMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        }
        HashMap<Long, List<Long>> res = new HashMap<Long, List<Long>>(orgIds.size());
        HashSet<Long> orgIdSetNotCache = new HashSet<Long>(orgIds.size());
        for (Long orgId : orgIds) {
            String id = String.valueOf(orgId);
            if (superiorOrgMap.containsKey(id)) {
                res.put(orgId, SerializationUtils.fromJsonStringToList((String)((String)superiorOrgMap.get(id)), Long.class));
                continue;
            }
            orgIdSetNotCache.add(orgId);
        }
        if (orgIdSetNotCache.isEmpty()) {
            return res;
        }
        Map notCacheSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewType, new ArrayList(orgIdSetNotCache));
        for (Map.Entry entry : notCacheSuperiorOrgs.entrySet()) {
            superiorOrgMap.put(((Long)entry.getKey()).toString(), SerializationUtils.toJsonString(entry.getValue()));
        }
        pageCache.put(cacheKey, SerializationUtils.toJsonString(superiorOrgMap));
        res.putAll(notCacheSuperiorOrgs);
        return res;
    }

    private TreeNode getRootNodeFromCache() {
        String treeNodesJson = this.getPageCache().get(CACHE_TREE_NODES);
        if (StringUtils.isNotBlank((CharSequence)treeNodesJson)) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodesJson, TreeNode.class);
            return root;
        }
        TreeNode root = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)true);
        this.filterCloudAndAppNodes(root);
        List<String> clouds = this.getEnableCloudOrAppIdList(true);
        Map<String, String> appViewTypeMap = this.getAppViewTypeMapFromCache();
        Set<String> appIds = appViewTypeMap.keySet();
        List children = root.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return root;
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode cloud = (TreeNode)iterator.next();
            cloud.getChildren().removeIf(app -> !appIds.contains(app.getId()));
            if (!cloud.getChildren().isEmpty() || clouds.contains(cloud.getId())) continue;
            iterator.remove();
        }
        TreeView treeView = (TreeView)this.getView().getControl(APP_TREE);
        treeView.addNode(root);
        this.getPageCache().put(CACHE_TREE_NODES, SerializationUtils.toJsonString((Object)root));
        return root;
    }

    private void filterCloudAndAppNodes(TreeNode root) {
        List cloudNodes = root.getChildren();
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        cloudNodes = treeNodeFilter.filterCloudTreeNode(cloudNodes);
        root.setChildren(cloudNodes);
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            appNodes = treeNodeFilter.filterAppTreeNode(appNodes);
            cloudNode.setChildren(appNodes);
        }
    }

    private Map<String, String> getAppViewTypeMapFromCache() {
        String viewTypeMapJson = this.getPageCache().get(CACHE_VIEW_TYPE);
        if (StringUtils.isNotBlank((CharSequence)viewTypeMapJson)) {
            Map appViewTypeMap = (Map)SerializationUtils.fromJsonString((String)viewTypeMapJson, Map.class);
            return appViewTypeMap;
        }
        List<String> apps = this.getEnableCloudOrAppIdList(false);
        Map bizApps = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("id", "in", apps).and(new QFilter("deploystatus", "=", (Object)"2"))});
        HashMap<String, String> appViewTypeMap = new HashMap<String, String>(bizApps.size());
        for (Map.Entry entry : bizApps.entrySet()) {
            String appId = String.valueOf(entry.getKey());
            DynamicObject appObj = (DynamicObject)entry.getValue();
            String viewType = appObj.getString("orgfunc");
            if (StringUtils.isBlank((CharSequence)viewType)) {
                viewType = "15";
            }
            appViewTypeMap.put(appId, viewType);
        }
        this.getPageCache().put(CACHE_VIEW_TYPE, SerializationUtils.toJsonString(appViewTypeMap));
        return appViewTypeMap;
    }

    private List<String> getEnableCloudOrAppIdList(boolean isCloud) {
        String sql;
        DynamicObjectCollection systems;
        String field = "FCLOUDID";
        if (!isCloud) {
            field = "FAPPID";
        }
        if (CollectionUtils.isEmpty((Collection)(systems = SingleORM.query(null, (String)(sql = "select distinct " + field + " from t_bas_sysparaconsole where FENABLED ='1'"), null)))) {
            return new ArrayList<String>(0);
        }
        List<String> ids = systems.stream().map(dynamicObject -> dynamicObject.getString(0)).collect(Collectors.toList());
        return ids;
    }

    private AppParam buildNowFocusAppParam() {
        AppParam appParam = this.buildDefaultAppParam();
        long orgId = this.getFoCusOrgId();
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        appParam.setOrgIds(orgIds);
        return appParam;
    }

    private AppParam buildDefaultAppParam() {
        String appId = this.getTreeFocusNodeId();
        Map<String, String> viewTypeMap = this.getAppViewTypeMapFromCache();
        ParamPublishObject parameterObject = readerService.getParameterObject(null, appId);
        String formId = parameterObject.getFormId();
        String viewTypeId = viewTypeMap.get(appId);
        AppParam appParam = new AppParam(null, null, viewTypeId, new ArrayList(0), Long.valueOf(0L), Long.valueOf(0L));
        appParam.setFormId(formId);
        appParam.setParamId(parameterObject.getId());
        return appParam;
    }

    private long getFoCusOrgId() {
        int orgFocusRow = this.getOrgFocusRow();
        DynamicObject entityRow = (DynamicObject)this.getModel().getEntryEntity("orglist").get(orgFocusRow);
        long orgId = entityRow.getLong("org_id");
        return orgId;
    }

    private static List<Long> getAllConfigOrg(AppParam appParam) {
        QFilter[] qFilters = ParamGroupControlPlugin.getAllConfigOrgQFilter(appParam);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_svc_sysparameter", (String)"forgid", (QFilter[])qFilters);
        ArrayList<Long> orgIds = new ArrayList<Long>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            orgIds.add(dynamicObject.getLong("forgid"));
        }
        return orgIds;
    }

    private static Set<Long> getExitOrgSet(AppParam appParam) {
        QFilter[] qFilters = new QFilter[]{new QFilter("FPARAMID", "=", (Object)appParam.getParamId()), new QFilter("FVIEWTYPEID", "=", (Object)appParam.getViewType()), new QFilter("FACCTBOOKID", "=", (Object)0), new QFilter("FACCTINGBOOKID", "=", (Object)0), new QFilter("forgid", "in", (Object)appParam.getOrgIds())};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_svc_sysparameter", (String)"forgid", (QFilter[])qFilters);
        HashSet<Long> orgIds = new HashSet<Long>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            orgIds.add(dynamicObject.getLong("forgid"));
        }
        return orgIds;
    }

    private static QFilter[] getAllConfigOrgQFilter(AppParam appParam) {
        QFilter[] qFilters = new QFilter[]{new QFilter("FPARAMID", "=", (Object)appParam.getParamId()), new QFilter("FVIEWTYPEID", "=", (Object)appParam.getViewType()), new QFilter("FACCTBOOKID", "=", (Object)0), new QFilter("FACCTINGBOOKID", "=", (Object)0), new QFilter("fparamconfig", "is not null", null).or(new QFilter("flockfields", "is not null", null))};
        return qFilters;
    }

    private String getCacheKey(String ... keys) {
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(key).append("_");
        }
        return builder.toString();
    }

    private Map<String, SelectParam> getMetaDataParamFromCache(String entityId) {
        String cacheKey = this.getCacheKey(entityId, "getMetaDataParam");
        String getMetaDataParamJson = this.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)getMetaDataParamJson)) {
            Map metaDataParam = (Map)SerializationUtils.fromJsonString((String)getMetaDataParamJson, Map.class);
            HashMap<String, SelectParam> res = new HashMap<String, SelectParam>(metaDataParam.size());
            for (Map.Entry entry : metaDataParam.entrySet()) {
                res.put((String)entry.getKey(), new SelectParam((Map)entry.getValue()));
            }
            return res;
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        HashMap<String, SelectParam> cacheParam = new HashMap<String, SelectParam>(16);
        int index = 0;
        for (ControlAp ap : controlAps) {
            boolean hidden;
            ContainerAp cp;
            String fieldKey = ap.getKey();
            Field field = entityMetadata.getFieldByKey(fieldKey);
            if (field instanceof RadioField || field instanceof BasedataPropField || ap instanceof ContainerAp && (cp = (ContainerAp)ap).getItems().isEmpty()) continue;
            String id = ap.getId();
            String name = ap.getName().getLocaleValue();
            if (ap instanceof FormAp || !(ap instanceof FieldAp)) continue;
            boolean bl = hidden = ap.isInvisible() || ap.isHidden() || StringUtils.isBlank((CharSequence)ap.getVisible());
            if (hidden) continue;
            SelectParam selectParam = new SelectParam();
            selectParam.setId(id);
            selectParam.setName(name);
            selectParam.setFieldKey(fieldKey);
            selectParam.setIndex(index);
            ++index;
            if (field.isGroupControl()) {
                selectParam.setDesignGcControl(true);
            }
            cacheParam.put(selectParam.getId(), selectParam);
        }
        this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(cacheParam));
        return cacheParam;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return;
        }
        String searchResultJson = this.getPageCache().get(CACHE_SEARCH_RESULT);
        if (StringUtils.isBlank((CharSequence)searchResultJson)) {
            this.searchNodeByText(searchText);
            return;
        }
        SearchResult searchResult = (SearchResult)SerializationUtils.fromJsonString((String)searchResultJson, SearchResult.class);
        if (!searchText.equals(searchResult.searchText)) {
            this.searchNodeByText(searchText);
            return;
        }
        if (searchResult.result.isEmpty()) {
            this.getPageCache().put(CACHE_SEARCH_RESULT, SerializationUtils.toJsonString((Object)searchResult));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u6570\u636e\u3002", (String)"ParamGroupControlPluginNew_0", (String)BOS_PARAMETER, (Object[])new Object[0]));
            return;
        }
        ++searchResult.index;
        if (searchResult.result.size() == searchResult.index) {
            searchResult.index = -1;
            this.getPageCache().put(CACHE_SEARCH_RESULT, SerializationUtils.toJsonString((Object)searchResult));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"ParamGroupControlPluginNew_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(CACHE_SEARCH_RESULT, SerializationUtils.toJsonString((Object)searchResult));
        TreeNode treeNode = searchResult.result.get(searchResult.index);
        this.clickNode(treeNode);
    }

    private void searchNodeByText(String searchText) {
        TreeNode root = this.getRootNodeFromCache();
        ArrayList<TreeNode> searchNodes = new ArrayList<TreeNode>(10);
        root.getTreeNodeListByText(searchNodes, searchText, 5);
        if (!searchNodes.isEmpty() && searchNodes.get(0) == root) {
            searchNodes.remove(0);
        }
        SearchResult searchResult = new SearchResult();
        searchResult.result = searchNodes;
        searchResult.index = -1;
        searchResult.searchText = searchText;
        if (searchResult.result.isEmpty()) {
            this.getPageCache().put(CACHE_SEARCH_RESULT, SerializationUtils.toJsonString((Object)searchResult));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u6570\u636e\u3002", (String)"ParamGroupControlPluginNew_0", (String)BOS_PARAMETER, (Object[])new Object[0]));
            return;
        }
        ++searchResult.index;
        TreeNode treeNode = (TreeNode)searchNodes.get(searchResult.index);
        this.clickNode(treeNode);
        this.getPageCache().put(CACHE_SEARCH_RESULT, SerializationUtils.toJsonString((Object)searchResult));
    }
}

