/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamConvert;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterCache;
import kd.bos.param.ParameterLocalCache;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class ParamLoadTestPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String APPID_PARAMID_KEY = "APPID_PARAMID_KEY";
    private static final String APPID_FORMID_KEY = "APPID_FORMID_KEY";
    private static final String[] API_ARRAY = new String[]{"loadSystemParameterFromCache", "getSystemParameter", "loadBatchSystemParameterByOrgFromCache", "loadBatchSystemParameterByBatchOrg"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"search", "clearcache", "searchcache"});
        BasedataEdit edit = (BasedataEdit)this.getControl("app");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgs = (BasedataEdit)this.getControl("orgs");
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String appId = dataEntity.getString("app_id");
        if (StringUtils.isBlank((CharSequence)appId)) {
            this.getView().showErrorNotification("app is null!");
            return;
        }
        ParameterReaderServiceImpl readerService = new ParameterReaderServiceImpl();
        ParamPublishObject paramPublishObject = readerService.getParameterObject("", appId);
        if (paramPublishObject == null) {
            this.getView().showErrorNotification("ParamPublishObject is null!");
            return;
        }
        if ("search".equals(key)) {
            String paramApis = (String)this.getModel().getValue("paramapi");
            if (StringUtils.isBlank((CharSequence)paramApis)) {
                return;
            }
            DynamicObjectCollection orgs = dataEntity.getDynamicObjectCollection("orgs");
            if (CollectionUtils.isEmpty((Collection)orgs)) {
                this.getView().showErrorNotification("orgs is null!");
                return;
            }
            ArrayList<Long> orgIds = new ArrayList<Long>(orgs.size());
            for (DynamicObject org : orgs) {
                long orgId = org.getLong("fbasedataid_id");
                orgIds.add(orgId);
            }
            HashMap res = new HashMap(16);
            String[] apiArray = paramApis.split(",");
            boolean clear = dataEntity.getBoolean("clear");
            block13: for (String api : apiArray) {
                if (StringUtils.isBlank((CharSequence)api)) continue;
                HashMap paramsMap = new HashMap(16);
                res.put(api, paramsMap);
                switch (api) {
                    case "loadSystemParameterFromCache": {
                        this.clearCache(appId, clear);
                        for (Long l : orgIds) {
                            AppParam appParam = new AppParam();
                            appParam.setAppId(appId);
                            appParam.setOrgId(l);
                            appParam.setParamId(paramPublishObject.getId());
                            appParam.setViewType(this.getOrgViewType(appId));
                            Map<String, Object> param = readerService.loadSystemParameterFromCache(appParam);
                            paramsMap.put(l.toString(), param);
                        }
                        continue block13;
                    }
                    case "getSystemParameter": {
                        this.clearCache(appId, clear);
                        List paramItems = ParamConvert.getParamItems((String)paramPublishObject.getFormId());
                        for (Long orgId2 : orgIds) {
                            AppParam appParam = new AppParam();
                            appParam.setAppId(appId);
                            appParam.setOrgId(orgId2);
                            appParam.setParamId(paramPublishObject.getId());
                            appParam.setViewType(this.getOrgViewType(appId));
                            DynamicObject systemParameter = readerService.getSystemParameter(appParam);
                            HashMap<String, Object> param = new HashMap<String, Object>(16);
                            for (String string : paramItems) {
                                param.put(string, systemParameter.get(string));
                            }
                            paramsMap.put(orgId2.toString(), param);
                        }
                        continue block13;
                    }
                    case "loadBatchSystemParameterByOrgFromCache": {
                        this.clearCache(appId, clear);
                        AppParam appParam = new AppParam();
                        appParam.setAppId(appId);
                        appParam.setOrgIds(orgIds);
                        appParam.setParamId(paramPublishObject.getId());
                        appParam.setViewType(this.getOrgViewType(appId));
                        Map<String, Map<String, Object>> params = readerService.loadBatchSystemParameterByOrgFromCache(appParam);
                        paramsMap.putAll(params);
                        continue block13;
                    }
                    case "loadBatchSystemParameterByBatchOrg": {
                        this.clearCache(appId, clear);
                        AppParam appParam = new AppParam();
                        appParam.setAppId(appId);
                        appParam.setOrgIds(orgIds);
                        appParam.setParamId(paramPublishObject.getId());
                        appParam.setViewType(this.getOrgViewType(appId));
                        Map<String, Map<String, Object>> params = readerService.loadBatchSystemParameterByBatchOrg(appParam);
                        paramsMap.putAll(params);
                        continue block13;
                    }
                    default: {
                        continue block13;
                    }
                }
            }
            String entityKey = "entryentity";
            this.getModel().deleteEntryData(entityKey);
            this.getModel().updateEntryCache(((AbstractFormDataModel)this.getModel()).getEntityEntity(entityKey));
            if (CollectionUtils.isEmpty(res)) {
                return;
            }
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            tableValueSetter.addField("api", new Object[0]);
            tableValueSetter.addField("org", new Object[0]);
            for (Map.Entry entry : res.entrySet()) {
                for (String org : ((Map)entry.getValue()).keySet()) {
                    tableValueSetter.addRow(new Object[]{entry.getKey(), Long.parseLong(org)});
                }
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(entityKey, tableValueSetter);
            DynamicObjectCollection entryEntity = ((AbstractFormDataModel)this.getModel()).getEntryEntity(entityKey);
            String subentryentity = "subentryentity";
            EntryProp entryProp = (EntryProp)this.getModel().getProperty(subentryentity);
            DynamicObjectType collectionItemPropertyType = entryProp._collectionItemPropertyType;
            for (DynamicObject dynamicObject : entryEntity) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(subentryentity);
                String api = dynamicObject.getString("api");
                Map params = (Map)res.get(api);
                String orgId = String.valueOf(dynamicObject.getLong("org_id"));
                Map paramMap = (Map)params.get(orgId);
                for (Map.Entry entry : paramMap.entrySet()) {
                    DynamicObject param = new DynamicObject(collectionItemPropertyType);
                    param.set("paramkey", entry.getKey());
                    param.set("paramvalue", (Object)String.valueOf(entry.getValue()));
                    dynamicObjectCollection.add((Object)param);
                }
            }
            this.getModel().updateCache();
            this.getView().updateView(entityKey);
            this.getView().updateView(subentryentity);
        }
        if ("clearcache".equals(key)) {
            this.clearCache(appId, true);
        }
        if ("searchcache".equals(key)) {
            AppParam appParam = new AppParam();
            appParam.setAppId(appId);
            appParam.setParamId(paramPublishObject.getId());
            appParam.setViewType(this.getOrgViewType(appId));
            Map redisCacheMap = ParameterCache.getAppParamAllOrgRedisCache(appParam);
            Map localCacheMap = new HashMap(16);
            Object appParamAllOrgLocalCacheValue = ParameterLocalCache.getAppParamAllOrgLocalCacheValue(appParam);
            if (appParamAllOrgLocalCacheValue instanceof Map) {
                localCacheMap = (Map)appParamAllOrgLocalCacheValue;
            }
            this.getModel().setValue("localcachevalue", (Object)"localcachevalue");
            this.getModel().setValue("localcachevalue_tag", (Object)SerializationUtils.toJsonString(localCacheMap));
            this.getModel().setValue("rediscachevalue", (Object)"rediscachevalue");
            this.getModel().setValue("rediscachevalue_tag", (Object)SerializationUtils.toJsonString((Object)redisCacheMap));
        }
    }

    private void clearCache(String appId, boolean clear) {
        if (clear) {
            ParameterCache.removeParameter("", appId);
            ParameterCache.removeBatchParameter("", appId);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String prop = beforeF7SelectEvent.getProperty().getName();
        if ("app".equals(prop)) {
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            QFilter qFilter = new QFilter("id", "in", (Object)this.getAppIdParamIdMap().keySet().toArray());
            if (CollectionUtils.isEmpty((Collection)qFilters) || qFilters.get(0) == null) {
                qFilters.add(qFilter);
            } else {
                ((QFilter)qFilters.get(0)).and(qFilter);
            }
            return;
        }
        if ("orgs".equals(prop)) {
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getModel().getDataEntity().getString("app_id");
            param.setCustomParam("orgFuncId", (Object)this.getOrgViewType(appId));
        }
    }

    private String getOrgViewType(String appId) {
        String appViewType = null;
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            ArrayList<String> fieldKeys = new ArrayList<String>();
            fieldKeys.add("orgfunc");
            DynamicObjectType bizAppType = EntityMetadataCache.getSubDataEntityType((String)"bos_devportal_bizapp", fieldKeys);
            Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{appId}, (DynamicObjectType)bizAppType);
            DynamicObject object = (DynamicObject)objs.get(appId);
            if (!ObjectUtils.isEmpty((Object)object)) {
                appViewType = object.getString("orgfunc");
            }
        }
        if (StringUtils.isBlank(appViewType)) {
            appViewType = "15";
        }
        return appViewType;
    }

    private Map<String, String> getAppIdParamIdMap() {
        String cacheJson = this.getPageCache().get(APPID_PARAMID_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheJson)) {
            return (Map)SerializationUtils.fromJsonString((String)cacheJson, Map.class);
        }
        return this.cacheAppParamData(true);
    }

    private Map<String, String> cacheAppParamData(boolean getAppIdParamIdMap) {
        HashMap<String, String> appIdParamIdMap = new HashMap<String, String>(16);
        HashMap<String, String> appIdFormIdMap = new HashMap<String, String>(16);
        String sql = "SELECT  DISTINCT FAPPID,FID,FFORMID FROM T_BAS_SYSPARACONSOLE  WHERE FENABLED ='1'";
        DynamicObjectCollection systems = SingleORM.query(null, (String)sql, null);
        if (systems != null) {
            for (int i = 0; i < systems.size(); ++i) {
                String appId = ((DynamicObject)systems.get(i)).getString(0);
                String paramId = ((DynamicObject)systems.get(i)).getString(1);
                String formId = ((DynamicObject)systems.get(i)).getString(2);
                if (!StringUtils.isNotBlank((CharSequence)appId) || !StringUtils.isNotBlank((CharSequence)paramId)) continue;
                appIdParamIdMap.put(appId, paramId);
                appIdFormIdMap.put(appId, formId);
            }
        }
        if (!appIdParamIdMap.isEmpty()) {
            Set<String> appIdSet = this.getAppIds();
            appIdFormIdMap.entrySet().removeIf(entry -> !appIdSet.contains(entry.getKey()));
            appIdParamIdMap.entrySet().removeIf(entry -> !appIdSet.contains(entry.getKey()));
        }
        this.getPageCache().put(APPID_FORMID_KEY, SerializationUtils.toJsonString(appIdFormIdMap));
        this.getPageCache().put(APPID_PARAMID_KEY, SerializationUtils.toJsonString(appIdParamIdMap));
        if (getAppIdParamIdMap) {
            return appIdParamIdMap;
        }
        return appIdFormIdMap;
    }

    private Set<String> getAppIds() {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)true);
        List cloudNodes = treeRoot.getChildren();
        Set<String> hideAppIds = ParamLoadTestPlugin.getHideAppIds();
        HashSet<String> appIdSet = new HashSet<String>(10);
        if (CollectionUtils.isEmpty((Collection)cloudNodes)) {
            return appIdSet;
        }
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            for (TreeNode appNode : appNodes) {
                String appId = appNode.getId();
                if (!StringUtils.isNotBlank((CharSequence)appId) || hideAppIds.contains(appId)) continue;
                appIdSet.add(appId);
            }
        }
        return appIdSet;
    }

    private static Set<String> getHideAppIds() {
        HashSet<String> hideAppIds = new HashSet<String>(3);
        hideAppIds.add("83bfebc8000037ac");
        hideAppIds.add("TV3/VDJ86RC");
        hideAppIds.add("83bfebc800003dac");
        hideAppIds.add("W3NF+MX967M");
        return hideAppIds;
    }
}

