/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class ParamOpLogUtils {
    private static ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static Log log = LogFactory.getLog(ParamOpLogUtils.class);

    public static void addLog(IFormView view, String opKey, String opName, String keyWord, MultiLangEnumBridge enumBridge, String ... args) {
        try {
            logService.addLog(ParamOpLogUtils.buildLogInfo(view, opKey, opName, keyWord, enumBridge, args));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void addLog(String appId, String entityId, String opKey, String keyWord) {
        try {
            logService.addLog(ParamOpLogUtils.buildLogInfo(appId, entityId, opKey, "", keyWord, null, new String[0]));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void addLog(IFormView view, String opKey, String opName, String keyWord) {
        try {
            logService.addLog(ParamOpLogUtils.buildLogInfo(view, opKey, opName, keyWord, null, new String[0]));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static AppLogInfo buildLogInfo(IFormView view, String opKey, String opName, String keyWord, MultiLangEnumBridge enumBridge, String ... args) {
        String appId = view.getFormShowParameter().getAppId();
        String entityId = view.getEntityId();
        if (view instanceof IListView) {
            entityId = ((IListView)view).getBillFormId();
        }
        return ParamOpLogUtils.buildLogInfo(appId, entityId, opKey, opName, keyWord, enumBridge, args);
    }

    private static AppLogInfo buildLogInfo(String appId, String entityId, String opKey, String opName, String keyWord, MultiLangEnumBridge enumBridge, String ... args) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String bizAppid = BizAppServiceHelp.getAppIdByAppNumber((String)appId);
        logInfo.setBizAppID(bizAppid);
        logInfo.setBizObjID(entityId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opKey, opName);
        logInfo.setKeyWord(keyWord);
        if (enumBridge != null) {
            logInfo.setOpDesc(enumBridge, args);
        }
        return logInfo;
    }
}

