/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.CustomParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.session.SystemPropertyUtils;

public class ParameterLog {
    private static final Log logger = LogFactory.getLog(ParameterLog.class);
    private static final IParameterReaderService readerService = new ParameterReaderServiceImpl();

    public static void info(String msg) {
        String parameterLogInfo = SystemPropertyUtils.getProptyByTenant((String)"PARAMETER_LOG_INFO", (String)RequestContext.get().getTenantId());
        if ("true".equals(parameterLogInfo)) {
            logger.info(msg);
        }
    }

    public static void info(String msg, AppParam appParam, Map<String, Object> result) {
        if (appParam == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)appParam.getAppId())) {
            ParameterLog.logAppParam(msg, appParam, result);
            return;
        }
        String parameterLogInfo = SystemPropertyUtils.getProptyByTenant((String)"PARAMETER_LOG_INFO", (String)RequestContext.get().getTenantId());
        if ("true".equals(parameterLogInfo)) {
            String[] split;
            StringBuilder builder = new StringBuilder();
            builder.append(msg);
            if (appParam != null) {
                String appParamData = "(cloudId,appId,viewType,orgId,acctBookId,acctingBookId)\uff1a" + appParam.getCloudId() + "," + appParam.getAppId() + "," + appParam.getViewType() + "," + appParam.getOrgId() + "," + appParam.getActBookId() + "," + appParam.getAcctingBookId();
                builder.append(appParamData);
            }
            if (CollectionUtils.isEmpty(result) || ParameterLog.getCustomLogKeyParameter().isEmpty()) {
                logger.info(builder.toString());
                return;
            }
            Map<String, String> customLogKeyParameter = ParameterLog.getCustomLogKeyParameter();
            String infoKey = customLogKeyParameter.get("PARAMETER_LOG_INFO_KEY");
            if (StringUtils.isBlank((CharSequence)infoKey)) {
                logger.info(builder.toString());
                return;
            }
            builder.append("result:");
            for (String key : split = infoKey.split(",")) {
                builder.append(key).append(":");
                builder.append(result.get(key));
            }
            logger.info(builder.toString());
        }
    }

    private static void logAppParam(String msg, AppParam appParam, Map<String, Object> result) {
        try {
            Map<String, String> appCustomLogKeyParameter = ParameterLog.getAppCustomLogKeyParameter(appParam.getAppId());
            if ("true".equals(appCustomLogKeyParameter.get("PARAMETER_LOG_INFO_KEY"))) {
                msg = msg + "(cloudId,appId,viewType,orgId,acctBookId,acctingBookId)\uff1a" + appParam.getCloudId() + "," + appParam.getAppId() + "," + appParam.getViewType() + "," + appParam.getOrgId() + "," + appParam.getActBookId() + "," + appParam.getAcctingBookId();
                if (CollectionUtils.isEmpty(result)) {
                    logger.info(msg + "{}");
                    return;
                }
                logger.info(msg + SerializationUtils.toJsonString(result));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static Map<String, String> getCustomLogKeyParameter() {
        CustomParam customParam = new CustomParam();
        customParam.getSearchKeySet().add("PARAMETER_LOG_INFO_KEY");
        Map parameter = readerService.loadCustomParameterFromCache(customParam);
        return parameter;
    }

    private static Map<String, String> getAppCustomLogKeyParameter(String appId) {
        AppCustomParam appCustomParam = new AppCustomParam(appId);
        appCustomParam.getSearchKeySet().add("PARAMETER_LOG_INFO_KEY");
        return readerService.loadAppCustomParameterFromCache(appCustomParam);
    }
}

