/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.org.api.IOrgService;
import kd.bos.param.facade.ISysParamServiceFacade;
import kd.bos.param.facade.SysParamServiceFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class ParameterOrgUtils {
    public static boolean isTreeOrg() {
        CustomParam customParam = new CustomParam();
        customParam.setGroupNumber("kd_svc_customerparam");
        HashSet<String> set = new HashSet<String>();
        set.add("AppParam_OrgType");
        customParam.setSearchKeySet(set);
        Map parameterMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        String appParamOrgType = parameterMap.getOrDefault("AppParam_OrgType", "0");
        boolean isTreeOrg = "0".equals(appParamOrgType);
        return isTreeOrg;
    }

    public static long getParamRootOrgId() {
        if (ParameterOrgUtils.isTreeOrg()) {
            return OrgUnitServiceHelper.getRootOrgId();
        }
        return ParameterOrgUtils.getVirtualRootOrg().getOrgId();
    }

    public static VirtualRootOrg getVirtualRootOrg() {
        return new VirtualRootOrg();
    }

    public static List<Long> getAllSuperiorOrgs(String orgFunction, long orgId, boolean isIncludeSelf) {
        ISysParamServiceFacade facade = SysParamServiceFactory.getFacade();
        if (null == facade || facade.getNoOrgFlag().booleanValue()) {
            return Stream.of(Long.valueOf(0L)).collect(Collectors.toList());
        }
        List<Long> lstOrgs = new ArrayList<Long>(16);
        if (orgId == 0L) {
            return lstOrgs;
        }
        if (StringUtils.isEmpty((CharSequence)orgFunction)) {
            orgFunction = "01";
        }
        if (!ParameterOrgUtils.isTreeOrg()) {
            long virtualRootId = ParameterOrgUtils.getVirtualRootOrg().getOrgId();
            if (orgId != virtualRootId) {
                lstOrgs.add(virtualRootId);
            }
            if (isIncludeSelf) {
                lstOrgs.add(orgId);
            }
            return lstOrgs;
        }
        lstOrgs = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getAllSuperiorOrgs(orgFunction, orgId);
        if (lstOrgs != null && isIncludeSelf) {
            lstOrgs.add(orgId);
        }
        return lstOrgs;
    }

    public static Map<Long, List<Long>> getAllSuperiorOrgs(String orgFunction, List<Long> orgIds, boolean isIncludeSelf) {
        ISysParamServiceFacade facade = SysParamServiceFactory.getFacade();
        if (null == facade || facade.getNoOrgFlag().booleanValue()) {
            HashMap<Long, List<Long>> list = new HashMap<Long, List<Long>>();
            ArrayList<Long> pIds = new ArrayList<Long>(1);
            if (isIncludeSelf) {
                pIds.add(0L);
            }
            list.put(0L, pIds);
            return list;
        }
        if (!ParameterOrgUtils.isTreeOrg()) {
            long virtualRootId = ParameterOrgUtils.getVirtualRootOrg().getOrgId();
            HashMap<Long, List<Long>> allSuperiorOrgs = new HashMap<Long, List<Long>>(orgIds.size());
            for (Long orgId : orgIds) {
                ArrayList<Long> lstOrgs = new ArrayList<Long>(2);
                if (orgId != virtualRootId) {
                    lstOrgs.add(virtualRootId);
                }
                if (isIncludeSelf) {
                    lstOrgs.add(orgId);
                }
                allSuperiorOrgs.put(orgId, lstOrgs);
            }
            return allSuperiorOrgs;
        }
        Map allSuperiorOrgs = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getAllSuperiorOrgs(orgFunction, orgIds);
        for (Map.Entry entry : allSuperiorOrgs.entrySet()) {
            Long key = (Long)entry.getKey();
            List value = (List)entry.getValue();
            if (!isIncludeSelf) continue;
            value.add(key);
        }
        return allSuperiorOrgs;
    }

    public static class VirtualRootOrg {
        public long getOrgId() {
            return -100000L;
        }

        public String getName() {
            return ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3", (String)"ParameterOrgUtils_0", (String)"bos-parameter", (Object[])new Object[0]);
        }
    }
}

