/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.plugin.param.copy.CopyParam;
import kd.bos.form.plugin.param.copy.ParamCopyUtil;
import kd.bos.org.event.AbstractOrgChangeEventServicePlugin;
import kd.bos.org.model.OrgChangeCheckReport;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.event.ChaneOrg;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ParamSyncWhenRootOrgChange
extends AbstractOrgChangeEventServicePlugin {
    private static final String BOS_PARAMETER = "bos-parameter";

    protected OrgChangeCheckReport handleEventAndReturnCheckReport(KDBizEvent evt) {
        OrgChangeCheckReport orgChangeCheckReport = new OrgChangeCheckReport();
        String variableStr = evt.getVariables();
        JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
        Object subscriptionId = variables.get((Object)"subscription_id");
        if (Objects.nonNull(subscriptionId)) {
            orgChangeCheckReport.setEventId(Long.valueOf(subscriptionId.toString()));
        }
        JSONObject operationParams = variables.getJSONObject("base_orgchange_resetroot");
        String changeRecordId = operationParams.getString("changerecordid");
        orgChangeCheckReport.setChangeRecordId(Long.valueOf(changeRecordId));
        JSONArray viewArray = operationParams.getJSONArray("synviews");
        try {
            this.copyParam(viewArray);
            orgChangeCheckReport.setCheckStatus("P");
            orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u5df2\u540c\u6b65\u539f\u6839\u7ec4\u7ec7\u7684\u5e94\u7528\u53c2\u6570\uff0c\u5177\u4f53\u65e5\u5fd7\u53ef\u89c1\u516c\u5171\u8bbe\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u53c2\u6570\u590d\u5236\u7ed3\u679c\u3002", (String)"ParamSyncWhenRootOrgChange_0", (String)BOS_PARAMETER, (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            orgChangeCheckReport.setCheckStatus("W");
            orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u540c\u6b65\u539f\u6839\u7ec4\u7ec7\u7684\u5e94\u7528\u53c2\u6570\u5931\u8d25\uff0c\u5177\u4f53\u8bf7\u67e5\u8be2\u65e5\u5fd7\u3002", (String)"ParamSyncWhenRootOrgChange_1", (String)BOS_PARAMETER, (Object[])new Object[0]));
        }
        return orgChangeCheckReport;
    }

    private void copyParam(JSONArray viewArray) {
        HashSet<Long> viewIdSet;
        HashMap copyOrgMap = new HashMap(1);
        for (Object viewMap : viewArray) {
            Map viewObj = (Map)viewMap;
            String newRootId = String.valueOf(viewObj.get("newrootid"));
            String oldrootid = String.valueOf(viewObj.get("oldrootid"));
            ChaneOrg chaneOrg = new ChaneOrg(Long.valueOf(newRootId), Long.valueOf(oldrootid));
            String viewId = String.valueOf(viewObj.get("viewid"));
            if (copyOrgMap.containsKey(chaneOrg)) {
                ((Set)copyOrgMap.get(chaneOrg)).add(Long.valueOf(viewId));
                continue;
            }
            viewIdSet = new HashSet<Long>(16);
            viewIdSet.add(Long.valueOf(viewId));
            copyOrgMap.put(chaneOrg, viewIdSet);
        }
        Map<String, String> appIdParamIdMap = ParamSyncWhenRootOrgChange.getAppIdParamIdMap();
        Map<String, String> appViewTypeMap = ParamSyncWhenRootOrgChange.getAppViewTypeMap(appIdParamIdMap.keySet());
        for (Map.Entry chaneOrgSetEntry : copyOrgMap.entrySet()) {
            HashMap<String, String> appIdParamIdMapCopy = new HashMap<String, String>(appIdParamIdMap);
            HashMap<String, String> appViewTypeMapCopy = new HashMap<String, String>(appViewTypeMap);
            ChaneOrg chaneOrg = (ChaneOrg)chaneOrgSetEntry.getKey();
            viewIdSet = (HashSet<Long>)chaneOrgSetEntry.getValue();
            ParamCopyUtil copyUtil = new ParamCopyUtil();
            CopyParam param = new CopyParam();
            param.setSourceOrgId(chaneOrg.getOldRootId());
            HashSet<Long> targetOrgIdSet = new HashSet<Long>();
            targetOrgIdSet.add(chaneOrg.getNewRootId());
            param.setTargetOrgIdSet(targetOrgIdSet);
            param.setUpdateAll(true);
            Iterator<Map.Entry<String, String>> iterator = appViewTypeMapCopy.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (viewIdSet.contains(Long.valueOf(entry.getValue()))) continue;
                appIdParamIdMapCopy.remove(entry.getKey());
                iterator.remove();
            }
            HashMap<String, Set<String>> allOrgByViewTypeMap = new HashMap<String, Set<String>>(16);
            for (String viewType : appViewTypeMapCopy.values()) {
                if (allOrgByViewTypeMap.containsKey(viewType)) continue;
                Set<String> orgSetByViewType = copyUtil.seachOrgSetByView(viewType);
                allOrgByViewTypeMap.put(viewType, orgSetByViewType);
            }
            param.setAppIdParamIdMap(appIdParamIdMapCopy);
            param.setAppViewTypeMap(appViewTypeMapCopy);
            param.setAppNameMap(new HashMap<String, String>(0));
            param.setSyncParamMap(new HashMap<String, List<String>>(0));
            param.setAllOrgByViewTypeMap(allOrgByViewTypeMap);
            OperationResult result = this.saveParamCopyBaseData(param);
            List successPkIds = result.getSuccessPkIds();
            if (!successPkIds.isEmpty()) {
                DynamicObject copyBaseData = BusinessDataServiceHelper.loadSingleFromCache(successPkIds.get(0), (String)"bos_svc_parametercopy");
                param.setCopyBaseData(copyBaseData);
            }
            copyUtil.copy(param);
        }
    }

    private OperationResult saveParamCopyBaseData(CopyParam param) {
        Map<String, String> appViewTypeMap;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_svc_parametercopy");
        dynamicObject.set("paramscope", (Object)"0");
        dynamicObject.set("sourceorg", (Object)param.getSourceOrgId());
        Set<Long> targetOrg = param.getTargetOrgIdSet();
        if (!targetOrg.isEmpty()) {
            MulBasedataProp property = (MulBasedataProp)dynamicObject.getDataEntityType().getProperties().get((Object)"targetorg");
            DynamicObjectType itemPropertyType = property.getDynamicCollectionItemPropertyType();
            MulBasedataDynamicObjectCollection collection = new MulBasedataDynamicObjectCollection(itemPropertyType, (Object)dynamicObject);
            for (Long targetOrgId : targetOrg) {
                DynamicObject newObj = collection.addNew();
                newObj.set("fbasedataid_id", (Object)targetOrgId);
                newObj.set("pkid", (Object)DB.genLongId((String)"t_svc_paramcopy_targetorg"));
            }
            dynamicObject.set("targetorg", (Object)collection);
        }
        if (!(appViewTypeMap = param.getAppViewTypeMap()).isEmpty()) {
            Set<String> appIdSet = appViewTypeMap.keySet();
            MulBasedataProp property = (MulBasedataProp)dynamicObject.getDataEntityType().getProperties().get((Object)"copyapp");
            DynamicObjectType itemPropertyType = property.getDynamicCollectionItemPropertyType();
            MulBasedataDynamicObjectCollection collection = new MulBasedataDynamicObjectCollection(itemPropertyType, (Object)dynamicObject);
            for (String appId : appIdSet) {
                DynamicObject newObj = collection.addNew();
                newObj.set("fbasedataid_id", (Object)appId);
                newObj.set("pkid", (Object)DB.genLongId((String)"t_svc_paramcopy_app"));
            }
            dynamicObject.set("copyapp", (Object)collection);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String format = dateFormat.format(new Date());
        dynamicObject.set("name", (Object)("FZ" + format));
        ArrayList<DynamicObject> copyBaseDataList = new ArrayList<DynamicObject>(1);
        copyBaseDataList.add(dynamicObject);
        OperationResult result = SaveServiceHelper.saveOperate((String)"bos_svc_parametercopy", (DynamicObject[])copyBaseDataList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        return result;
    }

    private static Map<String, String> getAppViewTypeMap(Set<String> appIdSet) {
        HashMap<String, String> appViewTypeMap = new HashMap<String, String>(appIdSet.size());
        Map appDataCollection = BusinessDataReader.loadFromCache((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)appIdSet.toArray())});
        for (Map.Entry app : appDataCollection.entrySet()) {
            String viewType = ((DynamicObject)app.getValue()).getString("orgfunc");
            if (StringUtils.isBlank((CharSequence)viewType)) {
                viewType = "15";
            }
            appViewTypeMap.put((String)app.getKey(), viewType);
        }
        return appViewTypeMap;
    }

    private static Map<String, String> getAppIdParamIdMap() {
        HashMap<String, String> appIdParamIdMap = new HashMap<String, String>(16);
        String sql = "SELECT  DISTINCT FAPPID,FID FROM T_BAS_SYSPARACONSOLE  WHERE FENABLED ='1'";
        DynamicObjectCollection systems = SingleORM.query(null, (String)sql, null);
        if (systems != null) {
            for (int i = 0; i < systems.size(); ++i) {
                String appId = ((DynamicObject)systems.get(i)).getString(0);
                String paramId = ((DynamicObject)systems.get(i)).getString(1);
                if (!StringUtils.isNotBlank((CharSequence)appId) || !StringUtils.isNotBlank((CharSequence)paramId)) continue;
                appIdParamIdMap.put(appId, paramId);
            }
        }
        if (!appIdParamIdMap.isEmpty()) {
            Set<String> appIdSet = ParamSyncWhenRootOrgChange.getAppIds();
            appIdParamIdMap.entrySet().removeIf(entry -> !appIdSet.contains(entry.getKey()));
        }
        return appIdParamIdMap;
    }

    private static Set<String> getAppIds() {
        TreeNode treeRoot = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)true);
        List cloudNodes = treeRoot.getChildren();
        HashSet<String> appIdSet = new HashSet<String>(10);
        if (CollectionUtils.isEmpty((Collection)cloudNodes)) {
            return appIdSet;
        }
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)appNodes)) continue;
            for (TreeNode appNode : appNodes) {
                String appId = appNode.getId();
                if (!StringUtils.isNotBlank((CharSequence)appId)) continue;
                appIdSet.add(appId);
            }
        }
        return appIdSet;
    }
}

