/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.param.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.ParameterHelper;
import kd.bos.data.impl.ParameterHelperServiceImpl;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.MobileListF7Config;
import kd.bos.entity.param.OverallParam;
import kd.bos.entity.param.ParamConvert;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterCache;
import kd.bos.param.ParameterLocalCache;
import kd.bos.param.ParameterLog;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.ParameterUtils;
import kd.bos.param.constant.UserParaType;
import kd.bos.param.facade.ISysParamServiceFacade;
import kd.bos.param.facade.SysParamServiceFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ParameterReaderServiceImpl
implements IParameterReaderService {
    private static final String FORGID = "FORGID";
    private static final String FACCTINGBOOKID = "FACCTINGBOOKID";
    private static final String FVIEWTYPEID = "FVIEWTYPEID";
    private static final String FACCTBOOKID = "FACCTBOOKID";
    private static final String FAPPID = "FAPPID";
    private static final String FCLOUDID = "FCLOUDID";
    private static final String FSUBSYSTEM = "FSUBSYSTEM";
    private static final String FDATA = "FDATA";
    private static final String FFORMID = "FFORMID";
    private static final String FPARAMID = "FPARAMID";
    private static final String FUSERID = "FUSERID";
    private static final String FEXTEND = "FEXTEND";
    private static final String FISLISTOPTION = "FISLISTOPTION";
    private static final String IS_VIEW_BILL = "isviewbill";
    private static final String MAX_RETURN_DATA = "maxreturndata";
    private static final String IS_ENABLE_SIGN_ORG = "isenablesignorg";
    private static final String PAGE_SIZE = "pagesize";
    private static final String DEFAULT_SORT = "defaultsort";
    private static final String FUZZY_SEARCH_ENTRY = "entryentity";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_WIDTH = "fieldwidth";
    private static final String FIELD_ID = "fieldid";
    private static final String IS_SEARCH = "issearch";
    private static final String COMBO_LIST_SHOW = "iscombolistshow";
    private static final String ORGFUNC = "orgfunc";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String SELECT_DATA_FORM_T_BAS_USERPARAMETER = " SELECT FDATA, FUSERID, FFORMID, FEXTEND, FISLISTOPTION FROM T_BAS_USERPARAMETER WHERE FUSERID=? AND FFORMID=? AND FISLISTOPTION=? ";
    private static final String IS_F7FULLNAME = "f7listformat";
    private static final String SELECTEDPARAMS = "selectedparams";
    private static final String ORG_ORDER = "orgorder";
    private static final String DEFAULT_VIEW_TYPE = "15";
    private static final Log logger = LogFactory.getLog(ParameterReader.class);
    private static final int INITIAL_COLLECTION_SIZE = 16;

    public DynamicObject getBillParameter(String formId) {
        String data;
        if (StringUtils.isBlank((CharSequence)formId)) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        if (!(entityType instanceof BillEntityType)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)((BillEntityType)entityType).getBillParameter())) {
            return null;
        }
        DynamicObject billParamObj = ParameterLocalCache.getBillParamDynamicObject(formId);
        if (billParamObj != null) {
            MainEntityType billParamType = EntityMetadataCache.getDataEntityType((String)((BillEntityType)entityType).getBillParameter());
            if (!StringUtils.equals((CharSequence)billParamType.getName(), (CharSequence)billParamObj.getDataEntityType().getName()) || !StringUtils.equals((CharSequence)billParamType.getVersion(), (CharSequence)billParamObj.getDataEntityType().getVersion())) {
                billParamObj = null;
            } else {
                if (StringUtils.equals((CharSequence)ParameterCache.loadBillParamVer(formId), (CharSequence)ParameterLocalCache.getBillParamVer(formId))) {
                    return billParamObj;
                }
                billParamObj = null;
            }
        }
        if ((data = ParameterCache.loadBillParamObj(formId)) != null) {
            billParamObj = ParameterUtils.serializeToDataEntity(data, ((BillEntityType)entityType).getBillParameter());
        } else {
            String sql = " SELECT FDATA FROM T_BAS_BILLPARAMETER WHERE FFORMID=? ";
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            params.add(new SqlParameter(FFORMID, 12, (Object)formId));
            DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            data = existData == null || existData.isEmpty() ? "" : ((DynamicObject)existData.get(0)).getString(0);
            ParameterCache.putBillParamObj(formId, data);
            billParamObj = ParameterUtils.serializeToDataEntity(data, ((BillEntityType)entityType).getBillParameter());
        }
        ParameterLocalCache.putBillParamDynamicObject(formId, billParamObj);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        String cacheVersion = sdf.format(new Date());
        ParameterCache.putBillParamVer(formId, cacheVersion);
        ParameterLocalCache.putBillParamVer(formId, cacheVersion);
        return billParamObj;
    }

    public BillParam loadBillParameterFormCache(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return null;
        }
        BillParam billParam = ParameterLocalCache.getBillParam(formId);
        if (billParam != null) {
            if (StringUtils.equals((CharSequence)ParameterCache.loadBillParamVer(formId), (CharSequence)ParameterLocalCache.getBillParamVer(formId))) {
                return billParam;
            }
            billParam = null;
        }
        DynamicObject obj = this.getBillParameter(formId);
        billParam = new BillParam();
        if (obj != null) {
            OverallParam overallParam = new OverallParam();
            overallParam.setViewBill(obj.getBoolean(IS_VIEW_BILL));
            overallParam.setMaxReturnData(obj.getInt(MAX_RETURN_DATA));
            overallParam.setEnableSignOrg(obj.getBoolean(IS_ENABLE_SIGN_ORG));
            billParam.setOverallParam(overallParam);
            billParam.setFuzzySearch(this.getFuzzySearch(obj, formId));
            MobileListF7Config mobileListF7Config = new MobileListF7Config(Boolean.valueOf(obj.getBoolean("isenabled")));
            mobileListF7Config.setPrimaryField(obj.getString("primaryfield"));
            mobileListF7Config.setSecondField(obj.getString("secondfield"));
            mobileListF7Config.setIconField(obj.getString("iconfield"));
            mobileListF7Config.setShowModal(obj.getBoolean("showmodal"));
            mobileListF7Config.setPageRow(obj.getInt("pagerow"));
            mobileListF7Config.setEnabledTree(obj.getBoolean("isenabledtree"));
            mobileListF7Config.setShowSearch(obj.getBoolean("showsearch"));
            billParam.setMobileListF7Config(mobileListF7Config);
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)formId);
        boolean isTreeBasedata = false;
        DataEntityPropertyCollection properties = mainType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof ParentBasedataProp)) continue;
            isTreeBasedata = true;
            break;
        }
        if (isTreeBasedata && billParam.getMobileListF7Config().isEnabledTree()) {
            billParam.getMobileListF7Config().setEnabled(true);
        } else {
            billParam.getMobileListF7Config().setEnabledTree(false);
        }
        ParameterLocalCache.putBillParam(formId, billParam);
        return billParam;
    }

    public Map<String, Object> loadBillParameterObjectFromCache(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject obj = this.getBillParameter(formId);
        if (obj == null) {
            return new HashMap<String, Object>();
        }
        MainEntityType type = (MainEntityType)obj.getDataEntityType();
        DataEntityPropertyCollection props = type.getProperties();
        for (IDataEntityProperty prop : props) {
            result.put(prop.getName(), obj.get(prop.getName()));
        }
        return result;
    }

    private FuzzySearch getFuzzySearch(DynamicObject dataEntity, String formId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        BasedataEntityType entityType = null;
        if (dataEntityType instanceof BasedataEntityType) {
            entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)formId);
        }
        DynamicObjectCollection entryList = null;
        if (dataEntity != null) {
            entryList = (DynamicObjectCollection)dataEntity.get(FUZZY_SEARCH_ENTRY);
        }
        if (entryList != null && !entryList.isEmpty()) {
            FuzzySearch setting = new FuzzySearch();
            for (DynamicObject entry : entryList) {
                float fieldWidth;
                String fieldId = entry.get(FIELD_ID).toString();
                IDataEntityProperty property = null;
                if (entityType != null) {
                    property = entityType.findProperty(fieldId);
                }
                String fieldName = property != null ? property.getDisplayName().toString() : entry.get(FIELD_NAME).toString();
                BigDecimal width = (BigDecimal)entry.get(FIELD_WIDTH);
                float f = fieldWidth = width != null ? width.floatValue() : 150.0f;
                if (StringUtils.isBlank((CharSequence)fieldId)) continue;
                int comboListIndex = -1;
                if (Boolean.TRUE.equals(entry.get(COMBO_LIST_SHOW)) || entityType != null && (StringUtils.equals((CharSequence)fieldId, (CharSequence)entityType.getNumberProperty()) || StringUtils.equals((CharSequence)fieldId, (CharSequence)entityType.getNameProperty()))) {
                    comboListIndex = setting.getComboListFields().size();
                }
                this.addItem(setting, fieldId, fieldName, fieldWidth, Boolean.TRUE.equals(entry.get(IS_SEARCH)) ? setting.getSearchFields().size() : -1, comboListIndex, Boolean.TRUE.equals(entry.get(COMBO_LIST_SHOW)) ? (Boolean)entry.get(COMBO_LIST_SHOW) : false);
            }
            setting.setPageSize(StringUtils.isBlank((Object)dataEntity.get(PAGE_SIZE)) ? 20 : Integer.parseInt(dataEntity.get(PAGE_SIZE).toString()));
            setting.setDefaultSort(StringUtils.isBlank((Object)dataEntity.get(DEFAULT_SORT)) ? true : Boolean.parseBoolean(dataEntity.get(DEFAULT_SORT).toString()));
            if (dataEntity.containsProperty(IS_F7FULLNAME)) {
                setting.setF7FullName(!StringUtils.isBlank((Object)dataEntity.get(IS_F7FULLNAME)) && StringUtils.equals((CharSequence)String.valueOf(dataEntity.get(IS_F7FULLNAME)), (CharSequence)"fullname"));
            }
            setting.setSortOrder(dataEntity.getString("sortorder"));
            return setting;
        }
        return null;
    }

    private void addItem(FuzzySearch setting, String id, String caption, float width, int searchIndex, int comboListIndex, boolean visible) {
        ShowColumn item = new ShowColumn(id, caption, width, visible);
        if (comboListIndex != -1) {
            setting.getComboListFields().add(comboListIndex, item);
        }
        if (searchIndex != -1) {
            setting.getSearchFields().add(searchIndex, id);
        }
    }

    public DynamicObject getBillTypeParameter(String formId, String paramFormId, long billTypeId) {
        MainEntityType entityType;
        if (billTypeId == 0L) {
            return null;
        }
        DynamicObject object = ParameterLocalCache.getBillTypeParameter(formId, billTypeId);
        if (object != null) {
            return object;
        }
        String data = ParameterCache.getBillTypeParamFromCache(formId, billTypeId);
        if (data != null) {
            object = ParameterUtils.serializeToDataEntity(data, paramFormId);
            ParameterLocalCache.putBillTypeParameter(formId, billTypeId, object);
            return object;
        }
        String sql = " SELECT FDATA FROM T_BAS_BILLTYPEPARAMETER WHERE FFORMID=? AND FBILLTYPEID=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FFORMID", 12, (Object)formId));
        params.add(new SqlParameter(":FBILLTYPEID", -5, (Object)billTypeId));
        DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (StringUtils.isNotBlank((CharSequence)formId) && (entityType = EntityMetadataCache.getDataEntityType((String)formId)) instanceof BillEntityType) {
            object = ParameterUtils.serializeToDataEntity(existData, paramFormId);
            ParameterLocalCache.putBillTypeParameter(formId, billTypeId, object);
            String dataTemp = existData != null && !existData.isEmpty() ? ((DynamicObject)existData.get(0)).getString(0) : null;
            ParameterCache.putBillTypeParamToCache(formId, billTypeId, dataTemp);
            return object;
        }
        return null;
    }

    public Map<String, Object> loadPublicParameterFromCache() {
        return this.loadPublicParameterFromCache("bos_publicparametertpl");
    }

    public Map<String, Object> loadPublicParameterFromCache(String publicParamFormId) {
        Object showContent;
        Map<String, Object> result = ParameterCache.getPublicParameter(publicParamFormId);
        if (result == null) {
            DynamicObject paramData = this.queryPublicParameter(publicParamFormId);
            if (paramData == null) {
                return new HashMap<String, Object>();
            }
            MainEntityType type = (MainEntityType)paramData.getDataEntityType();
            result = new HashMap<String, Object>(16);
            DataEntityPropertyCollection props = type.getProperties();
            for (IDataEntityProperty prop : props) {
                result.put(prop.getName(), paramData.get(prop.getName()));
            }
            ParameterCache.putPublicParameter(result, publicParamFormId);
            result = ParameterCache.getPublicParameter(publicParamFormId);
        }
        if ("bos_publicparametertpl".equals(publicParamFormId) && (showContent = result.get("showcontent")) != null) {
            String showContentNew = (String)showContent;
            showContentNew = showContentNew.replace(",2", "");
            result.put("showcontent", showContentNew);
        }
        return result;
    }

    private DynamicObject queryPublicParameter(String publicParamFormId) {
        ParamPublishObject param = this.getPublicObject(publicParamFormId);
        if (param == null) {
            logger.error("\u83b7\u53d6\u7cfb\u7edf\u516c\u5171\u53c2\u6570\u8868\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        String sql = "SELECT FDATA FROM T_BAS_SYSPARAMETER WHERE FPARAMID=? AND FORGID=? AND FVIEWTYPEID=? AND FACCTBOOKID=? AND FACCTINGBOOKID=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(FPARAMID, 12, (Object)param.getId()));
        params.add(new SqlParameter(FORGID, -5, (Object)0));
        params.add(new SqlParameter(FVIEWTYPEID, 12, (Object)"0"));
        params.add(new SqlParameter(FACCTBOOKID, -5, (Object)0));
        params.add(new SqlParameter(FACCTINGBOOKID, -5, (Object)0));
        DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        return ParameterUtils.serializeToDataEntity(existData, param.getFormId());
    }

    public DynamicObject getPublicParameter() {
        return this.getPublicParameter("bos_publicparametertpl");
    }

    public DynamicObject getPublicParameter(String publicParamFormId) {
        Object sc;
        DynamicObject pp = this.queryPublicParameter(publicParamFormId);
        if ("bos_publicparametertpl".equals(publicParamFormId) && pp != null && (sc = pp.get("showContent")) != null) {
            String showContentNew = (String)sc;
            showContentNew = showContentNew.replace(",2", "");
            pp.set("showContent", (Object)showContentNew);
        }
        return pp;
    }

    @Deprecated
    public DynamicObject getSystemParameter(String cloudId, String appId, String viewType, long orgId, long acctBookId) {
        AppParam appParam = new AppParam(cloudId, appId, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        return this.getSystemParameter(appParam);
    }

    public DynamicObject getSystemParameter(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterReaderServiceImpl.getSystemParameter(AppParam),AppParam=null");
            return null;
        }
        ParamPublishObject param = this.getParameterObject(appParam.getCloudId(), appParam.getAppId());
        if (param == null) {
            return null;
        }
        List orgIds = ParameterHelper.getSuperiorOrgIds((long)appParam.getOrgId(), (String)appParam.getViewType());
        AppParam queryParam = new AppParam(null, null, appParam.getViewType(), orgIds, appParam.getActBookId(), appParam.getAcctingBookId());
        queryParam.setFormId(param.getFormId());
        queryParam.setParamId(param.getId());
        queryParam.setGcFields(this.getGroupControlFields(param.getFormId()));
        List<Map<String, Object>> orgParams = new ParameterHelperServiceImpl().getParamFromDBBySortOrg(queryParam);
        List paramItems = ParamConvert.getParamItems((String)param.getFormId());
        Map rows = ParamConvert.getParamRows(orgParams, (List)paramItems);
        ArrayList reverOrgIds = new ArrayList(orgIds);
        Collections.reverse(reverOrgIds);
        Map paramData = ParameterHelper.handleParameterPlus((Map)rows, (List)paramItems, (long)appParam.getOrgId(), reverOrgIds);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)param.getFormId());
        DynamicObject result = (DynamicObject)entityType.createInstance();
        for (Map.Entry entry : paramData.entrySet()) {
            result.set((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Deprecated
    public Map<String, Object> loadSystemParameterFromCache(String cloudId, String appId, String viewType, long orgId, long acctBookId) {
        AppParam appParam = new AppParam(cloudId, appId, viewType, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(0L));
        return this.loadSystemParameterFromCache(appParam);
    }

    public Map<String, Object> loadSystemParameterFromCache(AppParam appParam) {
        appParam = (AppParam)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)appParam), AppParam.class);
        ISysParamServiceFacade facade = SysParamServiceFactory.getFacade();
        if (null == facade || facade.getNoOrgFlag().booleanValue()) {
            String appViewType = "0";
            appParam.setViewType(appViewType);
            appParam.setOrgId(Long.valueOf(0L));
            Map<String, Object> result = ParameterCache.getAppParameter(appParam);
            ParameterLog.info("ParameterReader.loadSystemParameterFromCache\uff0cresult=", appParam, result);
            if (result == null) {
                ParamPublishObject param = this.getParameterObject(appParam.getCloudId(), appParam.getAppId());
                if (param == null) {
                    return null;
                }
                Map<String, Object> paramData = this.getParamData(appParam, param);
                result = new HashMap<String, Object>(16);
                result.putAll(paramData);
                if (StringUtils.isBlank((CharSequence)appParam.getCloudId())) {
                    ParameterCache.putAppParameter(appParam, result);
                    result = ParameterCache.getAppParameter(appParam);
                    ParameterLog.info("ParameterReader.loadSystemParameterFromCache put\uff0cresult=", appParam, result);
                }
            }
            return result;
        }
        String appViewType = this.getOrgViewType(appParam.getAppId());
        appParam.setViewType(appViewType);
        Map<String, Object> result = ParameterCache.getAppParameter(appParam);
        ParameterLog.info("ParameterReader.loadSystemParameterFromCache\uff0cresult=", appParam, result);
        if (result == null) {
            ParamPublishObject param = this.getParameterObject(appParam.getCloudId(), appParam.getAppId());
            if (param == null) {
                return null;
            }
            Map<String, Object> paramData = this.getParamData(appParam, param);
            result = new HashMap<String, Object>(16);
            result.putAll(paramData);
            if (StringUtils.isBlank((CharSequence)appParam.getCloudId())) {
                ParameterCache.putAppParameter(appParam, result);
                result = ParameterCache.getAppParameter(appParam);
                ParameterLog.info("ParameterReader.loadSystemParameterFromCache put\uff0cresult=", appParam, result);
            }
        }
        return result;
    }

    private Map<String, Object> getParamData(AppParam appParam, ParamPublishObject param) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(appParam.getOrgId());
        Map<Long, List<Long>> allSuperiorOrgs = ParameterOrgUtils.getAllSuperiorOrgs(appParam.getViewType(), orgIdList, false);
        for (Map.Entry<Long, List<Long>> entry : allSuperiorOrgs.entrySet()) {
            Long key = entry.getKey();
            List<Long> value = entry.getValue();
            value.add(key);
            Collections.reverse(value);
            allSuperiorOrgs.put(key, value);
        }
        ArrayList<Long> superiorOrgIds = new ArrayList<Long>(allSuperiorOrgs.getOrDefault(appParam.getOrgId(), new ArrayList()));
        Collections.reverse(superiorOrgIds);
        Map<String, Map<String, Object>> sysParamByOrg = this.getSysParamByOrg(orgIdList, appParam.getActBookId(), appParam.getAcctingBookId(), appParam.getViewType(), param, superiorOrgIds, allSuperiorOrgs);
        Map paramData = sysParamByOrg.getOrDefault(String.valueOf(appParam.getOrgId()), new HashMap(0));
        return paramData;
    }

    @Deprecated
    public Map<String, Map<String, Object>> loadBatchSystemParameterByOrg(String cloudId, String appId, String viewType, List<Long> orgIds, long acctBookId) {
        AppParam appParam = new AppParam(cloudId, appId, viewType, orgIds, Long.valueOf(acctBookId), Long.valueOf(0L));
        return this.loadBatchSystemParameterByBatchOrg(appParam);
    }

    public Map<String, Map<String, Object>> loadBatchSystemParameterByBatchOrg(AppParam appParam) {
        ISysParamServiceFacade facade = SysParamServiceFactory.getFacade();
        if (null == facade || facade.getNoOrgFlag().booleanValue()) {
            return this.loadBatchSysParamByNoOrg(appParam);
        }
        return this.loadBatchSysParamByOrg(appParam);
    }

    @Deprecated
    public Map<String, Map<String, Object>> loadBatchSystemParameterByOrgFromCache(String cloudId, String appId, String viewType, List<Long> orgIds, long acctBookId) {
        AppParam appParam = new AppParam(cloudId, appId, viewType, orgIds, Long.valueOf(acctBookId), Long.valueOf(0L));
        return this.loadBatchSystemParameterByOrgFromCache(appParam);
    }

    public Map<String, Map<String, Object>> loadBatchSystemParameterByOrgFromCache(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterReaderServiceImpl.loadBatchSystemParameterByOrgFromCache(kd.bos.entity.param.AppParam),AppParam=null");
            return null;
        }
        String appViewType = this.getOrgViewType(appParam.getAppId());
        appParam.setViewType(appViewType);
        List orgIds = appParam.getOrgIds();
        HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>(16);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return res;
        }
        for (Long orgId : orgIds) {
            AppParam newAppParam = new AppParam(appParam.getCloudId(), appParam.getAppId(), appParam.getViewType(), orgId, appParam.getActBookId(), appParam.getAcctingBookId());
            Map<String, Object> param = this.loadSystemParameterFromCache(newAppParam);
            res.put(String.valueOf(orgId), param);
        }
        return res;
    }

    private Map<String, Map<String, Object>> getBatchSystemParameterByCacheMap(AppParam appParam, String appViewType, Map<String, Map<String, Object>> params) {
        ArrayList<Long> orgHasNulls = null;
        AppParam orgHasNullParam = new AppParam();
        orgHasNullParam.setViewType(appViewType);
        orgHasNullParam.setActBookId(appParam.getActBookId());
        orgHasNullParam.setAcctingBookId(appParam.getAcctingBookId());
        for (Long orgId : appParam.getOrgIds()) {
            orgHasNullParam.setOrgId(orgId);
            String key = ParameterCache.genAppInnerKey(orgHasNullParam);
            Map<String, Object> value = params.get(key);
            if (value != null) continue;
            if (orgHasNulls == null) {
                orgHasNulls = new ArrayList<Long>();
            }
            orgHasNulls.add(orgId);
        }
        HashMap<String, Map<String, Object>> mapParam = new HashMap<String, Map<String, Object>>(16);
        Map paramHasNulls = null;
        if (orgHasNulls != null) {
            orgHasNullParam.setCloudId(appParam.getCloudId());
            orgHasNullParam.setAppId(appParam.getAppId());
            orgHasNullParam.setOrgIds(orgHasNulls);
            paramHasNulls = this.loadBatchSystemParameterByBatchOrg(orgHasNullParam);
        }
        for (Long orgId : appParam.getOrgIds()) {
            AppParam tempParam = new AppParam();
            tempParam.setViewType(appViewType);
            tempParam.setOrgId(orgId);
            tempParam.setActBookId(appParam.getActBookId());
            tempParam.setAcctingBookId(appParam.getAcctingBookId());
            String key = ParameterCache.genAppInnerKey(tempParam);
            mapParam.put(String.valueOf(orgId), params.get(key));
        }
        if (paramHasNulls != null) {
            paramHasNulls = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(paramHasNulls), Map.class);
            mapParam.putAll(paramHasNulls);
        }
        if (!CollectionUtils.isEmpty(paramHasNulls)) {
            ParameterCache.putBatchAppParameter(appParam, paramHasNulls);
        }
        return mapParam;
    }

    private String getOrgViewType(String appId) {
        String appViewType = null;
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            AppInfo appInfo = this.getAppInfo(appId);
            if (appInfo != null) {
                appViewType = appInfo.getOrgFunc();
            } else {
                ArrayList<String> fieldKeys = new ArrayList<String>();
                fieldKeys.add(ORGFUNC);
                DynamicObjectType bizAppType = EntityMetadataCache.getSubDataEntityType((String)BOS_DEVPORTAL_BIZAPP, fieldKeys);
                Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{appId}, (DynamicObjectType)bizAppType);
                DynamicObject object = (DynamicObject)objs.get(appId);
                if (!ObjectUtils.isEmpty((Object)object)) {
                    appViewType = object.getString(ORGFUNC);
                }
            }
        }
        if (StringUtils.isBlank(appViewType)) {
            appViewType = DEFAULT_VIEW_TYPE;
        }
        return appViewType;
    }

    private AppInfo getAppInfo(String appId) {
        try {
            return AppMetadataCache.getAppInfo((String)appId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getGroupControlFields(String formId) {
        ArrayList<String> fields = new ArrayList<String>();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        Map props = type.getAllFields();
        IDataEntityProperty prop = null;
        for (Map.Entry item : props.entrySet()) {
            prop = (IDataEntityProperty)item.getValue();
            if (!(prop instanceof FieldProp && ((FieldProp)prop).isGroupControl() || prop instanceof BasedataProp && ((BasedataProp)prop).isGroupControl()) && (!(prop instanceof MulBasedataProp) || !((MulBasedataProp)prop).isGroupControl())) continue;
            fields.add((String)item.getKey());
        }
        return fields;
    }

    @Deprecated
    public DynamicObject getSystemParameter(String cloudId, String appId, long orgId, long acctBookId) {
        ParamPublishObject param = this.getParameterObject(cloudId, appId);
        if (param == null) {
            return null;
        }
        String sql = "SELECT FDATA FROM T_BAS_SYSPARAMETER WHERE FPARAMID=? AND FORGID=? AND FACCTBOOKID=? AND FACCTINGBOOKID=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(FPARAMID, 12, (Object)param.getId()));
        params.add(new SqlParameter(FORGID, -5, (Object)orgId));
        params.add(new SqlParameter(FACCTBOOKID, -5, (Object)acctBookId));
        params.add(new SqlParameter(FACCTINGBOOKID, -5, (Object)0L));
        DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        return ParameterUtils.serializeToDataEntity(existData, param.getFormId());
    }

    public DynamicObject getUserOptionParameter(Long userId, String formId, String extend) {
        MainEntityType entityType;
        if (StringUtils.isNotBlank((CharSequence)formId) && (entityType = EntityMetadataCache.getDataEntityType((String)formId)) instanceof BillEntityType) {
            String paramFormId = entityType.getUserOption();
            return this.getUserOptionParameter(userId, formId, paramFormId, UserParaType.DEFAULT, extend);
        }
        return null;
    }

    public DynamicObject getUserOptionParameter(Long userId, String bindFormId, String paramFormId, UserParaType paraType, String extend) {
        String dataJson = this.getUserOptionParameterFromCache(userId, bindFormId, paramFormId, paraType, extend);
        return ParameterUtils.serializeToDataEntity(dataJson, paramFormId);
    }

    private String getUserOptionParameterFromCache(Long userId, String bindFormId, String paramFormId, UserParaType paraType, String extend) {
        String cache = ParameterCache.getUserParamFromCache(bindFormId, userId, paraType, paramFormId + "." + (StringUtils.isBlank((CharSequence)extend) ? "" : extend));
        if (cache != null) {
            return cache;
        }
        String dataJson = this.queryUserParamDataJsonFromDB(userId, bindFormId, paraType, extend);
        ParameterCache.putUserParamToCache(bindFormId, userId, paraType, paramFormId + "." + (StringUtils.isBlank((CharSequence)extend) ? "" : extend), dataJson);
        return dataJson;
    }

    private String queryUserParamDataJsonFromDB(Long userId, String bindFormId, UserParaType paraType, String extend) {
        String sql = SELECT_DATA_FORM_T_BAS_USERPARAMETER;
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(FUSERID, -5, (Object)userId));
        params.add(new SqlParameter(FFORMID, 12, (Object)bindFormId));
        params.add(new SqlParameter(FISLISTOPTION, 1, (Object)paraType.getValue()));
        DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        DynamicObject dynamicObject0 = null;
        for (int i = existData.size() - 1; i >= 0; --i) {
            DynamicObject dynamicObject = (DynamicObject)existData.get(i);
            String extendValue = dynamicObject.getString(FEXTEND);
            if (StringUtils.isBlank((CharSequence)extend) && StringUtils.isBlank((CharSequence)extendValue)) {
                dynamicObject0 = dynamicObject;
                break;
            }
            if (!StringUtils.equals((CharSequence)extend, (CharSequence)extendValue)) continue;
            dynamicObject0 = dynamicObject;
            break;
        }
        String dataJson = this.getDataJson(dynamicObject0);
        return dataJson;
    }

    private String getDataJson(DynamicObject dynamicObject0) {
        String dataJson = null;
        if (dynamicObject0 != null && dynamicObject0.getDataEntityType().getProperties().containsKey((Object)FDATA)) {
            dataJson = dynamicObject0.getString(FDATA);
        }
        if (StringUtils.isBlank(dataJson)) {
            dataJson = "";
        }
        return dataJson;
    }

    public DynamicObject getListOptionParameter(long userId, String formId, String listOption, String extend) {
        return this.getUserOptionParameter(userId, formId, listOption, UserParaType.LIST, extend);
    }

    public boolean isExistListOptionParameter(long userId, String formId, String listOption, final String extend) {
        String sql = SELECT_DATA_FORM_T_BAS_USERPARAMETER;
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(FUSERID, -5, (Object)userId));
        params.add(new SqlParameter(FFORMID, 12, (Object)formId));
        params.add(new SqlParameter(FISLISTOPTION, 16, (Object)Boolean.TRUE));
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String extendValue = rs.getString(ParameterReaderServiceImpl.FEXTEND);
                    if (StringUtils.isBlank((CharSequence)extend) && StringUtils.isBlank((CharSequence)extendValue)) {
                        return Boolean.TRUE;
                    }
                    if (!StringUtils.equals((CharSequence)extend, (CharSequence)extendValue)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
    }

    public String getUserCustParameter(Long userId, String formId, String paramKey) {
        String cacheValue = ParameterCache.getCustParamFromCache(userId, formId, paramKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        cacheValue = this.queryUserParamDataJsonFromDB(userId, formId, UserParaType.DEFAULT, paramKey);
        if (cacheValue == null) {
            cacheValue = "";
        }
        ParameterCache.putCustParamToCache(userId, formId, paramKey, cacheValue);
        return cacheValue;
    }

    public ParamPublishObject getParameterObject(String cloudId, String appId) {
        ParamPublishObject param = ParameterCache.getParamPublishObject(cloudId, appId);
        if (param == null) {
            return this.queryParamObjectFormDb(cloudId, appId);
        }
        return param;
    }

    public ParamPublishObject getPublicObject(String publicParamFormId) {
        ParamPublishObject param = ParameterCache.getPublicParam(publicParamFormId);
        if (param == null) {
            return this.queryPublicParamFormDb(publicParamFormId);
        }
        return param;
    }

    private ParamPublishObject queryPublicParamFormDb(String publicParamFormId) {
        String sql = "SELECT FID, FFORMID, FCLOUDID, FAPPID, FACCTBOOKENABLED FROM T_BAS_SYSPARACONSOLE WHERE FFORMID=? AND FENABLED='1'";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(FFORMID, 12, (Object)(StringUtils.isBlank((CharSequence)publicParamFormId) ? " " : publicParamFormId)));
        DynamicObjectCollection collection = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (collection == null || collection.isEmpty()) {
            logger.info(String.format("REDIS\u7cfb\u7edf\u53c2\u6570\u8868\u5355\u4fe1\u606f\u7f13\u5b58\u4e3a\u7a7a\uff0cDB\u52a0\u8f7d\u4fe1\u606f\u4e5f\u4e3a\u7a7a\u4e86\uff0cSQL=%s\uff0cSqlParam=%s", sql, params));
            return null;
        }
        ParamPublishObject param = new ParamPublishObject();
        for (DynamicObject obj : collection) {
            param.setId(obj.get(0).toString());
            param.setFormId(obj.get(1).toString());
            param.setCloudId(obj.get(2).toString());
            param.setAppId(obj.get(3).toString());
            param.setActBookEnable(obj.getBoolean(4));
        }
        ParameterCache.putPublicParam(param);
        return ParameterCache.getPublicParam(publicParamFormId);
    }

    private ParamPublishObject queryParamObjectFormDb(String cloudId, String appId) {
        String sql = "SELECT FID, FFORMID, FCLOUDID, FAPPID, FACCTBOOKENABLED FROM T_BAS_SYSPARACONSOLE WHERE FCLOUDID=? AND FAPPID=? AND FENABLED='1'";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(FCLOUDID, 12, (Object)(StringUtils.isBlank((CharSequence)cloudId) ? " " : cloudId)));
        params.add(new SqlParameter(FAPPID, 12, (Object)(StringUtils.isBlank((CharSequence)appId) ? " " : appId)));
        DynamicObjectCollection collection = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (collection == null || collection.isEmpty()) {
            logger.info(String.format("REDIS\u7cfb\u7edf\u53c2\u6570\u8868\u5355\u4fe1\u606f\u7f13\u5b58\u4e3a\u7a7a\uff0cDB\u52a0\u8f7d\u4fe1\u606f\u4e5f\u4e3a\u7a7a\u4e86\uff0cSQL=%s\uff0cSqlParam=%s", sql, params));
            return null;
        }
        boolean isSysTem = StringUtils.isBlank((CharSequence)cloudId) && StringUtils.isBlank((CharSequence)appId);
        ParamPublishObject param = new ParamPublishObject();
        for (DynamicObject obj : collection) {
            String formId = obj.get(1).toString();
            param.setId(obj.get(0).toString());
            param.setFormId(formId);
            param.setCloudId(obj.get(2).toString());
            param.setAppId(obj.get(3).toString());
            param.setActBookEnable(obj.getBoolean(4));
            if (!isSysTem || !"bos_publicparametertpl".equals(formId)) continue;
            break;
        }
        ParameterCache.putParamPublishObject(param);
        return ParameterCache.getParamPublishObject(cloudId, appId);
    }

    public String getParameterFormId(String subSystem) {
        subSystem = StringUtils.isBlank((CharSequence)subSystem) ? "public/common" : subSystem;
        DynamicObjectCollection collection = SingleORM.query(null, (String)" SELECT FFORMID FROM T_BAS_SYSPARACONSOLE WHERE FSUBSYSTEM = ? AND FENABLED = '1' ", (Object[])new SqlParameter[]{new SqlParameter(FSUBSYSTEM, 12, (Object)subSystem)});
        return collection != null && !collection.isEmpty() ? ((DynamicObject)collection.get(0)).getString(0) : null;
    }

    public List<ParamPublishObject> getParameterObjects(String cloudId, String appId) {
        ArrayList<ParamPublishObject> result = new ArrayList<ParamPublishObject>();
        String sql = " SELECT FCLOUDID, FAPPID, FFORMID, FACCTBOOKENABLED FROM T_BAS_SYSPARACONSOLE WHERE FCLOUDID=? AND FAPPID=? AND FENABLED = '1' AND FFORMID IS NOT NULL ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FCLOUDID", 12, (Object)(StringUtils.isBlank((CharSequence)cloudId) ? " " : cloudId)));
        params.add(new SqlParameter(":FAPPID", 12, (Object)(StringUtils.isBlank((CharSequence)appId) ? " " : appId)));
        DynamicObjectCollection collection = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (collection != null && !collection.isEmpty()) {
            ParamPublishObject param = null;
            for (DynamicObject object : collection) {
                param = new ParamPublishObject();
                if (object.get(0) != null) {
                    param.setCloudId(object.getString(0));
                }
                if (object.get(1) != null) {
                    param.setAppId(object.getString(1));
                }
                param.setFormId(object.getString(2));
                param.setActBookEnable(object.getBoolean(3));
                result.add(param);
            }
        }
        return result;
    }

    public ParamPublishObject getParameterObjByFormId(String paramFormId) {
        String sql = "SELECT FID, FFORMID, FCLOUDID, FAPPID, FSELECTEDFIELDS from T_BAS_SYSPARACONSOLE where FENABLED='1' and FFORMID=?";
        ArrayList<SqlParameter> param = new ArrayList<SqlParameter>();
        param.add(new SqlParameter(12, (Object)paramFormId));
        DynamicObjectCollection doc = SingleORM.query(null, (String)sql, (Object[])param.toArray(new SqlParameter[param.size()]));
        if (doc == null || doc.isEmpty()) {
            return null;
        }
        ParamPublishObject pO = new ParamPublishObject();
        for (DynamicObject obj : doc) {
            pO.setId(obj.get(0).toString());
            pO.setFormId(obj.get(1).toString());
            pO.setCloudId(obj.get(2).toString());
            pO.setAppId(obj.get(3).toString());
            pO.setSelectedFields(obj.get(4) != null ? obj.get(4).toString() : null);
        }
        return pO;
    }

    public Object queryAcctBookId(String cloudId, String appId, String viewType, long orgId) {
        AppParam appParam = new AppParam(cloudId, appId, viewType, Long.valueOf(orgId), Long.valueOf(0L), Long.valueOf(0L));
        Map<String, Long> map = this.queryAcctBook(appParam);
        if (null != map) {
            return map.get(FACCTBOOKID);
        }
        return null;
    }

    public Map<String, Long> queryAcctBook(AppParam appParam) {
        DynamicObjectCollection existData;
        if (null == appParam) {
            ParameterLog.info("ParameterReaderService.queryAcctBook(AppParam appParam)\uff0cappParam=null");
            return null;
        }
        ParamPublishObject param = this.getParameterObject(appParam.getCloudId(), appParam.getAppId());
        if (param == null) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u8868\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        String sql = "SELECT FACCTBOOKID,FACCTINGBOOKID FROM T_BAS_SYSPARAMETER WHERE FPARAMID=? AND FORGID=? AND FVIEWTYPEID=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(FPARAMID, 12, (Object)param.getId()));
        params.add(new SqlParameter(FORGID, -5, (Object)appParam.getOrgId()));
        params.add(new SqlParameter(FVIEWTYPEID, 12, (Object)appParam.getViewType()));
        if (0L != appParam.getActBookId()) {
            sql = sql + " AND FACCTBOOKID=?";
            params.add(new SqlParameter(FACCTBOOKID, -5, (Object)appParam.getActBookId()));
        }
        if (0L != appParam.getAcctingBookId()) {
            sql = sql + " AND FACCTINGBOOKID=?";
            params.add(new SqlParameter(FACCTINGBOOKID, -5, (Object)appParam.getAcctingBookId()));
        }
        if ((existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]))) != null && existData.size() != 0) {
            HashMap<String, Long> map = new HashMap<String, Long>(16);
            if (null != existData.get(0) && ((DynamicObject)existData.get(0)).get(FACCTBOOKID) instanceof Long && ((DynamicObject)existData.get(0)).get(FACCTINGBOOKID) instanceof Long) {
                Long facctbookid = (Long)((DynamicObject)existData.get(0)).get(FACCTBOOKID);
                Long facctingbookid = (Long)((DynamicObject)existData.get(0)).get(FACCTINGBOOKID);
                map.put(FACCTBOOKID, facctbookid);
                map.put(FACCTINGBOOKID, facctingbookid);
            }
            return map;
        }
        return null;
    }

    private Map<String, Map<String, Object>> loadBatchSysParamByOrg(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterReaderServiceImpl.loadBatchSysParamByOrg,AppParam=null");
            return null;
        }
        String appViewType = this.getOrgViewType(appParam.getAppId());
        appParam.setViewType(appViewType);
        ParamPublishObject param = this.getParameterObject(appParam.getCloudId(), appParam.getAppId());
        if (param == null) {
            logger.error(String.format("Get ParamPublishObject null, cloudId=%s,appId=%s", appParam.getCloudId(), appParam.getAppId()));
            return null;
        }
        Map<Long, List<Long>> allSuperiorOrgs = ParameterOrgUtils.getAllSuperiorOrgs(appParam.getViewType(), appParam.getOrgIds(), false);
        if (allSuperiorOrgs.size() <= 50) {
            for (Map.Entry<Long, List<Long>> entry : allSuperiorOrgs.entrySet()) {
                Long key = entry.getKey();
                List<Long> value = entry.getValue();
                value.add(key);
                Collections.reverse(value);
                allSuperiorOrgs.put(key, value);
            }
            HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>(allSuperiorOrgs.size());
            List orgIds = appParam.getOrgIds();
            for (Long orgId : orgIds) {
                ArrayList<Long> superiorOrgIds;
                List<Long> parentIds = allSuperiorOrgs.get(orgId);
                ArrayList<Long> arrayList = superiorOrgIds = parentIds != null ? new ArrayList<Long>(parentIds) : null;
                if (superiorOrgIds != null) {
                    Collections.reverse(superiorOrgIds);
                }
                ArrayList<Long> searchOrgIds = new ArrayList<Long>(1);
                searchOrgIds.add(orgId);
                Map<String, Map<String, Object>> sysParamByOrg = this.getSysParamByOrg(searchOrgIds, appParam.getActBookId(), appParam.getAcctingBookId(), appParam.getViewType(), param, superiorOrgIds, allSuperiorOrgs);
                res.putAll(sysParamByOrg);
            }
            return res;
        }
        logger.warn("\u6279\u91cf\u63a5\u53e3\u4f20\u5165\u67e5\u8be2\u7684\u7ec4\u7ec7\u8d85\u8fc750\u4e2a\uff0c\u8017\u8d39\u6027\u80fd\uff0c\u4e14\u987a\u5e8f\u53ef\u80fd\u51fa\u95ee\u9898\u5bfc\u81f4\u53c2\u6570\u53d6\u503c\u51fa\u95ee\u9898\uff0c\u8bf7\u8f6c\u8c03loadBatchSystemParameterByOrgFromCache\u65b9\u6cd5");
        for (Map.Entry<Long, List<Long>> entry : allSuperiorOrgs.entrySet()) {
            Long key = entry.getKey();
            List<Long> value = entry.getValue();
            value.add(key);
            allSuperiorOrgs.put(key, value.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()));
        }
        List<Long> superiorOrgIds = allSuperiorOrgs.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return this.getSysParamByOrg(appParam.getOrgIds(), appParam.getActBookId(), appParam.getAcctingBookId(), appParam.getViewType(), param, superiorOrgIds, allSuperiorOrgs);
    }

    private Map<String, Map<String, Object>> loadBatchSysParamByNoOrg(AppParam appParam) {
        if (null == appParam) {
            ParameterLog.info("ParameterReaderServiceImpl.loadBatchSysParamByNoOrg,AppParam=null");
            return null;
        }
        String appViewType = "0";
        appParam.setViewType(appViewType);
        ParamPublishObject param = this.getParameterObject(appParam.getCloudId(), appParam.getAppId());
        if (param == null) {
            logger.error(String.format("Get ParamPublishObject null, cloudId=%s,appId=%s", appParam.getCloudId(), appParam.getAppId()));
            return null;
        }
        List<Long> superiorOrgIds = Stream.of(Long.valueOf(0L)).collect(Collectors.toList());
        HashMap<Long, List<Long>> allSuperiorOrgs = new HashMap<Long, List<Long>>();
        allSuperiorOrgs.put(0L, new ArrayList(1));
        return this.getSysParamByOrg(appParam.getOrgIds(), appParam.getActBookId(), appParam.getAcctingBookId(), appParam.getViewType(), param, superiorOrgIds, allSuperiorOrgs);
    }

    private Map<String, Map<String, Object>> getSysParamByOrg(List<Long> orgIds, long acctBookId, long acctingBookId, String appViewType, ParamPublishObject param, List<Long> superiorOrgIds, Map<Long, List<Long>> allSuperiorOrgs) {
        HashMap<String, Map<String, Object>> mapRet = new HashMap<String, Map<String, Object>>(16);
        if (CollectionUtils.isEmpty(orgIds)) {
            return mapRet;
        }
        AppParam appParam = new AppParam(null, null, appViewType, superiorOrgIds, Long.valueOf(acctBookId), Long.valueOf(acctingBookId));
        appParam.setFormId(param.getFormId());
        appParam.setParamId(param.getId());
        appParam.setGcFields(this.getGroupControlFields(param.getFormId()));
        List<Map<String, Object>> orgParams = new ParameterHelperServiceImpl().getParamFromDBBySortOrg(appParam);
        List paramItems = ParamConvert.getParamItems((String)param.getFormId());
        Map rows = ParamConvert.getParamRows(orgParams, (List)paramItems);
        for (Long orgId : orgIds) {
            List<Long> parentOrgIds = allSuperiorOrgs.get(orgId);
            if (parentOrgIds == null) continue;
            Map paramData = ParameterHelper.handleParameterPlus((Map)rows, (List)paramItems, (long)orgId, parentOrgIds);
            HashMap result = new HashMap(16);
            for (Map.Entry entry : paramData.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
            mapRet.put(String.valueOf(orgId), result);
        }
        return mapRet;
    }

    public Map<String, String> loadCustomParameterFromCache(CustomParam customParam) {
        Map appCustomParameterMap = (Map)ThreadCache.get((Object)this.getThreadCacheKey(customParam), () -> {
            HashMap<String, String> res = new HashMap<String, String>(16);
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam", (String)"id,key,value", (QFilter[])this.getCustomQFilter(customParam));
            for (DynamicObject dynamicObject : loadFromCache.values()) {
                String key = dynamicObject.getString("key");
                String value = dynamicObject.getString("value");
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                res.put(key, value);
            }
            return res;
        });
        return appCustomParameterMap;
    }

    public Map<String, String> loadAppCustomParameterFromCache(AppCustomParam customParam) {
        Map appCustomParameterMap = (Map)ThreadCache.get((Object)this.getThreadCacheKey(customParam), () -> {
            HashMap<String, String> res = new HashMap<String, String>(16);
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam_app", (String)"id,key,value", (QFilter[])this.getAppCustomQFilter(customParam));
            for (DynamicObject dynamicObject : loadFromCache.values()) {
                String key = dynamicObject.getString("key");
                String value = dynamicObject.getString("value");
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                res.put(key, value);
            }
            return res;
        });
        return appCustomParameterMap;
    }

    private String getThreadCacheKey(CustomParam customParam) {
        Set searchKeySet = customParam.getSearchKeySet();
        StringBuilder builder = new StringBuilder();
        builder.append("parameterCustom.").append(customParam.getGroupNumber()).append(".");
        if (!CollectionUtils.isEmpty((Collection)searchKeySet)) {
            for (String key : searchKeySet) {
                builder.append(key).append("-");
            }
        }
        return builder.toString();
    }

    private String getThreadCacheKey(AppCustomParam customParam) {
        Set searchKeySet = customParam.getSearchKeySet();
        StringBuilder builder = new StringBuilder();
        builder.append("parameterCustom.").append(customParam.getAppId()).append(".");
        if (!CollectionUtils.isEmpty((Collection)searchKeySet)) {
            for (String key : searchKeySet) {
                builder.append(key).append("-");
            }
        }
        return builder.toString();
    }

    private QFilter[] getCustomQFilter(CustomParam customParam) {
        String groupNumber = customParam.getGroupNumber();
        QFilter qFilter = new QFilter("group.number", "=", (Object)groupNumber);
        Set keySet = customParam.getSearchKeySet();
        if (!CollectionUtils.isEmpty((Collection)keySet)) {
            qFilter.and(new QFilter("key", "in", (Object)keySet));
        }
        return new QFilter[]{qFilter};
    }

    private QFilter[] getAppCustomQFilter(AppCustomParam customParam) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        qFilterList.add(new QFilter("appid", "=", (Object)customParam.getAppId()));
        Set keySet = customParam.getSearchKeySet();
        if (!CollectionUtils.isEmpty((Collection)keySet)) {
            qFilterList.add(new QFilter("key", "in", (Object)keySet));
        }
        return qFilterList.toArray(new QFilter[0]);
    }
}

