/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.attachment.util.AttachmentCommonUtils;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.control.Control;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeCloseListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.WebOfficeEventDispatcher;
import kd.bos.form.control.events.webOffice.event.WebOfficeAfterClosedEvent;
import kd.bos.form.control.model.WebOfficeCheckBox;
import kd.bos.form.control.model.WebOfficeDocProtectionType;
import kd.bos.form.control.model.WebOfficeFileType;
import kd.bos.form.control.model.WebOfficeImage;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.control.model.WebOfficeMergeType;
import kd.bos.form.control.model.WebOfficeTrackingType;
import kd.bos.form.control.model.WebofficeWaterMark;
import kd.bos.form.control.util.AttachmentParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.sdk.annotation.SdkPublic;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

@SdkPublic
public class WebOffice
extends Control {
    private static final String ATTACHMENT_UPLOAD_FILE_DO = "/attachment/uploadFile.do";
    private static final String USER_NAME = "userName";
    private static final String UPLOAD_URL = "uploadUrl";
    private static final String FIELD = "field";
    private static final String PW = "password";
    private static final String VALUE = "value";
    private List<UploadListener> uploadListeners = new ArrayList<UploadListener>();
    private List<WebOfficeDataListener> dataListeners = new ArrayList<WebOfficeDataListener>();
    private List<WebOfficeCloseListener> closeListeners = new ArrayList<WebOfficeCloseListener>();
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static DistributeSessionlessCache fileInfoRedisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("FILEINFO", new DistributeCacheHAPolicy(true, true));
    private static final Log log = LogFactory.getLog(WebOffice.class);
    private static final String DEFAULT_WEB_OFFICE = "1";

    @KSMethod
    public void addCloseListener(WebOfficeCloseListener listener) {
        this.closeListeners.add(listener);
    }

    @KSMethod
    public void addUploadListener(UploadListener listener) {
        this.uploadListeners.add(listener);
    }

    @KSMethod
    public void addDataListener(WebOfficeDataListener listener) {
        this.dataListeners.add(listener);
    }

    public void upload(Map<String, Object> file) {
        if (file == null) {
            return;
        }
        if (StringUtils.isBlank((Object)file.get("name"))) {
            log.info("weboffice upload file info is:" + SerializationUtils.toJsonString(file));
            String curDateFormat = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            file.put("name", "newFile_" + curDateFormat + ".docx");
            this.getView().getPageCache().put("version", curDateFormat);
        }
        UploadEvent event = new UploadEvent((Object)this, (Object[])new Map[]{file}, this.getKey());
        for (UploadListener l : this.uploadListeners) {
            l.upload(event);
            if (!event.isCancel()) {
                l.afterUpload(event);
            }
            if (!event.isCancel()) continue;
            return;
        }
    }

    public void reportData(Map<String, Object> data) {
        if (data == null || data.isEmpty() || this.dataListeners.isEmpty()) {
            return;
        }
        WebOfficeEventDispatcher.dispatch(data, this);
    }

    @KSMethod
    public void afterClose(Map<String, Object> data) {
        if (data == null || data.isEmpty() || this.closeListeners.isEmpty()) {
            return;
        }
        WebOfficeAfterClosedEvent event = new WebOfficeAfterClosedEvent((Object)this);
        for (WebOfficeCloseListener closeListener : this.closeListeners) {
            if (event.isCancel()) {
                return;
            }
            closeListener.afterClosed(event);
        }
    }

    public void open(String url) {
        this.open(url, RequestContext.get().getUserName());
    }

    public void open(String url, String userName) {
        this.open(url, userName, true);
    }

    public void open(String url, String userName, boolean edit) {
        String domainUrl = UrlService.getDomainContextUrl();
        String uploadUrl = domainUrl + ATTACHMENT_UPLOAD_FILE_DO;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Object newOpenUrl = this.getOpenUrl(url);
        dataMap.put("url", newOpenUrl);
        dataMap.put(USER_NAME, userName);
        dataMap.put(UPLOAD_URL, uploadUrl);
        if (this.isWpsPublicEdit()) {
            log.info("current edit mode is wps public");
            if (this.isWpsV3Edit()) {
                log.info("wps edit version is v3");
                dataMap.put("wpsV3FileId", this.getWpsV3FileId(url, false, null));
                dataMap.put("customEditInfo", this.getBillInfoForEdit());
            } else {
                log.info("wps edit version is v1");
                dataMap.put("editUrlForWps", this.getWpsEditUrl(url));
            }
        } else if (this.isWpsPrivateEdit()) {
            log.info("current edit mode is wps private");
            dataMap.put("editUrlForWpsPrivate", this.getWpsPrivateEditUrl(url, edit));
        } else if (this.isYozoEdit()) {
            log.info("current edit mode is yozo");
            dataMap.put("editUrlForYozo", this.geYozoEditUrl(url));
        } else if (this.isOnlyOfficeEdit()) {
            dataMap.put("onlyOfficeDownloadUrl", AttachmentParamUtil.getReplaceUrl(newOpenUrl.toString()));
        }
        this.sendAction("open", dataMap);
    }

    @KSMethod
    public void openNew(WebOfficeFileType type) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("fileType", type.getValue());
        if (this.isOnlyOfficeEdit()) {
            log.info("enter onlyoffice open new");
            String newFileUrl = this.createTempFileAndReturnUrl() + "&fromOnlyOffice=1";
            newFileUrl = AttachmentParamUtil.getReplaceUrl(newFileUrl);
            dataMap.put("templateUrlForOnlyOffice", newFileUrl);
        }
        if (this.isWpsPublicEdit()) {
            log.info("enter wps public open new");
            if (this.isWpsV3Edit()) {
                log.info("wps edit new file version is v3");
                dataMap.put("wpsV3FileIdForNewFile", this.getWpsV3FileId(null, true, type));
                dataMap.put("customEditInfo", this.getBillInfoForEdit());
            } else {
                log.info("wps edit new file version is v1");
                dataMap.put("newEditUrlForWps", this.getWpsNewEditUrlBySelf(false, type));
            }
        } else if (this.isWpsPrivateEdit()) {
            log.info("enter wps private open new");
            dataMap.put("newEditUrlForWpsPrivate", this.getWpsNewEditUrlBySelf(true, type));
        } else if (this.isYozoEdit()) {
            log.info("current edit mode is wps yozo");
            dataMap.put("newEditUrlForYozo", this.getYozoNewEditUrlBySelf(type));
        }
        this.sendAction("openNew", dataMap);
    }

    private String addCustomParams(String url) {
        return url + "&customEditInfo=" + this.getBillInfoForEdit();
    }

    private String getBillInfoForEdit() {
        IFormView view = this.getView();
        String billInfoForEdit = (String)view.getFormShowParameter().getCustomParam("billInfoForEditAttachment");
        if (StringUtils.isBlank((CharSequence)billInfoForEdit)) {
            billInfoForEdit = view.getPageCache().get("billInfoForEditAttachment");
        }
        log.info("wps\u7f16\u8f91\u4e1a\u52a1\u6240\u9700\u53c2\u6570\u4fe1\u606f\uff1a" + billInfoForEdit);
        return billInfoForEdit;
    }

    public void openAll(String url, String fileName) {
        String domainUrl = UrlService.getDomainContextUrl();
        String uploadUrl = domainUrl + ATTACHMENT_UPLOAD_FILE_DO;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("url", this.getOpenUrl(url));
        dataMap.put(USER_NAME, RequestContext.get().getUserName());
        dataMap.put(UPLOAD_URL, uploadUrl);
        dataMap.put("name", fileName);
        this.sendAction("open", dataMap);
    }

    public void open(String url, List<String> marks, String password) {
        this.open(url);
        this.setEditableAreas(marks, password);
    }

    public void open(String url, String userName, List<String> marks, String password) {
        this.open(url, userName);
        this.setEditableAreas(marks, password);
    }

    @KSMethod
    public void save(String name) {
        this.save(name, null);
    }

    @KSMethod
    public void save(String name, String id) {
        String domainUrl = UrlService.getDomainContextUrl();
        String uploadUrl = domainUrl + ATTACHMENT_UPLOAD_FILE_DO;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", id);
        dataMap.put("name", name);
        dataMap.put(UPLOAD_URL, uploadUrl);
        dataMap.put("isSplitRedis", "splitRedis".equals(System.getProperty("tempfile.cachetype", "splitRedis")));
        this.sendAction("save", dataMap);
    }

    public void close() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String domainUrl = UrlService.getDomainContextUrl();
        String uploadUrl = domainUrl + ATTACHMENT_UPLOAD_FILE_DO;
        dataMap.put(UPLOAD_URL, uploadUrl);
        this.sendAction("close", dataMap);
    }

    public void compareFile(String url1, String fileName1, String url2, String fileName2) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("currentFileUrl", url1);
        dataMap.put("currentFile", fileName1);
        dataMap.put("compareFileUrl", url2);
        dataMap.put("compareFile", fileName2);
        String domainUrl = UrlService.getDomainContextUrl();
        String uploadUrl = domainUrl + ATTACHMENT_UPLOAD_FILE_DO;
        dataMap.put(UPLOAD_URL, uploadUrl);
        this.sendAction("docCompare", dataMap);
    }

    public void insertValue(String value) {
        this.insertValue(value, false);
    }

    public void insertValue(String value, boolean needEnterBefore) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(VALUE, value);
        dataMap.put("needEnterBefore", needEnterBefore);
        this.sendAction("insertValue", dataMap);
    }

    public void sendIsFieldRevise(String field) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put(FIELD, field);
        this.sendAction("sendIsFieldRevise", dataMap);
    }

    public void addMarks(WebOfficeMark mark) {
        if (null == mark) {
            return;
        }
        this.sendAction("addMark", mark);
    }

    public void modifyMarks(List<WebOfficeMark> marks) {
        if (null == marks || marks.isEmpty()) {
            return;
        }
        this.sendAction("modifyMark", marks);
    }

    public void deleteMarks(List<String> marks) {
        if (null == marks || marks.isEmpty()) {
            return;
        }
        List list = marks.stream().map(field -> new WebOfficeMark((String)field, "")).collect(Collectors.toList());
        this.sendAction("deleteMark", list);
    }

    public void locateMark(String field) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return;
        }
        this.sendAction("locateMark", new WebOfficeMark(field, ""));
    }

    public void showCommentDialog() {
        this.sendAction("addCommentDialog", Collections.emptyMap());
    }

    public void protectDoc(WebOfficeDocProtectionType protectType, String password) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("isProtect", 1);
        data.put("protectType", protectType.getValue());
        data.put(PW, password);
        this.sendAction("docProtect", data);
    }

    public void cancelProtectDoc(String password) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("isProtect", 0);
        data.put("protectType", 0);
        data.put(PW, password);
        this.sendAction("docProtect", data);
    }

    public void limitDoc(String password) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(PW, password);
        this.sendAction("setDocLimit", data);
    }

    public void unLimitDoc(String password) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(PW, password);
        this.sendAction("setDocUnLimit", data);
    }

    public void setSelectedAreaEditBookmark(String bookmark) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(FIELD, bookmark);
        this.sendAction("setSelectionEditArea", data);
    }

    public void deleteSelectedAreaEditBookmark(String bookmark) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(FIELD, bookmark);
        this.sendAction("cancelSelectionEditArea", data);
    }

    public void setEditableAreas(List<String> bookmarks, String password) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(PW, password);
        data.put(FIELD, bookmarks);
        this.sendAction("setDocLimitByRole", data);
    }

    public void setDocUnLimitByRole(List<String> bookmarks) {
        ArrayList data = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (bookmarks != null && bookmarks.size() > 0) {
            for (int i = 0; i < bookmarks.size(); ++i) {
                map.put(FIELD, bookmarks.get(i));
                data.add(map);
            }
        }
        this.sendAction("setDocUnLimitByRole", data);
    }

    public void addTable(String[][] datas) {
        this.addTable("", datas);
    }

    public void addTable(String bookmark, String[][] datas) {
        if (null == datas || datas.length == 0) {
            return;
        }
        HashMap<String, Integer> tableSize = new HashMap<String, Integer>();
        tableSize.put("row", datas.length);
        tableSize.put("column", datas[0].length);
        ArrayList tableDatas = new ArrayList();
        for (int i = 0; i < datas.length; ++i) {
            for (int j = 0; j < datas[i].length; ++j) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("row", i + 1);
                data.put("column", j + 1);
                data.put(VALUE, datas[i][j]);
                tableDatas.add(data);
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("tableSize", tableSize);
        data.put("tableData", tableDatas);
        if (StringUtils.isNotBlank((CharSequence)bookmark)) {
            data.put(FIELD, bookmark);
        }
        this.sendAction("setDynamicTable", data);
    }

    public void setTrackingMode(String userName, WebOfficeTrackingType type) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(USER_NAME, userName);
        data.put("trackType", type.getValue());
        this.sendAction("setTrackingMode", data);
    }

    public void showAllTraces(boolean isShow) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("isShow", isShow);
        this.sendAction("showTraces", data);
    }

    public void showTracesBy(String userName, boolean isShow) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(USER_NAME, userName);
        data.put("isShow", isShow);
        this.sendAction("showTracesByRole", data);
    }

    public void checkBookmark(String bookmark) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(FIELD, bookmark);
        this.sendAction("sendFieldExist", data);
    }

    public void getAllBookmarks() {
        this.sendAction("sendAllField", Collections.emptyMap());
    }

    @KSMethod
    public void getAllBookmarks(String id) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", id);
        this.sendAction("sendAllField", data);
    }

    public void isDocChanged() {
        this.sendAction("sendIsDocChange", Collections.emptyMap());
    }

    public void addBookmarkForSelection(String bookmark) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(FIELD, bookmark);
        this.sendAction("setSelectionAsField", data);
    }

    public void getTextByBookmark(String bookmark) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(FIELD, bookmark);
        this.sendAction("sendTextByField", data);
    }

    public void setTextStyle(String bookmark, String style) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(FIELD, bookmark);
        data.put("style", style);
        this.sendAction("setTextAsTitle", data);
    }

    public void getAllCheckBoxs() {
        this.sendAction("sendAllCheckBox", Collections.emptyMap());
    }

    public void setCheckBoxChecked(boolean checked, String ... checkBoxIds) {
        if (null == checkBoxIds || checkBoxIds.length == 0) {
            return;
        }
        List datas = Arrays.stream(checkBoxIds).map(id -> new WebOfficeCheckBox((String)id, checked)).collect(Collectors.toList());
        this.sendAction("setCheckBoxValue", datas);
    }

    public void addTableRows(String bookmark, String[][] datas) {
        if (StringUtils.isEmpty((CharSequence)bookmark) || null == datas || datas.length == 0) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(FIELD, bookmark);
        dataMap.put("newRows", datas.length);
        dataMap.put("newRowsData", datas);
        this.sendAction("addTableRows", dataMap);
    }

    public void addTableColumns(String bookmark, String[][] datas) {
        if (StringUtils.isEmpty((CharSequence)bookmark) || null == datas || datas.length == 0) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(FIELD, bookmark);
        dataMap.put("newColumns", datas.length);
        dataMap.put("newColumnsData", datas);
        this.sendAction("addTableColumns", dataMap);
    }

    public void mergeDocsByBookmark(String bookmark, String[] docUrls) {
        if (StringUtils.isBlank((CharSequence)bookmark) || null == docUrls || docUrls.length == 0) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(FIELD, bookmark);
        dataMap.put("mergeType", WebOfficeMergeType.bookmark.getValue());
        dataMap.put("docsUrl", docUrls);
        this.sendAction("mergeDocs", dataMap);
    }

    public void mergeDocs(WebOfficeMergeType mergeType, String[] docUrls) {
        if (null == mergeType || WebOfficeMergeType.bookmark == mergeType || null == docUrls || docUrls.length == 0) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(FIELD, "");
        dataMap.put("mergeType", mergeType.getValue());
        dataMap.put("docsUrl", docUrls);
        this.sendAction("mergeDocs", dataMap);
    }

    public void setCaption(String value) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(VALUE, value);
        this.sendAction("setCaption", data);
    }

    public void setMenubar(boolean isShow) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(VALUE, isShow);
        this.sendAction("setMenubar", data);
    }

    public void setToolbars(boolean isShow) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(VALUE, isShow);
        this.sendAction("setToolbars", data);
    }

    public void setTitlebar(boolean isShow) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(VALUE, isShow);
        this.sendAction("setTitlebar", data);
    }

    public void setDocAsField(String bookMark) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(FIELD, bookMark);
        this.sendAction("setDocAsField", data);
    }

    public void sendOpenStatus() {
        this.sendAction("sendOpenStatus");
    }

    @KSMethod
    public void saveAsLocal() {
        this.sendAction("saveAsLocal");
    }

    @KSMethod
    public void insertPictures(List<WebOfficeImage> image) {
        if (null == image || image.isEmpty()) {
            return;
        }
        this.sendAction("insertPictures", image);
    }

    @KSMethod
    public void addWaterMark(WebofficeWaterMark waterMark) {
        if (null == waterMark) {
            return;
        }
        this.sendAction("addTextMark", waterMark);
    }

    @KSMethod
    public void delWaterMark() {
        this.sendAction("delMark");
    }

    @KSMethod
    public void getOfficeToken(Map<String, Object> params) {
        HashMap<String, String> officeToken = new HashMap<String, String>();
        String fileEditMode = AttachmentParamUtil.getEditType();
        if ("3".equals(fileEditMode)) {
            String jwtKey = ParamUtil.getOnlyOfficeJwtKey();
            if (StringUtils.isNotBlank((CharSequence)jwtKey)) {
                String token = AttachmentCommonUtils.generateJWTByMapParameters(params, (String)jwtKey, (long)(System.currentTimeMillis() + 86400000L), (boolean)false);
                officeToken.put("token", token);
            } else {
                officeToken.put("token", "");
            }
        } else if ("22".equals(fileEditMode)) {
            String token = AttachmentCommonUtils.getWpsJwtToken((boolean)false);
            officeToken.put("token", token);
        }
        this.sendAction("getOfficeToken", officeToken);
    }

    public List<WebOfficeDataListener> getDataListeners() {
        return this.dataListeners;
    }

    private void sendAction(String event) {
        this.sendAction(event, "");
    }

    private void sendAction(String event, Object data) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ClientActions.createWebOfficeActionBuilder().setEvent(event).setData(data).invokeControlMethod(proxy, this.key);
    }

    private Object getOpenUrl(String url) {
        try {
            String fileEditMode = AttachmentParamUtil.getEditType();
            if ("12".equals(fileEditMode) || "11".equals(fileEditMode)) {
                url = EncreptSessionUtils.encryptTokenLoinSession((String)url);
            } else if ("3".equals(fileEditMode) || "21".equals(fileEditMode) || "22".equals(fileEditMode)) {
                url = EncreptSessionUtils.encryptSession((String)url);
            }
            if ("3".equals(fileEditMode)) {
                url = url + "&fromOnlyOffice=1";
            }
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTempFileAndReturnUrl() {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String docTemplateUrl = (String)redisCache.get("templateDocUrlForOnlyOffice");
        if (StringUtils.isNotBlank((CharSequence)docTemplateUrl) && cache.exists(docTemplateUrl)) {
            return EncreptSessionUtils.encryptSession((String)docTemplateUrl);
        }
        XWPFDocument xwpfDocument = new XWPFDocument();
        File tempFile = null;
        FileInputStream in = null;
        FileOutputStream outputStream = null;
        try {
            tempFile = File.createTempFile("tempFile" + System.currentTimeMillis(), "docx");
            outputStream = new FileOutputStream(tempFile);
            xwpfDocument.write((OutputStream)outputStream);
            in = new FileInputStream(tempFile);
            docTemplateUrl = cache.saveAsFullUrl("tempFile.docx", (InputStream)in, 7200);
            redisCache.put("templateDocUrlForOnlyOffice", (Object)docTemplateUrl);
        }
        catch (Exception e) {
            try {
                log.error("create temp file template error", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(outputStream);
                FileSecurityUtil.safeClose(in);
                FileSecurityUtil.safeDeleteFile(tempFile);
                throw throwable;
            }
            FileSecurityUtil.safeClose(outputStream);
            FileSecurityUtil.safeClose(in);
            FileSecurityUtil.safeDeleteFile((File)tempFile);
        }
        FileSecurityUtil.safeClose((Closeable)outputStream);
        FileSecurityUtil.safeClose((Closeable)in);
        FileSecurityUtil.safeDeleteFile((File)tempFile);
        return EncreptSessionUtils.encryptSession((String)docTemplateUrl);
    }

    private boolean isOnlyOfficeEdit() {
        return "3".equals(AttachmentParamUtil.getEditType());
    }

    private boolean isWpsPublicEdit() {
        return "21".equals(AttachmentParamUtil.getEditType());
    }

    private boolean isWpsPrivateEdit() {
        return "22".equals(AttachmentParamUtil.getEditType());
    }

    private boolean isYozoEdit() {
        return "4".equals(AttachmentParamUtil.getEditType());
    }

    private boolean isWpsV3Edit() {
        Map newAttachParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_fileserverconfig");
        String wpsAppId = String.valueOf(newAttachParam.get("wpsappid1"));
        return StringUtils.isNotBlank((CharSequence)wpsAppId) && (wpsAppId.startsWith("SX") || wpsAppId.length() == 16);
    }

    private String getWpsEditUrl(String url) {
        String editUrl = "";
        try {
            Class<?> clazz = Class.forName("kd.bos.svc.attachment.wps.edit.WpsEditHandle");
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            log.info("web office get rootPageId is:" + rootPageId);
            Object actionObject = clazz.newInstance();
            Method actionMethod = clazz.getMethod("createWpsEditUrl", String.class, String.class);
            Object returnValue = actionMethod.invoke(actionObject, url, rootPageId);
            editUrl = returnValue.toString();
        }
        catch (Exception e) {
            log.error("createWpsEditUrl error", (Throwable)e);
        }
        return this.addCustomParams(editUrl);
    }

    private String getWpsV3FileId(String url, boolean isNew, WebOfficeFileType type) {
        String fileId = "";
        try {
            String finalUrl;
            if (isNew) {
                Map<String, Object> newFileInfo = this.createTempFileAndReturnFileInfo(type);
                finalUrl = String.valueOf(newFileInfo.get("url"));
            } else {
                finalUrl = url;
            }
            Class<?> clazz = Class.forName("kd.bos.svc.attachment.wps.v3.WpsV3Handle");
            Object actionObject = clazz.newInstance();
            Method actionMethod = clazz.getMethod("getWpsV3FileId", String.class, Boolean.class);
            Object returnValue = actionMethod.invoke(actionObject, finalUrl, false);
            fileId = returnValue.toString();
        }
        catch (Exception e) {
            log.error("getWpsV3FileId error", (Throwable)e);
        }
        return fileId;
    }

    private String getWpsPrivateEditUrl(String url, boolean edit) {
        String editUrl = "";
        try {
            Class<?> clazz = Class.forName("kd.bos.svc.attachment.wps.pri.WpsPrivateHandle");
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            log.info("web office get rootPageId is:" + rootPageId);
            Object actionObject = clazz.newInstance();
            Method actionMethod = clazz.getMethod("getEditUrlForWpsPrivate", String.class, String.class, Boolean.class);
            Object returnValue = actionMethod.invoke(actionObject, url, rootPageId, edit);
            editUrl = returnValue.toString();
        }
        catch (Exception e) {
            log.error("getWpsPrivateEditUrl error", (Throwable)e);
        }
        return this.addCustomParams(editUrl);
    }

    private String geYozoEditUrl(String url) {
        String editUrl = "";
        try {
            Class<?> clazz = Class.forName("kd.bos.svc.attachment.yozo.YozoDocumentHandle");
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            log.info("geYozoEditUrl rootPageId is:" + rootPageId);
            Object actionObject = clazz.newInstance();
            Method actionMethod = clazz.getMethod("getEditUrlForYozo", String.class, String.class);
            Object returnValue = actionMethod.invoke(actionObject, url, rootPageId);
            editUrl = returnValue.toString();
        }
        catch (Exception e) {
            log.error("geYozoEditUrl error", (Throwable)e);
        }
        return editUrl;
    }

    private String getYozoNewEditUrlBySelf(WebOfficeFileType type) {
        Map<String, Object> newFileInfo = this.createTempFileAndReturnFileInfo(type);
        String newEditFileUrl = "";
        try {
            Class<?> clazz = Class.forName("kd.bos.svc.attachment.yozo.YozoDocumentHandle");
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            log.info("getYozoNewEditUrlBySelf rootPageId is:" + rootPageId);
            String fileNme = String.valueOf(newFileInfo.get("fileName"));
            int size = (Integer)newFileInfo.get("size");
            String url = String.valueOf(newFileInfo.get("url"));
            Object actionObject = clazz.newInstance();
            Method actionMethod = clazz.getMethod("getNewEditUrlForYozo", String.class, String.class, String.class, Integer.class);
            Object returnValue = actionMethod.invoke(actionObject, url, rootPageId, fileNme, size);
            newEditFileUrl = returnValue.toString();
        }
        catch (Exception e) {
            log.error("getYozoNewEditUrlBySelf error", (Throwable)e);
        }
        return newEditFileUrl;
    }

    private String createNewFileName(WebOfficeFileType type) {
        String fileName = "";
        if (WebOfficeFileType.word == type) {
            fileName = "temp.docx";
        } else if (WebOfficeFileType.excel == type) {
            fileName = "temp.xlsx";
        } else if (WebOfficeFileType.ppt == type) {
            fileName = "temp.pptx";
        }
        log.info("wps new file name is:" + fileName);
        return fileName;
    }

    private String getWpsNewEditUrlBySelf(boolean isWpsPrivate, WebOfficeFileType type) {
        Map<String, Object> newFileInfo = this.createTempFileAndReturnFileInfo(type);
        String newFileUrl = "";
        try {
            String className = "kd.bos.svc.attachment.wps.edit.WpsEditHandle";
            String methodName = "createNewFileUrlBySelf";
            if (isWpsPrivate) {
                className = "kd.bos.svc.attachment.wps.pri.WpsPrivateHandle";
                methodName = "getNewFileEditUrl";
            }
            Class<?> clazz = Class.forName(className);
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            log.info("web office get rootPageId is:" + rootPageId);
            String fileNme = String.valueOf(newFileInfo.get("fileName"));
            int size = (Integer)newFileInfo.get("size");
            String url = String.valueOf(newFileInfo.get("url"));
            Object actionObject = clazz.newInstance();
            Method actionMethod = clazz.getMethod(methodName, String.class, String.class, String.class, Integer.class);
            Object returnValue = actionMethod.invoke(actionObject, url, rootPageId, fileNme, size);
            newFileUrl = returnValue.toString();
        }
        catch (Exception e) {
            log.error("createWpsEditUrl error", (Throwable)e);
        }
        return this.addCustomParams(newFileUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> createTempFileAndReturnFileInfo(WebOfficeFileType type) {
        String fileInfo;
        XWPFDocument document;
        String fileName = this.createNewFileName(type);
        String fileType = "";
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (WebOfficeFileType.word == type) {
            document = new XWPFDocument();
            fileType = "docx";
            fileInfo = (String)redisCache.get("templateWordInfoForWps");
        } else if (WebOfficeFileType.excel == type) {
            document = new XSSFWorkbook();
            fileType = "xlsx";
            fileInfo = (String)redisCache.get("templateFileInfoForWps");
        } else {
            document = new XMLSlideShow();
            fileType = "pptx";
            fileInfo = (String)redisCache.get("templatePptInfoForWps");
        }
        if (StringUtils.isNotBlank((CharSequence)fileInfo)) {
            log.info("return temp file info from cache:" + fileInfo);
            Map cacheMap = (Map)SerializationUtils.fromJsonString((String)fileInfo, Map.class);
            String url = String.valueOf(cacheMap.get("url"));
            if (cache.exists(url)) {
                this.putFileInfoToCache(cacheMap.get("fileName"), cacheMap.get("size"), url);
                return cacheMap;
            }
        }
        File tempFile = null;
        FileInputStream in = null;
        FileOutputStream outputStream = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            tempFile = File.createTempFile("tempFile" + System.currentTimeMillis(), fileType);
            outputStream = new FileOutputStream(tempFile);
            document.write((OutputStream)outputStream);
            in = new FileInputStream(tempFile);
            int size = in.available();
            String docTemplateUrl = cache.saveAsFullUrl(fileName, (InputStream)in, 7200);
            map.put("fileName", fileName);
            map.put("size", size);
            map.put("url", docTemplateUrl);
            if (WebOfficeFileType.word == type) {
                redisCache.put("templateWordInfoForWps", (Object)SerializationUtils.toJsonString(map));
            } else if (WebOfficeFileType.excel == type) {
                redisCache.put("templateExcelInfoForWps", (Object)SerializationUtils.toJsonString(map));
            } else {
                redisCache.put("templatePptInfoForWps", (Object)SerializationUtils.toJsonString(map));
            }
            this.putFileInfoToCache(fileName, size, docTemplateUrl);
        }
        catch (Exception e) {
            try {
                log.error("create temp file template error", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(outputStream);
                FileSecurityUtil.safeClose(in);
                FileSecurityUtil.safeDeleteFile(tempFile);
                throw throwable;
            }
            FileSecurityUtil.safeClose(outputStream);
            FileSecurityUtil.safeClose(in);
            FileSecurityUtil.safeDeleteFile((File)tempFile);
        }
        FileSecurityUtil.safeClose((Closeable)outputStream);
        FileSecurityUtil.safeClose((Closeable)in);
        FileSecurityUtil.safeDeleteFile((File)tempFile);
        log.info("return temp file info:" + SerializationUtils.toJsonString(map));
        return map;
    }

    private void putFileInfoToCache(Object name, Object size, String url) {
        HashMap<String, Object> fileInfoMap = new HashMap<String, Object>();
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        fileInfoMap.put("name", name);
        fileInfoMap.put("size", size);
        fileInfoRedisCache.put("FileInfo:" + tempFileId, (Object)SerializationUtils.toJsonString(fileInfoMap));
    }
}

